/*
* hal_disp_reg.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#ifndef __HAL_DISP_REG_H__
#define __HAL_DISP_REG_H__

#define REG_CHIPTOP_BASE        0x101E00UL
#define REG_LPLL_BASE           0x103300UL
#define REG_CLKGEN_BASE         0x103800UL
#define REG_HDMITX_DTOP_BASE    0x112500UL
#define REG_HDMITX_ATOP_BASE    0x112600UL
#define REG_DISP_DAC_BASE       0x112700UL
#define REG_DISP_TOP_BASE       0x112800UL
#define REG_DISP_TOP_OP2_BASE   0x112900UL
#define REG_DISP_TOP_MACE_BASE  0x112A00UL
#define REG_DISP_TOP_GAMMA_BASE 0x112B00UL
#define REG_SC_CTRL_BASE        0x113300UL

#define REG_DISP_MOPG_BK0_BASE  0x140500UL
#define REG_DISP_MOPG_BK1_BASE  0x140600UL
#define REG_DISP_MOPG_BK2_BASE  0x140700UL
#define REG_DISP_MOPS_BK0_BASE  0x140800UL
#define REG_DISP_MOP_ROT_BASE   0x140D00UL

//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
#define REG_CHIPTOP_00_L     (REG_CHIPTOP_BASE + 0x00)
#define REG_CHIPTOP_00_H     (REG_CHIPTOP_BASE + 0x01)
#define REG_CHIPTOP_01_L     (REG_CHIPTOP_BASE + 0x02)
#define REG_CHIPTOP_01_H     (REG_CHIPTOP_BASE + 0x03)
#define REG_CHIPTOP_02_L     (REG_CHIPTOP_BASE + 0x04)
#define REG_CHIPTOP_02_H     (REG_CHIPTOP_BASE + 0x05)
#define REG_CHIPTOP_03_L     (REG_CHIPTOP_BASE + 0x06)
#define REG_CHIPTOP_03_H     (REG_CHIPTOP_BASE + 0x07)
#define REG_CHIPTOP_04_L     (REG_CHIPTOP_BASE + 0x08)
#define REG_CHIPTOP_04_H     (REG_CHIPTOP_BASE + 0x09)
#define REG_CHIPTOP_05_L     (REG_CHIPTOP_BASE + 0x0A)
#define REG_CHIPTOP_05_H     (REG_CHIPTOP_BASE + 0x0B)
#define REG_CHIPTOP_06_L     (REG_CHIPTOP_BASE + 0x0C)
#define REG_CHIPTOP_06_H     (REG_CHIPTOP_BASE + 0x0D)
#define REG_CHIPTOP_07_L     (REG_CHIPTOP_BASE + 0x0E)
#define REG_CHIPTOP_07_H     (REG_CHIPTOP_BASE + 0x0F)
#define REG_CHIPTOP_08_L     (REG_CHIPTOP_BASE + 0x10)
#define REG_CHIPTOP_08_H     (REG_CHIPTOP_BASE + 0x11)
#define REG_CHIPTOP_09_L     (REG_CHIPTOP_BASE + 0x12)
#define REG_CHIPTOP_09_H     (REG_CHIPTOP_BASE + 0x13)
#define REG_CHIPTOP_0A_L     (REG_CHIPTOP_BASE + 0x14)
#define REG_CHIPTOP_0A_H     (REG_CHIPTOP_BASE + 0x15)
#define REG_CHIPTOP_0B_L     (REG_CHIPTOP_BASE + 0x16)
#define REG_CHIPTOP_0B_H     (REG_CHIPTOP_BASE + 0x17)
#define REG_CHIPTOP_0C_L     (REG_CHIPTOP_BASE + 0x18)
#define REG_CHIPTOP_0C_H     (REG_CHIPTOP_BASE + 0x19)
#define REG_CHIPTOP_0D_L     (REG_CHIPTOP_BASE + 0x1A)
#define REG_CHIPTOP_0D_H     (REG_CHIPTOP_BASE + 0x1B)
#define REG_CHIPTOP_0E_L     (REG_CHIPTOP_BASE + 0x1C)
#define REG_CHIPTOP_0E_H     (REG_CHIPTOP_BASE + 0x1D)
#define REG_CHIPTOP_0F_L     (REG_CHIPTOP_BASE + 0x1E)
#define REG_CHIPTOP_0F_H     (REG_CHIPTOP_BASE + 0x1F)
#define REG_CHIPTOP_10_L     (REG_CHIPTOP_BASE + 0x20)
#define REG_CHIPTOP_10_H     (REG_CHIPTOP_BASE + 0x21)
#define REG_CHIPTOP_11_L     (REG_CHIPTOP_BASE + 0x22)
#define REG_CHIPTOP_11_H     (REG_CHIPTOP_BASE + 0x23)
#define REG_CHIPTOP_12_L     (REG_CHIPTOP_BASE + 0x24)
#define REG_CHIPTOP_12_H     (REG_CHIPTOP_BASE + 0x25)
#define REG_CHIPTOP_13_L     (REG_CHIPTOP_BASE + 0x26)
#define REG_CHIPTOP_13_H     (REG_CHIPTOP_BASE + 0x27)
#define REG_CHIPTOP_14_L     (REG_CHIPTOP_BASE + 0x28)
#define REG_CHIPTOP_14_H     (REG_CHIPTOP_BASE + 0x29)
#define REG_CHIPTOP_15_L     (REG_CHIPTOP_BASE + 0x2A)
#define REG_CHIPTOP_15_H     (REG_CHIPTOP_BASE + 0x2B)
#define REG_CHIPTOP_16_L     (REG_CHIPTOP_BASE + 0x2C)
#define REG_CHIPTOP_16_H     (REG_CHIPTOP_BASE + 0x2D)
#define REG_CHIPTOP_17_L     (REG_CHIPTOP_BASE + 0x2E)
#define REG_CHIPTOP_17_H     (REG_CHIPTOP_BASE + 0x2F)
#define REG_CHIPTOP_18_L     (REG_CHIPTOP_BASE + 0x30)
#define REG_CHIPTOP_18_H     (REG_CHIPTOP_BASE + 0x31)
#define REG_CHIPTOP_19_L     (REG_CHIPTOP_BASE + 0x32)
#define REG_CHIPTOP_19_H     (REG_CHIPTOP_BASE + 0x33)
#define REG_CHIPTOP_1A_L     (REG_CHIPTOP_BASE + 0x34)
#define REG_CHIPTOP_1A_H     (REG_CHIPTOP_BASE + 0x35)
#define REG_CHIPTOP_1B_L     (REG_CHIPTOP_BASE + 0x36)
#define REG_CHIPTOP_1B_H     (REG_CHIPTOP_BASE + 0x37)
#define REG_CHIPTOP_1C_L     (REG_CHIPTOP_BASE + 0x38)
#define REG_CHIPTOP_1C_H     (REG_CHIPTOP_BASE + 0x39)
#define REG_CHIPTOP_1D_L     (REG_CHIPTOP_BASE + 0x3A)
#define REG_CHIPTOP_1D_H     (REG_CHIPTOP_BASE + 0x3B)
#define REG_CHIPTOP_1E_L     (REG_CHIPTOP_BASE + 0x3C)
#define REG_CHIPTOP_1E_H     (REG_CHIPTOP_BASE + 0x3D)
#define REG_CHIPTOP_1F_L     (REG_CHIPTOP_BASE + 0x3E)
#define REG_CHIPTOP_1F_H     (REG_CHIPTOP_BASE + 0x3F)
#define REG_CHIPTOP_20_L     (REG_CHIPTOP_BASE + 0x40)
#define REG_CHIPTOP_20_H     (REG_CHIPTOP_BASE + 0x41)
#define REG_CHIPTOP_21_L     (REG_CHIPTOP_BASE + 0x42)
#define REG_CHIPTOP_21_H     (REG_CHIPTOP_BASE + 0x43)
#define REG_CHIPTOP_22_L     (REG_CHIPTOP_BASE + 0x44)
#define REG_CHIPTOP_22_H     (REG_CHIPTOP_BASE + 0x45)
#define REG_CHIPTOP_23_L     (REG_CHIPTOP_BASE + 0x46)
#define REG_CHIPTOP_23_H     (REG_CHIPTOP_BASE + 0x47)
#define REG_CHIPTOP_24_L     (REG_CHIPTOP_BASE + 0x48)
#define REG_CHIPTOP_24_H     (REG_CHIPTOP_BASE + 0x49)
#define REG_CHIPTOP_25_L     (REG_CHIPTOP_BASE + 0x4A)
#define REG_CHIPTOP_25_H     (REG_CHIPTOP_BASE + 0x4B)
#define REG_CHIPTOP_26_L     (REG_CHIPTOP_BASE + 0x4C)
#define REG_CHIPTOP_26_H     (REG_CHIPTOP_BASE + 0x4D)
#define REG_CHIPTOP_27_L     (REG_CHIPTOP_BASE + 0x4E)
#define REG_CHIPTOP_27_H     (REG_CHIPTOP_BASE + 0x4F)
#define REG_CHIPTOP_28_L     (REG_CHIPTOP_BASE + 0x50)
#define REG_CHIPTOP_28_H     (REG_CHIPTOP_BASE + 0x51)
#define REG_CHIPTOP_29_L     (REG_CHIPTOP_BASE + 0x52)
#define REG_CHIPTOP_29_H     (REG_CHIPTOP_BASE + 0x53)
#define REG_CHIPTOP_2A_L     (REG_CHIPTOP_BASE + 0x54)
#define REG_CHIPTOP_2A_H     (REG_CHIPTOP_BASE + 0x55)
#define REG_CHIPTOP_2B_L     (REG_CHIPTOP_BASE + 0x56)
#define REG_CHIPTOP_2B_H     (REG_CHIPTOP_BASE + 0x57)
#define REG_CHIPTOP_2C_L     (REG_CHIPTOP_BASE + 0x58)
#define REG_CHIPTOP_2C_H     (REG_CHIPTOP_BASE + 0x59)
#define REG_CHIPTOP_2D_L     (REG_CHIPTOP_BASE + 0x5A)
#define REG_CHIPTOP_2D_H     (REG_CHIPTOP_BASE + 0x5B)
#define REG_CHIPTOP_2E_L     (REG_CHIPTOP_BASE + 0x5C)
#define REG_CHIPTOP_2E_H     (REG_CHIPTOP_BASE + 0x5D)
#define REG_CHIPTOP_2F_L     (REG_CHIPTOP_BASE + 0x5E)
#define REG_CHIPTOP_2F_H     (REG_CHIPTOP_BASE + 0x5F)
#define REG_CHIPTOP_30_L     (REG_CHIPTOP_BASE + 0x60)
#define REG_CHIPTOP_30_H     (REG_CHIPTOP_BASE + 0x61)
#define REG_CHIPTOP_31_L     (REG_CHIPTOP_BASE + 0x62)
#define REG_CHIPTOP_31_H     (REG_CHIPTOP_BASE + 0x63)
#define REG_CHIPTOP_32_L     (REG_CHIPTOP_BASE + 0x64)
#define REG_CHIPTOP_32_H     (REG_CHIPTOP_BASE + 0x65)
#define REG_CHIPTOP_33_L     (REG_CHIPTOP_BASE + 0x66)
#define REG_CHIPTOP_33_H     (REG_CHIPTOP_BASE + 0x67)
#define REG_CHIPTOP_34_L     (REG_CHIPTOP_BASE + 0x68)
#define REG_CHIPTOP_34_H     (REG_CHIPTOP_BASE + 0x69)
#define REG_CHIPTOP_35_L     (REG_CHIPTOP_BASE + 0x6A)
#define REG_CHIPTOP_35_H     (REG_CHIPTOP_BASE + 0x6B)
#define REG_CHIPTOP_36_L     (REG_CHIPTOP_BASE + 0x6C)
#define REG_CHIPTOP_36_H     (REG_CHIPTOP_BASE + 0x6D)
#define REG_CHIPTOP_37_L     (REG_CHIPTOP_BASE + 0x6E)
#define REG_CHIPTOP_37_H     (REG_CHIPTOP_BASE + 0x6F)
#define REG_CHIPTOP_38_L     (REG_CHIPTOP_BASE + 0x70)
#define REG_CHIPTOP_38_H     (REG_CHIPTOP_BASE + 0x71)
#define REG_CHIPTOP_39_L     (REG_CHIPTOP_BASE + 0x72)
#define REG_CHIPTOP_39_H     (REG_CHIPTOP_BASE + 0x73)
#define REG_CHIPTOP_3A_L     (REG_CHIPTOP_BASE + 0x74)
#define REG_CHIPTOP_3A_H     (REG_CHIPTOP_BASE + 0x75)
#define REG_CHIPTOP_3B_L     (REG_CHIPTOP_BASE + 0x76)
#define REG_CHIPTOP_3B_H     (REG_CHIPTOP_BASE + 0x77)
#define REG_CHIPTOP_3C_L     (REG_CHIPTOP_BASE + 0x78)
#define REG_CHIPTOP_3C_H     (REG_CHIPTOP_BASE + 0x79)
#define REG_CHIPTOP_3D_L     (REG_CHIPTOP_BASE + 0x7A)
#define REG_CHIPTOP_3D_H     (REG_CHIPTOP_BASE + 0x7B)
#define REG_CHIPTOP_3E_L     (REG_CHIPTOP_BASE + 0x7C)
#define REG_CHIPTOP_3E_H     (REG_CHIPTOP_BASE + 0x7D)
#define REG_CHIPTOP_3F_L     (REG_CHIPTOP_BASE + 0x7E)
#define REG_CHIPTOP_3F_H     (REG_CHIPTOP_BASE + 0x7F)
#define REG_CHIPTOP_40_L     (REG_CHIPTOP_BASE + 0x80)
#define REG_CHIPTOP_40_H     (REG_CHIPTOP_BASE + 0x81)
#define REG_CHIPTOP_41_L     (REG_CHIPTOP_BASE + 0x82)
#define REG_CHIPTOP_41_H     (REG_CHIPTOP_BASE + 0x83)
#define REG_CHIPTOP_42_L     (REG_CHIPTOP_BASE + 0x84)
#define REG_CHIPTOP_42_H     (REG_CHIPTOP_BASE + 0x85)
#define REG_CHIPTOP_43_L     (REG_CHIPTOP_BASE + 0x86)
#define REG_CHIPTOP_43_H     (REG_CHIPTOP_BASE + 0x87)
#define REG_CHIPTOP_44_L     (REG_CHIPTOP_BASE + 0x88)
#define REG_CHIPTOP_44_H     (REG_CHIPTOP_BASE + 0x89)
#define REG_CHIPTOP_45_L     (REG_CHIPTOP_BASE + 0x8A)
#define REG_CHIPTOP_45_H     (REG_CHIPTOP_BASE + 0x8B)
#define REG_CHIPTOP_46_L     (REG_CHIPTOP_BASE + 0x8C)
#define REG_CHIPTOP_46_H     (REG_CHIPTOP_BASE + 0x8D)
#define REG_CHIPTOP_47_L     (REG_CHIPTOP_BASE + 0x8E)
#define REG_CHIPTOP_47_H     (REG_CHIPTOP_BASE + 0x8F)
#define REG_CHIPTOP_48_L     (REG_CHIPTOP_BASE + 0x90)
#define REG_CHIPTOP_48_H     (REG_CHIPTOP_BASE + 0x91)
#define REG_CHIPTOP_49_L     (REG_CHIPTOP_BASE + 0x92)
#define REG_CHIPTOP_49_H     (REG_CHIPTOP_BASE + 0x93)
#define REG_CHIPTOP_4A_L     (REG_CHIPTOP_BASE + 0x94)
#define REG_CHIPTOP_4A_H     (REG_CHIPTOP_BASE + 0x95)
#define REG_CHIPTOP_4B_L     (REG_CHIPTOP_BASE + 0x96)
#define REG_CHIPTOP_4B_H     (REG_CHIPTOP_BASE + 0x97)
#define REG_CHIPTOP_4C_L     (REG_CHIPTOP_BASE + 0x98)
#define REG_CHIPTOP_4C_H     (REG_CHIPTOP_BASE + 0x99)
#define REG_CHIPTOP_4D_L     (REG_CHIPTOP_BASE + 0x9A)
#define REG_CHIPTOP_4D_H     (REG_CHIPTOP_BASE + 0x9B)
#define REG_CHIPTOP_4E_L     (REG_CHIPTOP_BASE + 0x9C)
#define REG_CHIPTOP_4E_H     (REG_CHIPTOP_BASE + 0x9D)
#define REG_CHIPTOP_4F_L     (REG_CHIPTOP_BASE + 0x9E)
#define REG_CHIPTOP_4F_H     (REG_CHIPTOP_BASE + 0x9F)
#define REG_CHIPTOP_50_L     (REG_CHIPTOP_BASE + 0xA0)
#define REG_CHIPTOP_50_H     (REG_CHIPTOP_BASE + 0xA1)
#define REG_CHIPTOP_51_L     (REG_CHIPTOP_BASE + 0xA2)
#define REG_CHIPTOP_51_H     (REG_CHIPTOP_BASE + 0xA3)
#define REG_CHIPTOP_52_L     (REG_CHIPTOP_BASE + 0xA4)
#define REG_CHIPTOP_52_H     (REG_CHIPTOP_BASE + 0xA5)
#define REG_CHIPTOP_53_L     (REG_CHIPTOP_BASE + 0xA6)
#define REG_CHIPTOP_53_H     (REG_CHIPTOP_BASE + 0xA7)
#define REG_CHIPTOP_54_L     (REG_CHIPTOP_BASE + 0xA8)
#define REG_CHIPTOP_54_H     (REG_CHIPTOP_BASE + 0xA9)
#define REG_CHIPTOP_55_L     (REG_CHIPTOP_BASE + 0xAA)
#define REG_CHIPTOP_55_H     (REG_CHIPTOP_BASE + 0xAB)
#define REG_CHIPTOP_56_L     (REG_CHIPTOP_BASE + 0xAC)
#define REG_CHIPTOP_56_H     (REG_CHIPTOP_BASE + 0xAD)
#define REG_CHIPTOP_57_L     (REG_CHIPTOP_BASE + 0xAE)
#define REG_CHIPTOP_57_H     (REG_CHIPTOP_BASE + 0xAF)
#define REG_CHIPTOP_58_L     (REG_CHIPTOP_BASE + 0xB0)
#define REG_CHIPTOP_58_H     (REG_CHIPTOP_BASE + 0xB1)
#define REG_CHIPTOP_59_L     (REG_CHIPTOP_BASE + 0xB2)
#define REG_CHIPTOP_59_H     (REG_CHIPTOP_BASE + 0xB3)
#define REG_CHIPTOP_5A_L     (REG_CHIPTOP_BASE + 0xB4)
#define REG_CHIPTOP_5A_H     (REG_CHIPTOP_BASE + 0xB5)
#define REG_CHIPTOP_5B_L     (REG_CHIPTOP_BASE + 0xB6)
#define REG_CHIPTOP_5B_H     (REG_CHIPTOP_BASE + 0xB7)
#define REG_CHIPTOP_5C_L     (REG_CHIPTOP_BASE + 0xB8)
#define REG_CHIPTOP_5C_H     (REG_CHIPTOP_BASE + 0xB9)
#define REG_CHIPTOP_5D_L     (REG_CHIPTOP_BASE + 0xBA)
#define REG_CHIPTOP_5D_H     (REG_CHIPTOP_BASE + 0xBB)
#define REG_CHIPTOP_5E_L     (REG_CHIPTOP_BASE + 0xBC)
#define REG_CHIPTOP_5E_H     (REG_CHIPTOP_BASE + 0xBD)
#define REG_CHIPTOP_5F_L     (REG_CHIPTOP_BASE + 0xBE)
#define REG_CHIPTOP_5F_H     (REG_CHIPTOP_BASE + 0xBF)
#define REG_CHIPTOP_60_L     (REG_CHIPTOP_BASE + 0xC0)
#define REG_CHIPTOP_60_H     (REG_CHIPTOP_BASE + 0xC1)
#define REG_CHIPTOP_61_L     (REG_CHIPTOP_BASE + 0xC2)
#define REG_CHIPTOP_61_H     (REG_CHIPTOP_BASE + 0xC3)
#define REG_CHIPTOP_62_L     (REG_CHIPTOP_BASE + 0xC4)
#define REG_CHIPTOP_62_H     (REG_CHIPTOP_BASE + 0xC5)
#define REG_CHIPTOP_63_L     (REG_CHIPTOP_BASE + 0xC6)
#define REG_CHIPTOP_63_H     (REG_CHIPTOP_BASE + 0xC7)
#define REG_CHIPTOP_64_L     (REG_CHIPTOP_BASE + 0xC8)
#define REG_CHIPTOP_64_H     (REG_CHIPTOP_BASE + 0xC9)
#define REG_CHIPTOP_65_L     (REG_CHIPTOP_BASE + 0xCA)
#define REG_CHIPTOP_65_H     (REG_CHIPTOP_BASE + 0xCB)
#define REG_CHIPTOP_66_L     (REG_CHIPTOP_BASE + 0xCC)
#define REG_CHIPTOP_66_H     (REG_CHIPTOP_BASE + 0xCD)
#define REG_CHIPTOP_67_L     (REG_CHIPTOP_BASE + 0xCE)
#define REG_CHIPTOP_67_H     (REG_CHIPTOP_BASE + 0xCF)
#define REG_CHIPTOP_68_L     (REG_CHIPTOP_BASE + 0xD0)
#define REG_CHIPTOP_68_H     (REG_CHIPTOP_BASE + 0xD1)
#define REG_CHIPTOP_69_L     (REG_CHIPTOP_BASE + 0xD2)
#define REG_CHIPTOP_69_H     (REG_CHIPTOP_BASE + 0xD3)
#define REG_CHIPTOP_6A_L     (REG_CHIPTOP_BASE + 0xD4)
#define REG_CHIPTOP_6A_H     (REG_CHIPTOP_BASE + 0xD5)
#define REG_CHIPTOP_6B_L     (REG_CHIPTOP_BASE + 0xD6)
#define REG_CHIPTOP_6B_H     (REG_CHIPTOP_BASE + 0xD7)
#define REG_CHIPTOP_6C_L     (REG_CHIPTOP_BASE + 0xD8)
#define REG_CHIPTOP_6C_H     (REG_CHIPTOP_BASE + 0xD9)
#define REG_CHIPTOP_6D_L     (REG_CHIPTOP_BASE + 0xDA)
#define REG_CHIPTOP_6D_H     (REG_CHIPTOP_BASE + 0xDB)
#define REG_CHIPTOP_6E_L     (REG_CHIPTOP_BASE + 0xDC)
#define REG_CHIPTOP_6E_H     (REG_CHIPTOP_BASE + 0xDD)
#define REG_CHIPTOP_6F_L     (REG_CHIPTOP_BASE + 0xDE)
#define REG_CHIPTOP_6F_H     (REG_CHIPTOP_BASE + 0xDF)
#define REG_CHIPTOP_70_L     (REG_CHIPTOP_BASE + 0xE0)
#define REG_CHIPTOP_70_H     (REG_CHIPTOP_BASE + 0xE1)
#define REG_CHIPTOP_71_L     (REG_CHIPTOP_BASE + 0xE2)
#define REG_CHIPTOP_71_H     (REG_CHIPTOP_BASE + 0xE3)
#define REG_CHIPTOP_72_L     (REG_CHIPTOP_BASE + 0xE4)
#define REG_CHIPTOP_72_H     (REG_CHIPTOP_BASE + 0xE5)
#define REG_CHIPTOP_73_L     (REG_CHIPTOP_BASE + 0xE6)
#define REG_CHIPTOP_73_H     (REG_CHIPTOP_BASE + 0xE7)
#define REG_CHIPTOP_74_L     (REG_CHIPTOP_BASE + 0xE8)
#define REG_CHIPTOP_74_H     (REG_CHIPTOP_BASE + 0xE9)
#define REG_CHIPTOP_75_L     (REG_CHIPTOP_BASE + 0xEA)
#define REG_CHIPTOP_75_H     (REG_CHIPTOP_BASE + 0xEB)
#define REG_CHIPTOP_76_L     (REG_CHIPTOP_BASE + 0xEC)
#define REG_CHIPTOP_76_H     (REG_CHIPTOP_BASE + 0xED)
#define REG_CHIPTOP_77_L     (REG_CHIPTOP_BASE + 0xEE)
#define REG_CHIPTOP_77_H     (REG_CHIPTOP_BASE + 0xEF)
#define REG_CHIPTOP_78_L     (REG_CHIPTOP_BASE + 0xF0)
#define REG_CHIPTOP_78_H     (REG_CHIPTOP_BASE + 0xF1)
#define REG_CHIPTOP_79_L     (REG_CHIPTOP_BASE + 0xF2)
#define REG_CHIPTOP_79_H     (REG_CHIPTOP_BASE + 0xF3)
#define REG_CHIPTOP_7A_L     (REG_CHIPTOP_BASE + 0xF4)
#define REG_CHIPTOP_7A_H     (REG_CHIPTOP_BASE + 0xF5)
#define REG_CHIPTOP_7B_L     (REG_CHIPTOP_BASE + 0xF6)
#define REG_CHIPTOP_7B_H     (REG_CHIPTOP_BASE + 0xF7)
#define REG_CHIPTOP_7C_L     (REG_CHIPTOP_BASE + 0xF8)
#define REG_CHIPTOP_7C_H     (REG_CHIPTOP_BASE + 0xF9)
#define REG_CHIPTOP_7D_L     (REG_CHIPTOP_BASE + 0xFA)
#define REG_CHIPTOP_7D_H     (REG_CHIPTOP_BASE + 0xFB)
#define REG_CHIPTOP_7E_L     (REG_CHIPTOP_BASE + 0xFC)
#define REG_CHIPTOP_7E_H     (REG_CHIPTOP_BASE + 0xFD)
#define REG_CHIPTOP_7F_L     (REG_CHIPTOP_BASE + 0xFE)
#define REG_CHIPTOP_7F_H     (REG_CHIPTOP_BASE + 0xFF)

#define REG_LPLL_00_L     (REG_LPLL_BASE + 0x00)
#define REG_LPLL_00_H     (REG_LPLL_BASE + 0x01)
#define REG_LPLL_01_L     (REG_LPLL_BASE + 0x02)
#define REG_LPLL_01_H     (REG_LPLL_BASE + 0x03)
#define REG_LPLL_02_L     (REG_LPLL_BASE + 0x04)
#define REG_LPLL_02_H     (REG_LPLL_BASE + 0x05)
#define REG_LPLL_03_L     (REG_LPLL_BASE + 0x06)
#define REG_LPLL_03_H     (REG_LPLL_BASE + 0x07)
#define REG_LPLL_04_L     (REG_LPLL_BASE + 0x08)
#define REG_LPLL_04_H     (REG_LPLL_BASE + 0x09)
#define REG_LPLL_05_L     (REG_LPLL_BASE + 0x0A)
#define REG_LPLL_05_H     (REG_LPLL_BASE + 0x0B)
#define REG_LPLL_06_L     (REG_LPLL_BASE + 0x0C)
#define REG_LPLL_06_H     (REG_LPLL_BASE + 0x0D)
#define REG_LPLL_07_L     (REG_LPLL_BASE + 0x0E)
#define REG_LPLL_07_H     (REG_LPLL_BASE + 0x0F)
#define REG_LPLL_08_L     (REG_LPLL_BASE + 0x10)
#define REG_LPLL_08_H     (REG_LPLL_BASE + 0x11)
#define REG_LPLL_09_L     (REG_LPLL_BASE + 0x12)
#define REG_LPLL_09_H     (REG_LPLL_BASE + 0x13)
#define REG_LPLL_0A_L     (REG_LPLL_BASE + 0x14)
#define REG_LPLL_0A_H     (REG_LPLL_BASE + 0x15)
#define REG_LPLL_0B_L     (REG_LPLL_BASE + 0x16)
#define REG_LPLL_0B_H     (REG_LPLL_BASE + 0x17)
#define REG_LPLL_0C_L     (REG_LPLL_BASE + 0x18)
#define REG_LPLL_0C_H     (REG_LPLL_BASE + 0x19)
#define REG_LPLL_0D_L     (REG_LPLL_BASE + 0x1A)
#define REG_LPLL_0D_H     (REG_LPLL_BASE + 0x1B)
#define REG_LPLL_0E_L     (REG_LPLL_BASE + 0x1C)
#define REG_LPLL_0E_H     (REG_LPLL_BASE + 0x1D)
#define REG_LPLL_0F_L     (REG_LPLL_BASE + 0x1E)
#define REG_LPLL_0F_H     (REG_LPLL_BASE + 0x1F)
#define REG_LPLL_10_L     (REG_LPLL_BASE + 0x20)
#define REG_LPLL_10_H     (REG_LPLL_BASE + 0x21)
#define REG_LPLL_11_L     (REG_LPLL_BASE + 0x22)
#define REG_LPLL_11_H     (REG_LPLL_BASE + 0x23)
#define REG_LPLL_12_L     (REG_LPLL_BASE + 0x24)
#define REG_LPLL_12_H     (REG_LPLL_BASE + 0x25)
#define REG_LPLL_13_L     (REG_LPLL_BASE + 0x26)
#define REG_LPLL_13_H     (REG_LPLL_BASE + 0x27)
#define REG_LPLL_14_L     (REG_LPLL_BASE + 0x28)
#define REG_LPLL_14_H     (REG_LPLL_BASE + 0x29)
#define REG_LPLL_15_L     (REG_LPLL_BASE + 0x2A)
#define REG_LPLL_15_H     (REG_LPLL_BASE + 0x2B)
#define REG_LPLL_16_L     (REG_LPLL_BASE + 0x2C)
#define REG_LPLL_16_H     (REG_LPLL_BASE + 0x2D)
#define REG_LPLL_17_L     (REG_LPLL_BASE + 0x2E)
#define REG_LPLL_17_H     (REG_LPLL_BASE + 0x2F)
#define REG_LPLL_18_L     (REG_LPLL_BASE + 0x30)
#define REG_LPLL_18_H     (REG_LPLL_BASE + 0x31)
#define REG_LPLL_19_L     (REG_LPLL_BASE + 0x32)
#define REG_LPLL_19_H     (REG_LPLL_BASE + 0x33)
#define REG_LPLL_1A_L     (REG_LPLL_BASE + 0x34)
#define REG_LPLL_1A_H     (REG_LPLL_BASE + 0x35)
#define REG_LPLL_1B_L     (REG_LPLL_BASE + 0x36)
#define REG_LPLL_1B_H     (REG_LPLL_BASE + 0x37)
#define REG_LPLL_1C_L     (REG_LPLL_BASE + 0x38)
#define REG_LPLL_1C_H     (REG_LPLL_BASE + 0x39)
#define REG_LPLL_1D_L     (REG_LPLL_BASE + 0x3A)
#define REG_LPLL_1D_H     (REG_LPLL_BASE + 0x3B)
#define REG_LPLL_1E_L     (REG_LPLL_BASE + 0x3C)
#define REG_LPLL_1E_H     (REG_LPLL_BASE + 0x3D)
#define REG_LPLL_1F_L     (REG_LPLL_BASE + 0x3E)
#define REG_LPLL_1F_H     (REG_LPLL_BASE + 0x3F)
#define REG_LPLL_20_L     (REG_LPLL_BASE + 0x40)
#define REG_LPLL_20_H     (REG_LPLL_BASE + 0x41)
#define REG_LPLL_21_L     (REG_LPLL_BASE + 0x42)
#define REG_LPLL_21_H     (REG_LPLL_BASE + 0x43)
#define REG_LPLL_22_L     (REG_LPLL_BASE + 0x44)
#define REG_LPLL_22_H     (REG_LPLL_BASE + 0x45)
#define REG_LPLL_23_L     (REG_LPLL_BASE + 0x46)
#define REG_LPLL_23_H     (REG_LPLL_BASE + 0x47)
#define REG_LPLL_24_L     (REG_LPLL_BASE + 0x48)
#define REG_LPLL_24_H     (REG_LPLL_BASE + 0x49)
#define REG_LPLL_25_L     (REG_LPLL_BASE + 0x4A)
#define REG_LPLL_25_H     (REG_LPLL_BASE + 0x4B)
#define REG_LPLL_26_L     (REG_LPLL_BASE + 0x4C)
#define REG_LPLL_26_H     (REG_LPLL_BASE + 0x4D)
#define REG_LPLL_27_L     (REG_LPLL_BASE + 0x4E)
#define REG_LPLL_27_H     (REG_LPLL_BASE + 0x4F)
#define REG_LPLL_28_L     (REG_LPLL_BASE + 0x50)
#define REG_LPLL_28_H     (REG_LPLL_BASE + 0x51)
#define REG_LPLL_29_L     (REG_LPLL_BASE + 0x52)
#define REG_LPLL_29_H     (REG_LPLL_BASE + 0x53)
#define REG_LPLL_2A_L     (REG_LPLL_BASE + 0x54)
#define REG_LPLL_2A_H     (REG_LPLL_BASE + 0x55)
#define REG_LPLL_2B_L     (REG_LPLL_BASE + 0x56)
#define REG_LPLL_2B_H     (REG_LPLL_BASE + 0x57)
#define REG_LPLL_2C_L     (REG_LPLL_BASE + 0x58)
#define REG_LPLL_2C_H     (REG_LPLL_BASE + 0x59)
#define REG_LPLL_2D_L     (REG_LPLL_BASE + 0x5A)
#define REG_LPLL_2D_H     (REG_LPLL_BASE + 0x5B)
#define REG_LPLL_2E_L     (REG_LPLL_BASE + 0x5C)
#define REG_LPLL_2E_H     (REG_LPLL_BASE + 0x5D)
#define REG_LPLL_2F_L     (REG_LPLL_BASE + 0x5E)
#define REG_LPLL_2F_H     (REG_LPLL_BASE + 0x5F)
#define REG_LPLL_30_L     (REG_LPLL_BASE + 0x60)
#define REG_LPLL_30_H     (REG_LPLL_BASE + 0x61)
#define REG_LPLL_31_L     (REG_LPLL_BASE + 0x62)
#define REG_LPLL_31_H     (REG_LPLL_BASE + 0x63)
#define REG_LPLL_32_L     (REG_LPLL_BASE + 0x64)
#define REG_LPLL_32_H     (REG_LPLL_BASE + 0x65)
#define REG_LPLL_33_L     (REG_LPLL_BASE + 0x66)
#define REG_LPLL_33_H     (REG_LPLL_BASE + 0x67)
#define REG_LPLL_34_L     (REG_LPLL_BASE + 0x68)
#define REG_LPLL_34_H     (REG_LPLL_BASE + 0x69)
#define REG_LPLL_35_L     (REG_LPLL_BASE + 0x6A)
#define REG_LPLL_35_H     (REG_LPLL_BASE + 0x6B)
#define REG_LPLL_36_L     (REG_LPLL_BASE + 0x6C)
#define REG_LPLL_36_H     (REG_LPLL_BASE + 0x6D)
#define REG_LPLL_37_L     (REG_LPLL_BASE + 0x6E)
#define REG_LPLL_37_H     (REG_LPLL_BASE + 0x6F)
#define REG_LPLL_38_L     (REG_LPLL_BASE + 0x70)
#define REG_LPLL_38_H     (REG_LPLL_BASE + 0x71)
#define REG_LPLL_39_L     (REG_LPLL_BASE + 0x72)
#define REG_LPLL_39_H     (REG_LPLL_BASE + 0x73)
#define REG_LPLL_3A_L     (REG_LPLL_BASE + 0x74)
#define REG_LPLL_3A_H     (REG_LPLL_BASE + 0x75)
#define REG_LPLL_3B_L     (REG_LPLL_BASE + 0x76)
#define REG_LPLL_3B_H     (REG_LPLL_BASE + 0x77)
#define REG_LPLL_3C_L     (REG_LPLL_BASE + 0x78)
#define REG_LPLL_3C_H     (REG_LPLL_BASE + 0x79)
#define REG_LPLL_3D_L     (REG_LPLL_BASE + 0x7A)
#define REG_LPLL_3D_H     (REG_LPLL_BASE + 0x7B)
#define REG_LPLL_3E_L     (REG_LPLL_BASE + 0x7C)
#define REG_LPLL_3E_H     (REG_LPLL_BASE + 0x7D)
#define REG_LPLL_3F_L     (REG_LPLL_BASE + 0x7E)
#define REG_LPLL_3F_H     (REG_LPLL_BASE + 0x7F)
#define REG_LPLL_40_L     (REG_LPLL_BASE + 0x80)
#define REG_LPLL_40_H     (REG_LPLL_BASE + 0x81)
#define REG_LPLL_41_L     (REG_LPLL_BASE + 0x82)
#define REG_LPLL_41_H     (REG_LPLL_BASE + 0x83)
#define REG_LPLL_42_L     (REG_LPLL_BASE + 0x84)
#define REG_LPLL_42_H     (REG_LPLL_BASE + 0x85)
#define REG_LPLL_43_L     (REG_LPLL_BASE + 0x86)
#define REG_LPLL_43_H     (REG_LPLL_BASE + 0x87)
#define REG_LPLL_44_L     (REG_LPLL_BASE + 0x88)
#define REG_LPLL_44_H     (REG_LPLL_BASE + 0x89)
#define REG_LPLL_45_L     (REG_LPLL_BASE + 0x8A)
#define REG_LPLL_45_H     (REG_LPLL_BASE + 0x8B)
#define REG_LPLL_46_L     (REG_LPLL_BASE + 0x8C)
#define REG_LPLL_46_H     (REG_LPLL_BASE + 0x8D)
#define REG_LPLL_47_L     (REG_LPLL_BASE + 0x8E)
#define REG_LPLL_47_H     (REG_LPLL_BASE + 0x8F)
#define REG_LPLL_48_L     (REG_LPLL_BASE + 0x90)
#define REG_LPLL_48_H     (REG_LPLL_BASE + 0x91)
#define REG_LPLL_49_L     (REG_LPLL_BASE + 0x92)
#define REG_LPLL_49_H     (REG_LPLL_BASE + 0x93)
#define REG_LPLL_4A_L     (REG_LPLL_BASE + 0x94)
#define REG_LPLL_4A_H     (REG_LPLL_BASE + 0x95)
#define REG_LPLL_4B_L     (REG_LPLL_BASE + 0x96)
#define REG_LPLL_4B_H     (REG_LPLL_BASE + 0x97)
#define REG_LPLL_4C_L     (REG_LPLL_BASE + 0x98)
#define REG_LPLL_4C_H     (REG_LPLL_BASE + 0x99)
#define REG_LPLL_4D_L     (REG_LPLL_BASE + 0x9A)
#define REG_LPLL_4D_H     (REG_LPLL_BASE + 0x9B)
#define REG_LPLL_4E_L     (REG_LPLL_BASE + 0x9C)
#define REG_LPLL_4E_H     (REG_LPLL_BASE + 0x9D)
#define REG_LPLL_4F_L     (REG_LPLL_BASE + 0x9E)
#define REG_LPLL_4F_H     (REG_LPLL_BASE + 0x9F)
#define REG_LPLL_50_L     (REG_LPLL_BASE + 0xA0)
#define REG_LPLL_50_H     (REG_LPLL_BASE + 0xA1)
#define REG_LPLL_51_L     (REG_LPLL_BASE + 0xA2)
#define REG_LPLL_51_H     (REG_LPLL_BASE + 0xA3)
#define REG_LPLL_52_L     (REG_LPLL_BASE + 0xA4)
#define REG_LPLL_52_H     (REG_LPLL_BASE + 0xA5)
#define REG_LPLL_53_L     (REG_LPLL_BASE + 0xA6)
#define REG_LPLL_53_H     (REG_LPLL_BASE + 0xA7)
#define REG_LPLL_54_L     (REG_LPLL_BASE + 0xA8)
#define REG_LPLL_54_H     (REG_LPLL_BASE + 0xA9)
#define REG_LPLL_55_L     (REG_LPLL_BASE + 0xAA)
#define REG_LPLL_55_H     (REG_LPLL_BASE + 0xAB)
#define REG_LPLL_56_L     (REG_LPLL_BASE + 0xAC)
#define REG_LPLL_56_H     (REG_LPLL_BASE + 0xAD)
#define REG_LPLL_57_L     (REG_LPLL_BASE + 0xAE)
#define REG_LPLL_57_H     (REG_LPLL_BASE + 0xAF)
#define REG_LPLL_58_L     (REG_LPLL_BASE + 0xB0)
#define REG_LPLL_58_H     (REG_LPLL_BASE + 0xB1)
#define REG_LPLL_59_L     (REG_LPLL_BASE + 0xB2)
#define REG_LPLL_59_H     (REG_LPLL_BASE + 0xB3)
#define REG_LPLL_5A_L     (REG_LPLL_BASE + 0xB4)
#define REG_LPLL_5A_H     (REG_LPLL_BASE + 0xB5)
#define REG_LPLL_5B_L     (REG_LPLL_BASE + 0xB6)
#define REG_LPLL_5B_H     (REG_LPLL_BASE + 0xB7)
#define REG_LPLL_5C_L     (REG_LPLL_BASE + 0xB8)
#define REG_LPLL_5C_H     (REG_LPLL_BASE + 0xB9)
#define REG_LPLL_5D_L     (REG_LPLL_BASE + 0xBA)
#define REG_LPLL_5D_H     (REG_LPLL_BASE + 0xBB)
#define REG_LPLL_5E_L     (REG_LPLL_BASE + 0xBC)
#define REG_LPLL_5E_H     (REG_LPLL_BASE + 0xBD)
#define REG_LPLL_5F_L     (REG_LPLL_BASE + 0xBE)
#define REG_LPLL_5F_H     (REG_LPLL_BASE + 0xBF)
#define REG_LPLL_60_L     (REG_LPLL_BASE + 0xC0)
#define REG_LPLL_60_H     (REG_LPLL_BASE + 0xC1)
#define REG_LPLL_61_L     (REG_LPLL_BASE + 0xC2)
#define REG_LPLL_61_H     (REG_LPLL_BASE + 0xC3)
#define REG_LPLL_62_L     (REG_LPLL_BASE + 0xC4)
#define REG_LPLL_62_H     (REG_LPLL_BASE + 0xC5)
#define REG_LPLL_63_L     (REG_LPLL_BASE + 0xC6)
#define REG_LPLL_63_H     (REG_LPLL_BASE + 0xC7)
#define REG_LPLL_64_L     (REG_LPLL_BASE + 0xC8)
#define REG_LPLL_64_H     (REG_LPLL_BASE + 0xC9)
#define REG_LPLL_65_L     (REG_LPLL_BASE + 0xCA)
#define REG_LPLL_65_H     (REG_LPLL_BASE + 0xCB)
#define REG_LPLL_66_L     (REG_LPLL_BASE + 0xCC)
#define REG_LPLL_66_H     (REG_LPLL_BASE + 0xCD)
#define REG_LPLL_67_L     (REG_LPLL_BASE + 0xCE)
#define REG_LPLL_67_H     (REG_LPLL_BASE + 0xCF)
#define REG_LPLL_68_L     (REG_LPLL_BASE + 0xD0)
#define REG_LPLL_68_H     (REG_LPLL_BASE + 0xD1)
#define REG_LPLL_69_L     (REG_LPLL_BASE + 0xD2)
#define REG_LPLL_69_H     (REG_LPLL_BASE + 0xD3)
#define REG_LPLL_6A_L     (REG_LPLL_BASE + 0xD4)
#define REG_LPLL_6A_H     (REG_LPLL_BASE + 0xD5)
#define REG_LPLL_6B_L     (REG_LPLL_BASE + 0xD6)
#define REG_LPLL_6B_H     (REG_LPLL_BASE + 0xD7)
#define REG_LPLL_6C_L     (REG_LPLL_BASE + 0xD8)
#define REG_LPLL_6C_H     (REG_LPLL_BASE + 0xD9)
#define REG_LPLL_6D_L     (REG_LPLL_BASE + 0xDA)
#define REG_LPLL_6D_H     (REG_LPLL_BASE + 0xDB)
#define REG_LPLL_6E_L     (REG_LPLL_BASE + 0xDC)
#define REG_LPLL_6E_H     (REG_LPLL_BASE + 0xDD)
#define REG_LPLL_6F_L     (REG_LPLL_BASE + 0xDE)
#define REG_LPLL_6F_H     (REG_LPLL_BASE + 0xDF)
#define REG_LPLL_70_L     (REG_LPLL_BASE + 0xE0)
#define REG_LPLL_70_H     (REG_LPLL_BASE + 0xE1)
#define REG_LPLL_71_L     (REG_LPLL_BASE + 0xE2)
#define REG_LPLL_71_H     (REG_LPLL_BASE + 0xE3)
#define REG_LPLL_72_L     (REG_LPLL_BASE + 0xE4)
#define REG_LPLL_72_H     (REG_LPLL_BASE + 0xE5)
#define REG_LPLL_73_L     (REG_LPLL_BASE + 0xE6)
#define REG_LPLL_73_H     (REG_LPLL_BASE + 0xE7)
#define REG_LPLL_74_L     (REG_LPLL_BASE + 0xE8)
#define REG_LPLL_74_H     (REG_LPLL_BASE + 0xE9)
#define REG_LPLL_75_L     (REG_LPLL_BASE + 0xEA)
#define REG_LPLL_75_H     (REG_LPLL_BASE + 0xEB)
#define REG_LPLL_76_L     (REG_LPLL_BASE + 0xEC)
#define REG_LPLL_76_H     (REG_LPLL_BASE + 0xED)
#define REG_LPLL_77_L     (REG_LPLL_BASE + 0xEE)
#define REG_LPLL_77_H     (REG_LPLL_BASE + 0xEF)
#define REG_LPLL_78_L     (REG_LPLL_BASE + 0xF0)
#define REG_LPLL_78_H     (REG_LPLL_BASE + 0xF1)
#define REG_LPLL_79_L     (REG_LPLL_BASE + 0xF2)
#define REG_LPLL_79_H     (REG_LPLL_BASE + 0xF3)
#define REG_LPLL_7A_L     (REG_LPLL_BASE + 0xF4)
#define REG_LPLL_7A_H     (REG_LPLL_BASE + 0xF5)
#define REG_LPLL_7B_L     (REG_LPLL_BASE + 0xF6)
#define REG_LPLL_7B_H     (REG_LPLL_BASE + 0xF7)
#define REG_LPLL_7C_L     (REG_LPLL_BASE + 0xF8)
#define REG_LPLL_7C_H     (REG_LPLL_BASE + 0xF9)
#define REG_LPLL_7D_L     (REG_LPLL_BASE + 0xFA)
#define REG_LPLL_7D_H     (REG_LPLL_BASE + 0xFB)
#define REG_LPLL_7E_L     (REG_LPLL_BASE + 0xFC)
#define REG_LPLL_7E_H     (REG_LPLL_BASE + 0xFD)
#define REG_LPLL_7F_L     (REG_LPLL_BASE + 0xFE)
#define REG_LPLL_7F_H     (REG_LPLL_BASE + 0xFF)


#define REG_DISP_TOP_00_L    (REG_DISP_TOP_BASE + 0x00)
#define REG_DISP_TOP_00_H    (REG_DISP_TOP_BASE + 0x01)
#define REG_DISP_TOP_01_L    (REG_DISP_TOP_BASE + 0x02)
#define REG_DISP_TOP_01_H    (REG_DISP_TOP_BASE + 0x03)
#define REG_DISP_TOP_02_L    (REG_DISP_TOP_BASE + 0x04)
#define REG_DISP_TOP_02_H    (REG_DISP_TOP_BASE + 0x05)
#define REG_DISP_TOP_03_L    (REG_DISP_TOP_BASE + 0x06)
#define REG_DISP_TOP_03_H    (REG_DISP_TOP_BASE + 0x07)
#define REG_DISP_TOP_04_L    (REG_DISP_TOP_BASE + 0x08)
#define REG_DISP_TOP_04_H    (REG_DISP_TOP_BASE + 0x09)
#define REG_DISP_TOP_05_L    (REG_DISP_TOP_BASE + 0x0A)
#define REG_DISP_TOP_05_H    (REG_DISP_TOP_BASE + 0x0B)
#define REG_DISP_TOP_06_L    (REG_DISP_TOP_BASE + 0x0C)
#define REG_DISP_TOP_06_H    (REG_DISP_TOP_BASE + 0x0D)
#define REG_DISP_TOP_07_L    (REG_DISP_TOP_BASE + 0x0E)
#define REG_DISP_TOP_07_H    (REG_DISP_TOP_BASE + 0x0F)
#define REG_DISP_TOP_08_L    (REG_DISP_TOP_BASE + 0x10)
#define REG_DISP_TOP_08_H    (REG_DISP_TOP_BASE + 0x11)
#define REG_DISP_TOP_09_L    (REG_DISP_TOP_BASE + 0x12)
#define REG_DISP_TOP_09_H    (REG_DISP_TOP_BASE + 0x13)
#define REG_DISP_TOP_0A_L    (REG_DISP_TOP_BASE + 0x14)
#define REG_DISP_TOP_0A_H    (REG_DISP_TOP_BASE + 0x15)
#define REG_DISP_TOP_0B_L    (REG_DISP_TOP_BASE + 0x16)
#define REG_DISP_TOP_0B_H    (REG_DISP_TOP_BASE + 0x17)
#define REG_DISP_TOP_0C_L    (REG_DISP_TOP_BASE + 0x18)
#define REG_DISP_TOP_0C_H    (REG_DISP_TOP_BASE + 0x19)
#define REG_DISP_TOP_0D_L    (REG_DISP_TOP_BASE + 0x1A)
#define REG_DISP_TOP_0D_H    (REG_DISP_TOP_BASE + 0x1B)
#define REG_DISP_TOP_0E_L    (REG_DISP_TOP_BASE + 0x1C)
#define REG_DISP_TOP_0E_H    (REG_DISP_TOP_BASE + 0x1D)
#define REG_DISP_TOP_0F_L    (REG_DISP_TOP_BASE + 0x1E)
#define REG_DISP_TOP_0F_H    (REG_DISP_TOP_BASE + 0x1F)
#define REG_DISP_TOP_10_L    (REG_DISP_TOP_BASE + 0x20)
#define REG_DISP_TOP_10_H    (REG_DISP_TOP_BASE + 0x21)
#define REG_DISP_TOP_11_L    (REG_DISP_TOP_BASE + 0x22)
#define REG_DISP_TOP_11_H    (REG_DISP_TOP_BASE + 0x23)
#define REG_DISP_TOP_12_L    (REG_DISP_TOP_BASE + 0x24)
#define REG_DISP_TOP_12_H    (REG_DISP_TOP_BASE + 0x25)
#define REG_DISP_TOP_13_L    (REG_DISP_TOP_BASE + 0x26)
#define REG_DISP_TOP_13_H    (REG_DISP_TOP_BASE + 0x27)
#define REG_DISP_TOP_14_L    (REG_DISP_TOP_BASE + 0x28)
#define REG_DISP_TOP_14_H    (REG_DISP_TOP_BASE + 0x29)
#define REG_DISP_TOP_15_L    (REG_DISP_TOP_BASE + 0x2A)
#define REG_DISP_TOP_15_H    (REG_DISP_TOP_BASE + 0x2B)
#define REG_DISP_TOP_16_L    (REG_DISP_TOP_BASE + 0x2C)
#define REG_DISP_TOP_16_H    (REG_DISP_TOP_BASE + 0x2D)
#define REG_DISP_TOP_17_L    (REG_DISP_TOP_BASE + 0x2E)
#define REG_DISP_TOP_17_H    (REG_DISP_TOP_BASE + 0x2F)
#define REG_DISP_TOP_18_L    (REG_DISP_TOP_BASE + 0x30)
#define REG_DISP_TOP_18_H    (REG_DISP_TOP_BASE + 0x31)
#define REG_DISP_TOP_19_L    (REG_DISP_TOP_BASE + 0x32)
#define REG_DISP_TOP_19_H    (REG_DISP_TOP_BASE + 0x33)
#define REG_DISP_TOP_1A_L    (REG_DISP_TOP_BASE + 0x34)
#define REG_DISP_TOP_1A_H    (REG_DISP_TOP_BASE + 0x35)
#define REG_DISP_TOP_1B_L    (REG_DISP_TOP_BASE + 0x36)
#define REG_DISP_TOP_1B_H    (REG_DISP_TOP_BASE + 0x37)
#define REG_DISP_TOP_1C_L    (REG_DISP_TOP_BASE + 0x38)
#define REG_DISP_TOP_1C_H    (REG_DISP_TOP_BASE + 0x39)
#define REG_DISP_TOP_1D_L    (REG_DISP_TOP_BASE + 0x3A)
#define REG_DISP_TOP_1D_H    (REG_DISP_TOP_BASE + 0x3B)
#define REG_DISP_TOP_1E_L    (REG_DISP_TOP_BASE + 0x3C)
#define REG_DISP_TOP_1E_H    (REG_DISP_TOP_BASE + 0x3D)
#define REG_DISP_TOP_1F_L    (REG_DISP_TOP_BASE + 0x3E)
#define REG_DISP_TOP_1F_H    (REG_DISP_TOP_BASE + 0x3F)
#define REG_DISP_TOP_20_L    (REG_DISP_TOP_BASE + 0x40)
#define REG_DISP_TOP_20_H    (REG_DISP_TOP_BASE + 0x41)
#define REG_DISP_TOP_21_L    (REG_DISP_TOP_BASE + 0x42)
#define REG_DISP_TOP_21_H    (REG_DISP_TOP_BASE + 0x43)
#define REG_DISP_TOP_22_L    (REG_DISP_TOP_BASE + 0x44)
#define REG_DISP_TOP_22_H    (REG_DISP_TOP_BASE + 0x45)
#define REG_DISP_TOP_23_L    (REG_DISP_TOP_BASE + 0x46)
#define REG_DISP_TOP_23_H    (REG_DISP_TOP_BASE + 0x47)
#define REG_DISP_TOP_24_L    (REG_DISP_TOP_BASE + 0x48)
#define REG_DISP_TOP_24_H    (REG_DISP_TOP_BASE + 0x49)
#define REG_DISP_TOP_25_L    (REG_DISP_TOP_BASE + 0x4A)
#define REG_DISP_TOP_25_H    (REG_DISP_TOP_BASE + 0x4B)
#define REG_DISP_TOP_26_L    (REG_DISP_TOP_BASE + 0x4C)
#define REG_DISP_TOP_26_H    (REG_DISP_TOP_BASE + 0x4D)
#define REG_DISP_TOP_27_L    (REG_DISP_TOP_BASE + 0x4E)
#define REG_DISP_TOP_27_H    (REG_DISP_TOP_BASE + 0x4F)
#define REG_DISP_TOP_28_L    (REG_DISP_TOP_BASE + 0x50)
#define REG_DISP_TOP_28_H    (REG_DISP_TOP_BASE + 0x51)
#define REG_DISP_TOP_29_L    (REG_DISP_TOP_BASE + 0x52)
#define REG_DISP_TOP_29_H    (REG_DISP_TOP_BASE + 0x53)
#define REG_DISP_TOP_2A_L    (REG_DISP_TOP_BASE + 0x54)
#define REG_DISP_TOP_2A_H    (REG_DISP_TOP_BASE + 0x55)
#define REG_DISP_TOP_2B_L    (REG_DISP_TOP_BASE + 0x56)
#define REG_DISP_TOP_2B_H    (REG_DISP_TOP_BASE + 0x57)
#define REG_DISP_TOP_2C_L    (REG_DISP_TOP_BASE + 0x58)
#define REG_DISP_TOP_2C_H    (REG_DISP_TOP_BASE + 0x59)
#define REG_DISP_TOP_2D_L    (REG_DISP_TOP_BASE + 0x5A)
#define REG_DISP_TOP_2D_H    (REG_DISP_TOP_BASE + 0x5B)
#define REG_DISP_TOP_2E_L    (REG_DISP_TOP_BASE + 0x5C)
#define REG_DISP_TOP_2E_H    (REG_DISP_TOP_BASE + 0x5D)
#define REG_DISP_TOP_2F_L    (REG_DISP_TOP_BASE + 0x5E)
#define REG_DISP_TOP_2F_H    (REG_DISP_TOP_BASE + 0x5F)
#define REG_DISP_TOP_30_L    (REG_DISP_TOP_BASE + 0x60)
#define REG_DISP_TOP_30_H    (REG_DISP_TOP_BASE + 0x61)
#define REG_DISP_TOP_31_L    (REG_DISP_TOP_BASE + 0x62)
#define REG_DISP_TOP_31_H    (REG_DISP_TOP_BASE + 0x63)
#define REG_DISP_TOP_32_L    (REG_DISP_TOP_BASE + 0x64)
#define REG_DISP_TOP_32_H    (REG_DISP_TOP_BASE + 0x65)
#define REG_DISP_TOP_33_L    (REG_DISP_TOP_BASE + 0x66)
#define REG_DISP_TOP_33_H    (REG_DISP_TOP_BASE + 0x67)
#define REG_DISP_TOP_34_L    (REG_DISP_TOP_BASE + 0x68)
#define REG_DISP_TOP_34_H    (REG_DISP_TOP_BASE + 0x69)
#define REG_DISP_TOP_35_L    (REG_DISP_TOP_BASE + 0x6A)
#define REG_DISP_TOP_35_H    (REG_DISP_TOP_BASE + 0x6B)
#define REG_DISP_TOP_36_L    (REG_DISP_TOP_BASE + 0x6C)
#define REG_DISP_TOP_36_H    (REG_DISP_TOP_BASE + 0x6D)
#define REG_DISP_TOP_37_L    (REG_DISP_TOP_BASE + 0x6E)
#define REG_DISP_TOP_37_H    (REG_DISP_TOP_BASE + 0x6F)
#define REG_DISP_TOP_38_L    (REG_DISP_TOP_BASE + 0x70)
#define REG_DISP_TOP_38_H    (REG_DISP_TOP_BASE + 0x71)
#define REG_DISP_TOP_39_L    (REG_DISP_TOP_BASE + 0x72)
#define REG_DISP_TOP_39_H    (REG_DISP_TOP_BASE + 0x73)
#define REG_DISP_TOP_3A_L    (REG_DISP_TOP_BASE + 0x74)
#define REG_DISP_TOP_3A_H    (REG_DISP_TOP_BASE + 0x75)
#define REG_DISP_TOP_3B_L    (REG_DISP_TOP_BASE + 0x76)
#define REG_DISP_TOP_3B_H    (REG_DISP_TOP_BASE + 0x77)
#define REG_DISP_TOP_3C_L    (REG_DISP_TOP_BASE + 0x78)
#define REG_DISP_TOP_3C_H    (REG_DISP_TOP_BASE + 0x79)
#define REG_DISP_TOP_3D_L    (REG_DISP_TOP_BASE + 0x7A)
#define REG_DISP_TOP_3D_H    (REG_DISP_TOP_BASE + 0x7B)
#define REG_DISP_TOP_3E_L    (REG_DISP_TOP_BASE + 0x7C)
#define REG_DISP_TOP_3E_H    (REG_DISP_TOP_BASE + 0x7D)
#define REG_DISP_TOP_3F_L    (REG_DISP_TOP_BASE + 0x7E)
#define REG_DISP_TOP_3F_H    (REG_DISP_TOP_BASE + 0x7F)
#define REG_DISP_TOP_40_L    (REG_DISP_TOP_BASE + 0x80)
#define REG_DISP_TOP_40_H    (REG_DISP_TOP_BASE + 0x81)
#define REG_DISP_TOP_41_L    (REG_DISP_TOP_BASE + 0x82)
#define REG_DISP_TOP_41_H    (REG_DISP_TOP_BASE + 0x83)
#define REG_DISP_TOP_42_L    (REG_DISP_TOP_BASE + 0x84)
#define REG_DISP_TOP_42_H    (REG_DISP_TOP_BASE + 0x85)
#define REG_DISP_TOP_43_L    (REG_DISP_TOP_BASE + 0x86)
#define REG_DISP_TOP_43_H    (REG_DISP_TOP_BASE + 0x87)
#define REG_DISP_TOP_44_L    (REG_DISP_TOP_BASE + 0x88)
#define REG_DISP_TOP_44_H    (REG_DISP_TOP_BASE + 0x89)
#define REG_DISP_TOP_45_L    (REG_DISP_TOP_BASE + 0x8A)
#define REG_DISP_TOP_45_H    (REG_DISP_TOP_BASE + 0x8B)
#define REG_DISP_TOP_46_L    (REG_DISP_TOP_BASE + 0x8C)
#define REG_DISP_TOP_46_H    (REG_DISP_TOP_BASE + 0x8D)
#define REG_DISP_TOP_47_L    (REG_DISP_TOP_BASE + 0x8E)
#define REG_DISP_TOP_47_H    (REG_DISP_TOP_BASE + 0x8F)
#define REG_DISP_TOP_48_L    (REG_DISP_TOP_BASE + 0x90)
#define REG_DISP_TOP_48_H    (REG_DISP_TOP_BASE + 0x91)
#define REG_DISP_TOP_49_L    (REG_DISP_TOP_BASE + 0x92)
#define REG_DISP_TOP_49_H    (REG_DISP_TOP_BASE + 0x93)
#define REG_DISP_TOP_4A_L    (REG_DISP_TOP_BASE + 0x94)
#define REG_DISP_TOP_4A_H    (REG_DISP_TOP_BASE + 0x95)
#define REG_DISP_TOP_4B_L    (REG_DISP_TOP_BASE + 0x96)
#define REG_DISP_TOP_4B_H    (REG_DISP_TOP_BASE + 0x97)
#define REG_DISP_TOP_4C_L    (REG_DISP_TOP_BASE + 0x98)
#define REG_DISP_TOP_4C_H    (REG_DISP_TOP_BASE + 0x99)
#define REG_DISP_TOP_4D_L    (REG_DISP_TOP_BASE + 0x9A)
#define REG_DISP_TOP_4D_H    (REG_DISP_TOP_BASE + 0x9B)
#define REG_DISP_TOP_4E_L    (REG_DISP_TOP_BASE + 0x9C)
#define REG_DISP_TOP_4E_H    (REG_DISP_TOP_BASE + 0x9D)
#define REG_DISP_TOP_4F_L    (REG_DISP_TOP_BASE + 0x9E)
#define REG_DISP_TOP_4F_H    (REG_DISP_TOP_BASE + 0x9F)
#define REG_DISP_TOP_50_L    (REG_DISP_TOP_BASE + 0xA0)
#define REG_DISP_TOP_50_H    (REG_DISP_TOP_BASE + 0xA1)
#define REG_DISP_TOP_51_L    (REG_DISP_TOP_BASE + 0xA2)
#define REG_DISP_TOP_51_H    (REG_DISP_TOP_BASE + 0xA3)
#define REG_DISP_TOP_52_L    (REG_DISP_TOP_BASE + 0xA4)
#define REG_DISP_TOP_52_H    (REG_DISP_TOP_BASE + 0xA5)
#define REG_DISP_TOP_53_L    (REG_DISP_TOP_BASE + 0xA6)
#define REG_DISP_TOP_53_H    (REG_DISP_TOP_BASE + 0xA7)
#define REG_DISP_TOP_54_L    (REG_DISP_TOP_BASE + 0xA8)
#define REG_DISP_TOP_54_H    (REG_DISP_TOP_BASE + 0xA9)
#define REG_DISP_TOP_55_L    (REG_DISP_TOP_BASE + 0xAA)
#define REG_DISP_TOP_55_H    (REG_DISP_TOP_BASE + 0xAB)
#define REG_DISP_TOP_56_L    (REG_DISP_TOP_BASE + 0xAC)
#define REG_DISP_TOP_56_H    (REG_DISP_TOP_BASE + 0xAD)
#define REG_DISP_TOP_57_L    (REG_DISP_TOP_BASE + 0xAE)
#define REG_DISP_TOP_57_H    (REG_DISP_TOP_BASE + 0xAF)
#define REG_DISP_TOP_58_L    (REG_DISP_TOP_BASE + 0xB0)
#define REG_DISP_TOP_58_H    (REG_DISP_TOP_BASE + 0xB1)
#define REG_DISP_TOP_59_L    (REG_DISP_TOP_BASE + 0xB2)
#define REG_DISP_TOP_59_H    (REG_DISP_TOP_BASE + 0xB3)
#define REG_DISP_TOP_5A_L    (REG_DISP_TOP_BASE + 0xB4)
#define REG_DISP_TOP_5A_H    (REG_DISP_TOP_BASE + 0xB5)
#define REG_DISP_TOP_5B_L    (REG_DISP_TOP_BASE + 0xB6)
#define REG_DISP_TOP_5B_H    (REG_DISP_TOP_BASE + 0xB7)
#define REG_DISP_TOP_5C_L    (REG_DISP_TOP_BASE + 0xB8)
#define REG_DISP_TOP_5C_H    (REG_DISP_TOP_BASE + 0xB9)
#define REG_DISP_TOP_5D_L    (REG_DISP_TOP_BASE + 0xBA)
#define REG_DISP_TOP_5D_H    (REG_DISP_TOP_BASE + 0xBB)
#define REG_DISP_TOP_5E_L    (REG_DISP_TOP_BASE + 0xBC)
#define REG_DISP_TOP_5E_H    (REG_DISP_TOP_BASE + 0xBD)
#define REG_DISP_TOP_5F_L    (REG_DISP_TOP_BASE + 0xBE)
#define REG_DISP_TOP_5F_H    (REG_DISP_TOP_BASE + 0xBF)
#define REG_DISP_TOP_60_L    (REG_DISP_TOP_BASE + 0xC0)
#define REG_DISP_TOP_60_H    (REG_DISP_TOP_BASE + 0xC1)
#define REG_DISP_TOP_61_L    (REG_DISP_TOP_BASE + 0xC2)
#define REG_DISP_TOP_61_H    (REG_DISP_TOP_BASE + 0xC3)
#define REG_DISP_TOP_62_L    (REG_DISP_TOP_BASE + 0xC4)
#define REG_DISP_TOP_62_H    (REG_DISP_TOP_BASE + 0xC5)
#define REG_DISP_TOP_63_L    (REG_DISP_TOP_BASE + 0xC6)
#define REG_DISP_TOP_63_H    (REG_DISP_TOP_BASE + 0xC7)
#define REG_DISP_TOP_64_L    (REG_DISP_TOP_BASE + 0xC8)
#define REG_DISP_TOP_64_H    (REG_DISP_TOP_BASE + 0xC9)
#define REG_DISP_TOP_65_L    (REG_DISP_TOP_BASE + 0xCA)
#define REG_DISP_TOP_65_H    (REG_DISP_TOP_BASE + 0xCB)
#define REG_DISP_TOP_66_L    (REG_DISP_TOP_BASE + 0xCC)
#define REG_DISP_TOP_66_H    (REG_DISP_TOP_BASE + 0xCD)
#define REG_DISP_TOP_67_L    (REG_DISP_TOP_BASE + 0xCE)
#define REG_DISP_TOP_67_H    (REG_DISP_TOP_BASE + 0xCF)
#define REG_DISP_TOP_68_L    (REG_DISP_TOP_BASE + 0xD0)
#define REG_DISP_TOP_68_H    (REG_DISP_TOP_BASE + 0xD1)
#define REG_DISP_TOP_69_L    (REG_DISP_TOP_BASE + 0xD2)
#define REG_DISP_TOP_69_H    (REG_DISP_TOP_BASE + 0xD3)
#define REG_DISP_TOP_6A_L    (REG_DISP_TOP_BASE + 0xD4)
#define REG_DISP_TOP_6A_H    (REG_DISP_TOP_BASE + 0xD5)
#define REG_DISP_TOP_6B_L    (REG_DISP_TOP_BASE + 0xD6)
#define REG_DISP_TOP_6B_H    (REG_DISP_TOP_BASE + 0xD7)
#define REG_DISP_TOP_6C_L    (REG_DISP_TOP_BASE + 0xD8)
#define REG_DISP_TOP_6C_H    (REG_DISP_TOP_BASE + 0xD9)
#define REG_DISP_TOP_6D_L    (REG_DISP_TOP_BASE + 0xDA)
#define REG_DISP_TOP_6D_H    (REG_DISP_TOP_BASE + 0xDB)
#define REG_DISP_TOP_6E_L    (REG_DISP_TOP_BASE + 0xDC)
#define REG_DISP_TOP_6E_H    (REG_DISP_TOP_BASE + 0xDD)
#define REG_DISP_TOP_6F_L    (REG_DISP_TOP_BASE + 0xDE)
#define REG_DISP_TOP_6F_H    (REG_DISP_TOP_BASE + 0xDF)
#define REG_DISP_TOP_70_L    (REG_DISP_TOP_BASE + 0xE0)
#define REG_DISP_TOP_70_H    (REG_DISP_TOP_BASE + 0xE1)
#define REG_DISP_TOP_71_L    (REG_DISP_TOP_BASE + 0xE2)
#define REG_DISP_TOP_71_H    (REG_DISP_TOP_BASE + 0xE3)
#define REG_DISP_TOP_72_L    (REG_DISP_TOP_BASE + 0xE4)
#define REG_DISP_TOP_72_H    (REG_DISP_TOP_BASE + 0xE5)
#define REG_DISP_TOP_73_L    (REG_DISP_TOP_BASE + 0xE6)
#define REG_DISP_TOP_73_H    (REG_DISP_TOP_BASE + 0xE7)
#define REG_DISP_TOP_74_L    (REG_DISP_TOP_BASE + 0xE8)
#define REG_DISP_TOP_74_H    (REG_DISP_TOP_BASE + 0xE9)
#define REG_DISP_TOP_75_L    (REG_DISP_TOP_BASE + 0xEA)
#define REG_DISP_TOP_75_H    (REG_DISP_TOP_BASE + 0xEB)
#define REG_DISP_TOP_76_L    (REG_DISP_TOP_BASE + 0xEC)
#define REG_DISP_TOP_76_H    (REG_DISP_TOP_BASE + 0xED)
#define REG_DISP_TOP_77_L    (REG_DISP_TOP_BASE + 0xEE)
#define REG_DISP_TOP_77_H    (REG_DISP_TOP_BASE + 0xEF)
#define REG_DISP_TOP_78_L    (REG_DISP_TOP_BASE + 0xF0)
#define REG_DISP_TOP_78_H    (REG_DISP_TOP_BASE + 0xF1)
#define REG_DISP_TOP_79_L    (REG_DISP_TOP_BASE + 0xF2)
#define REG_DISP_TOP_79_H    (REG_DISP_TOP_BASE + 0xF3)
#define REG_DISP_TOP_7A_L    (REG_DISP_TOP_BASE + 0xF4)
#define REG_DISP_TOP_7A_H    (REG_DISP_TOP_BASE + 0xF5)
#define REG_DISP_TOP_7B_L    (REG_DISP_TOP_BASE + 0xF6)
#define REG_DISP_TOP_7B_H    (REG_DISP_TOP_BASE + 0xF7)
#define REG_DISP_TOP_7C_L    (REG_DISP_TOP_BASE + 0xF8)
#define REG_DISP_TOP_7C_H    (REG_DISP_TOP_BASE + 0xF9)
#define REG_DISP_TOP_7D_L    (REG_DISP_TOP_BASE + 0xFA)
#define REG_DISP_TOP_7D_H    (REG_DISP_TOP_BASE + 0xFB)
#define REG_DISP_TOP_7E_L    (REG_DISP_TOP_BASE + 0xFC)
#define REG_DISP_TOP_7E_H    (REG_DISP_TOP_BASE + 0xFD)
#define REG_DISP_TOP_7F_L    (REG_DISP_TOP_BASE + 0xFE)
#define REG_DISP_TOP_7F_H    (REG_DISP_TOP_BASE + 0xFF)

#define REG_DISP_TOP_OP2_00_L    (REG_DISP_TOP_OP2_BASE + 0x00)
#define REG_DISP_TOP_OP2_00_H    (REG_DISP_TOP_OP2_BASE + 0x01)
#define REG_DISP_TOP_OP2_01_L    (REG_DISP_TOP_OP2_BASE + 0x02)
#define REG_DISP_TOP_OP2_01_H    (REG_DISP_TOP_OP2_BASE + 0x03)
#define REG_DISP_TOP_OP2_02_L    (REG_DISP_TOP_OP2_BASE + 0x04)
#define REG_DISP_TOP_OP2_02_H    (REG_DISP_TOP_OP2_BASE + 0x05)
#define REG_DISP_TOP_OP2_03_L    (REG_DISP_TOP_OP2_BASE + 0x06)
#define REG_DISP_TOP_OP2_03_H    (REG_DISP_TOP_OP2_BASE + 0x07)
#define REG_DISP_TOP_OP2_04_L    (REG_DISP_TOP_OP2_BASE + 0x08)
#define REG_DISP_TOP_OP2_04_H    (REG_DISP_TOP_OP2_BASE + 0x09)
#define REG_DISP_TOP_OP2_05_L    (REG_DISP_TOP_OP2_BASE + 0x0A)
#define REG_DISP_TOP_OP2_05_H    (REG_DISP_TOP_OP2_BASE + 0x0B)
#define REG_DISP_TOP_OP2_06_L    (REG_DISP_TOP_OP2_BASE + 0x0C)
#define REG_DISP_TOP_OP2_06_H    (REG_DISP_TOP_OP2_BASE + 0x0D)
#define REG_DISP_TOP_OP2_07_L    (REG_DISP_TOP_OP2_BASE + 0x0E)
#define REG_DISP_TOP_OP2_07_H    (REG_DISP_TOP_OP2_BASE + 0x0F)
#define REG_DISP_TOP_OP2_08_L    (REG_DISP_TOP_OP2_BASE + 0x10)
#define REG_DISP_TOP_OP2_08_H    (REG_DISP_TOP_OP2_BASE + 0x11)
#define REG_DISP_TOP_OP2_09_L    (REG_DISP_TOP_OP2_BASE + 0x12)
#define REG_DISP_TOP_OP2_09_H    (REG_DISP_TOP_OP2_BASE + 0x13)
#define REG_DISP_TOP_OP2_0A_L    (REG_DISP_TOP_OP2_BASE + 0x14)
#define REG_DISP_TOP_OP2_0A_H    (REG_DISP_TOP_OP2_BASE + 0x15)
#define REG_DISP_TOP_OP2_0B_L    (REG_DISP_TOP_OP2_BASE + 0x16)
#define REG_DISP_TOP_OP2_0B_H    (REG_DISP_TOP_OP2_BASE + 0x17)
#define REG_DISP_TOP_OP2_0C_L    (REG_DISP_TOP_OP2_BASE + 0x18)
#define REG_DISP_TOP_OP2_0C_H    (REG_DISP_TOP_OP2_BASE + 0x19)
#define REG_DISP_TOP_OP2_0D_L    (REG_DISP_TOP_OP2_BASE + 0x1A)
#define REG_DISP_TOP_OP2_0D_H    (REG_DISP_TOP_OP2_BASE + 0x1B)
#define REG_DISP_TOP_OP2_0E_L    (REG_DISP_TOP_OP2_BASE + 0x1C)
#define REG_DISP_TOP_OP2_0E_H    (REG_DISP_TOP_OP2_BASE + 0x1D)
#define REG_DISP_TOP_OP2_0F_L    (REG_DISP_TOP_OP2_BASE + 0x1E)
#define REG_DISP_TOP_OP2_0F_H    (REG_DISP_TOP_OP2_BASE + 0x1F)
#define REG_DISP_TOP_OP2_10_L    (REG_DISP_TOP_OP2_BASE + 0x20)
#define REG_DISP_TOP_OP2_10_H    (REG_DISP_TOP_OP2_BASE + 0x21)
#define REG_DISP_TOP_OP2_11_L    (REG_DISP_TOP_OP2_BASE + 0x22)
#define REG_DISP_TOP_OP2_11_H    (REG_DISP_TOP_OP2_BASE + 0x23)
#define REG_DISP_TOP_OP2_12_L    (REG_DISP_TOP_OP2_BASE + 0x24)
#define REG_DISP_TOP_OP2_12_H    (REG_DISP_TOP_OP2_BASE + 0x25)
#define REG_DISP_TOP_OP2_13_L    (REG_DISP_TOP_OP2_BASE + 0x26)
#define REG_DISP_TOP_OP2_13_H    (REG_DISP_TOP_OP2_BASE + 0x27)
#define REG_DISP_TOP_OP2_14_L    (REG_DISP_TOP_OP2_BASE + 0x28)
#define REG_DISP_TOP_OP2_14_H    (REG_DISP_TOP_OP2_BASE + 0x29)
#define REG_DISP_TOP_OP2_15_L    (REG_DISP_TOP_OP2_BASE + 0x2A)
#define REG_DISP_TOP_OP2_15_H    (REG_DISP_TOP_OP2_BASE + 0x2B)
#define REG_DISP_TOP_OP2_16_L    (REG_DISP_TOP_OP2_BASE + 0x2C)
#define REG_DISP_TOP_OP2_16_H    (REG_DISP_TOP_OP2_BASE + 0x2D)
#define REG_DISP_TOP_OP2_17_L    (REG_DISP_TOP_OP2_BASE + 0x2E)
#define REG_DISP_TOP_OP2_17_H    (REG_DISP_TOP_OP2_BASE + 0x2F)
#define REG_DISP_TOP_OP2_18_L    (REG_DISP_TOP_OP2_BASE + 0x30)
#define REG_DISP_TOP_OP2_18_H    (REG_DISP_TOP_OP2_BASE + 0x31)
#define REG_DISP_TOP_OP2_19_L    (REG_DISP_TOP_OP2_BASE + 0x32)
#define REG_DISP_TOP_OP2_19_H    (REG_DISP_TOP_OP2_BASE + 0x33)
#define REG_DISP_TOP_OP2_1A_L    (REG_DISP_TOP_OP2_BASE + 0x34)
#define REG_DISP_TOP_OP2_1A_H    (REG_DISP_TOP_OP2_BASE + 0x35)
#define REG_DISP_TOP_OP2_1B_L    (REG_DISP_TOP_OP2_BASE + 0x36)
#define REG_DISP_TOP_OP2_1B_H    (REG_DISP_TOP_OP2_BASE + 0x37)
#define REG_DISP_TOP_OP2_1C_L    (REG_DISP_TOP_OP2_BASE + 0x38)
#define REG_DISP_TOP_OP2_1C_H    (REG_DISP_TOP_OP2_BASE + 0x39)
#define REG_DISP_TOP_OP2_1D_L    (REG_DISP_TOP_OP2_BASE + 0x3A)
#define REG_DISP_TOP_OP2_1D_H    (REG_DISP_TOP_OP2_BASE + 0x3B)
#define REG_DISP_TOP_OP2_1E_L    (REG_DISP_TOP_OP2_BASE + 0x3C)
#define REG_DISP_TOP_OP2_1E_H    (REG_DISP_TOP_OP2_BASE + 0x3D)
#define REG_DISP_TOP_OP2_1F_L    (REG_DISP_TOP_OP2_BASE + 0x3E)
#define REG_DISP_TOP_OP2_1F_H    (REG_DISP_TOP_OP2_BASE + 0x3F)
#define REG_DISP_TOP_OP2_20_L    (REG_DISP_TOP_OP2_BASE + 0x40)
#define REG_DISP_TOP_OP2_20_H    (REG_DISP_TOP_OP2_BASE + 0x41)
#define REG_DISP_TOP_OP2_21_L    (REG_DISP_TOP_OP2_BASE + 0x42)
#define REG_DISP_TOP_OP2_21_H    (REG_DISP_TOP_OP2_BASE + 0x43)
#define REG_DISP_TOP_OP2_22_L    (REG_DISP_TOP_OP2_BASE + 0x44)
#define REG_DISP_TOP_OP2_22_H    (REG_DISP_TOP_OP2_BASE + 0x45)
#define REG_DISP_TOP_OP2_23_L    (REG_DISP_TOP_OP2_BASE + 0x46)
#define REG_DISP_TOP_OP2_23_H    (REG_DISP_TOP_OP2_BASE + 0x47)
#define REG_DISP_TOP_OP2_24_L    (REG_DISP_TOP_OP2_BASE + 0x48)
#define REG_DISP_TOP_OP2_24_H    (REG_DISP_TOP_OP2_BASE + 0x49)
#define REG_DISP_TOP_OP2_25_L    (REG_DISP_TOP_OP2_BASE + 0x4A)
#define REG_DISP_TOP_OP2_25_H    (REG_DISP_TOP_OP2_BASE + 0x4B)
#define REG_DISP_TOP_OP2_26_L    (REG_DISP_TOP_OP2_BASE + 0x4C)
#define REG_DISP_TOP_OP2_26_H    (REG_DISP_TOP_OP2_BASE + 0x4D)
#define REG_DISP_TOP_OP2_27_L    (REG_DISP_TOP_OP2_BASE + 0x4E)
#define REG_DISP_TOP_OP2_27_H    (REG_DISP_TOP_OP2_BASE + 0x4F)
#define REG_DISP_TOP_OP2_28_L    (REG_DISP_TOP_OP2_BASE + 0x50)
#define REG_DISP_TOP_OP2_28_H    (REG_DISP_TOP_OP2_BASE + 0x51)
#define REG_DISP_TOP_OP2_29_L    (REG_DISP_TOP_OP2_BASE + 0x52)
#define REG_DISP_TOP_OP2_29_H    (REG_DISP_TOP_OP2_BASE + 0x53)
#define REG_DISP_TOP_OP2_2A_L    (REG_DISP_TOP_OP2_BASE + 0x54)
#define REG_DISP_TOP_OP2_2A_H    (REG_DISP_TOP_OP2_BASE + 0x55)
#define REG_DISP_TOP_OP2_2B_L    (REG_DISP_TOP_OP2_BASE + 0x56)
#define REG_DISP_TOP_OP2_2B_H    (REG_DISP_TOP_OP2_BASE + 0x57)
#define REG_DISP_TOP_OP2_2C_L    (REG_DISP_TOP_OP2_BASE + 0x58)
#define REG_DISP_TOP_OP2_2C_H    (REG_DISP_TOP_OP2_BASE + 0x59)
#define REG_DISP_TOP_OP2_2D_L    (REG_DISP_TOP_OP2_BASE + 0x5A)
#define REG_DISP_TOP_OP2_2D_H    (REG_DISP_TOP_OP2_BASE + 0x5B)
#define REG_DISP_TOP_OP2_2E_L    (REG_DISP_TOP_OP2_BASE + 0x5C)
#define REG_DISP_TOP_OP2_2E_H    (REG_DISP_TOP_OP2_BASE + 0x5D)
#define REG_DISP_TOP_OP2_2F_L    (REG_DISP_TOP_OP2_BASE + 0x5E)
#define REG_DISP_TOP_OP2_2F_H    (REG_DISP_TOP_OP2_BASE + 0x5F)
#define REG_DISP_TOP_OP2_30_L    (REG_DISP_TOP_OP2_BASE + 0x60)
#define REG_DISP_TOP_OP2_30_H    (REG_DISP_TOP_OP2_BASE + 0x61)
#define REG_DISP_TOP_OP2_31_L    (REG_DISP_TOP_OP2_BASE + 0x62)
#define REG_DISP_TOP_OP2_31_H    (REG_DISP_TOP_OP2_BASE + 0x63)
#define REG_DISP_TOP_OP2_32_L    (REG_DISP_TOP_OP2_BASE + 0x64)
#define REG_DISP_TOP_OP2_32_H    (REG_DISP_TOP_OP2_BASE + 0x65)
#define REG_DISP_TOP_OP2_33_L    (REG_DISP_TOP_OP2_BASE + 0x66)
#define REG_DISP_TOP_OP2_33_H    (REG_DISP_TOP_OP2_BASE + 0x67)
#define REG_DISP_TOP_OP2_34_L    (REG_DISP_TOP_OP2_BASE + 0x68)
#define REG_DISP_TOP_OP2_34_H    (REG_DISP_TOP_OP2_BASE + 0x69)
#define REG_DISP_TOP_OP2_35_L    (REG_DISP_TOP_OP2_BASE + 0x6A)
#define REG_DISP_TOP_OP2_35_H    (REG_DISP_TOP_OP2_BASE + 0x6B)
#define REG_DISP_TOP_OP2_36_L    (REG_DISP_TOP_OP2_BASE + 0x6C)
#define REG_DISP_TOP_OP2_36_H    (REG_DISP_TOP_OP2_BASE + 0x6D)
#define REG_DISP_TOP_OP2_37_L    (REG_DISP_TOP_OP2_BASE + 0x6E)
#define REG_DISP_TOP_OP2_37_H    (REG_DISP_TOP_OP2_BASE + 0x6F)
#define REG_DISP_TOP_OP2_38_L    (REG_DISP_TOP_OP2_BASE + 0x70)
#define REG_DISP_TOP_OP2_38_H    (REG_DISP_TOP_OP2_BASE + 0x71)
#define REG_DISP_TOP_OP2_39_L    (REG_DISP_TOP_OP2_BASE + 0x72)
#define REG_DISP_TOP_OP2_39_H    (REG_DISP_TOP_OP2_BASE + 0x73)
#define REG_DISP_TOP_OP2_3A_L    (REG_DISP_TOP_OP2_BASE + 0x74)
#define REG_DISP_TOP_OP2_3A_H    (REG_DISP_TOP_OP2_BASE + 0x75)
#define REG_DISP_TOP_OP2_3B_L    (REG_DISP_TOP_OP2_BASE + 0x76)
#define REG_DISP_TOP_OP2_3B_H    (REG_DISP_TOP_OP2_BASE + 0x77)
#define REG_DISP_TOP_OP2_3C_L    (REG_DISP_TOP_OP2_BASE + 0x78)
#define REG_DISP_TOP_OP2_3C_H    (REG_DISP_TOP_OP2_BASE + 0x79)
#define REG_DISP_TOP_OP2_3D_L    (REG_DISP_TOP_OP2_BASE + 0x7A)
#define REG_DISP_TOP_OP2_3D_H    (REG_DISP_TOP_OP2_BASE + 0x7B)
#define REG_DISP_TOP_OP2_3E_L    (REG_DISP_TOP_OP2_BASE + 0x7C)
#define REG_DISP_TOP_OP2_3E_H    (REG_DISP_TOP_OP2_BASE + 0x7D)
#define REG_DISP_TOP_OP2_3F_L    (REG_DISP_TOP_OP2_BASE + 0x7E)
#define REG_DISP_TOP_OP2_3F_H    (REG_DISP_TOP_OP2_BASE + 0x7F)
#define REG_DISP_TOP_OP2_40_L    (REG_DISP_TOP_OP2_BASE + 0x80)
#define REG_DISP_TOP_OP2_40_H    (REG_DISP_TOP_OP2_BASE + 0x81)
#define REG_DISP_TOP_OP2_41_L    (REG_DISP_TOP_OP2_BASE + 0x82)
#define REG_DISP_TOP_OP2_41_H    (REG_DISP_TOP_OP2_BASE + 0x83)
#define REG_DISP_TOP_OP2_42_L    (REG_DISP_TOP_OP2_BASE + 0x84)
#define REG_DISP_TOP_OP2_42_H    (REG_DISP_TOP_OP2_BASE + 0x85)
#define REG_DISP_TOP_OP2_43_L    (REG_DISP_TOP_OP2_BASE + 0x86)
#define REG_DISP_TOP_OP2_43_H    (REG_DISP_TOP_OP2_BASE + 0x87)
#define REG_DISP_TOP_OP2_44_L    (REG_DISP_TOP_OP2_BASE + 0x88)
#define REG_DISP_TOP_OP2_44_H    (REG_DISP_TOP_OP2_BASE + 0x89)
#define REG_DISP_TOP_OP2_45_L    (REG_DISP_TOP_OP2_BASE + 0x8A)
#define REG_DISP_TOP_OP2_45_H    (REG_DISP_TOP_OP2_BASE + 0x8B)
#define REG_DISP_TOP_OP2_46_L    (REG_DISP_TOP_OP2_BASE + 0x8C)
#define REG_DISP_TOP_OP2_46_H    (REG_DISP_TOP_OP2_BASE + 0x8D)
#define REG_DISP_TOP_OP2_47_L    (REG_DISP_TOP_OP2_BASE + 0x8E)
#define REG_DISP_TOP_OP2_47_H    (REG_DISP_TOP_OP2_BASE + 0x8F)
#define REG_DISP_TOP_OP2_48_L    (REG_DISP_TOP_OP2_BASE + 0x90)
#define REG_DISP_TOP_OP2_48_H    (REG_DISP_TOP_OP2_BASE + 0x91)
#define REG_DISP_TOP_OP2_49_L    (REG_DISP_TOP_OP2_BASE + 0x92)
#define REG_DISP_TOP_OP2_49_H    (REG_DISP_TOP_OP2_BASE + 0x93)
#define REG_DISP_TOP_OP2_4A_L    (REG_DISP_TOP_OP2_BASE + 0x94)
#define REG_DISP_TOP_OP2_4A_H    (REG_DISP_TOP_OP2_BASE + 0x95)
#define REG_DISP_TOP_OP2_4B_L    (REG_DISP_TOP_OP2_BASE + 0x96)
#define REG_DISP_TOP_OP2_4B_H    (REG_DISP_TOP_OP2_BASE + 0x97)
#define REG_DISP_TOP_OP2_4C_L    (REG_DISP_TOP_OP2_BASE + 0x98)
#define REG_DISP_TOP_OP2_4C_H    (REG_DISP_TOP_OP2_BASE + 0x99)
#define REG_DISP_TOP_OP2_4D_L    (REG_DISP_TOP_OP2_BASE + 0x9A)
#define REG_DISP_TOP_OP2_4D_H    (REG_DISP_TOP_OP2_BASE + 0x9B)
#define REG_DISP_TOP_OP2_4E_L    (REG_DISP_TOP_OP2_BASE + 0x9C)
#define REG_DISP_TOP_OP2_4E_H    (REG_DISP_TOP_OP2_BASE + 0x9D)
#define REG_DISP_TOP_OP2_4F_L    (REG_DISP_TOP_OP2_BASE + 0x9E)
#define REG_DISP_TOP_OP2_4F_H    (REG_DISP_TOP_OP2_BASE + 0x9F)
#define REG_DISP_TOP_OP2_50_L    (REG_DISP_TOP_OP2_BASE + 0xA0)
#define REG_DISP_TOP_OP2_50_H    (REG_DISP_TOP_OP2_BASE + 0xA1)
#define REG_DISP_TOP_OP2_51_L    (REG_DISP_TOP_OP2_BASE + 0xA2)
#define REG_DISP_TOP_OP2_51_H    (REG_DISP_TOP_OP2_BASE + 0xA3)
#define REG_DISP_TOP_OP2_52_L    (REG_DISP_TOP_OP2_BASE + 0xA4)
#define REG_DISP_TOP_OP2_52_H    (REG_DISP_TOP_OP2_BASE + 0xA5)
#define REG_DISP_TOP_OP2_53_L    (REG_DISP_TOP_OP2_BASE + 0xA6)
#define REG_DISP_TOP_OP2_53_H    (REG_DISP_TOP_OP2_BASE + 0xA7)
#define REG_DISP_TOP_OP2_54_L    (REG_DISP_TOP_OP2_BASE + 0xA8)
#define REG_DISP_TOP_OP2_54_H    (REG_DISP_TOP_OP2_BASE + 0xA9)
#define REG_DISP_TOP_OP2_55_L    (REG_DISP_TOP_OP2_BASE + 0xAA)
#define REG_DISP_TOP_OP2_55_H    (REG_DISP_TOP_OP2_BASE + 0xAB)
#define REG_DISP_TOP_OP2_56_L    (REG_DISP_TOP_OP2_BASE + 0xAC)
#define REG_DISP_TOP_OP2_56_H    (REG_DISP_TOP_OP2_BASE + 0xAD)
#define REG_DISP_TOP_OP2_57_L    (REG_DISP_TOP_OP2_BASE + 0xAE)
#define REG_DISP_TOP_OP2_57_H    (REG_DISP_TOP_OP2_BASE + 0xAF)
#define REG_DISP_TOP_OP2_58_L    (REG_DISP_TOP_OP2_BASE + 0xB0)
#define REG_DISP_TOP_OP2_58_H    (REG_DISP_TOP_OP2_BASE + 0xB1)
#define REG_DISP_TOP_OP2_59_L    (REG_DISP_TOP_OP2_BASE + 0xB2)
#define REG_DISP_TOP_OP2_59_H    (REG_DISP_TOP_OP2_BASE + 0xB3)
#define REG_DISP_TOP_OP2_5A_L    (REG_DISP_TOP_OP2_BASE + 0xB4)
#define REG_DISP_TOP_OP2_5A_H    (REG_DISP_TOP_OP2_BASE + 0xB5)
#define REG_DISP_TOP_OP2_5B_L    (REG_DISP_TOP_OP2_BASE + 0xB6)
#define REG_DISP_TOP_OP2_5B_H    (REG_DISP_TOP_OP2_BASE + 0xB7)
#define REG_DISP_TOP_OP2_5C_L    (REG_DISP_TOP_OP2_BASE + 0xB8)
#define REG_DISP_TOP_OP2_5C_H    (REG_DISP_TOP_OP2_BASE + 0xB9)
#define REG_DISP_TOP_OP2_5D_L    (REG_DISP_TOP_OP2_BASE + 0xBA)
#define REG_DISP_TOP_OP2_5D_H    (REG_DISP_TOP_OP2_BASE + 0xBB)
#define REG_DISP_TOP_OP2_5E_L    (REG_DISP_TOP_OP2_BASE + 0xBC)
#define REG_DISP_TOP_OP2_5E_H    (REG_DISP_TOP_OP2_BASE + 0xBD)
#define REG_DISP_TOP_OP2_5F_L    (REG_DISP_TOP_OP2_BASE + 0xBE)
#define REG_DISP_TOP_OP2_5F_H    (REG_DISP_TOP_OP2_BASE + 0xBF)
#define REG_DISP_TOP_OP2_60_L    (REG_DISP_TOP_OP2_BASE + 0xC0)
#define REG_DISP_TOP_OP2_60_H    (REG_DISP_TOP_OP2_BASE + 0xC1)
#define REG_DISP_TOP_OP2_61_L    (REG_DISP_TOP_OP2_BASE + 0xC2)
#define REG_DISP_TOP_OP2_61_H    (REG_DISP_TOP_OP2_BASE + 0xC3)
#define REG_DISP_TOP_OP2_62_L    (REG_DISP_TOP_OP2_BASE + 0xC4)
#define REG_DISP_TOP_OP2_62_H    (REG_DISP_TOP_OP2_BASE + 0xC5)
#define REG_DISP_TOP_OP2_63_L    (REG_DISP_TOP_OP2_BASE + 0xC6)
#define REG_DISP_TOP_OP2_63_H    (REG_DISP_TOP_OP2_BASE + 0xC7)
#define REG_DISP_TOP_OP2_64_L    (REG_DISP_TOP_OP2_BASE + 0xC8)
#define REG_DISP_TOP_OP2_64_H    (REG_DISP_TOP_OP2_BASE + 0xC9)
#define REG_DISP_TOP_OP2_65_L    (REG_DISP_TOP_OP2_BASE + 0xCA)
#define REG_DISP_TOP_OP2_65_H    (REG_DISP_TOP_OP2_BASE + 0xCB)
#define REG_DISP_TOP_OP2_66_L    (REG_DISP_TOP_OP2_BASE + 0xCC)
#define REG_DISP_TOP_OP2_66_H    (REG_DISP_TOP_OP2_BASE + 0xCD)
#define REG_DISP_TOP_OP2_67_L    (REG_DISP_TOP_OP2_BASE + 0xCE)
#define REG_DISP_TOP_OP2_67_H    (REG_DISP_TOP_OP2_BASE + 0xCF)
#define REG_DISP_TOP_OP2_68_L    (REG_DISP_TOP_OP2_BASE + 0xD0)
#define REG_DISP_TOP_OP2_68_H    (REG_DISP_TOP_OP2_BASE + 0xD1)
#define REG_DISP_TOP_OP2_69_L    (REG_DISP_TOP_OP2_BASE + 0xD2)
#define REG_DISP_TOP_OP2_69_H    (REG_DISP_TOP_OP2_BASE + 0xD3)
#define REG_DISP_TOP_OP2_6A_L    (REG_DISP_TOP_OP2_BASE + 0xD4)
#define REG_DISP_TOP_OP2_6A_H    (REG_DISP_TOP_OP2_BASE + 0xD5)
#define REG_DISP_TOP_OP2_6B_L    (REG_DISP_TOP_OP2_BASE + 0xD6)
#define REG_DISP_TOP_OP2_6B_H    (REG_DISP_TOP_OP2_BASE + 0xD7)
#define REG_DISP_TOP_OP2_6C_L    (REG_DISP_TOP_OP2_BASE + 0xD8)
#define REG_DISP_TOP_OP2_6C_H    (REG_DISP_TOP_OP2_BASE + 0xD9)
#define REG_DISP_TOP_OP2_6D_L    (REG_DISP_TOP_OP2_BASE + 0xDA)
#define REG_DISP_TOP_OP2_6D_H    (REG_DISP_TOP_OP2_BASE + 0xDB)
#define REG_DISP_TOP_OP2_6E_L    (REG_DISP_TOP_OP2_BASE + 0xDC)
#define REG_DISP_TOP_OP2_6E_H    (REG_DISP_TOP_OP2_BASE + 0xDD)
#define REG_DISP_TOP_OP2_6F_L    (REG_DISP_TOP_OP2_BASE + 0xDE)
#define REG_DISP_TOP_OP2_6F_H    (REG_DISP_TOP_OP2_BASE + 0xDF)
#define REG_DISP_TOP_OP2_70_L    (REG_DISP_TOP_OP2_BASE + 0xE0)
#define REG_DISP_TOP_OP2_70_H    (REG_DISP_TOP_OP2_BASE + 0xE1)
#define REG_DISP_TOP_OP2_71_L    (REG_DISP_TOP_OP2_BASE + 0xE2)
#define REG_DISP_TOP_OP2_71_H    (REG_DISP_TOP_OP2_BASE + 0xE3)
#define REG_DISP_TOP_OP2_72_L    (REG_DISP_TOP_OP2_BASE + 0xE4)
#define REG_DISP_TOP_OP2_72_H    (REG_DISP_TOP_OP2_BASE + 0xE5)
#define REG_DISP_TOP_OP2_73_L    (REG_DISP_TOP_OP2_BASE + 0xE6)
#define REG_DISP_TOP_OP2_73_H    (REG_DISP_TOP_OP2_BASE + 0xE7)
#define REG_DISP_TOP_OP2_74_L    (REG_DISP_TOP_OP2_BASE + 0xE8)
#define REG_DISP_TOP_OP2_74_H    (REG_DISP_TOP_OP2_BASE + 0xE9)
#define REG_DISP_TOP_OP2_75_L    (REG_DISP_TOP_OP2_BASE + 0xEA)
#define REG_DISP_TOP_OP2_75_H    (REG_DISP_TOP_OP2_BASE + 0xEB)
#define REG_DISP_TOP_OP2_76_L    (REG_DISP_TOP_OP2_BASE + 0xEC)
#define REG_DISP_TOP_OP2_76_H    (REG_DISP_TOP_OP2_BASE + 0xED)
#define REG_DISP_TOP_OP2_77_L    (REG_DISP_TOP_OP2_BASE + 0xEE)
#define REG_DISP_TOP_OP2_77_H    (REG_DISP_TOP_OP2_BASE + 0xEF)
#define REG_DISP_TOP_OP2_78_L    (REG_DISP_TOP_OP2_BASE + 0xF0)
#define REG_DISP_TOP_OP2_78_H    (REG_DISP_TOP_OP2_BASE + 0xF1)
#define REG_DISP_TOP_OP2_79_L    (REG_DISP_TOP_OP2_BASE + 0xF2)
#define REG_DISP_TOP_OP2_79_H    (REG_DISP_TOP_OP2_BASE + 0xF3)
#define REG_DISP_TOP_OP2_7A_L    (REG_DISP_TOP_OP2_BASE + 0xF4)
#define REG_DISP_TOP_OP2_7A_H    (REG_DISP_TOP_OP2_BASE + 0xF5)
#define REG_DISP_TOP_OP2_7B_L    (REG_DISP_TOP_OP2_BASE + 0xF6)
#define REG_DISP_TOP_OP2_7B_H    (REG_DISP_TOP_OP2_BASE + 0xF7)
#define REG_DISP_TOP_OP2_7C_L    (REG_DISP_TOP_OP2_BASE + 0xF8)
#define REG_DISP_TOP_OP2_7C_H    (REG_DISP_TOP_OP2_BASE + 0xF9)
#define REG_DISP_TOP_OP2_7D_L    (REG_DISP_TOP_OP2_BASE + 0xFA)
#define REG_DISP_TOP_OP2_7D_H    (REG_DISP_TOP_OP2_BASE + 0xFB)
#define REG_DISP_TOP_OP2_7E_L    (REG_DISP_TOP_OP2_BASE + 0xFC)
#define REG_DISP_TOP_OP2_7E_H    (REG_DISP_TOP_OP2_BASE + 0xFD)
#define REG_DISP_TOP_OP2_7F_L    (REG_DISP_TOP_OP2_BASE + 0xFE)
#define REG_DISP_TOP_OP2_7F_H    (REG_DISP_TOP_OP2_BASE + 0xFF)


#define REG_DISP_TOP_GAMMA_00_L    (REG_DISP_TOP_GAMMA_BASE + 0x00)
#define REG_DISP_TOP_GAMMA_00_H    (REG_DISP_TOP_GAMMA_BASE + 0x01)
#define REG_DISP_TOP_GAMMA_01_L    (REG_DISP_TOP_GAMMA_BASE + 0x02)
#define REG_DISP_TOP_GAMMA_01_H    (REG_DISP_TOP_GAMMA_BASE + 0x03)
#define REG_DISP_TOP_GAMMA_02_L    (REG_DISP_TOP_GAMMA_BASE + 0x04)
#define REG_DISP_TOP_GAMMA_02_H    (REG_DISP_TOP_GAMMA_BASE + 0x05)
#define REG_DISP_TOP_GAMMA_03_L    (REG_DISP_TOP_GAMMA_BASE + 0x06)
#define REG_DISP_TOP_GAMMA_03_H    (REG_DISP_TOP_GAMMA_BASE + 0x07)
#define REG_DISP_TOP_GAMMA_04_L    (REG_DISP_TOP_GAMMA_BASE + 0x08)
#define REG_DISP_TOP_GAMMA_04_H    (REG_DISP_TOP_GAMMA_BASE + 0x09)
#define REG_DISP_TOP_GAMMA_05_L    (REG_DISP_TOP_GAMMA_BASE + 0x0A)
#define REG_DISP_TOP_GAMMA_05_H    (REG_DISP_TOP_GAMMA_BASE + 0x0B)
#define REG_DISP_TOP_GAMMA_06_L    (REG_DISP_TOP_GAMMA_BASE + 0x0C)
#define REG_DISP_TOP_GAMMA_06_H    (REG_DISP_TOP_GAMMA_BASE + 0x0D)
#define REG_DISP_TOP_GAMMA_07_L    (REG_DISP_TOP_GAMMA_BASE + 0x0E)
#define REG_DISP_TOP_GAMMA_07_H    (REG_DISP_TOP_GAMMA_BASE + 0x0F)
#define REG_DISP_TOP_GAMMA_08_L    (REG_DISP_TOP_GAMMA_BASE + 0x10)
#define REG_DISP_TOP_GAMMA_08_H    (REG_DISP_TOP_GAMMA_BASE + 0x11)
#define REG_DISP_TOP_GAMMA_09_L    (REG_DISP_TOP_GAMMA_BASE + 0x12)
#define REG_DISP_TOP_GAMMA_09_H    (REG_DISP_TOP_GAMMA_BASE + 0x13)
#define REG_DISP_TOP_GAMMA_0A_L    (REG_DISP_TOP_GAMMA_BASE + 0x14)
#define REG_DISP_TOP_GAMMA_0A_H    (REG_DISP_TOP_GAMMA_BASE + 0x15)
#define REG_DISP_TOP_GAMMA_0B_L    (REG_DISP_TOP_GAMMA_BASE + 0x16)
#define REG_DISP_TOP_GAMMA_0B_H    (REG_DISP_TOP_GAMMA_BASE + 0x17)
#define REG_DISP_TOP_GAMMA_0C_L    (REG_DISP_TOP_GAMMA_BASE + 0x18)
#define REG_DISP_TOP_GAMMA_0C_H    (REG_DISP_TOP_GAMMA_BASE + 0x19)
#define REG_DISP_TOP_GAMMA_0D_L    (REG_DISP_TOP_GAMMA_BASE + 0x1A)
#define REG_DISP_TOP_GAMMA_0D_H    (REG_DISP_TOP_GAMMA_BASE + 0x1B)
#define REG_DISP_TOP_GAMMA_0E_L    (REG_DISP_TOP_GAMMA_BASE + 0x1C)
#define REG_DISP_TOP_GAMMA_0E_H    (REG_DISP_TOP_GAMMA_BASE + 0x1D)
#define REG_DISP_TOP_GAMMA_0F_L    (REG_DISP_TOP_GAMMA_BASE + 0x1E)
#define REG_DISP_TOP_GAMMA_0F_H    (REG_DISP_TOP_GAMMA_BASE + 0x1F)
#define REG_DISP_TOP_GAMMA_10_L    (REG_DISP_TOP_GAMMA_BASE + 0x20)
#define REG_DISP_TOP_GAMMA_10_H    (REG_DISP_TOP_GAMMA_BASE + 0x21)
#define REG_DISP_TOP_GAMMA_11_L    (REG_DISP_TOP_GAMMA_BASE + 0x22)
#define REG_DISP_TOP_GAMMA_11_H    (REG_DISP_TOP_GAMMA_BASE + 0x23)
#define REG_DISP_TOP_GAMMA_12_L    (REG_DISP_TOP_GAMMA_BASE + 0x24)
#define REG_DISP_TOP_GAMMA_12_H    (REG_DISP_TOP_GAMMA_BASE + 0x25)
#define REG_DISP_TOP_GAMMA_13_L    (REG_DISP_TOP_GAMMA_BASE + 0x26)
#define REG_DISP_TOP_GAMMA_13_H    (REG_DISP_TOP_GAMMA_BASE + 0x27)
#define REG_DISP_TOP_GAMMA_14_L    (REG_DISP_TOP_GAMMA_BASE + 0x28)
#define REG_DISP_TOP_GAMMA_14_H    (REG_DISP_TOP_GAMMA_BASE + 0x29)
#define REG_DISP_TOP_GAMMA_15_L    (REG_DISP_TOP_GAMMA_BASE + 0x2A)
#define REG_DISP_TOP_GAMMA_15_H    (REG_DISP_TOP_GAMMA_BASE + 0x2B)
#define REG_DISP_TOP_GAMMA_16_L    (REG_DISP_TOP_GAMMA_BASE + 0x2C)
#define REG_DISP_TOP_GAMMA_16_H    (REG_DISP_TOP_GAMMA_BASE + 0x2D)
#define REG_DISP_TOP_GAMMA_17_L    (REG_DISP_TOP_GAMMA_BASE + 0x2E)
#define REG_DISP_TOP_GAMMA_17_H    (REG_DISP_TOP_GAMMA_BASE + 0x2F)
#define REG_DISP_TOP_GAMMA_18_L    (REG_DISP_TOP_GAMMA_BASE + 0x30)
#define REG_DISP_TOP_GAMMA_18_H    (REG_DISP_TOP_GAMMA_BASE + 0x31)
#define REG_DISP_TOP_GAMMA_19_L    (REG_DISP_TOP_GAMMA_BASE + 0x32)
#define REG_DISP_TOP_GAMMA_19_H    (REG_DISP_TOP_GAMMA_BASE + 0x33)
#define REG_DISP_TOP_GAMMA_1A_L    (REG_DISP_TOP_GAMMA_BASE + 0x34)
#define REG_DISP_TOP_GAMMA_1A_H    (REG_DISP_TOP_GAMMA_BASE + 0x35)
#define REG_DISP_TOP_GAMMA_1B_L    (REG_DISP_TOP_GAMMA_BASE + 0x36)
#define REG_DISP_TOP_GAMMA_1B_H    (REG_DISP_TOP_GAMMA_BASE + 0x37)
#define REG_DISP_TOP_GAMMA_1C_L    (REG_DISP_TOP_GAMMA_BASE + 0x38)
#define REG_DISP_TOP_GAMMA_1C_H    (REG_DISP_TOP_GAMMA_BASE + 0x39)
#define REG_DISP_TOP_GAMMA_1D_L    (REG_DISP_TOP_GAMMA_BASE + 0x3A)
#define REG_DISP_TOP_GAMMA_1D_H    (REG_DISP_TOP_GAMMA_BASE + 0x3B)
#define REG_DISP_TOP_GAMMA_1E_L    (REG_DISP_TOP_GAMMA_BASE + 0x3C)
#define REG_DISP_TOP_GAMMA_1E_H    (REG_DISP_TOP_GAMMA_BASE + 0x3D)
#define REG_DISP_TOP_GAMMA_1F_L    (REG_DISP_TOP_GAMMA_BASE + 0x3E)
#define REG_DISP_TOP_GAMMA_1F_H    (REG_DISP_TOP_GAMMA_BASE + 0x3F)
#define REG_DISP_TOP_GAMMA_20_L    (REG_DISP_TOP_GAMMA_BASE + 0x40)
#define REG_DISP_TOP_GAMMA_20_H    (REG_DISP_TOP_GAMMA_BASE + 0x41)
#define REG_DISP_TOP_GAMMA_21_L    (REG_DISP_TOP_GAMMA_BASE + 0x42)
#define REG_DISP_TOP_GAMMA_21_H    (REG_DISP_TOP_GAMMA_BASE + 0x43)
#define REG_DISP_TOP_GAMMA_22_L    (REG_DISP_TOP_GAMMA_BASE + 0x44)
#define REG_DISP_TOP_GAMMA_22_H    (REG_DISP_TOP_GAMMA_BASE + 0x45)
#define REG_DISP_TOP_GAMMA_23_L    (REG_DISP_TOP_GAMMA_BASE + 0x46)
#define REG_DISP_TOP_GAMMA_23_H    (REG_DISP_TOP_GAMMA_BASE + 0x47)
#define REG_DISP_TOP_GAMMA_24_L    (REG_DISP_TOP_GAMMA_BASE + 0x48)
#define REG_DISP_TOP_GAMMA_24_H    (REG_DISP_TOP_GAMMA_BASE + 0x49)
#define REG_DISP_TOP_GAMMA_25_L    (REG_DISP_TOP_GAMMA_BASE + 0x4A)
#define REG_DISP_TOP_GAMMA_25_H    (REG_DISP_TOP_GAMMA_BASE + 0x4B)
#define REG_DISP_TOP_GAMMA_26_L    (REG_DISP_TOP_GAMMA_BASE + 0x4C)
#define REG_DISP_TOP_GAMMA_26_H    (REG_DISP_TOP_GAMMA_BASE + 0x4D)
#define REG_DISP_TOP_GAMMA_27_L    (REG_DISP_TOP_GAMMA_BASE + 0x4E)
#define REG_DISP_TOP_GAMMA_27_H    (REG_DISP_TOP_GAMMA_BASE + 0x4F)
#define REG_DISP_TOP_GAMMA_28_L    (REG_DISP_TOP_GAMMA_BASE + 0x50)
#define REG_DISP_TOP_GAMMA_28_H    (REG_DISP_TOP_GAMMA_BASE + 0x51)
#define REG_DISP_TOP_GAMMA_29_L    (REG_DISP_TOP_GAMMA_BASE + 0x52)
#define REG_DISP_TOP_GAMMA_29_H    (REG_DISP_TOP_GAMMA_BASE + 0x53)
#define REG_DISP_TOP_GAMMA_2A_L    (REG_DISP_TOP_GAMMA_BASE + 0x54)
#define REG_DISP_TOP_GAMMA_2A_H    (REG_DISP_TOP_GAMMA_BASE + 0x55)
#define REG_DISP_TOP_GAMMA_2B_L    (REG_DISP_TOP_GAMMA_BASE + 0x56)
#define REG_DISP_TOP_GAMMA_2B_H    (REG_DISP_TOP_GAMMA_BASE + 0x57)
#define REG_DISP_TOP_GAMMA_2C_L    (REG_DISP_TOP_GAMMA_BASE + 0x58)
#define REG_DISP_TOP_GAMMA_2C_H    (REG_DISP_TOP_GAMMA_BASE + 0x59)
#define REG_DISP_TOP_GAMMA_2D_L    (REG_DISP_TOP_GAMMA_BASE + 0x5A)
#define REG_DISP_TOP_GAMMA_2D_H    (REG_DISP_TOP_GAMMA_BASE + 0x5B)
#define REG_DISP_TOP_GAMMA_2E_L    (REG_DISP_TOP_GAMMA_BASE + 0x5C)
#define REG_DISP_TOP_GAMMA_2E_H    (REG_DISP_TOP_GAMMA_BASE + 0x5D)
#define REG_DISP_TOP_GAMMA_2F_L    (REG_DISP_TOP_GAMMA_BASE + 0x5E)
#define REG_DISP_TOP_GAMMA_2F_H    (REG_DISP_TOP_GAMMA_BASE + 0x5F)
#define REG_DISP_TOP_GAMMA_30_L    (REG_DISP_TOP_GAMMA_BASE + 0x60)
#define REG_DISP_TOP_GAMMA_30_H    (REG_DISP_TOP_GAMMA_BASE + 0x61)
#define REG_DISP_TOP_GAMMA_31_L    (REG_DISP_TOP_GAMMA_BASE + 0x62)
#define REG_DISP_TOP_GAMMA_31_H    (REG_DISP_TOP_GAMMA_BASE + 0x63)
#define REG_DISP_TOP_GAMMA_32_L    (REG_DISP_TOP_GAMMA_BASE + 0x64)
#define REG_DISP_TOP_GAMMA_32_H    (REG_DISP_TOP_GAMMA_BASE + 0x65)
#define REG_DISP_TOP_GAMMA_33_L    (REG_DISP_TOP_GAMMA_BASE + 0x66)
#define REG_DISP_TOP_GAMMA_33_H    (REG_DISP_TOP_GAMMA_BASE + 0x67)
#define REG_DISP_TOP_GAMMA_34_L    (REG_DISP_TOP_GAMMA_BASE + 0x68)
#define REG_DISP_TOP_GAMMA_34_H    (REG_DISP_TOP_GAMMA_BASE + 0x69)
#define REG_DISP_TOP_GAMMA_35_L    (REG_DISP_TOP_GAMMA_BASE + 0x6A)
#define REG_DISP_TOP_GAMMA_35_H    (REG_DISP_TOP_GAMMA_BASE + 0x6B)
#define REG_DISP_TOP_GAMMA_36_L    (REG_DISP_TOP_GAMMA_BASE + 0x6C)
#define REG_DISP_TOP_GAMMA_36_H    (REG_DISP_TOP_GAMMA_BASE + 0x6D)
#define REG_DISP_TOP_GAMMA_37_L    (REG_DISP_TOP_GAMMA_BASE + 0x6E)
#define REG_DISP_TOP_GAMMA_37_H    (REG_DISP_TOP_GAMMA_BASE + 0x6F)
#define REG_DISP_TOP_GAMMA_38_L    (REG_DISP_TOP_GAMMA_BASE + 0x70)
#define REG_DISP_TOP_GAMMA_38_H    (REG_DISP_TOP_GAMMA_BASE + 0x71)
#define REG_DISP_TOP_GAMMA_39_L    (REG_DISP_TOP_GAMMA_BASE + 0x72)
#define REG_DISP_TOP_GAMMA_39_H    (REG_DISP_TOP_GAMMA_BASE + 0x73)
#define REG_DISP_TOP_GAMMA_3A_L    (REG_DISP_TOP_GAMMA_BASE + 0x74)
#define REG_DISP_TOP_GAMMA_3A_H    (REG_DISP_TOP_GAMMA_BASE + 0x75)
#define REG_DISP_TOP_GAMMA_3B_L    (REG_DISP_TOP_GAMMA_BASE + 0x76)
#define REG_DISP_TOP_GAMMA_3B_H    (REG_DISP_TOP_GAMMA_BASE + 0x77)
#define REG_DISP_TOP_GAMMA_3C_L    (REG_DISP_TOP_GAMMA_BASE + 0x78)
#define REG_DISP_TOP_GAMMA_3C_H    (REG_DISP_TOP_GAMMA_BASE + 0x79)
#define REG_DISP_TOP_GAMMA_3D_L    (REG_DISP_TOP_GAMMA_BASE + 0x7A)
#define REG_DISP_TOP_GAMMA_3D_H    (REG_DISP_TOP_GAMMA_BASE + 0x7B)
#define REG_DISP_TOP_GAMMA_3E_L    (REG_DISP_TOP_GAMMA_BASE + 0x7C)
#define REG_DISP_TOP_GAMMA_3E_H    (REG_DISP_TOP_GAMMA_BASE + 0x7D)
#define REG_DISP_TOP_GAMMA_3F_L    (REG_DISP_TOP_GAMMA_BASE + 0x7E)
#define REG_DISP_TOP_GAMMA_3F_H    (REG_DISP_TOP_GAMMA_BASE + 0x7F)
#define REG_DISP_TOP_GAMMA_40_L    (REG_DISP_TOP_GAMMA_BASE + 0x80)
#define REG_DISP_TOP_GAMMA_40_H    (REG_DISP_TOP_GAMMA_BASE + 0x81)
#define REG_DISP_TOP_GAMMA_41_L    (REG_DISP_TOP_GAMMA_BASE + 0x82)
#define REG_DISP_TOP_GAMMA_41_H    (REG_DISP_TOP_GAMMA_BASE + 0x83)
#define REG_DISP_TOP_GAMMA_42_L    (REG_DISP_TOP_GAMMA_BASE + 0x84)
#define REG_DISP_TOP_GAMMA_42_H    (REG_DISP_TOP_GAMMA_BASE + 0x85)
#define REG_DISP_TOP_GAMMA_43_L    (REG_DISP_TOP_GAMMA_BASE + 0x86)
#define REG_DISP_TOP_GAMMA_43_H    (REG_DISP_TOP_GAMMA_BASE + 0x87)
#define REG_DISP_TOP_GAMMA_44_L    (REG_DISP_TOP_GAMMA_BASE + 0x88)
#define REG_DISP_TOP_GAMMA_44_H    (REG_DISP_TOP_GAMMA_BASE + 0x89)
#define REG_DISP_TOP_GAMMA_45_L    (REG_DISP_TOP_GAMMA_BASE + 0x8A)
#define REG_DISP_TOP_GAMMA_45_H    (REG_DISP_TOP_GAMMA_BASE + 0x8B)
#define REG_DISP_TOP_GAMMA_46_L    (REG_DISP_TOP_GAMMA_BASE + 0x8C)
#define REG_DISP_TOP_GAMMA_46_H    (REG_DISP_TOP_GAMMA_BASE + 0x8D)
#define REG_DISP_TOP_GAMMA_47_L    (REG_DISP_TOP_GAMMA_BASE + 0x8E)
#define REG_DISP_TOP_GAMMA_47_H    (REG_DISP_TOP_GAMMA_BASE + 0x8F)
#define REG_DISP_TOP_GAMMA_48_L    (REG_DISP_TOP_GAMMA_BASE + 0x90)
#define REG_DISP_TOP_GAMMA_48_H    (REG_DISP_TOP_GAMMA_BASE + 0x91)
#define REG_DISP_TOP_GAMMA_49_L    (REG_DISP_TOP_GAMMA_BASE + 0x92)
#define REG_DISP_TOP_GAMMA_49_H    (REG_DISP_TOP_GAMMA_BASE + 0x93)
#define REG_DISP_TOP_GAMMA_4A_L    (REG_DISP_TOP_GAMMA_BASE + 0x94)
#define REG_DISP_TOP_GAMMA_4A_H    (REG_DISP_TOP_GAMMA_BASE + 0x95)
#define REG_DISP_TOP_GAMMA_4B_L    (REG_DISP_TOP_GAMMA_BASE + 0x96)
#define REG_DISP_TOP_GAMMA_4B_H    (REG_DISP_TOP_GAMMA_BASE + 0x97)
#define REG_DISP_TOP_GAMMA_4C_L    (REG_DISP_TOP_GAMMA_BASE + 0x98)
#define REG_DISP_TOP_GAMMA_4C_H    (REG_DISP_TOP_GAMMA_BASE + 0x99)
#define REG_DISP_TOP_GAMMA_4D_L    (REG_DISP_TOP_GAMMA_BASE + 0x9A)
#define REG_DISP_TOP_GAMMA_4D_H    (REG_DISP_TOP_GAMMA_BASE + 0x9B)
#define REG_DISP_TOP_GAMMA_4E_L    (REG_DISP_TOP_GAMMA_BASE + 0x9C)
#define REG_DISP_TOP_GAMMA_4E_H    (REG_DISP_TOP_GAMMA_BASE + 0x9D)
#define REG_DISP_TOP_GAMMA_4F_L    (REG_DISP_TOP_GAMMA_BASE + 0x9E)
#define REG_DISP_TOP_GAMMA_4F_H    (REG_DISP_TOP_GAMMA_BASE + 0x9F)
#define REG_DISP_TOP_GAMMA_50_L    (REG_DISP_TOP_GAMMA_BASE + 0xA0)
#define REG_DISP_TOP_GAMMA_50_H    (REG_DISP_TOP_GAMMA_BASE + 0xA1)
#define REG_DISP_TOP_GAMMA_51_L    (REG_DISP_TOP_GAMMA_BASE + 0xA2)
#define REG_DISP_TOP_GAMMA_51_H    (REG_DISP_TOP_GAMMA_BASE + 0xA3)
#define REG_DISP_TOP_GAMMA_52_L    (REG_DISP_TOP_GAMMA_BASE + 0xA4)
#define REG_DISP_TOP_GAMMA_52_H    (REG_DISP_TOP_GAMMA_BASE + 0xA5)
#define REG_DISP_TOP_GAMMA_53_L    (REG_DISP_TOP_GAMMA_BASE + 0xA6)
#define REG_DISP_TOP_GAMMA_53_H    (REG_DISP_TOP_GAMMA_BASE + 0xA7)
#define REG_DISP_TOP_GAMMA_54_L    (REG_DISP_TOP_GAMMA_BASE + 0xA8)
#define REG_DISP_TOP_GAMMA_54_H    (REG_DISP_TOP_GAMMA_BASE + 0xA9)
#define REG_DISP_TOP_GAMMA_55_L    (REG_DISP_TOP_GAMMA_BASE + 0xAA)
#define REG_DISP_TOP_GAMMA_55_H    (REG_DISP_TOP_GAMMA_BASE + 0xAB)
#define REG_DISP_TOP_GAMMA_56_L    (REG_DISP_TOP_GAMMA_BASE + 0xAC)
#define REG_DISP_TOP_GAMMA_56_H    (REG_DISP_TOP_GAMMA_BASE + 0xAD)
#define REG_DISP_TOP_GAMMA_57_L    (REG_DISP_TOP_GAMMA_BASE + 0xAE)
#define REG_DISP_TOP_GAMMA_57_H    (REG_DISP_TOP_GAMMA_BASE + 0xAF)
#define REG_DISP_TOP_GAMMA_58_L    (REG_DISP_TOP_GAMMA_BASE + 0xB0)
#define REG_DISP_TOP_GAMMA_58_H    (REG_DISP_TOP_GAMMA_BASE + 0xB1)
#define REG_DISP_TOP_GAMMA_59_L    (REG_DISP_TOP_GAMMA_BASE + 0xB2)
#define REG_DISP_TOP_GAMMA_59_H    (REG_DISP_TOP_GAMMA_BASE + 0xB3)
#define REG_DISP_TOP_GAMMA_5A_L    (REG_DISP_TOP_GAMMA_BASE + 0xB4)
#define REG_DISP_TOP_GAMMA_5A_H    (REG_DISP_TOP_GAMMA_BASE + 0xB5)
#define REG_DISP_TOP_GAMMA_5B_L    (REG_DISP_TOP_GAMMA_BASE + 0xB6)
#define REG_DISP_TOP_GAMMA_5B_H    (REG_DISP_TOP_GAMMA_BASE + 0xB7)
#define REG_DISP_TOP_GAMMA_5C_L    (REG_DISP_TOP_GAMMA_BASE + 0xB8)
#define REG_DISP_TOP_GAMMA_5C_H    (REG_DISP_TOP_GAMMA_BASE + 0xB9)
#define REG_DISP_TOP_GAMMA_5D_L    (REG_DISP_TOP_GAMMA_BASE + 0xBA)
#define REG_DISP_TOP_GAMMA_5D_H    (REG_DISP_TOP_GAMMA_BASE + 0xBB)
#define REG_DISP_TOP_GAMMA_5E_L    (REG_DISP_TOP_GAMMA_BASE + 0xBC)
#define REG_DISP_TOP_GAMMA_5E_H    (REG_DISP_TOP_GAMMA_BASE + 0xBD)
#define REG_DISP_TOP_GAMMA_5F_L    (REG_DISP_TOP_GAMMA_BASE + 0xBE)
#define REG_DISP_TOP_GAMMA_5F_H    (REG_DISP_TOP_GAMMA_BASE + 0xBF)
#define REG_DISP_TOP_GAMMA_60_L    (REG_DISP_TOP_GAMMA_BASE + 0xC0)
#define REG_DISP_TOP_GAMMA_60_H    (REG_DISP_TOP_GAMMA_BASE + 0xC1)
#define REG_DISP_TOP_GAMMA_61_L    (REG_DISP_TOP_GAMMA_BASE + 0xC2)
#define REG_DISP_TOP_GAMMA_61_H    (REG_DISP_TOP_GAMMA_BASE + 0xC3)
#define REG_DISP_TOP_GAMMA_62_L    (REG_DISP_TOP_GAMMA_BASE + 0xC4)
#define REG_DISP_TOP_GAMMA_62_H    (REG_DISP_TOP_GAMMA_BASE + 0xC5)
#define REG_DISP_TOP_GAMMA_63_L    (REG_DISP_TOP_GAMMA_BASE + 0xC6)
#define REG_DISP_TOP_GAMMA_63_H    (REG_DISP_TOP_GAMMA_BASE + 0xC7)
#define REG_DISP_TOP_GAMMA_64_L    (REG_DISP_TOP_GAMMA_BASE + 0xC8)
#define REG_DISP_TOP_GAMMA_64_H    (REG_DISP_TOP_GAMMA_BASE + 0xC9)
#define REG_DISP_TOP_GAMMA_65_L    (REG_DISP_TOP_GAMMA_BASE + 0xCA)
#define REG_DISP_TOP_GAMMA_65_H    (REG_DISP_TOP_GAMMA_BASE + 0xCB)
#define REG_DISP_TOP_GAMMA_66_L    (REG_DISP_TOP_GAMMA_BASE + 0xCC)
#define REG_DISP_TOP_GAMMA_66_H    (REG_DISP_TOP_GAMMA_BASE + 0xCD)
#define REG_DISP_TOP_GAMMA_67_L    (REG_DISP_TOP_GAMMA_BASE + 0xCE)
#define REG_DISP_TOP_GAMMA_67_H    (REG_DISP_TOP_GAMMA_BASE + 0xCF)
#define REG_DISP_TOP_GAMMA_68_L    (REG_DISP_TOP_GAMMA_BASE + 0xD0)
#define REG_DISP_TOP_GAMMA_68_H    (REG_DISP_TOP_GAMMA_BASE + 0xD1)
#define REG_DISP_TOP_GAMMA_69_L    (REG_DISP_TOP_GAMMA_BASE + 0xD2)
#define REG_DISP_TOP_GAMMA_69_H    (REG_DISP_TOP_GAMMA_BASE + 0xD3)
#define REG_DISP_TOP_GAMMA_6A_L    (REG_DISP_TOP_GAMMA_BASE + 0xD4)
#define REG_DISP_TOP_GAMMA_6A_H    (REG_DISP_TOP_GAMMA_BASE + 0xD5)
#define REG_DISP_TOP_GAMMA_6B_L    (REG_DISP_TOP_GAMMA_BASE + 0xD6)
#define REG_DISP_TOP_GAMMA_6B_H    (REG_DISP_TOP_GAMMA_BASE + 0xD7)
#define REG_DISP_TOP_GAMMA_6C_L    (REG_DISP_TOP_GAMMA_BASE + 0xD8)
#define REG_DISP_TOP_GAMMA_6C_H    (REG_DISP_TOP_GAMMA_BASE + 0xD9)
#define REG_DISP_TOP_GAMMA_6D_L    (REG_DISP_TOP_GAMMA_BASE + 0xDA)
#define REG_DISP_TOP_GAMMA_6D_H    (REG_DISP_TOP_GAMMA_BASE + 0xDB)
#define REG_DISP_TOP_GAMMA_6E_L    (REG_DISP_TOP_GAMMA_BASE + 0xDC)
#define REG_DISP_TOP_GAMMA_6E_H    (REG_DISP_TOP_GAMMA_BASE + 0xDD)
#define REG_DISP_TOP_GAMMA_6F_L    (REG_DISP_TOP_GAMMA_BASE + 0xDE)
#define REG_DISP_TOP_GAMMA_6F_H    (REG_DISP_TOP_GAMMA_BASE + 0xDF)
#define REG_DISP_TOP_GAMMA_70_L    (REG_DISP_TOP_GAMMA_BASE + 0xE0)
#define REG_DISP_TOP_GAMMA_70_H    (REG_DISP_TOP_GAMMA_BASE + 0xE1)
#define REG_DISP_TOP_GAMMA_71_L    (REG_DISP_TOP_GAMMA_BASE + 0xE2)
#define REG_DISP_TOP_GAMMA_71_H    (REG_DISP_TOP_GAMMA_BASE + 0xE3)
#define REG_DISP_TOP_GAMMA_72_L    (REG_DISP_TOP_GAMMA_BASE + 0xE4)
#define REG_DISP_TOP_GAMMA_72_H    (REG_DISP_TOP_GAMMA_BASE + 0xE5)
#define REG_DISP_TOP_GAMMA_73_L    (REG_DISP_TOP_GAMMA_BASE + 0xE6)
#define REG_DISP_TOP_GAMMA_73_H    (REG_DISP_TOP_GAMMA_BASE + 0xE7)
#define REG_DISP_TOP_GAMMA_74_L    (REG_DISP_TOP_GAMMA_BASE + 0xE8)
#define REG_DISP_TOP_GAMMA_74_H    (REG_DISP_TOP_GAMMA_BASE + 0xE9)
#define REG_DISP_TOP_GAMMA_75_L    (REG_DISP_TOP_GAMMA_BASE + 0xEA)
#define REG_DISP_TOP_GAMMA_75_H    (REG_DISP_TOP_GAMMA_BASE + 0xEB)
#define REG_DISP_TOP_GAMMA_76_L    (REG_DISP_TOP_GAMMA_BASE + 0xEC)
#define REG_DISP_TOP_GAMMA_76_H    (REG_DISP_TOP_GAMMA_BASE + 0xED)
#define REG_DISP_TOP_GAMMA_77_L    (REG_DISP_TOP_GAMMA_BASE + 0xEE)
#define REG_DISP_TOP_GAMMA_77_H    (REG_DISP_TOP_GAMMA_BASE + 0xEF)
#define REG_DISP_TOP_GAMMA_78_L    (REG_DISP_TOP_GAMMA_BASE + 0xF0)
#define REG_DISP_TOP_GAMMA_78_H    (REG_DISP_TOP_GAMMA_BASE + 0xF1)
#define REG_DISP_TOP_GAMMA_79_L    (REG_DISP_TOP_GAMMA_BASE + 0xF2)
#define REG_DISP_TOP_GAMMA_79_H    (REG_DISP_TOP_GAMMA_BASE + 0xF3)
#define REG_DISP_TOP_GAMMA_7A_L    (REG_DISP_TOP_GAMMA_BASE + 0xF4)
#define REG_DISP_TOP_GAMMA_7A_H    (REG_DISP_TOP_GAMMA_BASE + 0xF5)
#define REG_DISP_TOP_GAMMA_7B_L    (REG_DISP_TOP_GAMMA_BASE + 0xF6)
#define REG_DISP_TOP_GAMMA_7B_H    (REG_DISP_TOP_GAMMA_BASE + 0xF7)
#define REG_DISP_TOP_GAMMA_7C_L    (REG_DISP_TOP_GAMMA_BASE + 0xF8)
#define REG_DISP_TOP_GAMMA_7C_H    (REG_DISP_TOP_GAMMA_BASE + 0xF9)
#define REG_DISP_TOP_GAMMA_7D_L    (REG_DISP_TOP_GAMMA_BASE + 0xFA)
#define REG_DISP_TOP_GAMMA_7D_H    (REG_DISP_TOP_GAMMA_BASE + 0xFB)
#define REG_DISP_TOP_GAMMA_7E_L    (REG_DISP_TOP_GAMMA_BASE + 0xFC)
#define REG_DISP_TOP_GAMMA_7E_H    (REG_DISP_TOP_GAMMA_BASE + 0xFD)
#define REG_DISP_TOP_GAMMA_7F_L    (REG_DISP_TOP_GAMMA_BASE + 0xFE)
#define REG_DISP_TOP_GAMMA_7F_H    (REG_DISP_TOP_GAMMA_BASE + 0xFF)

#define REG_DISP_TOP_MACE_00_L    (REG_DISP_TOP_MACE_BASE + 0x00)
#define REG_DISP_TOP_MACE_00_H    (REG_DISP_TOP_MACE_BASE + 0x01)
#define REG_DISP_TOP_MACE_01_L    (REG_DISP_TOP_MACE_BASE + 0x02)
#define REG_DISP_TOP_MACE_01_H    (REG_DISP_TOP_MACE_BASE + 0x03)
#define REG_DISP_TOP_MACE_02_L    (REG_DISP_TOP_MACE_BASE + 0x04)
#define REG_DISP_TOP_MACE_02_H    (REG_DISP_TOP_MACE_BASE + 0x05)
#define REG_DISP_TOP_MACE_03_L    (REG_DISP_TOP_MACE_BASE + 0x06)
#define REG_DISP_TOP_MACE_03_H    (REG_DISP_TOP_MACE_BASE + 0x07)
#define REG_DISP_TOP_MACE_04_L    (REG_DISP_TOP_MACE_BASE + 0x08)
#define REG_DISP_TOP_MACE_04_H    (REG_DISP_TOP_MACE_BASE + 0x09)
#define REG_DISP_TOP_MACE_05_L    (REG_DISP_TOP_MACE_BASE + 0x0A)
#define REG_DISP_TOP_MACE_05_H    (REG_DISP_TOP_MACE_BASE + 0x0B)
#define REG_DISP_TOP_MACE_06_L    (REG_DISP_TOP_MACE_BASE + 0x0C)
#define REG_DISP_TOP_MACE_06_H    (REG_DISP_TOP_MACE_BASE + 0x0D)
#define REG_DISP_TOP_MACE_07_L    (REG_DISP_TOP_MACE_BASE + 0x0E)
#define REG_DISP_TOP_MACE_07_H    (REG_DISP_TOP_MACE_BASE + 0x0F)
#define REG_DISP_TOP_MACE_08_L    (REG_DISP_TOP_MACE_BASE + 0x10)
#define REG_DISP_TOP_MACE_08_H    (REG_DISP_TOP_MACE_BASE + 0x11)
#define REG_DISP_TOP_MACE_09_L    (REG_DISP_TOP_MACE_BASE + 0x12)
#define REG_DISP_TOP_MACE_09_H    (REG_DISP_TOP_MACE_BASE + 0x13)
#define REG_DISP_TOP_MACE_0A_L    (REG_DISP_TOP_MACE_BASE + 0x14)
#define REG_DISP_TOP_MACE_0A_H    (REG_DISP_TOP_MACE_BASE + 0x15)
#define REG_DISP_TOP_MACE_0B_L    (REG_DISP_TOP_MACE_BASE + 0x16)
#define REG_DISP_TOP_MACE_0B_H    (REG_DISP_TOP_MACE_BASE + 0x17)
#define REG_DISP_TOP_MACE_0C_L    (REG_DISP_TOP_MACE_BASE + 0x18)
#define REG_DISP_TOP_MACE_0C_H    (REG_DISP_TOP_MACE_BASE + 0x19)
#define REG_DISP_TOP_MACE_0D_L    (REG_DISP_TOP_MACE_BASE + 0x1A)
#define REG_DISP_TOP_MACE_0D_H    (REG_DISP_TOP_MACE_BASE + 0x1B)
#define REG_DISP_TOP_MACE_0E_L    (REG_DISP_TOP_MACE_BASE + 0x1C)
#define REG_DISP_TOP_MACE_0E_H    (REG_DISP_TOP_MACE_BASE + 0x1D)
#define REG_DISP_TOP_MACE_0F_L    (REG_DISP_TOP_MACE_BASE + 0x1E)
#define REG_DISP_TOP_MACE_0F_H    (REG_DISP_TOP_MACE_BASE + 0x1F)
#define REG_DISP_TOP_MACE_10_L    (REG_DISP_TOP_MACE_BASE + 0x20)
#define REG_DISP_TOP_MACE_10_H    (REG_DISP_TOP_MACE_BASE + 0x21)
#define REG_DISP_TOP_MACE_11_L    (REG_DISP_TOP_MACE_BASE + 0x22)
#define REG_DISP_TOP_MACE_11_H    (REG_DISP_TOP_MACE_BASE + 0x23)
#define REG_DISP_TOP_MACE_12_L    (REG_DISP_TOP_MACE_BASE + 0x24)
#define REG_DISP_TOP_MACE_12_H    (REG_DISP_TOP_MACE_BASE + 0x25)
#define REG_DISP_TOP_MACE_13_L    (REG_DISP_TOP_MACE_BASE + 0x26)
#define REG_DISP_TOP_MACE_13_H    (REG_DISP_TOP_MACE_BASE + 0x27)
#define REG_DISP_TOP_MACE_14_L    (REG_DISP_TOP_MACE_BASE + 0x28)
#define REG_DISP_TOP_MACE_14_H    (REG_DISP_TOP_MACE_BASE + 0x29)
#define REG_DISP_TOP_MACE_15_L    (REG_DISP_TOP_MACE_BASE + 0x2A)
#define REG_DISP_TOP_MACE_15_H    (REG_DISP_TOP_MACE_BASE + 0x2B)
#define REG_DISP_TOP_MACE_16_L    (REG_DISP_TOP_MACE_BASE + 0x2C)
#define REG_DISP_TOP_MACE_16_H    (REG_DISP_TOP_MACE_BASE + 0x2D)
#define REG_DISP_TOP_MACE_17_L    (REG_DISP_TOP_MACE_BASE + 0x2E)
#define REG_DISP_TOP_MACE_17_H    (REG_DISP_TOP_MACE_BASE + 0x2F)
#define REG_DISP_TOP_MACE_18_L    (REG_DISP_TOP_MACE_BASE + 0x30)
#define REG_DISP_TOP_MACE_18_H    (REG_DISP_TOP_MACE_BASE + 0x31)
#define REG_DISP_TOP_MACE_19_L    (REG_DISP_TOP_MACE_BASE + 0x32)
#define REG_DISP_TOP_MACE_19_H    (REG_DISP_TOP_MACE_BASE + 0x33)
#define REG_DISP_TOP_MACE_1A_L    (REG_DISP_TOP_MACE_BASE + 0x34)
#define REG_DISP_TOP_MACE_1A_H    (REG_DISP_TOP_MACE_BASE + 0x35)
#define REG_DISP_TOP_MACE_1B_L    (REG_DISP_TOP_MACE_BASE + 0x36)
#define REG_DISP_TOP_MACE_1B_H    (REG_DISP_TOP_MACE_BASE + 0x37)
#define REG_DISP_TOP_MACE_1C_L    (REG_DISP_TOP_MACE_BASE + 0x38)
#define REG_DISP_TOP_MACE_1C_H    (REG_DISP_TOP_MACE_BASE + 0x39)
#define REG_DISP_TOP_MACE_1D_L    (REG_DISP_TOP_MACE_BASE + 0x3A)
#define REG_DISP_TOP_MACE_1D_H    (REG_DISP_TOP_MACE_BASE + 0x3B)
#define REG_DISP_TOP_MACE_1E_L    (REG_DISP_TOP_MACE_BASE + 0x3C)
#define REG_DISP_TOP_MACE_1E_H    (REG_DISP_TOP_MACE_BASE + 0x3D)
#define REG_DISP_TOP_MACE_1F_L    (REG_DISP_TOP_MACE_BASE + 0x3E)
#define REG_DISP_TOP_MACE_1F_H    (REG_DISP_TOP_MACE_BASE + 0x3F)
#define REG_DISP_TOP_MACE_20_L    (REG_DISP_TOP_MACE_BASE + 0x40)
#define REG_DISP_TOP_MACE_20_H    (REG_DISP_TOP_MACE_BASE + 0x41)
#define REG_DISP_TOP_MACE_21_L    (REG_DISP_TOP_MACE_BASE + 0x42)
#define REG_DISP_TOP_MACE_21_H    (REG_DISP_TOP_MACE_BASE + 0x43)
#define REG_DISP_TOP_MACE_22_L    (REG_DISP_TOP_MACE_BASE + 0x44)
#define REG_DISP_TOP_MACE_22_H    (REG_DISP_TOP_MACE_BASE + 0x45)
#define REG_DISP_TOP_MACE_23_L    (REG_DISP_TOP_MACE_BASE + 0x46)
#define REG_DISP_TOP_MACE_23_H    (REG_DISP_TOP_MACE_BASE + 0x47)
#define REG_DISP_TOP_MACE_24_L    (REG_DISP_TOP_MACE_BASE + 0x48)
#define REG_DISP_TOP_MACE_24_H    (REG_DISP_TOP_MACE_BASE + 0x49)
#define REG_DISP_TOP_MACE_25_L    (REG_DISP_TOP_MACE_BASE + 0x4A)
#define REG_DISP_TOP_MACE_25_H    (REG_DISP_TOP_MACE_BASE + 0x4B)
#define REG_DISP_TOP_MACE_26_L    (REG_DISP_TOP_MACE_BASE + 0x4C)
#define REG_DISP_TOP_MACE_26_H    (REG_DISP_TOP_MACE_BASE + 0x4D)
#define REG_DISP_TOP_MACE_27_L    (REG_DISP_TOP_MACE_BASE + 0x4E)
#define REG_DISP_TOP_MACE_27_H    (REG_DISP_TOP_MACE_BASE + 0x4F)
#define REG_DISP_TOP_MACE_28_L    (REG_DISP_TOP_MACE_BASE + 0x50)
#define REG_DISP_TOP_MACE_28_H    (REG_DISP_TOP_MACE_BASE + 0x51)
#define REG_DISP_TOP_MACE_29_L    (REG_DISP_TOP_MACE_BASE + 0x52)
#define REG_DISP_TOP_MACE_29_H    (REG_DISP_TOP_MACE_BASE + 0x53)
#define REG_DISP_TOP_MACE_2A_L    (REG_DISP_TOP_MACE_BASE + 0x54)
#define REG_DISP_TOP_MACE_2A_H    (REG_DISP_TOP_MACE_BASE + 0x55)
#define REG_DISP_TOP_MACE_2B_L    (REG_DISP_TOP_MACE_BASE + 0x56)
#define REG_DISP_TOP_MACE_2B_H    (REG_DISP_TOP_MACE_BASE + 0x57)
#define REG_DISP_TOP_MACE_2C_L    (REG_DISP_TOP_MACE_BASE + 0x58)
#define REG_DISP_TOP_MACE_2C_H    (REG_DISP_TOP_MACE_BASE + 0x59)
#define REG_DISP_TOP_MACE_2D_L    (REG_DISP_TOP_MACE_BASE + 0x5A)
#define REG_DISP_TOP_MACE_2D_H    (REG_DISP_TOP_MACE_BASE + 0x5B)
#define REG_DISP_TOP_MACE_2E_L    (REG_DISP_TOP_MACE_BASE + 0x5C)
#define REG_DISP_TOP_MACE_2E_H    (REG_DISP_TOP_MACE_BASE + 0x5D)
#define REG_DISP_TOP_MACE_2F_L    (REG_DISP_TOP_MACE_BASE + 0x5E)
#define REG_DISP_TOP_MACE_2F_H    (REG_DISP_TOP_MACE_BASE + 0x5F)
#define REG_DISP_TOP_MACE_30_L    (REG_DISP_TOP_MACE_BASE + 0x60)
#define REG_DISP_TOP_MACE_30_H    (REG_DISP_TOP_MACE_BASE + 0x61)
#define REG_DISP_TOP_MACE_31_L    (REG_DISP_TOP_MACE_BASE + 0x62)
#define REG_DISP_TOP_MACE_31_H    (REG_DISP_TOP_MACE_BASE + 0x63)
#define REG_DISP_TOP_MACE_32_L    (REG_DISP_TOP_MACE_BASE + 0x64)
#define REG_DISP_TOP_MACE_32_H    (REG_DISP_TOP_MACE_BASE + 0x65)
#define REG_DISP_TOP_MACE_33_L    (REG_DISP_TOP_MACE_BASE + 0x66)
#define REG_DISP_TOP_MACE_33_H    (REG_DISP_TOP_MACE_BASE + 0x67)
#define REG_DISP_TOP_MACE_34_L    (REG_DISP_TOP_MACE_BASE + 0x68)
#define REG_DISP_TOP_MACE_34_H    (REG_DISP_TOP_MACE_BASE + 0x69)
#define REG_DISP_TOP_MACE_35_L    (REG_DISP_TOP_MACE_BASE + 0x6A)
#define REG_DISP_TOP_MACE_35_H    (REG_DISP_TOP_MACE_BASE + 0x6B)
#define REG_DISP_TOP_MACE_36_L    (REG_DISP_TOP_MACE_BASE + 0x6C)
#define REG_DISP_TOP_MACE_36_H    (REG_DISP_TOP_MACE_BASE + 0x6D)
#define REG_DISP_TOP_MACE_37_L    (REG_DISP_TOP_MACE_BASE + 0x6E)
#define REG_DISP_TOP_MACE_37_H    (REG_DISP_TOP_MACE_BASE + 0x6F)
#define REG_DISP_TOP_MACE_38_L    (REG_DISP_TOP_MACE_BASE + 0x70)
#define REG_DISP_TOP_MACE_38_H    (REG_DISP_TOP_MACE_BASE + 0x71)
#define REG_DISP_TOP_MACE_39_L    (REG_DISP_TOP_MACE_BASE + 0x72)
#define REG_DISP_TOP_MACE_39_H    (REG_DISP_TOP_MACE_BASE + 0x73)
#define REG_DISP_TOP_MACE_3A_L    (REG_DISP_TOP_MACE_BASE + 0x74)
#define REG_DISP_TOP_MACE_3A_H    (REG_DISP_TOP_MACE_BASE + 0x75)
#define REG_DISP_TOP_MACE_3B_L    (REG_DISP_TOP_MACE_BASE + 0x76)
#define REG_DISP_TOP_MACE_3B_H    (REG_DISP_TOP_MACE_BASE + 0x77)
#define REG_DISP_TOP_MACE_3C_L    (REG_DISP_TOP_MACE_BASE + 0x78)
#define REG_DISP_TOP_MACE_3C_H    (REG_DISP_TOP_MACE_BASE + 0x79)
#define REG_DISP_TOP_MACE_3D_L    (REG_DISP_TOP_MACE_BASE + 0x7A)
#define REG_DISP_TOP_MACE_3D_H    (REG_DISP_TOP_MACE_BASE + 0x7B)
#define REG_DISP_TOP_MACE_3E_L    (REG_DISP_TOP_MACE_BASE + 0x7C)
#define REG_DISP_TOP_MACE_3E_H    (REG_DISP_TOP_MACE_BASE + 0x7D)
#define REG_DISP_TOP_MACE_3F_L    (REG_DISP_TOP_MACE_BASE + 0x7E)
#define REG_DISP_TOP_MACE_3F_H    (REG_DISP_TOP_MACE_BASE + 0x7F)
#define REG_DISP_TOP_MACE_40_L    (REG_DISP_TOP_MACE_BASE + 0x80)
#define REG_DISP_TOP_MACE_40_H    (REG_DISP_TOP_MACE_BASE + 0x81)
#define REG_DISP_TOP_MACE_41_L    (REG_DISP_TOP_MACE_BASE + 0x82)
#define REG_DISP_TOP_MACE_41_H    (REG_DISP_TOP_MACE_BASE + 0x83)
#define REG_DISP_TOP_MACE_42_L    (REG_DISP_TOP_MACE_BASE + 0x84)
#define REG_DISP_TOP_MACE_42_H    (REG_DISP_TOP_MACE_BASE + 0x85)
#define REG_DISP_TOP_MACE_43_L    (REG_DISP_TOP_MACE_BASE + 0x86)
#define REG_DISP_TOP_MACE_43_H    (REG_DISP_TOP_MACE_BASE + 0x87)
#define REG_DISP_TOP_MACE_44_L    (REG_DISP_TOP_MACE_BASE + 0x88)
#define REG_DISP_TOP_MACE_44_H    (REG_DISP_TOP_MACE_BASE + 0x89)
#define REG_DISP_TOP_MACE_45_L    (REG_DISP_TOP_MACE_BASE + 0x8A)
#define REG_DISP_TOP_MACE_45_H    (REG_DISP_TOP_MACE_BASE + 0x8B)
#define REG_DISP_TOP_MACE_46_L    (REG_DISP_TOP_MACE_BASE + 0x8C)
#define REG_DISP_TOP_MACE_46_H    (REG_DISP_TOP_MACE_BASE + 0x8D)
#define REG_DISP_TOP_MACE_47_L    (REG_DISP_TOP_MACE_BASE + 0x8E)
#define REG_DISP_TOP_MACE_47_H    (REG_DISP_TOP_MACE_BASE + 0x8F)
#define REG_DISP_TOP_MACE_48_L    (REG_DISP_TOP_MACE_BASE + 0x90)
#define REG_DISP_TOP_MACE_48_H    (REG_DISP_TOP_MACE_BASE + 0x91)
#define REG_DISP_TOP_MACE_49_L    (REG_DISP_TOP_MACE_BASE + 0x92)
#define REG_DISP_TOP_MACE_49_H    (REG_DISP_TOP_MACE_BASE + 0x93)
#define REG_DISP_TOP_MACE_4A_L    (REG_DISP_TOP_MACE_BASE + 0x94)
#define REG_DISP_TOP_MACE_4A_H    (REG_DISP_TOP_MACE_BASE + 0x95)
#define REG_DISP_TOP_MACE_4B_L    (REG_DISP_TOP_MACE_BASE + 0x96)
#define REG_DISP_TOP_MACE_4B_H    (REG_DISP_TOP_MACE_BASE + 0x97)
#define REG_DISP_TOP_MACE_4C_L    (REG_DISP_TOP_MACE_BASE + 0x98)
#define REG_DISP_TOP_MACE_4C_H    (REG_DISP_TOP_MACE_BASE + 0x99)
#define REG_DISP_TOP_MACE_4D_L    (REG_DISP_TOP_MACE_BASE + 0x9A)
#define REG_DISP_TOP_MACE_4D_H    (REG_DISP_TOP_MACE_BASE + 0x9B)
#define REG_DISP_TOP_MACE_4E_L    (REG_DISP_TOP_MACE_BASE + 0x9C)
#define REG_DISP_TOP_MACE_4E_H    (REG_DISP_TOP_MACE_BASE + 0x9D)
#define REG_DISP_TOP_MACE_4F_L    (REG_DISP_TOP_MACE_BASE + 0x9E)
#define REG_DISP_TOP_MACE_4F_H    (REG_DISP_TOP_MACE_BASE + 0x9F)
#define REG_DISP_TOP_MACE_50_L    (REG_DISP_TOP_MACE_BASE + 0xA0)
#define REG_DISP_TOP_MACE_50_H    (REG_DISP_TOP_MACE_BASE + 0xA1)
#define REG_DISP_TOP_MACE_51_L    (REG_DISP_TOP_MACE_BASE + 0xA2)
#define REG_DISP_TOP_MACE_51_H    (REG_DISP_TOP_MACE_BASE + 0xA3)
#define REG_DISP_TOP_MACE_52_L    (REG_DISP_TOP_MACE_BASE + 0xA4)
#define REG_DISP_TOP_MACE_52_H    (REG_DISP_TOP_MACE_BASE + 0xA5)
#define REG_DISP_TOP_MACE_53_L    (REG_DISP_TOP_MACE_BASE + 0xA6)
#define REG_DISP_TOP_MACE_53_H    (REG_DISP_TOP_MACE_BASE + 0xA7)
#define REG_DISP_TOP_MACE_54_L    (REG_DISP_TOP_MACE_BASE + 0xA8)
#define REG_DISP_TOP_MACE_54_H    (REG_DISP_TOP_MACE_BASE + 0xA9)
#define REG_DISP_TOP_MACE_55_L    (REG_DISP_TOP_MACE_BASE + 0xAA)
#define REG_DISP_TOP_MACE_55_H    (REG_DISP_TOP_MACE_BASE + 0xAB)
#define REG_DISP_TOP_MACE_56_L    (REG_DISP_TOP_MACE_BASE + 0xAC)
#define REG_DISP_TOP_MACE_56_H    (REG_DISP_TOP_MACE_BASE + 0xAD)
#define REG_DISP_TOP_MACE_57_L    (REG_DISP_TOP_MACE_BASE + 0xAE)
#define REG_DISP_TOP_MACE_57_H    (REG_DISP_TOP_MACE_BASE + 0xAF)
#define REG_DISP_TOP_MACE_58_L    (REG_DISP_TOP_MACE_BASE + 0xB0)
#define REG_DISP_TOP_MACE_58_H    (REG_DISP_TOP_MACE_BASE + 0xB1)
#define REG_DISP_TOP_MACE_59_L    (REG_DISP_TOP_MACE_BASE + 0xB2)
#define REG_DISP_TOP_MACE_59_H    (REG_DISP_TOP_MACE_BASE + 0xB3)
#define REG_DISP_TOP_MACE_5A_L    (REG_DISP_TOP_MACE_BASE + 0xB4)
#define REG_DISP_TOP_MACE_5A_H    (REG_DISP_TOP_MACE_BASE + 0xB5)
#define REG_DISP_TOP_MACE_5B_L    (REG_DISP_TOP_MACE_BASE + 0xB6)
#define REG_DISP_TOP_MACE_5B_H    (REG_DISP_TOP_MACE_BASE + 0xB7)
#define REG_DISP_TOP_MACE_5C_L    (REG_DISP_TOP_MACE_BASE + 0xB8)
#define REG_DISP_TOP_MACE_5C_H    (REG_DISP_TOP_MACE_BASE + 0xB9)
#define REG_DISP_TOP_MACE_5D_L    (REG_DISP_TOP_MACE_BASE + 0xBA)
#define REG_DISP_TOP_MACE_5D_H    (REG_DISP_TOP_MACE_BASE + 0xBB)
#define REG_DISP_TOP_MACE_5E_L    (REG_DISP_TOP_MACE_BASE + 0xBC)
#define REG_DISP_TOP_MACE_5E_H    (REG_DISP_TOP_MACE_BASE + 0xBD)
#define REG_DISP_TOP_MACE_5F_L    (REG_DISP_TOP_MACE_BASE + 0xBE)
#define REG_DISP_TOP_MACE_5F_H    (REG_DISP_TOP_MACE_BASE + 0xBF)
#define REG_DISP_TOP_MACE_60_L    (REG_DISP_TOP_MACE_BASE + 0xC0)
#define REG_DISP_TOP_MACE_60_H    (REG_DISP_TOP_MACE_BASE + 0xC1)
#define REG_DISP_TOP_MACE_61_L    (REG_DISP_TOP_MACE_BASE + 0xC2)
#define REG_DISP_TOP_MACE_61_H    (REG_DISP_TOP_MACE_BASE + 0xC3)
#define REG_DISP_TOP_MACE_62_L    (REG_DISP_TOP_MACE_BASE + 0xC4)
#define REG_DISP_TOP_MACE_62_H    (REG_DISP_TOP_MACE_BASE + 0xC5)
#define REG_DISP_TOP_MACE_63_L    (REG_DISP_TOP_MACE_BASE + 0xC6)
#define REG_DISP_TOP_MACE_63_H    (REG_DISP_TOP_MACE_BASE + 0xC7)
#define REG_DISP_TOP_MACE_64_L    (REG_DISP_TOP_MACE_BASE + 0xC8)
#define REG_DISP_TOP_MACE_64_H    (REG_DISP_TOP_MACE_BASE + 0xC9)
#define REG_DISP_TOP_MACE_65_L    (REG_DISP_TOP_MACE_BASE + 0xCA)
#define REG_DISP_TOP_MACE_65_H    (REG_DISP_TOP_MACE_BASE + 0xCB)
#define REG_DISP_TOP_MACE_66_L    (REG_DISP_TOP_MACE_BASE + 0xCC)
#define REG_DISP_TOP_MACE_66_H    (REG_DISP_TOP_MACE_BASE + 0xCD)
#define REG_DISP_TOP_MACE_67_L    (REG_DISP_TOP_MACE_BASE + 0xCE)
#define REG_DISP_TOP_MACE_67_H    (REG_DISP_TOP_MACE_BASE + 0xCF)
#define REG_DISP_TOP_MACE_68_L    (REG_DISP_TOP_MACE_BASE + 0xD0)
#define REG_DISP_TOP_MACE_68_H    (REG_DISP_TOP_MACE_BASE + 0xD1)
#define REG_DISP_TOP_MACE_69_L    (REG_DISP_TOP_MACE_BASE + 0xD2)
#define REG_DISP_TOP_MACE_69_H    (REG_DISP_TOP_MACE_BASE + 0xD3)
#define REG_DISP_TOP_MACE_6A_L    (REG_DISP_TOP_MACE_BASE + 0xD4)
#define REG_DISP_TOP_MACE_6A_H    (REG_DISP_TOP_MACE_BASE + 0xD5)
#define REG_DISP_TOP_MACE_6B_L    (REG_DISP_TOP_MACE_BASE + 0xD6)
#define REG_DISP_TOP_MACE_6B_H    (REG_DISP_TOP_MACE_BASE + 0xD7)
#define REG_DISP_TOP_MACE_6C_L    (REG_DISP_TOP_MACE_BASE + 0xD8)
#define REG_DISP_TOP_MACE_6C_H    (REG_DISP_TOP_MACE_BASE + 0xD9)
#define REG_DISP_TOP_MACE_6D_L    (REG_DISP_TOP_MACE_BASE + 0xDA)
#define REG_DISP_TOP_MACE_6D_H    (REG_DISP_TOP_MACE_BASE + 0xDB)
#define REG_DISP_TOP_MACE_6E_L    (REG_DISP_TOP_MACE_BASE + 0xDC)
#define REG_DISP_TOP_MACE_6E_H    (REG_DISP_TOP_MACE_BASE + 0xDD)
#define REG_DISP_TOP_MACE_6F_L    (REG_DISP_TOP_MACE_BASE + 0xDE)
#define REG_DISP_TOP_MACE_6F_H    (REG_DISP_TOP_MACE_BASE + 0xDF)
#define REG_DISP_TOP_MACE_70_L    (REG_DISP_TOP_MACE_BASE + 0xE0)
#define REG_DISP_TOP_MACE_70_H    (REG_DISP_TOP_MACE_BASE + 0xE1)
#define REG_DISP_TOP_MACE_71_L    (REG_DISP_TOP_MACE_BASE + 0xE2)
#define REG_DISP_TOP_MACE_71_H    (REG_DISP_TOP_MACE_BASE + 0xE3)
#define REG_DISP_TOP_MACE_72_L    (REG_DISP_TOP_MACE_BASE + 0xE4)
#define REG_DISP_TOP_MACE_72_H    (REG_DISP_TOP_MACE_BASE + 0xE5)
#define REG_DISP_TOP_MACE_73_L    (REG_DISP_TOP_MACE_BASE + 0xE6)
#define REG_DISP_TOP_MACE_73_H    (REG_DISP_TOP_MACE_BASE + 0xE7)
#define REG_DISP_TOP_MACE_74_L    (REG_DISP_TOP_MACE_BASE + 0xE8)
#define REG_DISP_TOP_MACE_74_H    (REG_DISP_TOP_MACE_BASE + 0xE9)
#define REG_DISP_TOP_MACE_75_L    (REG_DISP_TOP_MACE_BASE + 0xEA)
#define REG_DISP_TOP_MACE_75_H    (REG_DISP_TOP_MACE_BASE + 0xEB)
#define REG_DISP_TOP_MACE_76_L    (REG_DISP_TOP_MACE_BASE + 0xEC)
#define REG_DISP_TOP_MACE_76_H    (REG_DISP_TOP_MACE_BASE + 0xED)
#define REG_DISP_TOP_MACE_77_L    (REG_DISP_TOP_MACE_BASE + 0xEE)
#define REG_DISP_TOP_MACE_77_H    (REG_DISP_TOP_MACE_BASE + 0xEF)
#define REG_DISP_TOP_MACE_78_L    (REG_DISP_TOP_MACE_BASE + 0xF0)
#define REG_DISP_TOP_MACE_78_H    (REG_DISP_TOP_MACE_BASE + 0xF1)
#define REG_DISP_TOP_MACE_79_L    (REG_DISP_TOP_MACE_BASE + 0xF2)
#define REG_DISP_TOP_MACE_79_H    (REG_DISP_TOP_MACE_BASE + 0xF3)
#define REG_DISP_TOP_MACE_7A_L    (REG_DISP_TOP_MACE_BASE + 0xF4)
#define REG_DISP_TOP_MACE_7A_H    (REG_DISP_TOP_MACE_BASE + 0xF5)
#define REG_DISP_TOP_MACE_7B_L    (REG_DISP_TOP_MACE_BASE + 0xF6)
#define REG_DISP_TOP_MACE_7B_H    (REG_DISP_TOP_MACE_BASE + 0xF7)
#define REG_DISP_TOP_MACE_7C_L    (REG_DISP_TOP_MACE_BASE + 0xF8)
#define REG_DISP_TOP_MACE_7C_H    (REG_DISP_TOP_MACE_BASE + 0xF9)
#define REG_DISP_TOP_MACE_7D_L    (REG_DISP_TOP_MACE_BASE + 0xFA)
#define REG_DISP_TOP_MACE_7D_H    (REG_DISP_TOP_MACE_BASE + 0xFB)
#define REG_DISP_TOP_MACE_7E_L    (REG_DISP_TOP_MACE_BASE + 0xFC)
#define REG_DISP_TOP_MACE_7E_H    (REG_DISP_TOP_MACE_BASE + 0xFD)
#define REG_DISP_TOP_MACE_7F_L    (REG_DISP_TOP_MACE_BASE + 0xFE)
#define REG_DISP_TOP_MACE_7F_H    (REG_DISP_TOP_MACE_BASE + 0xFF)

#define REG_DISP_MOPG_BK0_00_L     (REG_DISP_MOPG_BK0_BASE + 0x00)
#define REG_DISP_MOPG_BK0_00_H     (REG_DISP_MOPG_BK0_BASE + 0x01)
#define REG_DISP_MOPG_BK0_01_L     (REG_DISP_MOPG_BK0_BASE + 0x02)
#define REG_DISP_MOPG_BK0_01_H     (REG_DISP_MOPG_BK0_BASE + 0x03)
#define REG_DISP_MOPG_BK0_02_L     (REG_DISP_MOPG_BK0_BASE + 0x04)
#define REG_DISP_MOPG_BK0_02_H     (REG_DISP_MOPG_BK0_BASE + 0x05)
#define REG_DISP_MOPG_BK0_03_L     (REG_DISP_MOPG_BK0_BASE + 0x06)
#define REG_DISP_MOPG_BK0_03_H     (REG_DISP_MOPG_BK0_BASE + 0x07)
#define REG_DISP_MOPG_BK0_04_L     (REG_DISP_MOPG_BK0_BASE + 0x08)
#define REG_DISP_MOPG_BK0_04_H     (REG_DISP_MOPG_BK0_BASE + 0x09)
#define REG_DISP_MOPG_BK0_05_L     (REG_DISP_MOPG_BK0_BASE + 0x0A)
#define REG_DISP_MOPG_BK0_05_H     (REG_DISP_MOPG_BK0_BASE + 0x0B)
#define REG_DISP_MOPG_BK0_06_L     (REG_DISP_MOPG_BK0_BASE + 0x0C)
#define REG_DISP_MOPG_BK0_06_H     (REG_DISP_MOPG_BK0_BASE + 0x0D)
#define REG_DISP_MOPG_BK0_07_L     (REG_DISP_MOPG_BK0_BASE + 0x0E)
#define REG_DISP_MOPG_BK0_07_H     (REG_DISP_MOPG_BK0_BASE + 0x0F)
#define REG_DISP_MOPG_BK0_08_L     (REG_DISP_MOPG_BK0_BASE + 0x10)
#define REG_DISP_MOPG_BK0_08_H     (REG_DISP_MOPG_BK0_BASE + 0x11)
#define REG_DISP_MOPG_BK0_09_L     (REG_DISP_MOPG_BK0_BASE + 0x12)
#define REG_DISP_MOPG_BK0_09_H     (REG_DISP_MOPG_BK0_BASE + 0x13)
#define REG_DISP_MOPG_BK0_0A_L     (REG_DISP_MOPG_BK0_BASE + 0x14)
#define REG_DISP_MOPG_BK0_0A_H     (REG_DISP_MOPG_BK0_BASE + 0x15)
#define REG_DISP_MOPG_BK0_0B_L     (REG_DISP_MOPG_BK0_BASE + 0x16)
#define REG_DISP_MOPG_BK0_0B_H     (REG_DISP_MOPG_BK0_BASE + 0x17)
#define REG_DISP_MOPG_BK0_0C_L     (REG_DISP_MOPG_BK0_BASE + 0x18)
#define REG_DISP_MOPG_BK0_0C_H     (REG_DISP_MOPG_BK0_BASE + 0x19)
#define REG_DISP_MOPG_BK0_0D_L     (REG_DISP_MOPG_BK0_BASE + 0x1A)
#define REG_DISP_MOPG_BK0_0D_H     (REG_DISP_MOPG_BK0_BASE + 0x1B)
#define REG_DISP_MOPG_BK0_0E_L     (REG_DISP_MOPG_BK0_BASE + 0x1C)
#define REG_DISP_MOPG_BK0_0E_H     (REG_DISP_MOPG_BK0_BASE + 0x1D)
#define REG_DISP_MOPG_BK0_0F_L     (REG_DISP_MOPG_BK0_BASE + 0x1E)
#define REG_DISP_MOPG_BK0_0F_H     (REG_DISP_MOPG_BK0_BASE + 0x1F)
#define REG_DISP_MOPG_BK0_10_L     (REG_DISP_MOPG_BK0_BASE + 0x20)
#define REG_DISP_MOPG_BK0_10_H     (REG_DISP_MOPG_BK0_BASE + 0x21)
#define REG_DISP_MOPG_BK0_11_L     (REG_DISP_MOPG_BK0_BASE + 0x22)
#define REG_DISP_MOPG_BK0_11_H     (REG_DISP_MOPG_BK0_BASE + 0x23)
#define REG_DISP_MOPG_BK0_12_L     (REG_DISP_MOPG_BK0_BASE + 0x24)
#define REG_DISP_MOPG_BK0_12_H     (REG_DISP_MOPG_BK0_BASE + 0x25)
#define REG_DISP_MOPG_BK0_13_L     (REG_DISP_MOPG_BK0_BASE + 0x26)
#define REG_DISP_MOPG_BK0_13_H     (REG_DISP_MOPG_BK0_BASE + 0x27)
#define REG_DISP_MOPG_BK0_14_L     (REG_DISP_MOPG_BK0_BASE + 0x28)
#define REG_DISP_MOPG_BK0_14_H     (REG_DISP_MOPG_BK0_BASE + 0x29)
#define REG_DISP_MOPG_BK0_15_L     (REG_DISP_MOPG_BK0_BASE + 0x2A)
#define REG_DISP_MOPG_BK0_15_H     (REG_DISP_MOPG_BK0_BASE + 0x2B)
#define REG_DISP_MOPG_BK0_16_L     (REG_DISP_MOPG_BK0_BASE + 0x2C)
#define REG_DISP_MOPG_BK0_16_H     (REG_DISP_MOPG_BK0_BASE + 0x2D)
#define REG_DISP_MOPG_BK0_17_L     (REG_DISP_MOPG_BK0_BASE + 0x2E)
#define REG_DISP_MOPG_BK0_17_H     (REG_DISP_MOPG_BK0_BASE + 0x2F)
#define REG_DISP_MOPG_BK0_18_L     (REG_DISP_MOPG_BK0_BASE + 0x30)
#define REG_DISP_MOPG_BK0_18_H     (REG_DISP_MOPG_BK0_BASE + 0x31)
#define REG_DISP_MOPG_BK0_19_L     (REG_DISP_MOPG_BK0_BASE + 0x32)
#define REG_DISP_MOPG_BK0_19_H     (REG_DISP_MOPG_BK0_BASE + 0x33)
#define REG_DISP_MOPG_BK0_1A_L     (REG_DISP_MOPG_BK0_BASE + 0x34)
#define REG_DISP_MOPG_BK0_1A_H     (REG_DISP_MOPG_BK0_BASE + 0x35)
#define REG_DISP_MOPG_BK0_1B_L     (REG_DISP_MOPG_BK0_BASE + 0x36)
#define REG_DISP_MOPG_BK0_1B_H     (REG_DISP_MOPG_BK0_BASE + 0x37)
#define REG_DISP_MOPG_BK0_1C_L     (REG_DISP_MOPG_BK0_BASE + 0x38)
#define REG_DISP_MOPG_BK0_1C_H     (REG_DISP_MOPG_BK0_BASE + 0x39)
#define REG_DISP_MOPG_BK0_1D_L     (REG_DISP_MOPG_BK0_BASE + 0x3A)
#define REG_DISP_MOPG_BK0_1D_H     (REG_DISP_MOPG_BK0_BASE + 0x3B)
#define REG_DISP_MOPG_BK0_1E_L     (REG_DISP_MOPG_BK0_BASE + 0x3C)
#define REG_DISP_MOPG_BK0_1E_H     (REG_DISP_MOPG_BK0_BASE + 0x3D)
#define REG_DISP_MOPG_BK0_1F_L     (REG_DISP_MOPG_BK0_BASE + 0x3E)
#define REG_DISP_MOPG_BK0_1F_H     (REG_DISP_MOPG_BK0_BASE + 0x3F)
#define REG_DISP_MOPG_BK0_20_L     (REG_DISP_MOPG_BK0_BASE + 0x40)
#define REG_DISP_MOPG_BK0_20_H     (REG_DISP_MOPG_BK0_BASE + 0x41)
#define REG_DISP_MOPG_BK0_21_L     (REG_DISP_MOPG_BK0_BASE + 0x42)
#define REG_DISP_MOPG_BK0_21_H     (REG_DISP_MOPG_BK0_BASE + 0x43)
#define REG_DISP_MOPG_BK0_22_L     (REG_DISP_MOPG_BK0_BASE + 0x44)
#define REG_DISP_MOPG_BK0_22_H     (REG_DISP_MOPG_BK0_BASE + 0x45)
#define REG_DISP_MOPG_BK0_23_L     (REG_DISP_MOPG_BK0_BASE + 0x46)
#define REG_DISP_MOPG_BK0_23_H     (REG_DISP_MOPG_BK0_BASE + 0x47)
#define REG_DISP_MOPG_BK0_24_L     (REG_DISP_MOPG_BK0_BASE + 0x48)
#define REG_DISP_MOPG_BK0_24_H     (REG_DISP_MOPG_BK0_BASE + 0x49)
#define REG_DISP_MOPG_BK0_25_L     (REG_DISP_MOPG_BK0_BASE + 0x4A)
#define REG_DISP_MOPG_BK0_25_H     (REG_DISP_MOPG_BK0_BASE + 0x4B)
#define REG_DISP_MOPG_BK0_26_L     (REG_DISP_MOPG_BK0_BASE + 0x4C)
#define REG_DISP_MOPG_BK0_26_H     (REG_DISP_MOPG_BK0_BASE + 0x4D)
#define REG_DISP_MOPG_BK0_27_L     (REG_DISP_MOPG_BK0_BASE + 0x4E)
#define REG_DISP_MOPG_BK0_27_H     (REG_DISP_MOPG_BK0_BASE + 0x4F)
#define REG_DISP_MOPG_BK0_28_L     (REG_DISP_MOPG_BK0_BASE + 0x50)
#define REG_DISP_MOPG_BK0_28_H     (REG_DISP_MOPG_BK0_BASE + 0x51)
#define REG_DISP_MOPG_BK0_29_L     (REG_DISP_MOPG_BK0_BASE + 0x52)
#define REG_DISP_MOPG_BK0_29_H     (REG_DISP_MOPG_BK0_BASE + 0x53)
#define REG_DISP_MOPG_BK0_2A_L     (REG_DISP_MOPG_BK0_BASE + 0x54)
#define REG_DISP_MOPG_BK0_2A_H     (REG_DISP_MOPG_BK0_BASE + 0x55)
#define REG_DISP_MOPG_BK0_2B_L     (REG_DISP_MOPG_BK0_BASE + 0x56)
#define REG_DISP_MOPG_BK0_2B_H     (REG_DISP_MOPG_BK0_BASE + 0x57)
#define REG_DISP_MOPG_BK0_2C_L     (REG_DISP_MOPG_BK0_BASE + 0x58)
#define REG_DISP_MOPG_BK0_2C_H     (REG_DISP_MOPG_BK0_BASE + 0x59)
#define REG_DISP_MOPG_BK0_2D_L     (REG_DISP_MOPG_BK0_BASE + 0x5A)
#define REG_DISP_MOPG_BK0_2D_H     (REG_DISP_MOPG_BK0_BASE + 0x5B)
#define REG_DISP_MOPG_BK0_2E_L     (REG_DISP_MOPG_BK0_BASE + 0x5C)
#define REG_DISP_MOPG_BK0_2E_H     (REG_DISP_MOPG_BK0_BASE + 0x5D)
#define REG_DISP_MOPG_BK0_2F_L     (REG_DISP_MOPG_BK0_BASE + 0x5E)
#define REG_DISP_MOPG_BK0_2F_H     (REG_DISP_MOPG_BK0_BASE + 0x5F)
#define REG_DISP_MOPG_BK0_30_L     (REG_DISP_MOPG_BK0_BASE + 0x60)
#define REG_DISP_MOPG_BK0_30_H     (REG_DISP_MOPG_BK0_BASE + 0x61)
#define REG_DISP_MOPG_BK0_31_L     (REG_DISP_MOPG_BK0_BASE + 0x62)
#define REG_DISP_MOPG_BK0_31_H     (REG_DISP_MOPG_BK0_BASE + 0x63)
#define REG_DISP_MOPG_BK0_32_L     (REG_DISP_MOPG_BK0_BASE + 0x64)
#define REG_DISP_MOPG_BK0_32_H     (REG_DISP_MOPG_BK0_BASE + 0x65)
#define REG_DISP_MOPG_BK0_33_L     (REG_DISP_MOPG_BK0_BASE + 0x66)
#define REG_DISP_MOPG_BK0_33_H     (REG_DISP_MOPG_BK0_BASE + 0x67)
#define REG_DISP_MOPG_BK0_34_L     (REG_DISP_MOPG_BK0_BASE + 0x68)
#define REG_DISP_MOPG_BK0_34_H     (REG_DISP_MOPG_BK0_BASE + 0x69)
#define REG_DISP_MOPG_BK0_35_L     (REG_DISP_MOPG_BK0_BASE + 0x6A)
#define REG_DISP_MOPG_BK0_35_H     (REG_DISP_MOPG_BK0_BASE + 0x6B)
#define REG_DISP_MOPG_BK0_36_L     (REG_DISP_MOPG_BK0_BASE + 0x6C)
#define REG_DISP_MOPG_BK0_36_H     (REG_DISP_MOPG_BK0_BASE + 0x6D)
#define REG_DISP_MOPG_BK0_37_L     (REG_DISP_MOPG_BK0_BASE + 0x6E)
#define REG_DISP_MOPG_BK0_37_H     (REG_DISP_MOPG_BK0_BASE + 0x6F)
#define REG_DISP_MOPG_BK0_38_L     (REG_DISP_MOPG_BK0_BASE + 0x70)
#define REG_DISP_MOPG_BK0_38_H     (REG_DISP_MOPG_BK0_BASE + 0x71)
#define REG_DISP_MOPG_BK0_39_L     (REG_DISP_MOPG_BK0_BASE + 0x72)
#define REG_DISP_MOPG_BK0_39_H     (REG_DISP_MOPG_BK0_BASE + 0x73)
#define REG_DISP_MOPG_BK0_3A_L     (REG_DISP_MOPG_BK0_BASE + 0x74)
#define REG_DISP_MOPG_BK0_3A_H     (REG_DISP_MOPG_BK0_BASE + 0x75)
#define REG_DISP_MOPG_BK0_3B_L     (REG_DISP_MOPG_BK0_BASE + 0x76)
#define REG_DISP_MOPG_BK0_3B_H     (REG_DISP_MOPG_BK0_BASE + 0x77)
#define REG_DISP_MOPG_BK0_3C_L     (REG_DISP_MOPG_BK0_BASE + 0x78)
#define REG_DISP_MOPG_BK0_3C_H     (REG_DISP_MOPG_BK0_BASE + 0x79)
#define REG_DISP_MOPG_BK0_3D_L     (REG_DISP_MOPG_BK0_BASE + 0x7A)
#define REG_DISP_MOPG_BK0_3D_H     (REG_DISP_MOPG_BK0_BASE + 0x7B)
#define REG_DISP_MOPG_BK0_3E_L     (REG_DISP_MOPG_BK0_BASE + 0x7C)
#define REG_DISP_MOPG_BK0_3E_H     (REG_DISP_MOPG_BK0_BASE + 0x7D)
#define REG_DISP_MOPG_BK0_3F_L     (REG_DISP_MOPG_BK0_BASE + 0x7E)
#define REG_DISP_MOPG_BK0_3F_H     (REG_DISP_MOPG_BK0_BASE + 0x7F)
#define REG_DISP_MOPG_BK0_40_L     (REG_DISP_MOPG_BK0_BASE + 0x80)
#define REG_DISP_MOPG_BK0_40_H     (REG_DISP_MOPG_BK0_BASE + 0x81)
#define REG_DISP_MOPG_BK0_41_L     (REG_DISP_MOPG_BK0_BASE + 0x82)
#define REG_DISP_MOPG_BK0_41_H     (REG_DISP_MOPG_BK0_BASE + 0x83)
#define REG_DISP_MOPG_BK0_42_L     (REG_DISP_MOPG_BK0_BASE + 0x84)
#define REG_DISP_MOPG_BK0_42_H     (REG_DISP_MOPG_BK0_BASE + 0x85)
#define REG_DISP_MOPG_BK0_43_L     (REG_DISP_MOPG_BK0_BASE + 0x86)
#define REG_DISP_MOPG_BK0_43_H     (REG_DISP_MOPG_BK0_BASE + 0x87)
#define REG_DISP_MOPG_BK0_44_L     (REG_DISP_MOPG_BK0_BASE + 0x88)
#define REG_DISP_MOPG_BK0_44_H     (REG_DISP_MOPG_BK0_BASE + 0x89)
#define REG_DISP_MOPG_BK0_45_L     (REG_DISP_MOPG_BK0_BASE + 0x8A)
#define REG_DISP_MOPG_BK0_45_H     (REG_DISP_MOPG_BK0_BASE + 0x8B)
#define REG_DISP_MOPG_BK0_46_L     (REG_DISP_MOPG_BK0_BASE + 0x8C)
#define REG_DISP_MOPG_BK0_46_H     (REG_DISP_MOPG_BK0_BASE + 0x8D)
#define REG_DISP_MOPG_BK0_47_L     (REG_DISP_MOPG_BK0_BASE + 0x8E)
#define REG_DISP_MOPG_BK0_47_H     (REG_DISP_MOPG_BK0_BASE + 0x8F)
#define REG_DISP_MOPG_BK0_48_L     (REG_DISP_MOPG_BK0_BASE + 0x90)
#define REG_DISP_MOPG_BK0_48_H     (REG_DISP_MOPG_BK0_BASE + 0x91)
#define REG_DISP_MOPG_BK0_49_L     (REG_DISP_MOPG_BK0_BASE + 0x92)
#define REG_DISP_MOPG_BK0_49_H     (REG_DISP_MOPG_BK0_BASE + 0x93)
#define REG_DISP_MOPG_BK0_4A_L     (REG_DISP_MOPG_BK0_BASE + 0x94)
#define REG_DISP_MOPG_BK0_4A_H     (REG_DISP_MOPG_BK0_BASE + 0x95)
#define REG_DISP_MOPG_BK0_4B_L     (REG_DISP_MOPG_BK0_BASE + 0x96)
#define REG_DISP_MOPG_BK0_4B_H     (REG_DISP_MOPG_BK0_BASE + 0x97)
#define REG_DISP_MOPG_BK0_4C_L     (REG_DISP_MOPG_BK0_BASE + 0x98)
#define REG_DISP_MOPG_BK0_4C_H     (REG_DISP_MOPG_BK0_BASE + 0x99)
#define REG_DISP_MOPG_BK0_4D_L     (REG_DISP_MOPG_BK0_BASE + 0x9A)
#define REG_DISP_MOPG_BK0_4D_H     (REG_DISP_MOPG_BK0_BASE + 0x9B)
#define REG_DISP_MOPG_BK0_4E_L     (REG_DISP_MOPG_BK0_BASE + 0x9C)
#define REG_DISP_MOPG_BK0_4E_H     (REG_DISP_MOPG_BK0_BASE + 0x9D)
#define REG_DISP_MOPG_BK0_4F_L     (REG_DISP_MOPG_BK0_BASE + 0x9E)
#define REG_DISP_MOPG_BK0_4F_H     (REG_DISP_MOPG_BK0_BASE + 0x9F)
#define REG_DISP_MOPG_BK0_50_L     (REG_DISP_MOPG_BK0_BASE + 0xA0)
#define REG_DISP_MOPG_BK0_50_H     (REG_DISP_MOPG_BK0_BASE + 0xA1)
#define REG_DISP_MOPG_BK0_51_L     (REG_DISP_MOPG_BK0_BASE + 0xA2)
#define REG_DISP_MOPG_BK0_51_H     (REG_DISP_MOPG_BK0_BASE + 0xA3)
#define REG_DISP_MOPG_BK0_52_L     (REG_DISP_MOPG_BK0_BASE + 0xA4)
#define REG_DISP_MOPG_BK0_52_H     (REG_DISP_MOPG_BK0_BASE + 0xA5)
#define REG_DISP_MOPG_BK0_53_L     (REG_DISP_MOPG_BK0_BASE + 0xA6)
#define REG_DISP_MOPG_BK0_53_H     (REG_DISP_MOPG_BK0_BASE + 0xA7)
#define REG_DISP_MOPG_BK0_54_L     (REG_DISP_MOPG_BK0_BASE + 0xA8)
#define REG_DISP_MOPG_BK0_54_H     (REG_DISP_MOPG_BK0_BASE + 0xA9)
#define REG_DISP_MOPG_BK0_55_L     (REG_DISP_MOPG_BK0_BASE + 0xAA)
#define REG_DISP_MOPG_BK0_55_H     (REG_DISP_MOPG_BK0_BASE + 0xAB)
#define REG_DISP_MOPG_BK0_56_L     (REG_DISP_MOPG_BK0_BASE + 0xAC)
#define REG_DISP_MOPG_BK0_56_H     (REG_DISP_MOPG_BK0_BASE + 0xAD)
#define REG_DISP_MOPG_BK0_57_L     (REG_DISP_MOPG_BK0_BASE + 0xAE)
#define REG_DISP_MOPG_BK0_57_H     (REG_DISP_MOPG_BK0_BASE + 0xAF)
#define REG_DISP_MOPG_BK0_58_L     (REG_DISP_MOPG_BK0_BASE + 0xB0)
#define REG_DISP_MOPG_BK0_58_H     (REG_DISP_MOPG_BK0_BASE + 0xB1)
#define REG_DISP_MOPG_BK0_59_L     (REG_DISP_MOPG_BK0_BASE + 0xB2)
#define REG_DISP_MOPG_BK0_59_H     (REG_DISP_MOPG_BK0_BASE + 0xB3)
#define REG_DISP_MOPG_BK0_5A_L     (REG_DISP_MOPG_BK0_BASE + 0xB4)
#define REG_DISP_MOPG_BK0_5A_H     (REG_DISP_MOPG_BK0_BASE + 0xB5)
#define REG_DISP_MOPG_BK0_5B_L     (REG_DISP_MOPG_BK0_BASE + 0xB6)
#define REG_DISP_MOPG_BK0_5B_H     (REG_DISP_MOPG_BK0_BASE + 0xB7)
#define REG_DISP_MOPG_BK0_5C_L     (REG_DISP_MOPG_BK0_BASE + 0xB8)
#define REG_DISP_MOPG_BK0_5C_H     (REG_DISP_MOPG_BK0_BASE + 0xB9)
#define REG_DISP_MOPG_BK0_5D_L     (REG_DISP_MOPG_BK0_BASE + 0xBA)
#define REG_DISP_MOPG_BK0_5D_H     (REG_DISP_MOPG_BK0_BASE + 0xBB)
#define REG_DISP_MOPG_BK0_5E_L     (REG_DISP_MOPG_BK0_BASE + 0xBC)
#define REG_DISP_MOPG_BK0_5E_H     (REG_DISP_MOPG_BK0_BASE + 0xBD)
#define REG_DISP_MOPG_BK0_5F_L     (REG_DISP_MOPG_BK0_BASE + 0xBE)
#define REG_DISP_MOPG_BK0_5F_H     (REG_DISP_MOPG_BK0_BASE + 0xBF)
#define REG_DISP_MOPG_BK0_60_L     (REG_DISP_MOPG_BK0_BASE + 0xC0)
#define REG_DISP_MOPG_BK0_60_H     (REG_DISP_MOPG_BK0_BASE + 0xC1)
#define REG_DISP_MOPG_BK0_61_L     (REG_DISP_MOPG_BK0_BASE + 0xC2)
#define REG_DISP_MOPG_BK0_61_H     (REG_DISP_MOPG_BK0_BASE + 0xC3)
#define REG_DISP_MOPG_BK0_62_L     (REG_DISP_MOPG_BK0_BASE + 0xC4)
#define REG_DISP_MOPG_BK0_62_H     (REG_DISP_MOPG_BK0_BASE + 0xC5)
#define REG_DISP_MOPG_BK0_63_L     (REG_DISP_MOPG_BK0_BASE + 0xC6)
#define REG_DISP_MOPG_BK0_63_H     (REG_DISP_MOPG_BK0_BASE + 0xC7)
#define REG_DISP_MOPG_BK0_64_L     (REG_DISP_MOPG_BK0_BASE + 0xC8)
#define REG_DISP_MOPG_BK0_64_H     (REG_DISP_MOPG_BK0_BASE + 0xC9)
#define REG_DISP_MOPG_BK0_65_L     (REG_DISP_MOPG_BK0_BASE + 0xCA)
#define REG_DISP_MOPG_BK0_65_H     (REG_DISP_MOPG_BK0_BASE + 0xCB)
#define REG_DISP_MOPG_BK0_66_L     (REG_DISP_MOPG_BK0_BASE + 0xCC)
#define REG_DISP_MOPG_BK0_66_H     (REG_DISP_MOPG_BK0_BASE + 0xCD)
#define REG_DISP_MOPG_BK0_67_L     (REG_DISP_MOPG_BK0_BASE + 0xCE)
#define REG_DISP_MOPG_BK0_67_H     (REG_DISP_MOPG_BK0_BASE + 0xCF)
#define REG_DISP_MOPG_BK0_68_L     (REG_DISP_MOPG_BK0_BASE + 0xD0)
#define REG_DISP_MOPG_BK0_68_H     (REG_DISP_MOPG_BK0_BASE + 0xD1)
#define REG_DISP_MOPG_BK0_69_L     (REG_DISP_MOPG_BK0_BASE + 0xD2)
#define REG_DISP_MOPG_BK0_69_H     (REG_DISP_MOPG_BK0_BASE + 0xD3)
#define REG_DISP_MOPG_BK0_6A_L     (REG_DISP_MOPG_BK0_BASE + 0xD4)
#define REG_DISP_MOPG_BK0_6A_H     (REG_DISP_MOPG_BK0_BASE + 0xD5)
#define REG_DISP_MOPG_BK0_6B_L     (REG_DISP_MOPG_BK0_BASE + 0xD6)
#define REG_DISP_MOPG_BK0_6B_H     (REG_DISP_MOPG_BK0_BASE + 0xD7)
#define REG_DISP_MOPG_BK0_6C_L     (REG_DISP_MOPG_BK0_BASE + 0xD8)
#define REG_DISP_MOPG_BK0_6C_H     (REG_DISP_MOPG_BK0_BASE + 0xD9)
#define REG_DISP_MOPG_BK0_6D_L     (REG_DISP_MOPG_BK0_BASE + 0xDA)
#define REG_DISP_MOPG_BK0_6D_H     (REG_DISP_MOPG_BK0_BASE + 0xDB)
#define REG_DISP_MOPG_BK0_6E_L     (REG_DISP_MOPG_BK0_BASE + 0xDC)
#define REG_DISP_MOPG_BK0_6E_H     (REG_DISP_MOPG_BK0_BASE + 0xDD)
#define REG_DISP_MOPG_BK0_6F_L     (REG_DISP_MOPG_BK0_BASE + 0xDE)
#define REG_DISP_MOPG_BK0_6F_H     (REG_DISP_MOPG_BK0_BASE + 0xDF)
#define REG_DISP_MOPG_BK0_70_L     (REG_DISP_MOPG_BK0_BASE + 0xE0)
#define REG_DISP_MOPG_BK0_70_H     (REG_DISP_MOPG_BK0_BASE + 0xE1)
#define REG_DISP_MOPG_BK0_71_L     (REG_DISP_MOPG_BK0_BASE + 0xE2)
#define REG_DISP_MOPG_BK0_71_H     (REG_DISP_MOPG_BK0_BASE + 0xE3)
#define REG_DISP_MOPG_BK0_72_L     (REG_DISP_MOPG_BK0_BASE + 0xE4)
#define REG_DISP_MOPG_BK0_72_H     (REG_DISP_MOPG_BK0_BASE + 0xE5)
#define REG_DISP_MOPG_BK0_73_L     (REG_DISP_MOPG_BK0_BASE + 0xE6)
#define REG_DISP_MOPG_BK0_73_H     (REG_DISP_MOPG_BK0_BASE + 0xE7)
#define REG_DISP_MOPG_BK0_74_L     (REG_DISP_MOPG_BK0_BASE + 0xE8)
#define REG_DISP_MOPG_BK0_74_H     (REG_DISP_MOPG_BK0_BASE + 0xE9)
#define REG_DISP_MOPG_BK0_75_L     (REG_DISP_MOPG_BK0_BASE + 0xEA)
#define REG_DISP_MOPG_BK0_75_H     (REG_DISP_MOPG_BK0_BASE + 0xEB)
#define REG_DISP_MOPG_BK0_76_L     (REG_DISP_MOPG_BK0_BASE + 0xEC)
#define REG_DISP_MOPG_BK0_76_H     (REG_DISP_MOPG_BK0_BASE + 0xED)
#define REG_DISP_MOPG_BK0_77_L     (REG_DISP_MOPG_BK0_BASE + 0xEE)
#define REG_DISP_MOPG_BK0_77_H     (REG_DISP_MOPG_BK0_BASE + 0xEF)
#define REG_DISP_MOPG_BK0_78_L     (REG_DISP_MOPG_BK0_BASE + 0xF0)
#define REG_DISP_MOPG_BK0_78_H     (REG_DISP_MOPG_BK0_BASE + 0xF1)
#define REG_DISP_MOPG_BK0_79_L     (REG_DISP_MOPG_BK0_BASE + 0xF2)
#define REG_DISP_MOPG_BK0_79_H     (REG_DISP_MOPG_BK0_BASE + 0xF3)
#define REG_DISP_MOPG_BK0_7A_L     (REG_DISP_MOPG_BK0_BASE + 0xF4)
#define REG_DISP_MOPG_BK0_7A_H     (REG_DISP_MOPG_BK0_BASE + 0xF5)
#define REG_DISP_MOPG_BK0_7B_L     (REG_DISP_MOPG_BK0_BASE + 0xF6)
#define REG_DISP_MOPG_BK0_7B_H     (REG_DISP_MOPG_BK0_BASE + 0xF7)
#define REG_DISP_MOPG_BK0_7C_L     (REG_DISP_MOPG_BK0_BASE + 0xF8)
#define REG_DISP_MOPG_BK0_7C_H     (REG_DISP_MOPG_BK0_BASE + 0xF9)
#define REG_DISP_MOPG_BK0_7D_L     (REG_DISP_MOPG_BK0_BASE + 0xFA)
#define REG_DISP_MOPG_BK0_7D_H     (REG_DISP_MOPG_BK0_BASE + 0xFB)
#define REG_DISP_MOPG_BK0_7E_L     (REG_DISP_MOPG_BK0_BASE + 0xFC)
#define REG_DISP_MOPG_BK0_7E_H     (REG_DISP_MOPG_BK0_BASE + 0xFD)
#define REG_DISP_MOPG_BK0_7F_L     (REG_DISP_MOPG_BK0_BASE + 0xFE)
#define REG_DISP_MOPG_BK0_7F_H     (REG_DISP_MOPG_BK0_BASE + 0xFF)

#define REG_DISP_MOPG_BK1_00_L     (REG_DISP_MOPG_BK1_BASE + 0x00)
#define REG_DISP_MOPG_BK1_00_H     (REG_DISP_MOPG_BK1_BASE + 0x01)
#define REG_DISP_MOPG_BK1_01_L     (REG_DISP_MOPG_BK1_BASE + 0x02)
#define REG_DISP_MOPG_BK1_01_H     (REG_DISP_MOPG_BK1_BASE + 0x03)
#define REG_DISP_MOPG_BK1_02_L     (REG_DISP_MOPG_BK1_BASE + 0x04)
#define REG_DISP_MOPG_BK1_02_H     (REG_DISP_MOPG_BK1_BASE + 0x05)
#define REG_DISP_MOPG_BK1_03_L     (REG_DISP_MOPG_BK1_BASE + 0x06)
#define REG_DISP_MOPG_BK1_03_H     (REG_DISP_MOPG_BK1_BASE + 0x07)
#define REG_DISP_MOPG_BK1_04_L     (REG_DISP_MOPG_BK1_BASE + 0x08)
#define REG_DISP_MOPG_BK1_04_H     (REG_DISP_MOPG_BK1_BASE + 0x09)
#define REG_DISP_MOPG_BK1_05_L     (REG_DISP_MOPG_BK1_BASE + 0x0A)
#define REG_DISP_MOPG_BK1_05_H     (REG_DISP_MOPG_BK1_BASE + 0x0B)
#define REG_DISP_MOPG_BK1_06_L     (REG_DISP_MOPG_BK1_BASE + 0x0C)
#define REG_DISP_MOPG_BK1_06_H     (REG_DISP_MOPG_BK1_BASE + 0x0D)
#define REG_DISP_MOPG_BK1_07_L     (REG_DISP_MOPG_BK1_BASE + 0x0E)
#define REG_DISP_MOPG_BK1_07_H     (REG_DISP_MOPG_BK1_BASE + 0x0F)
#define REG_DISP_MOPG_BK1_08_L     (REG_DISP_MOPG_BK1_BASE + 0x10)
#define REG_DISP_MOPG_BK1_08_H     (REG_DISP_MOPG_BK1_BASE + 0x11)
#define REG_DISP_MOPG_BK1_09_L     (REG_DISP_MOPG_BK1_BASE + 0x12)
#define REG_DISP_MOPG_BK1_09_H     (REG_DISP_MOPG_BK1_BASE + 0x13)
#define REG_DISP_MOPG_BK1_0A_L     (REG_DISP_MOPG_BK1_BASE + 0x14)
#define REG_DISP_MOPG_BK1_0A_H     (REG_DISP_MOPG_BK1_BASE + 0x15)
#define REG_DISP_MOPG_BK1_0B_L     (REG_DISP_MOPG_BK1_BASE + 0x16)
#define REG_DISP_MOPG_BK1_0B_H     (REG_DISP_MOPG_BK1_BASE + 0x17)
#define REG_DISP_MOPG_BK1_0C_L     (REG_DISP_MOPG_BK1_BASE + 0x18)
#define REG_DISP_MOPG_BK1_0C_H     (REG_DISP_MOPG_BK1_BASE + 0x19)
#define REG_DISP_MOPG_BK1_0D_L     (REG_DISP_MOPG_BK1_BASE + 0x1A)
#define REG_DISP_MOPG_BK1_0D_H     (REG_DISP_MOPG_BK1_BASE + 0x1B)
#define REG_DISP_MOPG_BK1_0E_L     (REG_DISP_MOPG_BK1_BASE + 0x1C)
#define REG_DISP_MOPG_BK1_0E_H     (REG_DISP_MOPG_BK1_BASE + 0x1D)
#define REG_DISP_MOPG_BK1_0F_L     (REG_DISP_MOPG_BK1_BASE + 0x1E)
#define REG_DISP_MOPG_BK1_0F_H     (REG_DISP_MOPG_BK1_BASE + 0x1F)
#define REG_DISP_MOPG_BK1_10_L     (REG_DISP_MOPG_BK1_BASE + 0x20)
#define REG_DISP_MOPG_BK1_10_H     (REG_DISP_MOPG_BK1_BASE + 0x21)
#define REG_DISP_MOPG_BK1_11_L     (REG_DISP_MOPG_BK1_BASE + 0x22)
#define REG_DISP_MOPG_BK1_11_H     (REG_DISP_MOPG_BK1_BASE + 0x23)
#define REG_DISP_MOPG_BK1_12_L     (REG_DISP_MOPG_BK1_BASE + 0x24)
#define REG_DISP_MOPG_BK1_12_H     (REG_DISP_MOPG_BK1_BASE + 0x25)
#define REG_DISP_MOPG_BK1_13_L     (REG_DISP_MOPG_BK1_BASE + 0x26)
#define REG_DISP_MOPG_BK1_13_H     (REG_DISP_MOPG_BK1_BASE + 0x27)
#define REG_DISP_MOPG_BK1_14_L     (REG_DISP_MOPG_BK1_BASE + 0x28)
#define REG_DISP_MOPG_BK1_14_H     (REG_DISP_MOPG_BK1_BASE + 0x29)
#define REG_DISP_MOPG_BK1_15_L     (REG_DISP_MOPG_BK1_BASE + 0x2A)
#define REG_DISP_MOPG_BK1_15_H     (REG_DISP_MOPG_BK1_BASE + 0x2B)
#define REG_DISP_MOPG_BK1_16_L     (REG_DISP_MOPG_BK1_BASE + 0x2C)
#define REG_DISP_MOPG_BK1_16_H     (REG_DISP_MOPG_BK1_BASE + 0x2D)
#define REG_DISP_MOPG_BK1_17_L     (REG_DISP_MOPG_BK1_BASE + 0x2E)
#define REG_DISP_MOPG_BK1_17_H     (REG_DISP_MOPG_BK1_BASE + 0x2F)
#define REG_DISP_MOPG_BK1_18_L     (REG_DISP_MOPG_BK1_BASE + 0x30)
#define REG_DISP_MOPG_BK1_18_H     (REG_DISP_MOPG_BK1_BASE + 0x31)
#define REG_DISP_MOPG_BK1_19_L     (REG_DISP_MOPG_BK1_BASE + 0x32)
#define REG_DISP_MOPG_BK1_19_H     (REG_DISP_MOPG_BK1_BASE + 0x33)
#define REG_DISP_MOPG_BK1_1A_L     (REG_DISP_MOPG_BK1_BASE + 0x34)
#define REG_DISP_MOPG_BK1_1A_H     (REG_DISP_MOPG_BK1_BASE + 0x35)
#define REG_DISP_MOPG_BK1_1B_L     (REG_DISP_MOPG_BK1_BASE + 0x36)
#define REG_DISP_MOPG_BK1_1B_H     (REG_DISP_MOPG_BK1_BASE + 0x37)
#define REG_DISP_MOPG_BK1_1C_L     (REG_DISP_MOPG_BK1_BASE + 0x38)
#define REG_DISP_MOPG_BK1_1C_H     (REG_DISP_MOPG_BK1_BASE + 0x39)
#define REG_DISP_MOPG_BK1_1D_L     (REG_DISP_MOPG_BK1_BASE + 0x3A)
#define REG_DISP_MOPG_BK1_1D_H     (REG_DISP_MOPG_BK1_BASE + 0x3B)
#define REG_DISP_MOPG_BK1_1E_L     (REG_DISP_MOPG_BK1_BASE + 0x3C)
#define REG_DISP_MOPG_BK1_1E_H     (REG_DISP_MOPG_BK1_BASE + 0x3D)
#define REG_DISP_MOPG_BK1_1F_L     (REG_DISP_MOPG_BK1_BASE + 0x3E)
#define REG_DISP_MOPG_BK1_1F_H     (REG_DISP_MOPG_BK1_BASE + 0x3F)
#define REG_DISP_MOPG_BK1_20_L     (REG_DISP_MOPG_BK1_BASE + 0x40)
#define REG_DISP_MOPG_BK1_20_H     (REG_DISP_MOPG_BK1_BASE + 0x41)
#define REG_DISP_MOPG_BK1_21_L     (REG_DISP_MOPG_BK1_BASE + 0x42)
#define REG_DISP_MOPG_BK1_21_H     (REG_DISP_MOPG_BK1_BASE + 0x43)
#define REG_DISP_MOPG_BK1_22_L     (REG_DISP_MOPG_BK1_BASE + 0x44)
#define REG_DISP_MOPG_BK1_22_H     (REG_DISP_MOPG_BK1_BASE + 0x45)
#define REG_DISP_MOPG_BK1_23_L     (REG_DISP_MOPG_BK1_BASE + 0x46)
#define REG_DISP_MOPG_BK1_23_H     (REG_DISP_MOPG_BK1_BASE + 0x47)
#define REG_DISP_MOPG_BK1_24_L     (REG_DISP_MOPG_BK1_BASE + 0x48)
#define REG_DISP_MOPG_BK1_24_H     (REG_DISP_MOPG_BK1_BASE + 0x49)
#define REG_DISP_MOPG_BK1_25_L     (REG_DISP_MOPG_BK1_BASE + 0x4A)
#define REG_DISP_MOPG_BK1_25_H     (REG_DISP_MOPG_BK1_BASE + 0x4B)
#define REG_DISP_MOPG_BK1_26_L     (REG_DISP_MOPG_BK1_BASE + 0x4C)
#define REG_DISP_MOPG_BK1_26_H     (REG_DISP_MOPG_BK1_BASE + 0x4D)
#define REG_DISP_MOPG_BK1_27_L     (REG_DISP_MOPG_BK1_BASE + 0x4E)
#define REG_DISP_MOPG_BK1_27_H     (REG_DISP_MOPG_BK1_BASE + 0x4F)
#define REG_DISP_MOPG_BK1_28_L     (REG_DISP_MOPG_BK1_BASE + 0x50)
#define REG_DISP_MOPG_BK1_28_H     (REG_DISP_MOPG_BK1_BASE + 0x51)
#define REG_DISP_MOPG_BK1_29_L     (REG_DISP_MOPG_BK1_BASE + 0x52)
#define REG_DISP_MOPG_BK1_29_H     (REG_DISP_MOPG_BK1_BASE + 0x53)
#define REG_DISP_MOPG_BK1_2A_L     (REG_DISP_MOPG_BK1_BASE + 0x54)
#define REG_DISP_MOPG_BK1_2A_H     (REG_DISP_MOPG_BK1_BASE + 0x55)
#define REG_DISP_MOPG_BK1_2B_L     (REG_DISP_MOPG_BK1_BASE + 0x56)
#define REG_DISP_MOPG_BK1_2B_H     (REG_DISP_MOPG_BK1_BASE + 0x57)
#define REG_DISP_MOPG_BK1_2C_L     (REG_DISP_MOPG_BK1_BASE + 0x58)
#define REG_DISP_MOPG_BK1_2C_H     (REG_DISP_MOPG_BK1_BASE + 0x59)
#define REG_DISP_MOPG_BK1_2D_L     (REG_DISP_MOPG_BK1_BASE + 0x5A)
#define REG_DISP_MOPG_BK1_2D_H     (REG_DISP_MOPG_BK1_BASE + 0x5B)
#define REG_DISP_MOPG_BK1_2E_L     (REG_DISP_MOPG_BK1_BASE + 0x5C)
#define REG_DISP_MOPG_BK1_2E_H     (REG_DISP_MOPG_BK1_BASE + 0x5D)
#define REG_DISP_MOPG_BK1_2F_L     (REG_DISP_MOPG_BK1_BASE + 0x5E)
#define REG_DISP_MOPG_BK1_2F_H     (REG_DISP_MOPG_BK1_BASE + 0x5F)
#define REG_DISP_MOPG_BK1_30_L     (REG_DISP_MOPG_BK1_BASE + 0x60)
#define REG_DISP_MOPG_BK1_30_H     (REG_DISP_MOPG_BK1_BASE + 0x61)
#define REG_DISP_MOPG_BK1_31_L     (REG_DISP_MOPG_BK1_BASE + 0x62)
#define REG_DISP_MOPG_BK1_31_H     (REG_DISP_MOPG_BK1_BASE + 0x63)
#define REG_DISP_MOPG_BK1_32_L     (REG_DISP_MOPG_BK1_BASE + 0x64)
#define REG_DISP_MOPG_BK1_32_H     (REG_DISP_MOPG_BK1_BASE + 0x65)
#define REG_DISP_MOPG_BK1_33_L     (REG_DISP_MOPG_BK1_BASE + 0x66)
#define REG_DISP_MOPG_BK1_33_H     (REG_DISP_MOPG_BK1_BASE + 0x67)
#define REG_DISP_MOPG_BK1_34_L     (REG_DISP_MOPG_BK1_BASE + 0x68)
#define REG_DISP_MOPG_BK1_34_H     (REG_DISP_MOPG_BK1_BASE + 0x69)
#define REG_DISP_MOPG_BK1_35_L     (REG_DISP_MOPG_BK1_BASE + 0x6A)
#define REG_DISP_MOPG_BK1_35_H     (REG_DISP_MOPG_BK1_BASE + 0x6B)
#define REG_DISP_MOPG_BK1_36_L     (REG_DISP_MOPG_BK1_BASE + 0x6C)
#define REG_DISP_MOPG_BK1_36_H     (REG_DISP_MOPG_BK1_BASE + 0x6D)
#define REG_DISP_MOPG_BK1_37_L     (REG_DISP_MOPG_BK1_BASE + 0x6E)
#define REG_DISP_MOPG_BK1_37_H     (REG_DISP_MOPG_BK1_BASE + 0x6F)
#define REG_DISP_MOPG_BK1_38_L     (REG_DISP_MOPG_BK1_BASE + 0x70)
#define REG_DISP_MOPG_BK1_38_H     (REG_DISP_MOPG_BK1_BASE + 0x71)
#define REG_DISP_MOPG_BK1_39_L     (REG_DISP_MOPG_BK1_BASE + 0x72)
#define REG_DISP_MOPG_BK1_39_H     (REG_DISP_MOPG_BK1_BASE + 0x73)
#define REG_DISP_MOPG_BK1_3A_L     (REG_DISP_MOPG_BK1_BASE + 0x74)
#define REG_DISP_MOPG_BK1_3A_H     (REG_DISP_MOPG_BK1_BASE + 0x75)
#define REG_DISP_MOPG_BK1_3B_L     (REG_DISP_MOPG_BK1_BASE + 0x76)
#define REG_DISP_MOPG_BK1_3B_H     (REG_DISP_MOPG_BK1_BASE + 0x77)
#define REG_DISP_MOPG_BK1_3C_L     (REG_DISP_MOPG_BK1_BASE + 0x78)
#define REG_DISP_MOPG_BK1_3C_H     (REG_DISP_MOPG_BK1_BASE + 0x79)
#define REG_DISP_MOPG_BK1_3D_L     (REG_DISP_MOPG_BK1_BASE + 0x7A)
#define REG_DISP_MOPG_BK1_3D_H     (REG_DISP_MOPG_BK1_BASE + 0x7B)
#define REG_DISP_MOPG_BK1_3E_L     (REG_DISP_MOPG_BK1_BASE + 0x7C)
#define REG_DISP_MOPG_BK1_3E_H     (REG_DISP_MOPG_BK1_BASE + 0x7D)
#define REG_DISP_MOPG_BK1_3F_L     (REG_DISP_MOPG_BK1_BASE + 0x7E)
#define REG_DISP_MOPG_BK1_3F_H     (REG_DISP_MOPG_BK1_BASE + 0x7F)
#define REG_DISP_MOPG_BK1_40_L     (REG_DISP_MOPG_BK1_BASE + 0x80)
#define REG_DISP_MOPG_BK1_40_H     (REG_DISP_MOPG_BK1_BASE + 0x81)
#define REG_DISP_MOPG_BK1_41_L     (REG_DISP_MOPG_BK1_BASE + 0x82)
#define REG_DISP_MOPG_BK1_41_H     (REG_DISP_MOPG_BK1_BASE + 0x83)
#define REG_DISP_MOPG_BK1_42_L     (REG_DISP_MOPG_BK1_BASE + 0x84)
#define REG_DISP_MOPG_BK1_42_H     (REG_DISP_MOPG_BK1_BASE + 0x85)
#define REG_DISP_MOPG_BK1_43_L     (REG_DISP_MOPG_BK1_BASE + 0x86)
#define REG_DISP_MOPG_BK1_43_H     (REG_DISP_MOPG_BK1_BASE + 0x87)
#define REG_DISP_MOPG_BK1_44_L     (REG_DISP_MOPG_BK1_BASE + 0x88)
#define REG_DISP_MOPG_BK1_44_H     (REG_DISP_MOPG_BK1_BASE + 0x89)
#define REG_DISP_MOPG_BK1_45_L     (REG_DISP_MOPG_BK1_BASE + 0x8A)
#define REG_DISP_MOPG_BK1_45_H     (REG_DISP_MOPG_BK1_BASE + 0x8B)
#define REG_DISP_MOPG_BK1_46_L     (REG_DISP_MOPG_BK1_BASE + 0x8C)
#define REG_DISP_MOPG_BK1_46_H     (REG_DISP_MOPG_BK1_BASE + 0x8D)
#define REG_DISP_MOPG_BK1_47_L     (REG_DISP_MOPG_BK1_BASE + 0x8E)
#define REG_DISP_MOPG_BK1_47_H     (REG_DISP_MOPG_BK1_BASE + 0x8F)
#define REG_DISP_MOPG_BK1_48_L     (REG_DISP_MOPG_BK1_BASE + 0x90)
#define REG_DISP_MOPG_BK1_48_H     (REG_DISP_MOPG_BK1_BASE + 0x91)
#define REG_DISP_MOPG_BK1_49_L     (REG_DISP_MOPG_BK1_BASE + 0x92)
#define REG_DISP_MOPG_BK1_49_H     (REG_DISP_MOPG_BK1_BASE + 0x93)
#define REG_DISP_MOPG_BK1_4A_L     (REG_DISP_MOPG_BK1_BASE + 0x94)
#define REG_DISP_MOPG_BK1_4A_H     (REG_DISP_MOPG_BK1_BASE + 0x95)
#define REG_DISP_MOPG_BK1_4B_L     (REG_DISP_MOPG_BK1_BASE + 0x96)
#define REG_DISP_MOPG_BK1_4B_H     (REG_DISP_MOPG_BK1_BASE + 0x97)
#define REG_DISP_MOPG_BK1_4C_L     (REG_DISP_MOPG_BK1_BASE + 0x98)
#define REG_DISP_MOPG_BK1_4C_H     (REG_DISP_MOPG_BK1_BASE + 0x99)
#define REG_DISP_MOPG_BK1_4D_L     (REG_DISP_MOPG_BK1_BASE + 0x9A)
#define REG_DISP_MOPG_BK1_4D_H     (REG_DISP_MOPG_BK1_BASE + 0x9B)
#define REG_DISP_MOPG_BK1_4E_L     (REG_DISP_MOPG_BK1_BASE + 0x9C)
#define REG_DISP_MOPG_BK1_4E_H     (REG_DISP_MOPG_BK1_BASE + 0x9D)
#define REG_DISP_MOPG_BK1_4F_L     (REG_DISP_MOPG_BK1_BASE + 0x9E)
#define REG_DISP_MOPG_BK1_4F_H     (REG_DISP_MOPG_BK1_BASE + 0x9F)
#define REG_DISP_MOPG_BK1_50_L     (REG_DISP_MOPG_BK1_BASE + 0xA0)
#define REG_DISP_MOPG_BK1_50_H     (REG_DISP_MOPG_BK1_BASE + 0xA1)
#define REG_DISP_MOPG_BK1_51_L     (REG_DISP_MOPG_BK1_BASE + 0xA2)
#define REG_DISP_MOPG_BK1_51_H     (REG_DISP_MOPG_BK1_BASE + 0xA3)
#define REG_DISP_MOPG_BK1_52_L     (REG_DISP_MOPG_BK1_BASE + 0xA4)
#define REG_DISP_MOPG_BK1_52_H     (REG_DISP_MOPG_BK1_BASE + 0xA5)
#define REG_DISP_MOPG_BK1_53_L     (REG_DISP_MOPG_BK1_BASE + 0xA6)
#define REG_DISP_MOPG_BK1_53_H     (REG_DISP_MOPG_BK1_BASE + 0xA7)
#define REG_DISP_MOPG_BK1_54_L     (REG_DISP_MOPG_BK1_BASE + 0xA8)
#define REG_DISP_MOPG_BK1_54_H     (REG_DISP_MOPG_BK1_BASE + 0xA9)
#define REG_DISP_MOPG_BK1_55_L     (REG_DISP_MOPG_BK1_BASE + 0xAA)
#define REG_DISP_MOPG_BK1_55_H     (REG_DISP_MOPG_BK1_BASE + 0xAB)
#define REG_DISP_MOPG_BK1_56_L     (REG_DISP_MOPG_BK1_BASE + 0xAC)
#define REG_DISP_MOPG_BK1_56_H     (REG_DISP_MOPG_BK1_BASE + 0xAD)
#define REG_DISP_MOPG_BK1_57_L     (REG_DISP_MOPG_BK1_BASE + 0xAE)
#define REG_DISP_MOPG_BK1_57_H     (REG_DISP_MOPG_BK1_BASE + 0xAF)
#define REG_DISP_MOPG_BK1_58_L     (REG_DISP_MOPG_BK1_BASE + 0xB0)
#define REG_DISP_MOPG_BK1_58_H     (REG_DISP_MOPG_BK1_BASE + 0xB1)
#define REG_DISP_MOPG_BK1_59_L     (REG_DISP_MOPG_BK1_BASE + 0xB2)
#define REG_DISP_MOPG_BK1_59_H     (REG_DISP_MOPG_BK1_BASE + 0xB3)
#define REG_DISP_MOPG_BK1_5A_L     (REG_DISP_MOPG_BK1_BASE + 0xB4)
#define REG_DISP_MOPG_BK1_5A_H     (REG_DISP_MOPG_BK1_BASE + 0xB5)
#define REG_DISP_MOPG_BK1_5B_L     (REG_DISP_MOPG_BK1_BASE + 0xB6)
#define REG_DISP_MOPG_BK1_5B_H     (REG_DISP_MOPG_BK1_BASE + 0xB7)
#define REG_DISP_MOPG_BK1_5C_L     (REG_DISP_MOPG_BK1_BASE + 0xB8)
#define REG_DISP_MOPG_BK1_5C_H     (REG_DISP_MOPG_BK1_BASE + 0xB9)
#define REG_DISP_MOPG_BK1_5D_L     (REG_DISP_MOPG_BK1_BASE + 0xBA)
#define REG_DISP_MOPG_BK1_5D_H     (REG_DISP_MOPG_BK1_BASE + 0xBB)
#define REG_DISP_MOPG_BK1_5E_L     (REG_DISP_MOPG_BK1_BASE + 0xBC)
#define REG_DISP_MOPG_BK1_5E_H     (REG_DISP_MOPG_BK1_BASE + 0xBD)
#define REG_DISP_MOPG_BK1_5F_L     (REG_DISP_MOPG_BK1_BASE + 0xBE)
#define REG_DISP_MOPG_BK1_5F_H     (REG_DISP_MOPG_BK1_BASE + 0xBF)
#define REG_DISP_MOPG_BK1_60_L     (REG_DISP_MOPG_BK1_BASE + 0xC0)
#define REG_DISP_MOPG_BK1_60_H     (REG_DISP_MOPG_BK1_BASE + 0xC1)
#define REG_DISP_MOPG_BK1_61_L     (REG_DISP_MOPG_BK1_BASE + 0xC2)
#define REG_DISP_MOPG_BK1_61_H     (REG_DISP_MOPG_BK1_BASE + 0xC3)
#define REG_DISP_MOPG_BK1_62_L     (REG_DISP_MOPG_BK1_BASE + 0xC4)
#define REG_DISP_MOPG_BK1_62_H     (REG_DISP_MOPG_BK1_BASE + 0xC5)
#define REG_DISP_MOPG_BK1_63_L     (REG_DISP_MOPG_BK1_BASE + 0xC6)
#define REG_DISP_MOPG_BK1_63_H     (REG_DISP_MOPG_BK1_BASE + 0xC7)
#define REG_DISP_MOPG_BK1_64_L     (REG_DISP_MOPG_BK1_BASE + 0xC8)
#define REG_DISP_MOPG_BK1_64_H     (REG_DISP_MOPG_BK1_BASE + 0xC9)
#define REG_DISP_MOPG_BK1_65_L     (REG_DISP_MOPG_BK1_BASE + 0xCA)
#define REG_DISP_MOPG_BK1_65_H     (REG_DISP_MOPG_BK1_BASE + 0xCB)
#define REG_DISP_MOPG_BK1_66_L     (REG_DISP_MOPG_BK1_BASE + 0xCC)
#define REG_DISP_MOPG_BK1_66_H     (REG_DISP_MOPG_BK1_BASE + 0xCD)
#define REG_DISP_MOPG_BK1_67_L     (REG_DISP_MOPG_BK1_BASE + 0xCE)
#define REG_DISP_MOPG_BK1_67_H     (REG_DISP_MOPG_BK1_BASE + 0xCF)
#define REG_DISP_MOPG_BK1_68_L     (REG_DISP_MOPG_BK1_BASE + 0xD0)
#define REG_DISP_MOPG_BK1_68_H     (REG_DISP_MOPG_BK1_BASE + 0xD1)
#define REG_DISP_MOPG_BK1_69_L     (REG_DISP_MOPG_BK1_BASE + 0xD2)
#define REG_DISP_MOPG_BK1_69_H     (REG_DISP_MOPG_BK1_BASE + 0xD3)
#define REG_DISP_MOPG_BK1_6A_L     (REG_DISP_MOPG_BK1_BASE + 0xD4)
#define REG_DISP_MOPG_BK1_6A_H     (REG_DISP_MOPG_BK1_BASE + 0xD5)
#define REG_DISP_MOPG_BK1_6B_L     (REG_DISP_MOPG_BK1_BASE + 0xD6)
#define REG_DISP_MOPG_BK1_6B_H     (REG_DISP_MOPG_BK1_BASE + 0xD7)
#define REG_DISP_MOPG_BK1_6C_L     (REG_DISP_MOPG_BK1_BASE + 0xD8)
#define REG_DISP_MOPG_BK1_6C_H     (REG_DISP_MOPG_BK1_BASE + 0xD9)
#define REG_DISP_MOPG_BK1_6D_L     (REG_DISP_MOPG_BK1_BASE + 0xDA)
#define REG_DISP_MOPG_BK1_6D_H     (REG_DISP_MOPG_BK1_BASE + 0xDB)
#define REG_DISP_MOPG_BK1_6E_L     (REG_DISP_MOPG_BK1_BASE + 0xDC)
#define REG_DISP_MOPG_BK1_6E_H     (REG_DISP_MOPG_BK1_BASE + 0xDD)
#define REG_DISP_MOPG_BK1_6F_L     (REG_DISP_MOPG_BK1_BASE + 0xDE)
#define REG_DISP_MOPG_BK1_6F_H     (REG_DISP_MOPG_BK1_BASE + 0xDF)
#define REG_DISP_MOPG_BK1_70_L     (REG_DISP_MOPG_BK1_BASE + 0xE0)
#define REG_DISP_MOPG_BK1_70_H     (REG_DISP_MOPG_BK1_BASE + 0xE1)
#define REG_DISP_MOPG_BK1_71_L     (REG_DISP_MOPG_BK1_BASE + 0xE2)
#define REG_DISP_MOPG_BK1_71_H     (REG_DISP_MOPG_BK1_BASE + 0xE3)
#define REG_DISP_MOPG_BK1_72_L     (REG_DISP_MOPG_BK1_BASE + 0xE4)
#define REG_DISP_MOPG_BK1_72_H     (REG_DISP_MOPG_BK1_BASE + 0xE5)
#define REG_DISP_MOPG_BK1_73_L     (REG_DISP_MOPG_BK1_BASE + 0xE6)
#define REG_DISP_MOPG_BK1_73_H     (REG_DISP_MOPG_BK1_BASE + 0xE7)
#define REG_DISP_MOPG_BK1_74_L     (REG_DISP_MOPG_BK1_BASE + 0xE8)
#define REG_DISP_MOPG_BK1_74_H     (REG_DISP_MOPG_BK1_BASE + 0xE9)
#define REG_DISP_MOPG_BK1_75_L     (REG_DISP_MOPG_BK1_BASE + 0xEA)
#define REG_DISP_MOPG_BK1_75_H     (REG_DISP_MOPG_BK1_BASE + 0xEB)
#define REG_DISP_MOPG_BK1_76_L     (REG_DISP_MOPG_BK1_BASE + 0xEC)
#define REG_DISP_MOPG_BK1_76_H     (REG_DISP_MOPG_BK1_BASE + 0xED)
#define REG_DISP_MOPG_BK1_77_L     (REG_DISP_MOPG_BK1_BASE + 0xEE)
#define REG_DISP_MOPG_BK1_77_H     (REG_DISP_MOPG_BK1_BASE + 0xEF)
#define REG_DISP_MOPG_BK1_78_L     (REG_DISP_MOPG_BK1_BASE + 0xF0)
#define REG_DISP_MOPG_BK1_78_H     (REG_DISP_MOPG_BK1_BASE + 0xF1)
#define REG_DISP_MOPG_BK1_79_L     (REG_DISP_MOPG_BK1_BASE + 0xF2)
#define REG_DISP_MOPG_BK1_79_H     (REG_DISP_MOPG_BK1_BASE + 0xF3)
#define REG_DISP_MOPG_BK1_7A_L     (REG_DISP_MOPG_BK1_BASE + 0xF4)
#define REG_DISP_MOPG_BK1_7A_H     (REG_DISP_MOPG_BK1_BASE + 0xF5)
#define REG_DISP_MOPG_BK1_7B_L     (REG_DISP_MOPG_BK1_BASE + 0xF6)
#define REG_DISP_MOPG_BK1_7B_H     (REG_DISP_MOPG_BK1_BASE + 0xF7)
#define REG_DISP_MOPG_BK1_7C_L     (REG_DISP_MOPG_BK1_BASE + 0xF8)
#define REG_DISP_MOPG_BK1_7C_H     (REG_DISP_MOPG_BK1_BASE + 0xF9)
#define REG_DISP_MOPG_BK1_7D_L     (REG_DISP_MOPG_BK1_BASE + 0xFA)
#define REG_DISP_MOPG_BK1_7D_H     (REG_DISP_MOPG_BK1_BASE + 0xFB)
#define REG_DISP_MOPG_BK1_7E_L     (REG_DISP_MOPG_BK1_BASE + 0xFC)
#define REG_DISP_MOPG_BK1_7E_H     (REG_DISP_MOPG_BK1_BASE + 0xFD)
#define REG_DISP_MOPG_BK1_7F_L     (REG_DISP_MOPG_BK1_BASE + 0xFE)
#define REG_DISP_MOPG_BK1_7F_H     (REG_DISP_MOPG_BK1_BASE + 0xFF)

#define REG_DISP_MOPG_BK2_00_L     (REG_DISP_MOPG_BK2_BASE + 0x00)
#define REG_DISP_MOPG_BK2_00_H     (REG_DISP_MOPG_BK2_BASE + 0x01)
#define REG_DISP_MOPG_BK2_01_L     (REG_DISP_MOPG_BK2_BASE + 0x02)
#define REG_DISP_MOPG_BK2_01_H     (REG_DISP_MOPG_BK2_BASE + 0x03)
#define REG_DISP_MOPG_BK2_02_L     (REG_DISP_MOPG_BK2_BASE + 0x04)
#define REG_DISP_MOPG_BK2_02_H     (REG_DISP_MOPG_BK2_BASE + 0x05)
#define REG_DISP_MOPG_BK2_03_L     (REG_DISP_MOPG_BK2_BASE + 0x06)
#define REG_DISP_MOPG_BK2_03_H     (REG_DISP_MOPG_BK2_BASE + 0x07)
#define REG_DISP_MOPG_BK2_04_L     (REG_DISP_MOPG_BK2_BASE + 0x08)
#define REG_DISP_MOPG_BK2_04_H     (REG_DISP_MOPG_BK2_BASE + 0x09)
#define REG_DISP_MOPG_BK2_05_L     (REG_DISP_MOPG_BK2_BASE + 0x0A)
#define REG_DISP_MOPG_BK2_05_H     (REG_DISP_MOPG_BK2_BASE + 0x0B)
#define REG_DISP_MOPG_BK2_06_L     (REG_DISP_MOPG_BK2_BASE + 0x0C)
#define REG_DISP_MOPG_BK2_06_H     (REG_DISP_MOPG_BK2_BASE + 0x0D)
#define REG_DISP_MOPG_BK2_07_L     (REG_DISP_MOPG_BK2_BASE + 0x0E)
#define REG_DISP_MOPG_BK2_07_H     (REG_DISP_MOPG_BK2_BASE + 0x0F)
#define REG_DISP_MOPG_BK2_08_L     (REG_DISP_MOPG_BK2_BASE + 0x10)
#define REG_DISP_MOPG_BK2_08_H     (REG_DISP_MOPG_BK2_BASE + 0x11)
#define REG_DISP_MOPG_BK2_09_L     (REG_DISP_MOPG_BK2_BASE + 0x12)
#define REG_DISP_MOPG_BK2_09_H     (REG_DISP_MOPG_BK2_BASE + 0x13)
#define REG_DISP_MOPG_BK2_0A_L     (REG_DISP_MOPG_BK2_BASE + 0x14)
#define REG_DISP_MOPG_BK2_0A_H     (REG_DISP_MOPG_BK2_BASE + 0x15)
#define REG_DISP_MOPG_BK2_0B_L     (REG_DISP_MOPG_BK2_BASE + 0x16)
#define REG_DISP_MOPG_BK2_0B_H     (REG_DISP_MOPG_BK2_BASE + 0x17)
#define REG_DISP_MOPG_BK2_0C_L     (REG_DISP_MOPG_BK2_BASE + 0x18)
#define REG_DISP_MOPG_BK2_0C_H     (REG_DISP_MOPG_BK2_BASE + 0x19)
#define REG_DISP_MOPG_BK2_0D_L     (REG_DISP_MOPG_BK2_BASE + 0x1A)
#define REG_DISP_MOPG_BK2_0D_H     (REG_DISP_MOPG_BK2_BASE + 0x1B)
#define REG_DISP_MOPG_BK2_0E_L     (REG_DISP_MOPG_BK2_BASE + 0x1C)
#define REG_DISP_MOPG_BK2_0E_H     (REG_DISP_MOPG_BK2_BASE + 0x1D)
#define REG_DISP_MOPG_BK2_0F_L     (REG_DISP_MOPG_BK2_BASE + 0x1E)
#define REG_DISP_MOPG_BK2_0F_H     (REG_DISP_MOPG_BK2_BASE + 0x1F)
#define REG_DISP_MOPG_BK2_10_L     (REG_DISP_MOPG_BK2_BASE + 0x20)
#define REG_DISP_MOPG_BK2_10_H     (REG_DISP_MOPG_BK2_BASE + 0x21)
#define REG_DISP_MOPG_BK2_11_L     (REG_DISP_MOPG_BK2_BASE + 0x22)
#define REG_DISP_MOPG_BK2_11_H     (REG_DISP_MOPG_BK2_BASE + 0x23)
#define REG_DISP_MOPG_BK2_12_L     (REG_DISP_MOPG_BK2_BASE + 0x24)
#define REG_DISP_MOPG_BK2_12_H     (REG_DISP_MOPG_BK2_BASE + 0x25)
#define REG_DISP_MOPG_BK2_13_L     (REG_DISP_MOPG_BK2_BASE + 0x26)
#define REG_DISP_MOPG_BK2_13_H     (REG_DISP_MOPG_BK2_BASE + 0x27)
#define REG_DISP_MOPG_BK2_14_L     (REG_DISP_MOPG_BK2_BASE + 0x28)
#define REG_DISP_MOPG_BK2_14_H     (REG_DISP_MOPG_BK2_BASE + 0x29)
#define REG_DISP_MOPG_BK2_15_L     (REG_DISP_MOPG_BK2_BASE + 0x2A)
#define REG_DISP_MOPG_BK2_15_H     (REG_DISP_MOPG_BK2_BASE + 0x2B)
#define REG_DISP_MOPG_BK2_16_L     (REG_DISP_MOPG_BK2_BASE + 0x2C)
#define REG_DISP_MOPG_BK2_16_H     (REG_DISP_MOPG_BK2_BASE + 0x2D)
#define REG_DISP_MOPG_BK2_17_L     (REG_DISP_MOPG_BK2_BASE + 0x2E)
#define REG_DISP_MOPG_BK2_17_H     (REG_DISP_MOPG_BK2_BASE + 0x2F)
#define REG_DISP_MOPG_BK2_18_L     (REG_DISP_MOPG_BK2_BASE + 0x30)
#define REG_DISP_MOPG_BK2_18_H     (REG_DISP_MOPG_BK2_BASE + 0x31)
#define REG_DISP_MOPG_BK2_19_L     (REG_DISP_MOPG_BK2_BASE + 0x32)
#define REG_DISP_MOPG_BK2_19_H     (REG_DISP_MOPG_BK2_BASE + 0x33)
#define REG_DISP_MOPG_BK2_1A_L     (REG_DISP_MOPG_BK2_BASE + 0x34)
#define REG_DISP_MOPG_BK2_1A_H     (REG_DISP_MOPG_BK2_BASE + 0x35)
#define REG_DISP_MOPG_BK2_1B_L     (REG_DISP_MOPG_BK2_BASE + 0x36)
#define REG_DISP_MOPG_BK2_1B_H     (REG_DISP_MOPG_BK2_BASE + 0x37)
#define REG_DISP_MOPG_BK2_1C_L     (REG_DISP_MOPG_BK2_BASE + 0x38)
#define REG_DISP_MOPG_BK2_1C_H     (REG_DISP_MOPG_BK2_BASE + 0x39)
#define REG_DISP_MOPG_BK2_1D_L     (REG_DISP_MOPG_BK2_BASE + 0x3A)
#define REG_DISP_MOPG_BK2_1D_H     (REG_DISP_MOPG_BK2_BASE + 0x3B)
#define REG_DISP_MOPG_BK2_1E_L     (REG_DISP_MOPG_BK2_BASE + 0x3C)
#define REG_DISP_MOPG_BK2_1E_H     (REG_DISP_MOPG_BK2_BASE + 0x3D)
#define REG_DISP_MOPG_BK2_1F_L     (REG_DISP_MOPG_BK2_BASE + 0x3E)
#define REG_DISP_MOPG_BK2_1F_H     (REG_DISP_MOPG_BK2_BASE + 0x3F)
#define REG_DISP_MOPG_BK2_20_L     (REG_DISP_MOPG_BK2_BASE + 0x40)
#define REG_DISP_MOPG_BK2_20_H     (REG_DISP_MOPG_BK2_BASE + 0x41)
#define REG_DISP_MOPG_BK2_21_L     (REG_DISP_MOPG_BK2_BASE + 0x42)
#define REG_DISP_MOPG_BK2_21_H     (REG_DISP_MOPG_BK2_BASE + 0x43)
#define REG_DISP_MOPG_BK2_22_L     (REG_DISP_MOPG_BK2_BASE + 0x44)
#define REG_DISP_MOPG_BK2_22_H     (REG_DISP_MOPG_BK2_BASE + 0x45)
#define REG_DISP_MOPG_BK2_23_L     (REG_DISP_MOPG_BK2_BASE + 0x46)
#define REG_DISP_MOPG_BK2_23_H     (REG_DISP_MOPG_BK2_BASE + 0x47)
#define REG_DISP_MOPG_BK2_24_L     (REG_DISP_MOPG_BK2_BASE + 0x48)
#define REG_DISP_MOPG_BK2_24_H     (REG_DISP_MOPG_BK2_BASE + 0x49)
#define REG_DISP_MOPG_BK2_25_L     (REG_DISP_MOPG_BK2_BASE + 0x4A)
#define REG_DISP_MOPG_BK2_25_H     (REG_DISP_MOPG_BK2_BASE + 0x4B)
#define REG_DISP_MOPG_BK2_26_L     (REG_DISP_MOPG_BK2_BASE + 0x4C)
#define REG_DISP_MOPG_BK2_26_H     (REG_DISP_MOPG_BK2_BASE + 0x4D)
#define REG_DISP_MOPG_BK2_27_L     (REG_DISP_MOPG_BK2_BASE + 0x4E)
#define REG_DISP_MOPG_BK2_27_H     (REG_DISP_MOPG_BK2_BASE + 0x4F)
#define REG_DISP_MOPG_BK2_28_L     (REG_DISP_MOPG_BK2_BASE + 0x50)
#define REG_DISP_MOPG_BK2_28_H     (REG_DISP_MOPG_BK2_BASE + 0x51)
#define REG_DISP_MOPG_BK2_29_L     (REG_DISP_MOPG_BK2_BASE + 0x52)
#define REG_DISP_MOPG_BK2_29_H     (REG_DISP_MOPG_BK2_BASE + 0x53)
#define REG_DISP_MOPG_BK2_2A_L     (REG_DISP_MOPG_BK2_BASE + 0x54)
#define REG_DISP_MOPG_BK2_2A_H     (REG_DISP_MOPG_BK2_BASE + 0x55)
#define REG_DISP_MOPG_BK2_2B_L     (REG_DISP_MOPG_BK2_BASE + 0x56)
#define REG_DISP_MOPG_BK2_2B_H     (REG_DISP_MOPG_BK2_BASE + 0x57)
#define REG_DISP_MOPG_BK2_2C_L     (REG_DISP_MOPG_BK2_BASE + 0x58)
#define REG_DISP_MOPG_BK2_2C_H     (REG_DISP_MOPG_BK2_BASE + 0x59)
#define REG_DISP_MOPG_BK2_2D_L     (REG_DISP_MOPG_BK2_BASE + 0x5A)
#define REG_DISP_MOPG_BK2_2D_H     (REG_DISP_MOPG_BK2_BASE + 0x5B)
#define REG_DISP_MOPG_BK2_2E_L     (REG_DISP_MOPG_BK2_BASE + 0x5C)
#define REG_DISP_MOPG_BK2_2E_H     (REG_DISP_MOPG_BK2_BASE + 0x5D)
#define REG_DISP_MOPG_BK2_2F_L     (REG_DISP_MOPG_BK2_BASE + 0x5E)
#define REG_DISP_MOPG_BK2_2F_H     (REG_DISP_MOPG_BK2_BASE + 0x5F)
#define REG_DISP_MOPG_BK2_30_L     (REG_DISP_MOPG_BK2_BASE + 0x60)
#define REG_DISP_MOPG_BK2_30_H     (REG_DISP_MOPG_BK2_BASE + 0x61)
#define REG_DISP_MOPG_BK2_31_L     (REG_DISP_MOPG_BK2_BASE + 0x62)
#define REG_DISP_MOPG_BK2_31_H     (REG_DISP_MOPG_BK2_BASE + 0x63)
#define REG_DISP_MOPG_BK2_32_L     (REG_DISP_MOPG_BK2_BASE + 0x64)
#define REG_DISP_MOPG_BK2_32_H     (REG_DISP_MOPG_BK2_BASE + 0x65)
#define REG_DISP_MOPG_BK2_33_L     (REG_DISP_MOPG_BK2_BASE + 0x66)
#define REG_DISP_MOPG_BK2_33_H     (REG_DISP_MOPG_BK2_BASE + 0x67)
#define REG_DISP_MOPG_BK2_34_L     (REG_DISP_MOPG_BK2_BASE + 0x68)
#define REG_DISP_MOPG_BK2_34_H     (REG_DISP_MOPG_BK2_BASE + 0x69)
#define REG_DISP_MOPG_BK2_35_L     (REG_DISP_MOPG_BK2_BASE + 0x6A)
#define REG_DISP_MOPG_BK2_35_H     (REG_DISP_MOPG_BK2_BASE + 0x6B)
#define REG_DISP_MOPG_BK2_36_L     (REG_DISP_MOPG_BK2_BASE + 0x6C)
#define REG_DISP_MOPG_BK2_36_H     (REG_DISP_MOPG_BK2_BASE + 0x6D)
#define REG_DISP_MOPG_BK2_37_L     (REG_DISP_MOPG_BK2_BASE + 0x6E)
#define REG_DISP_MOPG_BK2_37_H     (REG_DISP_MOPG_BK2_BASE + 0x6F)
#define REG_DISP_MOPG_BK2_38_L     (REG_DISP_MOPG_BK2_BASE + 0x70)
#define REG_DISP_MOPG_BK2_38_H     (REG_DISP_MOPG_BK2_BASE + 0x71)
#define REG_DISP_MOPG_BK2_39_L     (REG_DISP_MOPG_BK2_BASE + 0x72)
#define REG_DISP_MOPG_BK2_39_H     (REG_DISP_MOPG_BK2_BASE + 0x73)
#define REG_DISP_MOPG_BK2_3A_L     (REG_DISP_MOPG_BK2_BASE + 0x74)
#define REG_DISP_MOPG_BK2_3A_H     (REG_DISP_MOPG_BK2_BASE + 0x75)
#define REG_DISP_MOPG_BK2_3B_L     (REG_DISP_MOPG_BK2_BASE + 0x76)
#define REG_DISP_MOPG_BK2_3B_H     (REG_DISP_MOPG_BK2_BASE + 0x77)
#define REG_DISP_MOPG_BK2_3C_L     (REG_DISP_MOPG_BK2_BASE + 0x78)
#define REG_DISP_MOPG_BK2_3C_H     (REG_DISP_MOPG_BK2_BASE + 0x79)
#define REG_DISP_MOPG_BK2_3D_L     (REG_DISP_MOPG_BK2_BASE + 0x7A)
#define REG_DISP_MOPG_BK2_3D_H     (REG_DISP_MOPG_BK2_BASE + 0x7B)
#define REG_DISP_MOPG_BK2_3E_L     (REG_DISP_MOPG_BK2_BASE + 0x7C)
#define REG_DISP_MOPG_BK2_3E_H     (REG_DISP_MOPG_BK2_BASE + 0x7D)
#define REG_DISP_MOPG_BK2_3F_L     (REG_DISP_MOPG_BK2_BASE + 0x7E)
#define REG_DISP_MOPG_BK2_3F_H     (REG_DISP_MOPG_BK2_BASE + 0x7F)
#define REG_DISP_MOPG_BK2_40_L     (REG_DISP_MOPG_BK2_BASE + 0x80)
#define REG_DISP_MOPG_BK2_40_H     (REG_DISP_MOPG_BK2_BASE + 0x81)
#define REG_DISP_MOPG_BK2_41_L     (REG_DISP_MOPG_BK2_BASE + 0x82)
#define REG_DISP_MOPG_BK2_41_H     (REG_DISP_MOPG_BK2_BASE + 0x83)
#define REG_DISP_MOPG_BK2_42_L     (REG_DISP_MOPG_BK2_BASE + 0x84)
#define REG_DISP_MOPG_BK2_42_H     (REG_DISP_MOPG_BK2_BASE + 0x85)
#define REG_DISP_MOPG_BK2_43_L     (REG_DISP_MOPG_BK2_BASE + 0x86)
#define REG_DISP_MOPG_BK2_43_H     (REG_DISP_MOPG_BK2_BASE + 0x87)
#define REG_DISP_MOPG_BK2_44_L     (REG_DISP_MOPG_BK2_BASE + 0x88)
#define REG_DISP_MOPG_BK2_44_H     (REG_DISP_MOPG_BK2_BASE + 0x89)
#define REG_DISP_MOPG_BK2_45_L     (REG_DISP_MOPG_BK2_BASE + 0x8A)
#define REG_DISP_MOPG_BK2_45_H     (REG_DISP_MOPG_BK2_BASE + 0x8B)
#define REG_DISP_MOPG_BK2_46_L     (REG_DISP_MOPG_BK2_BASE + 0x8C)
#define REG_DISP_MOPG_BK2_46_H     (REG_DISP_MOPG_BK2_BASE + 0x8D)
#define REG_DISP_MOPG_BK2_47_L     (REG_DISP_MOPG_BK2_BASE + 0x8E)
#define REG_DISP_MOPG_BK2_47_H     (REG_DISP_MOPG_BK2_BASE + 0x8F)
#define REG_DISP_MOPG_BK2_48_L     (REG_DISP_MOPG_BK2_BASE + 0x90)
#define REG_DISP_MOPG_BK2_48_H     (REG_DISP_MOPG_BK2_BASE + 0x91)
#define REG_DISP_MOPG_BK2_49_L     (REG_DISP_MOPG_BK2_BASE + 0x92)
#define REG_DISP_MOPG_BK2_49_H     (REG_DISP_MOPG_BK2_BASE + 0x93)
#define REG_DISP_MOPG_BK2_4A_L     (REG_DISP_MOPG_BK2_BASE + 0x94)
#define REG_DISP_MOPG_BK2_4A_H     (REG_DISP_MOPG_BK2_BASE + 0x95)
#define REG_DISP_MOPG_BK2_4B_L     (REG_DISP_MOPG_BK2_BASE + 0x96)
#define REG_DISP_MOPG_BK2_4B_H     (REG_DISP_MOPG_BK2_BASE + 0x97)
#define REG_DISP_MOPG_BK2_4C_L     (REG_DISP_MOPG_BK2_BASE + 0x98)
#define REG_DISP_MOPG_BK2_4C_H     (REG_DISP_MOPG_BK2_BASE + 0x99)
#define REG_DISP_MOPG_BK2_4D_L     (REG_DISP_MOPG_BK2_BASE + 0x9A)
#define REG_DISP_MOPG_BK2_4D_H     (REG_DISP_MOPG_BK2_BASE + 0x9B)
#define REG_DISP_MOPG_BK2_4E_L     (REG_DISP_MOPG_BK2_BASE + 0x9C)
#define REG_DISP_MOPG_BK2_4E_H     (REG_DISP_MOPG_BK2_BASE + 0x9D)
#define REG_DISP_MOPG_BK2_4F_L     (REG_DISP_MOPG_BK2_BASE + 0x9E)
#define REG_DISP_MOPG_BK2_4F_H     (REG_DISP_MOPG_BK2_BASE + 0x9F)
#define REG_DISP_MOPG_BK2_50_L     (REG_DISP_MOPG_BK2_BASE + 0xA0)
#define REG_DISP_MOPG_BK2_50_H     (REG_DISP_MOPG_BK2_BASE + 0xA1)
#define REG_DISP_MOPG_BK2_51_L     (REG_DISP_MOPG_BK2_BASE + 0xA2)
#define REG_DISP_MOPG_BK2_51_H     (REG_DISP_MOPG_BK2_BASE + 0xA3)
#define REG_DISP_MOPG_BK2_52_L     (REG_DISP_MOPG_BK2_BASE + 0xA4)
#define REG_DISP_MOPG_BK2_52_H     (REG_DISP_MOPG_BK2_BASE + 0xA5)
#define REG_DISP_MOPG_BK2_53_L     (REG_DISP_MOPG_BK2_BASE + 0xA6)
#define REG_DISP_MOPG_BK2_53_H     (REG_DISP_MOPG_BK2_BASE + 0xA7)
#define REG_DISP_MOPG_BK2_54_L     (REG_DISP_MOPG_BK2_BASE + 0xA8)
#define REG_DISP_MOPG_BK2_54_H     (REG_DISP_MOPG_BK2_BASE + 0xA9)
#define REG_DISP_MOPG_BK2_55_L     (REG_DISP_MOPG_BK2_BASE + 0xAA)
#define REG_DISP_MOPG_BK2_55_H     (REG_DISP_MOPG_BK2_BASE + 0xAB)
#define REG_DISP_MOPG_BK2_56_L     (REG_DISP_MOPG_BK2_BASE + 0xAC)
#define REG_DISP_MOPG_BK2_56_H     (REG_DISP_MOPG_BK2_BASE + 0xAD)
#define REG_DISP_MOPG_BK2_57_L     (REG_DISP_MOPG_BK2_BASE + 0xAE)
#define REG_DISP_MOPG_BK2_57_H     (REG_DISP_MOPG_BK2_BASE + 0xAF)
#define REG_DISP_MOPG_BK2_58_L     (REG_DISP_MOPG_BK2_BASE + 0xB0)
#define REG_DISP_MOPG_BK2_58_H     (REG_DISP_MOPG_BK2_BASE + 0xB1)
#define REG_DISP_MOPG_BK2_59_L     (REG_DISP_MOPG_BK2_BASE + 0xB2)
#define REG_DISP_MOPG_BK2_59_H     (REG_DISP_MOPG_BK2_BASE + 0xB3)
#define REG_DISP_MOPG_BK2_5A_L     (REG_DISP_MOPG_BK2_BASE + 0xB4)
#define REG_DISP_MOPG_BK2_5A_H     (REG_DISP_MOPG_BK2_BASE + 0xB5)
#define REG_DISP_MOPG_BK2_5B_L     (REG_DISP_MOPG_BK2_BASE + 0xB6)
#define REG_DISP_MOPG_BK2_5B_H     (REG_DISP_MOPG_BK2_BASE + 0xB7)
#define REG_DISP_MOPG_BK2_5C_L     (REG_DISP_MOPG_BK2_BASE + 0xB8)
#define REG_DISP_MOPG_BK2_5C_H     (REG_DISP_MOPG_BK2_BASE + 0xB9)
#define REG_DISP_MOPG_BK2_5D_L     (REG_DISP_MOPG_BK2_BASE + 0xBA)
#define REG_DISP_MOPG_BK2_5D_H     (REG_DISP_MOPG_BK2_BASE + 0xBB)
#define REG_DISP_MOPG_BK2_5E_L     (REG_DISP_MOPG_BK2_BASE + 0xBC)
#define REG_DISP_MOPG_BK2_5E_H     (REG_DISP_MOPG_BK2_BASE + 0xBD)
#define REG_DISP_MOPG_BK2_5F_L     (REG_DISP_MOPG_BK2_BASE + 0xBE)
#define REG_DISP_MOPG_BK2_5F_H     (REG_DISP_MOPG_BK2_BASE + 0xBF)
#define REG_DISP_MOPG_BK2_60_L     (REG_DISP_MOPG_BK2_BASE + 0xC0)
#define REG_DISP_MOPG_BK2_60_H     (REG_DISP_MOPG_BK2_BASE + 0xC1)
#define REG_DISP_MOPG_BK2_61_L     (REG_DISP_MOPG_BK2_BASE + 0xC2)
#define REG_DISP_MOPG_BK2_61_H     (REG_DISP_MOPG_BK2_BASE + 0xC3)
#define REG_DISP_MOPG_BK2_62_L     (REG_DISP_MOPG_BK2_BASE + 0xC4)
#define REG_DISP_MOPG_BK2_62_H     (REG_DISP_MOPG_BK2_BASE + 0xC5)
#define REG_DISP_MOPG_BK2_63_L     (REG_DISP_MOPG_BK2_BASE + 0xC6)
#define REG_DISP_MOPG_BK2_63_H     (REG_DISP_MOPG_BK2_BASE + 0xC7)
#define REG_DISP_MOPG_BK2_64_L     (REG_DISP_MOPG_BK2_BASE + 0xC8)
#define REG_DISP_MOPG_BK2_64_H     (REG_DISP_MOPG_BK2_BASE + 0xC9)
#define REG_DISP_MOPG_BK2_65_L     (REG_DISP_MOPG_BK2_BASE + 0xCA)
#define REG_DISP_MOPG_BK2_65_H     (REG_DISP_MOPG_BK2_BASE + 0xCB)
#define REG_DISP_MOPG_BK2_66_L     (REG_DISP_MOPG_BK2_BASE + 0xCC)
#define REG_DISP_MOPG_BK2_66_H     (REG_DISP_MOPG_BK2_BASE + 0xCD)
#define REG_DISP_MOPG_BK2_67_L     (REG_DISP_MOPG_BK2_BASE + 0xCE)
#define REG_DISP_MOPG_BK2_67_H     (REG_DISP_MOPG_BK2_BASE + 0xCF)
#define REG_DISP_MOPG_BK2_68_L     (REG_DISP_MOPG_BK2_BASE + 0xD0)
#define REG_DISP_MOPG_BK2_68_H     (REG_DISP_MOPG_BK2_BASE + 0xD1)
#define REG_DISP_MOPG_BK2_69_L     (REG_DISP_MOPG_BK2_BASE + 0xD2)
#define REG_DISP_MOPG_BK2_69_H     (REG_DISP_MOPG_BK2_BASE + 0xD3)
#define REG_DISP_MOPG_BK2_6A_L     (REG_DISP_MOPG_BK2_BASE + 0xD4)
#define REG_DISP_MOPG_BK2_6A_H     (REG_DISP_MOPG_BK2_BASE + 0xD5)
#define REG_DISP_MOPG_BK2_6B_L     (REG_DISP_MOPG_BK2_BASE + 0xD6)
#define REG_DISP_MOPG_BK2_6B_H     (REG_DISP_MOPG_BK2_BASE + 0xD7)
#define REG_DISP_MOPG_BK2_6C_L     (REG_DISP_MOPG_BK2_BASE + 0xD8)
#define REG_DISP_MOPG_BK2_6C_H     (REG_DISP_MOPG_BK2_BASE + 0xD9)
#define REG_DISP_MOPG_BK2_6D_L     (REG_DISP_MOPG_BK2_BASE + 0xDA)
#define REG_DISP_MOPG_BK2_6D_H     (REG_DISP_MOPG_BK2_BASE + 0xDB)
#define REG_DISP_MOPG_BK2_6E_L     (REG_DISP_MOPG_BK2_BASE + 0xDC)
#define REG_DISP_MOPG_BK2_6E_H     (REG_DISP_MOPG_BK2_BASE + 0xDD)
#define REG_DISP_MOPG_BK2_6F_L     (REG_DISP_MOPG_BK2_BASE + 0xDE)
#define REG_DISP_MOPG_BK2_6F_H     (REG_DISP_MOPG_BK2_BASE + 0xDF)
#define REG_DISP_MOPG_BK2_70_L     (REG_DISP_MOPG_BK2_BASE + 0xE0)
#define REG_DISP_MOPG_BK2_70_H     (REG_DISP_MOPG_BK2_BASE + 0xE1)
#define REG_DISP_MOPG_BK2_71_L     (REG_DISP_MOPG_BK2_BASE + 0xE2)
#define REG_DISP_MOPG_BK2_71_H     (REG_DISP_MOPG_BK2_BASE + 0xE3)
#define REG_DISP_MOPG_BK2_72_L     (REG_DISP_MOPG_BK2_BASE + 0xE4)
#define REG_DISP_MOPG_BK2_72_H     (REG_DISP_MOPG_BK2_BASE + 0xE5)
#define REG_DISP_MOPG_BK2_73_L     (REG_DISP_MOPG_BK2_BASE + 0xE6)
#define REG_DISP_MOPG_BK2_73_H     (REG_DISP_MOPG_BK2_BASE + 0xE7)
#define REG_DISP_MOPG_BK2_74_L     (REG_DISP_MOPG_BK2_BASE + 0xE8)
#define REG_DISP_MOPG_BK2_74_H     (REG_DISP_MOPG_BK2_BASE + 0xE9)
#define REG_DISP_MOPG_BK2_75_L     (REG_DISP_MOPG_BK2_BASE + 0xEA)
#define REG_DISP_MOPG_BK2_75_H     (REG_DISP_MOPG_BK2_BASE + 0xEB)
#define REG_DISP_MOPG_BK2_76_L     (REG_DISP_MOPG_BK2_BASE + 0xEC)
#define REG_DISP_MOPG_BK2_76_H     (REG_DISP_MOPG_BK2_BASE + 0xED)
#define REG_DISP_MOPG_BK2_77_L     (REG_DISP_MOPG_BK2_BASE + 0xEE)
#define REG_DISP_MOPG_BK2_77_H     (REG_DISP_MOPG_BK2_BASE + 0xEF)
#define REG_DISP_MOPG_BK2_78_L     (REG_DISP_MOPG_BK2_BASE + 0xF0)
#define REG_DISP_MOPG_BK2_78_H     (REG_DISP_MOPG_BK2_BASE + 0xF1)
#define REG_DISP_MOPG_BK2_79_L     (REG_DISP_MOPG_BK2_BASE + 0xF2)
#define REG_DISP_MOPG_BK2_79_H     (REG_DISP_MOPG_BK2_BASE + 0xF3)
#define REG_DISP_MOPG_BK2_7A_L     (REG_DISP_MOPG_BK2_BASE + 0xF4)
#define REG_DISP_MOPG_BK2_7A_H     (REG_DISP_MOPG_BK2_BASE + 0xF5)
#define REG_DISP_MOPG_BK2_7B_L     (REG_DISP_MOPG_BK2_BASE + 0xF6)
#define REG_DISP_MOPG_BK2_7B_H     (REG_DISP_MOPG_BK2_BASE + 0xF7)
#define REG_DISP_MOPG_BK2_7C_L     (REG_DISP_MOPG_BK2_BASE + 0xF8)
#define REG_DISP_MOPG_BK2_7C_H     (REG_DISP_MOPG_BK2_BASE + 0xF9)
#define REG_DISP_MOPG_BK2_7D_L     (REG_DISP_MOPG_BK2_BASE + 0xFA)
#define REG_DISP_MOPG_BK2_7D_H     (REG_DISP_MOPG_BK2_BASE + 0xFB)
#define REG_DISP_MOPG_BK2_7E_L     (REG_DISP_MOPG_BK2_BASE + 0xFC)
#define REG_DISP_MOPG_BK2_7E_H     (REG_DISP_MOPG_BK2_BASE + 0xFD)
#define REG_DISP_MOPG_BK2_7F_L     (REG_DISP_MOPG_BK2_BASE + 0xFE)
#define REG_DISP_MOPG_BK2_7F_H     (REG_DISP_MOPG_BK2_BASE + 0xFF)

#define REG_DISP_MOPS_BK0_00_L     (REG_DISP_MOPS_BK0_BASE + 0x00)
#define REG_DISP_MOPS_BK0_00_H     (REG_DISP_MOPS_BK0_BASE + 0x01)
#define REG_DISP_MOPS_BK0_01_L     (REG_DISP_MOPS_BK0_BASE + 0x02)
#define REG_DISP_MOPS_BK0_01_H     (REG_DISP_MOPS_BK0_BASE + 0x03)
#define REG_DISP_MOPS_BK0_02_L     (REG_DISP_MOPS_BK0_BASE + 0x04)
#define REG_DISP_MOPS_BK0_02_H     (REG_DISP_MOPS_BK0_BASE + 0x05)
#define REG_DISP_MOPS_BK0_03_L     (REG_DISP_MOPS_BK0_BASE + 0x06)
#define REG_DISP_MOPS_BK0_03_H     (REG_DISP_MOPS_BK0_BASE + 0x07)
#define REG_DISP_MOPS_BK0_04_L     (REG_DISP_MOPS_BK0_BASE + 0x08)
#define REG_DISP_MOPS_BK0_04_H     (REG_DISP_MOPS_BK0_BASE + 0x09)
#define REG_DISP_MOPS_BK0_05_L     (REG_DISP_MOPS_BK0_BASE + 0x0A)
#define REG_DISP_MOPS_BK0_05_H     (REG_DISP_MOPS_BK0_BASE + 0x0B)
#define REG_DISP_MOPS_BK0_06_L     (REG_DISP_MOPS_BK0_BASE + 0x0C)
#define REG_DISP_MOPS_BK0_06_H     (REG_DISP_MOPS_BK0_BASE + 0x0D)
#define REG_DISP_MOPS_BK0_07_L     (REG_DISP_MOPS_BK0_BASE + 0x0E)
#define REG_DISP_MOPS_BK0_07_H     (REG_DISP_MOPS_BK0_BASE + 0x0F)
#define REG_DISP_MOPS_BK0_08_L     (REG_DISP_MOPS_BK0_BASE + 0x10)
#define REG_DISP_MOPS_BK0_08_H     (REG_DISP_MOPS_BK0_BASE + 0x11)
#define REG_DISP_MOPS_BK0_09_L     (REG_DISP_MOPS_BK0_BASE + 0x12)
#define REG_DISP_MOPS_BK0_09_H     (REG_DISP_MOPS_BK0_BASE + 0x13)
#define REG_DISP_MOPS_BK0_0A_L     (REG_DISP_MOPS_BK0_BASE + 0x14)
#define REG_DISP_MOPS_BK0_0A_H     (REG_DISP_MOPS_BK0_BASE + 0x15)
#define REG_DISP_MOPS_BK0_0B_L     (REG_DISP_MOPS_BK0_BASE + 0x16)
#define REG_DISP_MOPS_BK0_0B_H     (REG_DISP_MOPS_BK0_BASE + 0x17)
#define REG_DISP_MOPS_BK0_0C_L     (REG_DISP_MOPS_BK0_BASE + 0x18)
#define REG_DISP_MOPS_BK0_0C_H     (REG_DISP_MOPS_BK0_BASE + 0x19)
#define REG_DISP_MOPS_BK0_0D_L     (REG_DISP_MOPS_BK0_BASE + 0x1A)
#define REG_DISP_MOPS_BK0_0D_H     (REG_DISP_MOPS_BK0_BASE + 0x1B)
#define REG_DISP_MOPS_BK0_0E_L     (REG_DISP_MOPS_BK0_BASE + 0x1C)
#define REG_DISP_MOPS_BK0_0E_H     (REG_DISP_MOPS_BK0_BASE + 0x1D)
#define REG_DISP_MOPS_BK0_0F_L     (REG_DISP_MOPS_BK0_BASE + 0x1E)
#define REG_DISP_MOPS_BK0_0F_H     (REG_DISP_MOPS_BK0_BASE + 0x1F)
#define REG_DISP_MOPS_BK0_10_L     (REG_DISP_MOPS_BK0_BASE + 0x20)
#define REG_DISP_MOPS_BK0_10_H     (REG_DISP_MOPS_BK0_BASE + 0x21)
#define REG_DISP_MOPS_BK0_11_L     (REG_DISP_MOPS_BK0_BASE + 0x22)
#define REG_DISP_MOPS_BK0_11_H     (REG_DISP_MOPS_BK0_BASE + 0x23)
#define REG_DISP_MOPS_BK0_12_L     (REG_DISP_MOPS_BK0_BASE + 0x24)
#define REG_DISP_MOPS_BK0_12_H     (REG_DISP_MOPS_BK0_BASE + 0x25)
#define REG_DISP_MOPS_BK0_13_L     (REG_DISP_MOPS_BK0_BASE + 0x26)
#define REG_DISP_MOPS_BK0_13_H     (REG_DISP_MOPS_BK0_BASE + 0x27)
#define REG_DISP_MOPS_BK0_14_L     (REG_DISP_MOPS_BK0_BASE + 0x28)
#define REG_DISP_MOPS_BK0_14_H     (REG_DISP_MOPS_BK0_BASE + 0x29)
#define REG_DISP_MOPS_BK0_15_L     (REG_DISP_MOPS_BK0_BASE + 0x2A)
#define REG_DISP_MOPS_BK0_15_H     (REG_DISP_MOPS_BK0_BASE + 0x2B)
#define REG_DISP_MOPS_BK0_16_L     (REG_DISP_MOPS_BK0_BASE + 0x2C)
#define REG_DISP_MOPS_BK0_16_H     (REG_DISP_MOPS_BK0_BASE + 0x2D)
#define REG_DISP_MOPS_BK0_17_L     (REG_DISP_MOPS_BK0_BASE + 0x2E)
#define REG_DISP_MOPS_BK0_17_H     (REG_DISP_MOPS_BK0_BASE + 0x2F)
#define REG_DISP_MOPS_BK0_18_L     (REG_DISP_MOPS_BK0_BASE + 0x30)
#define REG_DISP_MOPS_BK0_18_H     (REG_DISP_MOPS_BK0_BASE + 0x31)
#define REG_DISP_MOPS_BK0_19_L     (REG_DISP_MOPS_BK0_BASE + 0x32)
#define REG_DISP_MOPS_BK0_19_H     (REG_DISP_MOPS_BK0_BASE + 0x33)
#define REG_DISP_MOPS_BK0_1A_L     (REG_DISP_MOPS_BK0_BASE + 0x34)
#define REG_DISP_MOPS_BK0_1A_H     (REG_DISP_MOPS_BK0_BASE + 0x35)
#define REG_DISP_MOPS_BK0_1B_L     (REG_DISP_MOPS_BK0_BASE + 0x36)
#define REG_DISP_MOPS_BK0_1B_H     (REG_DISP_MOPS_BK0_BASE + 0x37)
#define REG_DISP_MOPS_BK0_1C_L     (REG_DISP_MOPS_BK0_BASE + 0x38)
#define REG_DISP_MOPS_BK0_1C_H     (REG_DISP_MOPS_BK0_BASE + 0x39)
#define REG_DISP_MOPS_BK0_1D_L     (REG_DISP_MOPS_BK0_BASE + 0x3A)
#define REG_DISP_MOPS_BK0_1D_H     (REG_DISP_MOPS_BK0_BASE + 0x3B)
#define REG_DISP_MOPS_BK0_1E_L     (REG_DISP_MOPS_BK0_BASE + 0x3C)
#define REG_DISP_MOPS_BK0_1E_H     (REG_DISP_MOPS_BK0_BASE + 0x3D)
#define REG_DISP_MOPS_BK0_1F_L     (REG_DISP_MOPS_BK0_BASE + 0x3E)
#define REG_DISP_MOPS_BK0_1F_H     (REG_DISP_MOPS_BK0_BASE + 0x3F)
#define REG_DISP_MOPS_BK0_20_L     (REG_DISP_MOPS_BK0_BASE + 0x40)
#define REG_DISP_MOPS_BK0_20_H     (REG_DISP_MOPS_BK0_BASE + 0x41)
#define REG_DISP_MOPS_BK0_21_L     (REG_DISP_MOPS_BK0_BASE + 0x42)
#define REG_DISP_MOPS_BK0_21_H     (REG_DISP_MOPS_BK0_BASE + 0x43)
#define REG_DISP_MOPS_BK0_22_L     (REG_DISP_MOPS_BK0_BASE + 0x44)
#define REG_DISP_MOPS_BK0_22_H     (REG_DISP_MOPS_BK0_BASE + 0x45)
#define REG_DISP_MOPS_BK0_23_L     (REG_DISP_MOPS_BK0_BASE + 0x46)
#define REG_DISP_MOPS_BK0_23_H     (REG_DISP_MOPS_BK0_BASE + 0x47)
#define REG_DISP_MOPS_BK0_24_L     (REG_DISP_MOPS_BK0_BASE + 0x48)
#define REG_DISP_MOPS_BK0_24_H     (REG_DISP_MOPS_BK0_BASE + 0x49)
#define REG_DISP_MOPS_BK0_25_L     (REG_DISP_MOPS_BK0_BASE + 0x4A)
#define REG_DISP_MOPS_BK0_25_H     (REG_DISP_MOPS_BK0_BASE + 0x4B)
#define REG_DISP_MOPS_BK0_26_L     (REG_DISP_MOPS_BK0_BASE + 0x4C)
#define REG_DISP_MOPS_BK0_26_H     (REG_DISP_MOPS_BK0_BASE + 0x4D)
#define REG_DISP_MOPS_BK0_27_L     (REG_DISP_MOPS_BK0_BASE + 0x4E)
#define REG_DISP_MOPS_BK0_27_H     (REG_DISP_MOPS_BK0_BASE + 0x4F)
#define REG_DISP_MOPS_BK0_28_L     (REG_DISP_MOPS_BK0_BASE + 0x50)
#define REG_DISP_MOPS_BK0_28_H     (REG_DISP_MOPS_BK0_BASE + 0x51)
#define REG_DISP_MOPS_BK0_29_L     (REG_DISP_MOPS_BK0_BASE + 0x52)
#define REG_DISP_MOPS_BK0_29_H     (REG_DISP_MOPS_BK0_BASE + 0x53)
#define REG_DISP_MOPS_BK0_2A_L     (REG_DISP_MOPS_BK0_BASE + 0x54)
#define REG_DISP_MOPS_BK0_2A_H     (REG_DISP_MOPS_BK0_BASE + 0x55)
#define REG_DISP_MOPS_BK0_2B_L     (REG_DISP_MOPS_BK0_BASE + 0x56)
#define REG_DISP_MOPS_BK0_2B_H     (REG_DISP_MOPS_BK0_BASE + 0x57)
#define REG_DISP_MOPS_BK0_2C_L     (REG_DISP_MOPS_BK0_BASE + 0x58)
#define REG_DISP_MOPS_BK0_2C_H     (REG_DISP_MOPS_BK0_BASE + 0x59)
#define REG_DISP_MOPS_BK0_2D_L     (REG_DISP_MOPS_BK0_BASE + 0x5A)
#define REG_DISP_MOPS_BK0_2D_H     (REG_DISP_MOPS_BK0_BASE + 0x5B)
#define REG_DISP_MOPS_BK0_2E_L     (REG_DISP_MOPS_BK0_BASE + 0x5C)
#define REG_DISP_MOPS_BK0_2E_H     (REG_DISP_MOPS_BK0_BASE + 0x5D)
#define REG_DISP_MOPS_BK0_2F_L     (REG_DISP_MOPS_BK0_BASE + 0x5E)
#define REG_DISP_MOPS_BK0_2F_H     (REG_DISP_MOPS_BK0_BASE + 0x5F)
#define REG_DISP_MOPS_BK0_30_L     (REG_DISP_MOPS_BK0_BASE + 0x60)
#define REG_DISP_MOPS_BK0_30_H     (REG_DISP_MOPS_BK0_BASE + 0x61)
#define REG_DISP_MOPS_BK0_31_L     (REG_DISP_MOPS_BK0_BASE + 0x62)
#define REG_DISP_MOPS_BK0_31_H     (REG_DISP_MOPS_BK0_BASE + 0x63)
#define REG_DISP_MOPS_BK0_32_L     (REG_DISP_MOPS_BK0_BASE + 0x64)
#define REG_DISP_MOPS_BK0_32_H     (REG_DISP_MOPS_BK0_BASE + 0x65)
#define REG_DISP_MOPS_BK0_33_L     (REG_DISP_MOPS_BK0_BASE + 0x66)
#define REG_DISP_MOPS_BK0_33_H     (REG_DISP_MOPS_BK0_BASE + 0x67)
#define REG_DISP_MOPS_BK0_34_L     (REG_DISP_MOPS_BK0_BASE + 0x68)
#define REG_DISP_MOPS_BK0_34_H     (REG_DISP_MOPS_BK0_BASE + 0x69)
#define REG_DISP_MOPS_BK0_35_L     (REG_DISP_MOPS_BK0_BASE + 0x6A)
#define REG_DISP_MOPS_BK0_35_H     (REG_DISP_MOPS_BK0_BASE + 0x6B)
#define REG_DISP_MOPS_BK0_36_L     (REG_DISP_MOPS_BK0_BASE + 0x6C)
#define REG_DISP_MOPS_BK0_36_H     (REG_DISP_MOPS_BK0_BASE + 0x6D)
#define REG_DISP_MOPS_BK0_37_L     (REG_DISP_MOPS_BK0_BASE + 0x6E)
#define REG_DISP_MOPS_BK0_37_H     (REG_DISP_MOPS_BK0_BASE + 0x6F)
#define REG_DISP_MOPS_BK0_38_L     (REG_DISP_MOPS_BK0_BASE + 0x70)
#define REG_DISP_MOPS_BK0_38_H     (REG_DISP_MOPS_BK0_BASE + 0x71)
#define REG_DISP_MOPS_BK0_39_L     (REG_DISP_MOPS_BK0_BASE + 0x72)
#define REG_DISP_MOPS_BK0_39_H     (REG_DISP_MOPS_BK0_BASE + 0x73)
#define REG_DISP_MOPS_BK0_3A_L     (REG_DISP_MOPS_BK0_BASE + 0x74)
#define REG_DISP_MOPS_BK0_3A_H     (REG_DISP_MOPS_BK0_BASE + 0x75)
#define REG_DISP_MOPS_BK0_3B_L     (REG_DISP_MOPS_BK0_BASE + 0x76)
#define REG_DISP_MOPS_BK0_3B_H     (REG_DISP_MOPS_BK0_BASE + 0x77)
#define REG_DISP_MOPS_BK0_3C_L     (REG_DISP_MOPS_BK0_BASE + 0x78)
#define REG_DISP_MOPS_BK0_3C_H     (REG_DISP_MOPS_BK0_BASE + 0x79)
#define REG_DISP_MOPS_BK0_3D_L     (REG_DISP_MOPS_BK0_BASE + 0x7A)
#define REG_DISP_MOPS_BK0_3D_H     (REG_DISP_MOPS_BK0_BASE + 0x7B)
#define REG_DISP_MOPS_BK0_3E_L     (REG_DISP_MOPS_BK0_BASE + 0x7C)
#define REG_DISP_MOPS_BK0_3E_H     (REG_DISP_MOPS_BK0_BASE + 0x7D)
#define REG_DISP_MOPS_BK0_3F_L     (REG_DISP_MOPS_BK0_BASE + 0x7E)
#define REG_DISP_MOPS_BK0_3F_H     (REG_DISP_MOPS_BK0_BASE + 0x7F)
#define REG_DISP_MOPS_BK0_40_L     (REG_DISP_MOPS_BK0_BASE + 0x80)
#define REG_DISP_MOPS_BK0_40_H     (REG_DISP_MOPS_BK0_BASE + 0x81)
#define REG_DISP_MOPS_BK0_41_L     (REG_DISP_MOPS_BK0_BASE + 0x82)
#define REG_DISP_MOPS_BK0_41_H     (REG_DISP_MOPS_BK0_BASE + 0x83)
#define REG_DISP_MOPS_BK0_42_L     (REG_DISP_MOPS_BK0_BASE + 0x84)
#define REG_DISP_MOPS_BK0_42_H     (REG_DISP_MOPS_BK0_BASE + 0x85)
#define REG_DISP_MOPS_BK0_43_L     (REG_DISP_MOPS_BK0_BASE + 0x86)
#define REG_DISP_MOPS_BK0_43_H     (REG_DISP_MOPS_BK0_BASE + 0x87)
#define REG_DISP_MOPS_BK0_44_L     (REG_DISP_MOPS_BK0_BASE + 0x88)
#define REG_DISP_MOPS_BK0_44_H     (REG_DISP_MOPS_BK0_BASE + 0x89)
#define REG_DISP_MOPS_BK0_45_L     (REG_DISP_MOPS_BK0_BASE + 0x8A)
#define REG_DISP_MOPS_BK0_45_H     (REG_DISP_MOPS_BK0_BASE + 0x8B)
#define REG_DISP_MOPS_BK0_46_L     (REG_DISP_MOPS_BK0_BASE + 0x8C)
#define REG_DISP_MOPS_BK0_46_H     (REG_DISP_MOPS_BK0_BASE + 0x8D)
#define REG_DISP_MOPS_BK0_47_L     (REG_DISP_MOPS_BK0_BASE + 0x8E)
#define REG_DISP_MOPS_BK0_47_H     (REG_DISP_MOPS_BK0_BASE + 0x8F)
#define REG_DISP_MOPS_BK0_48_L     (REG_DISP_MOPS_BK0_BASE + 0x90)
#define REG_DISP_MOPS_BK0_48_H     (REG_DISP_MOPS_BK0_BASE + 0x91)
#define REG_DISP_MOPS_BK0_49_L     (REG_DISP_MOPS_BK0_BASE + 0x92)
#define REG_DISP_MOPS_BK0_49_H     (REG_DISP_MOPS_BK0_BASE + 0x93)
#define REG_DISP_MOPS_BK0_4A_L     (REG_DISP_MOPS_BK0_BASE + 0x94)
#define REG_DISP_MOPS_BK0_4A_H     (REG_DISP_MOPS_BK0_BASE + 0x95)
#define REG_DISP_MOPS_BK0_4B_L     (REG_DISP_MOPS_BK0_BASE + 0x96)
#define REG_DISP_MOPS_BK0_4B_H     (REG_DISP_MOPS_BK0_BASE + 0x97)
#define REG_DISP_MOPS_BK0_4C_L     (REG_DISP_MOPS_BK0_BASE + 0x98)
#define REG_DISP_MOPS_BK0_4C_H     (REG_DISP_MOPS_BK0_BASE + 0x99)
#define REG_DISP_MOPS_BK0_4D_L     (REG_DISP_MOPS_BK0_BASE + 0x9A)
#define REG_DISP_MOPS_BK0_4D_H     (REG_DISP_MOPS_BK0_BASE + 0x9B)
#define REG_DISP_MOPS_BK0_4E_L     (REG_DISP_MOPS_BK0_BASE + 0x9C)
#define REG_DISP_MOPS_BK0_4E_H     (REG_DISP_MOPS_BK0_BASE + 0x9D)
#define REG_DISP_MOPS_BK0_4F_L     (REG_DISP_MOPS_BK0_BASE + 0x9E)
#define REG_DISP_MOPS_BK0_4F_H     (REG_DISP_MOPS_BK0_BASE + 0x9F)
#define REG_DISP_MOPS_BK0_50_L     (REG_DISP_MOPS_BK0_BASE + 0xA0)
#define REG_DISP_MOPS_BK0_50_H     (REG_DISP_MOPS_BK0_BASE + 0xA1)
#define REG_DISP_MOPS_BK0_51_L     (REG_DISP_MOPS_BK0_BASE + 0xA2)
#define REG_DISP_MOPS_BK0_51_H     (REG_DISP_MOPS_BK0_BASE + 0xA3)
#define REG_DISP_MOPS_BK0_52_L     (REG_DISP_MOPS_BK0_BASE + 0xA4)
#define REG_DISP_MOPS_BK0_52_H     (REG_DISP_MOPS_BK0_BASE + 0xA5)
#define REG_DISP_MOPS_BK0_53_L     (REG_DISP_MOPS_BK0_BASE + 0xA6)
#define REG_DISP_MOPS_BK0_53_H     (REG_DISP_MOPS_BK0_BASE + 0xA7)
#define REG_DISP_MOPS_BK0_54_L     (REG_DISP_MOPS_BK0_BASE + 0xA8)
#define REG_DISP_MOPS_BK0_54_H     (REG_DISP_MOPS_BK0_BASE + 0xA9)
#define REG_DISP_MOPS_BK0_55_L     (REG_DISP_MOPS_BK0_BASE + 0xAA)
#define REG_DISP_MOPS_BK0_55_H     (REG_DISP_MOPS_BK0_BASE + 0xAB)
#define REG_DISP_MOPS_BK0_56_L     (REG_DISP_MOPS_BK0_BASE + 0xAC)
#define REG_DISP_MOPS_BK0_56_H     (REG_DISP_MOPS_BK0_BASE + 0xAD)
#define REG_DISP_MOPS_BK0_57_L     (REG_DISP_MOPS_BK0_BASE + 0xAE)
#define REG_DISP_MOPS_BK0_57_H     (REG_DISP_MOPS_BK0_BASE + 0xAF)
#define REG_DISP_MOPS_BK0_58_L     (REG_DISP_MOPS_BK0_BASE + 0xB0)
#define REG_DISP_MOPS_BK0_58_H     (REG_DISP_MOPS_BK0_BASE + 0xB1)
#define REG_DISP_MOPS_BK0_59_L     (REG_DISP_MOPS_BK0_BASE + 0xB2)
#define REG_DISP_MOPS_BK0_59_H     (REG_DISP_MOPS_BK0_BASE + 0xB3)
#define REG_DISP_MOPS_BK0_5A_L     (REG_DISP_MOPS_BK0_BASE + 0xB4)
#define REG_DISP_MOPS_BK0_5A_H     (REG_DISP_MOPS_BK0_BASE + 0xB5)
#define REG_DISP_MOPS_BK0_5B_L     (REG_DISP_MOPS_BK0_BASE + 0xB6)
#define REG_DISP_MOPS_BK0_5B_H     (REG_DISP_MOPS_BK0_BASE + 0xB7)
#define REG_DISP_MOPS_BK0_5C_L     (REG_DISP_MOPS_BK0_BASE + 0xB8)
#define REG_DISP_MOPS_BK0_5C_H     (REG_DISP_MOPS_BK0_BASE + 0xB9)
#define REG_DISP_MOPS_BK0_5D_L     (REG_DISP_MOPS_BK0_BASE + 0xBA)
#define REG_DISP_MOPS_BK0_5D_H     (REG_DISP_MOPS_BK0_BASE + 0xBB)
#define REG_DISP_MOPS_BK0_5E_L     (REG_DISP_MOPS_BK0_BASE + 0xBC)
#define REG_DISP_MOPS_BK0_5E_H     (REG_DISP_MOPS_BK0_BASE + 0xBD)
#define REG_DISP_MOPS_BK0_5F_L     (REG_DISP_MOPS_BK0_BASE + 0xBE)
#define REG_DISP_MOPS_BK0_5F_H     (REG_DISP_MOPS_BK0_BASE + 0xBF)
#define REG_DISP_MOPS_BK0_60_L     (REG_DISP_MOPS_BK0_BASE + 0xC0)
#define REG_DISP_MOPS_BK0_60_H     (REG_DISP_MOPS_BK0_BASE + 0xC1)
#define REG_DISP_MOPS_BK0_61_L     (REG_DISP_MOPS_BK0_BASE + 0xC2)
#define REG_DISP_MOPS_BK0_61_H     (REG_DISP_MOPS_BK0_BASE + 0xC3)
#define REG_DISP_MOPS_BK0_62_L     (REG_DISP_MOPS_BK0_BASE + 0xC4)
#define REG_DISP_MOPS_BK0_62_H     (REG_DISP_MOPS_BK0_BASE + 0xC5)
#define REG_DISP_MOPS_BK0_63_L     (REG_DISP_MOPS_BK0_BASE + 0xC6)
#define REG_DISP_MOPS_BK0_63_H     (REG_DISP_MOPS_BK0_BASE + 0xC7)
#define REG_DISP_MOPS_BK0_64_L     (REG_DISP_MOPS_BK0_BASE + 0xC8)
#define REG_DISP_MOPS_BK0_64_H     (REG_DISP_MOPS_BK0_BASE + 0xC9)
#define REG_DISP_MOPS_BK0_65_L     (REG_DISP_MOPS_BK0_BASE + 0xCA)
#define REG_DISP_MOPS_BK0_65_H     (REG_DISP_MOPS_BK0_BASE + 0xCB)
#define REG_DISP_MOPS_BK0_66_L     (REG_DISP_MOPS_BK0_BASE + 0xCC)
#define REG_DISP_MOPS_BK0_66_H     (REG_DISP_MOPS_BK0_BASE + 0xCD)
#define REG_DISP_MOPS_BK0_67_L     (REG_DISP_MOPS_BK0_BASE + 0xCE)
#define REG_DISP_MOPS_BK0_67_H     (REG_DISP_MOPS_BK0_BASE + 0xCF)
#define REG_DISP_MOPS_BK0_68_L     (REG_DISP_MOPS_BK0_BASE + 0xD0)
#define REG_DISP_MOPS_BK0_68_H     (REG_DISP_MOPS_BK0_BASE + 0xD1)
#define REG_DISP_MOPS_BK0_69_L     (REG_DISP_MOPS_BK0_BASE + 0xD2)
#define REG_DISP_MOPS_BK0_69_H     (REG_DISP_MOPS_BK0_BASE + 0xD3)
#define REG_DISP_MOPS_BK0_6A_L     (REG_DISP_MOPS_BK0_BASE + 0xD4)
#define REG_DISP_MOPS_BK0_6A_H     (REG_DISP_MOPS_BK0_BASE + 0xD5)
#define REG_DISP_MOPS_BK0_6B_L     (REG_DISP_MOPS_BK0_BASE + 0xD6)
#define REG_DISP_MOPS_BK0_6B_H     (REG_DISP_MOPS_BK0_BASE + 0xD7)
#define REG_DISP_MOPS_BK0_6C_L     (REG_DISP_MOPS_BK0_BASE + 0xD8)
#define REG_DISP_MOPS_BK0_6C_H     (REG_DISP_MOPS_BK0_BASE + 0xD9)
#define REG_DISP_MOPS_BK0_6D_L     (REG_DISP_MOPS_BK0_BASE + 0xDA)
#define REG_DISP_MOPS_BK0_6D_H     (REG_DISP_MOPS_BK0_BASE + 0xDB)
#define REG_DISP_MOPS_BK0_6E_L     (REG_DISP_MOPS_BK0_BASE + 0xDC)
#define REG_DISP_MOPS_BK0_6E_H     (REG_DISP_MOPS_BK0_BASE + 0xDD)
#define REG_DISP_MOPS_BK0_6F_L     (REG_DISP_MOPS_BK0_BASE + 0xDE)
#define REG_DISP_MOPS_BK0_6F_H     (REG_DISP_MOPS_BK0_BASE + 0xDF)
#define REG_DISP_MOPS_BK0_70_L     (REG_DISP_MOPS_BK0_BASE + 0xE0)
#define REG_DISP_MOPS_BK0_70_H     (REG_DISP_MOPS_BK0_BASE + 0xE1)
#define REG_DISP_MOPS_BK0_71_L     (REG_DISP_MOPS_BK0_BASE + 0xE2)
#define REG_DISP_MOPS_BK0_71_H     (REG_DISP_MOPS_BK0_BASE + 0xE3)
#define REG_DISP_MOPS_BK0_72_L     (REG_DISP_MOPS_BK0_BASE + 0xE4)
#define REG_DISP_MOPS_BK0_72_H     (REG_DISP_MOPS_BK0_BASE + 0xE5)
#define REG_DISP_MOPS_BK0_73_L     (REG_DISP_MOPS_BK0_BASE + 0xE6)
#define REG_DISP_MOPS_BK0_73_H     (REG_DISP_MOPS_BK0_BASE + 0xE7)
#define REG_DISP_MOPS_BK0_74_L     (REG_DISP_MOPS_BK0_BASE + 0xE8)
#define REG_DISP_MOPS_BK0_74_H     (REG_DISP_MOPS_BK0_BASE + 0xE9)
#define REG_DISP_MOPS_BK0_75_L     (REG_DISP_MOPS_BK0_BASE + 0xEA)
#define REG_DISP_MOPS_BK0_75_H     (REG_DISP_MOPS_BK0_BASE + 0xEB)
#define REG_DISP_MOPS_BK0_76_L     (REG_DISP_MOPS_BK0_BASE + 0xEC)
#define REG_DISP_MOPS_BK0_76_H     (REG_DISP_MOPS_BK0_BASE + 0xED)
#define REG_DISP_MOPS_BK0_77_L     (REG_DISP_MOPS_BK0_BASE + 0xEE)
#define REG_DISP_MOPS_BK0_77_H     (REG_DISP_MOPS_BK0_BASE + 0xEF)
#define REG_DISP_MOPS_BK0_78_L     (REG_DISP_MOPS_BK0_BASE + 0xF0)
#define REG_DISP_MOPS_BK0_78_H     (REG_DISP_MOPS_BK0_BASE + 0xF1)
#define REG_DISP_MOPS_BK0_79_L     (REG_DISP_MOPS_BK0_BASE + 0xF2)
#define REG_DISP_MOPS_BK0_79_H     (REG_DISP_MOPS_BK0_BASE + 0xF3)
#define REG_DISP_MOPS_BK0_7A_L     (REG_DISP_MOPS_BK0_BASE + 0xF4)
#define REG_DISP_MOPS_BK0_7A_H     (REG_DISP_MOPS_BK0_BASE + 0xF5)
#define REG_DISP_MOPS_BK0_7B_L     (REG_DISP_MOPS_BK0_BASE + 0xF6)
#define REG_DISP_MOPS_BK0_7B_H     (REG_DISP_MOPS_BK0_BASE + 0xF7)
#define REG_DISP_MOPS_BK0_7C_L     (REG_DISP_MOPS_BK0_BASE + 0xF8)
#define REG_DISP_MOPS_BK0_7C_H     (REG_DISP_MOPS_BK0_BASE + 0xF9)
#define REG_DISP_MOPS_BK0_7D_L     (REG_DISP_MOPS_BK0_BASE + 0xFA)
#define REG_DISP_MOPS_BK0_7D_H     (REG_DISP_MOPS_BK0_BASE + 0xFB)
#define REG_DISP_MOPS_BK0_7E_L     (REG_DISP_MOPS_BK0_BASE + 0xFC)
#define REG_DISP_MOPS_BK0_7E_H     (REG_DISP_MOPS_BK0_BASE + 0xFD)
#define REG_DISP_MOPS_BK0_7F_L     (REG_DISP_MOPS_BK0_BASE + 0xFE)
#define REG_DISP_MOPS_BK0_7F_H     (REG_DISP_MOPS_BK0_BASE + 0xFF)

#define REG_DISP_MOP_ROT_00_L     (REG_DISP_MOP_ROT_BASE + 0x00)
#define REG_DISP_MOP_ROT_00_H     (REG_DISP_MOP_ROT_BASE + 0x01)
#define REG_DISP_MOP_ROT_01_L     (REG_DISP_MOP_ROT_BASE + 0x02)
#define REG_DISP_MOP_ROT_01_H     (REG_DISP_MOP_ROT_BASE + 0x03)
#define REG_DISP_MOP_ROT_02_L     (REG_DISP_MOP_ROT_BASE + 0x04)
#define REG_DISP_MOP_ROT_02_H     (REG_DISP_MOP_ROT_BASE + 0x05)
#define REG_DISP_MOP_ROT_03_L     (REG_DISP_MOP_ROT_BASE + 0x06)
#define REG_DISP_MOP_ROT_03_H     (REG_DISP_MOP_ROT_BASE + 0x07)
#define REG_DISP_MOP_ROT_04_L     (REG_DISP_MOP_ROT_BASE + 0x08)
#define REG_DISP_MOP_ROT_04_H     (REG_DISP_MOP_ROT_BASE + 0x09)
#define REG_DISP_MOP_ROT_05_L     (REG_DISP_MOP_ROT_BASE + 0x0A)
#define REG_DISP_MOP_ROT_05_H     (REG_DISP_MOP_ROT_BASE + 0x0B)
#define REG_DISP_MOP_ROT_06_L     (REG_DISP_MOP_ROT_BASE + 0x0C)
#define REG_DISP_MOP_ROT_06_H     (REG_DISP_MOP_ROT_BASE + 0x0D)
#define REG_DISP_MOP_ROT_07_L     (REG_DISP_MOP_ROT_BASE + 0x0E)
#define REG_DISP_MOP_ROT_07_H     (REG_DISP_MOP_ROT_BASE + 0x0F)
#define REG_DISP_MOP_ROT_08_L     (REG_DISP_MOP_ROT_BASE + 0x10)
#define REG_DISP_MOP_ROT_08_H     (REG_DISP_MOP_ROT_BASE + 0x11)
#define REG_DISP_MOP_ROT_09_L     (REG_DISP_MOP_ROT_BASE + 0x12)
#define REG_DISP_MOP_ROT_09_H     (REG_DISP_MOP_ROT_BASE + 0x13)
#define REG_DISP_MOP_ROT_0A_L     (REG_DISP_MOP_ROT_BASE + 0x14)
#define REG_DISP_MOP_ROT_0A_H     (REG_DISP_MOP_ROT_BASE + 0x15)
#define REG_DISP_MOP_ROT_0B_L     (REG_DISP_MOP_ROT_BASE + 0x16)
#define REG_DISP_MOP_ROT_0B_H     (REG_DISP_MOP_ROT_BASE + 0x17)
#define REG_DISP_MOP_ROT_0C_L     (REG_DISP_MOP_ROT_BASE + 0x18)
#define REG_DISP_MOP_ROT_0C_H     (REG_DISP_MOP_ROT_BASE + 0x19)
#define REG_DISP_MOP_ROT_0D_L     (REG_DISP_MOP_ROT_BASE + 0x1A)
#define REG_DISP_MOP_ROT_0D_H     (REG_DISP_MOP_ROT_BASE + 0x1B)
#define REG_DISP_MOP_ROT_0E_L     (REG_DISP_MOP_ROT_BASE + 0x1C)
#define REG_DISP_MOP_ROT_0E_H     (REG_DISP_MOP_ROT_BASE + 0x1D)
#define REG_DISP_MOP_ROT_0F_L     (REG_DISP_MOP_ROT_BASE + 0x1E)
#define REG_DISP_MOP_ROT_0F_H     (REG_DISP_MOP_ROT_BASE + 0x1F)
#define REG_DISP_MOP_ROT_10_L     (REG_DISP_MOP_ROT_BASE + 0x20)
#define REG_DISP_MOP_ROT_10_H     (REG_DISP_MOP_ROT_BASE + 0x21)
#define REG_DISP_MOP_ROT_11_L     (REG_DISP_MOP_ROT_BASE + 0x22)
#define REG_DISP_MOP_ROT_11_H     (REG_DISP_MOP_ROT_BASE + 0x23)
#define REG_DISP_MOP_ROT_12_L     (REG_DISP_MOP_ROT_BASE + 0x24)
#define REG_DISP_MOP_ROT_12_H     (REG_DISP_MOP_ROT_BASE + 0x25)
#define REG_DISP_MOP_ROT_13_L     (REG_DISP_MOP_ROT_BASE + 0x26)
#define REG_DISP_MOP_ROT_13_H     (REG_DISP_MOP_ROT_BASE + 0x27)
#define REG_DISP_MOP_ROT_14_L     (REG_DISP_MOP_ROT_BASE + 0x28)
#define REG_DISP_MOP_ROT_14_H     (REG_DISP_MOP_ROT_BASE + 0x29)
#define REG_DISP_MOP_ROT_15_L     (REG_DISP_MOP_ROT_BASE + 0x2A)
#define REG_DISP_MOP_ROT_15_H     (REG_DISP_MOP_ROT_BASE + 0x2B)
#define REG_DISP_MOP_ROT_16_L     (REG_DISP_MOP_ROT_BASE + 0x2C)
#define REG_DISP_MOP_ROT_16_H     (REG_DISP_MOP_ROT_BASE + 0x2D)
#define REG_DISP_MOP_ROT_17_L     (REG_DISP_MOP_ROT_BASE + 0x2E)
#define REG_DISP_MOP_ROT_17_H     (REG_DISP_MOP_ROT_BASE + 0x2F)
#define REG_DISP_MOP_ROT_18_L     (REG_DISP_MOP_ROT_BASE + 0x30)
#define REG_DISP_MOP_ROT_18_H     (REG_DISP_MOP_ROT_BASE + 0x31)
#define REG_DISP_MOP_ROT_19_L     (REG_DISP_MOP_ROT_BASE + 0x32)
#define REG_DISP_MOP_ROT_19_H     (REG_DISP_MOP_ROT_BASE + 0x33)
#define REG_DISP_MOP_ROT_1A_L     (REG_DISP_MOP_ROT_BASE + 0x34)
#define REG_DISP_MOP_ROT_1A_H     (REG_DISP_MOP_ROT_BASE + 0x35)
#define REG_DISP_MOP_ROT_1B_L     (REG_DISP_MOP_ROT_BASE + 0x36)
#define REG_DISP_MOP_ROT_1B_H     (REG_DISP_MOP_ROT_BASE + 0x37)
#define REG_DISP_MOP_ROT_1C_L     (REG_DISP_MOP_ROT_BASE + 0x38)
#define REG_DISP_MOP_ROT_1C_H     (REG_DISP_MOP_ROT_BASE + 0x39)
#define REG_DISP_MOP_ROT_1D_L     (REG_DISP_MOP_ROT_BASE + 0x3A)
#define REG_DISP_MOP_ROT_1D_H     (REG_DISP_MOP_ROT_BASE + 0x3B)
#define REG_DISP_MOP_ROT_1E_L     (REG_DISP_MOP_ROT_BASE + 0x3C)
#define REG_DISP_MOP_ROT_1E_H     (REG_DISP_MOP_ROT_BASE + 0x3D)
#define REG_DISP_MOP_ROT_1F_L     (REG_DISP_MOP_ROT_BASE + 0x3E)
#define REG_DISP_MOP_ROT_1F_H     (REG_DISP_MOP_ROT_BASE + 0x3F)
#define REG_DISP_MOP_ROT_20_L     (REG_DISP_MOP_ROT_BASE + 0x40)
#define REG_DISP_MOP_ROT_20_H     (REG_DISP_MOP_ROT_BASE + 0x41)
#define REG_DISP_MOP_ROT_21_L     (REG_DISP_MOP_ROT_BASE + 0x42)
#define REG_DISP_MOP_ROT_21_H     (REG_DISP_MOP_ROT_BASE + 0x43)
#define REG_DISP_MOP_ROT_22_L     (REG_DISP_MOP_ROT_BASE + 0x44)
#define REG_DISP_MOP_ROT_22_H     (REG_DISP_MOP_ROT_BASE + 0x45)
#define REG_DISP_MOP_ROT_23_L     (REG_DISP_MOP_ROT_BASE + 0x46)
#define REG_DISP_MOP_ROT_23_H     (REG_DISP_MOP_ROT_BASE + 0x47)
#define REG_DISP_MOP_ROT_24_L     (REG_DISP_MOP_ROT_BASE + 0x48)
#define REG_DISP_MOP_ROT_24_H     (REG_DISP_MOP_ROT_BASE + 0x49)
#define REG_DISP_MOP_ROT_25_L     (REG_DISP_MOP_ROT_BASE + 0x4A)
#define REG_DISP_MOP_ROT_25_H     (REG_DISP_MOP_ROT_BASE + 0x4B)
#define REG_DISP_MOP_ROT_26_L     (REG_DISP_MOP_ROT_BASE + 0x4C)
#define REG_DISP_MOP_ROT_26_H     (REG_DISP_MOP_ROT_BASE + 0x4D)
#define REG_DISP_MOP_ROT_27_L     (REG_DISP_MOP_ROT_BASE + 0x4E)
#define REG_DISP_MOP_ROT_27_H     (REG_DISP_MOP_ROT_BASE + 0x4F)
#define REG_DISP_MOP_ROT_28_L     (REG_DISP_MOP_ROT_BASE + 0x50)
#define REG_DISP_MOP_ROT_28_H     (REG_DISP_MOP_ROT_BASE + 0x51)
#define REG_DISP_MOP_ROT_29_L     (REG_DISP_MOP_ROT_BASE + 0x52)
#define REG_DISP_MOP_ROT_29_H     (REG_DISP_MOP_ROT_BASE + 0x53)
#define REG_DISP_MOP_ROT_2A_L     (REG_DISP_MOP_ROT_BASE + 0x54)
#define REG_DISP_MOP_ROT_2A_H     (REG_DISP_MOP_ROT_BASE + 0x55)
#define REG_DISP_MOP_ROT_2B_L     (REG_DISP_MOP_ROT_BASE + 0x56)
#define REG_DISP_MOP_ROT_2B_H     (REG_DISP_MOP_ROT_BASE + 0x57)
#define REG_DISP_MOP_ROT_2C_L     (REG_DISP_MOP_ROT_BASE + 0x58)
#define REG_DISP_MOP_ROT_2C_H     (REG_DISP_MOP_ROT_BASE + 0x59)
#define REG_DISP_MOP_ROT_2D_L     (REG_DISP_MOP_ROT_BASE + 0x5A)
#define REG_DISP_MOP_ROT_2D_H     (REG_DISP_MOP_ROT_BASE + 0x5B)
#define REG_DISP_MOP_ROT_2E_L     (REG_DISP_MOP_ROT_BASE + 0x5C)
#define REG_DISP_MOP_ROT_2E_H     (REG_DISP_MOP_ROT_BASE + 0x5D)
#define REG_DISP_MOP_ROT_2F_L     (REG_DISP_MOP_ROT_BASE + 0x5E)
#define REG_DISP_MOP_ROT_2F_H     (REG_DISP_MOP_ROT_BASE + 0x5F)
#define REG_DISP_MOP_ROT_30_L     (REG_DISP_MOP_ROT_BASE + 0x60)
#define REG_DISP_MOP_ROT_30_H     (REG_DISP_MOP_ROT_BASE + 0x61)
#define REG_DISP_MOP_ROT_31_L     (REG_DISP_MOP_ROT_BASE + 0x62)
#define REG_DISP_MOP_ROT_31_H     (REG_DISP_MOP_ROT_BASE + 0x63)
#define REG_DISP_MOP_ROT_32_L     (REG_DISP_MOP_ROT_BASE + 0x64)
#define REG_DISP_MOP_ROT_32_H     (REG_DISP_MOP_ROT_BASE + 0x65)
#define REG_DISP_MOP_ROT_33_L     (REG_DISP_MOP_ROT_BASE + 0x66)
#define REG_DISP_MOP_ROT_33_H     (REG_DISP_MOP_ROT_BASE + 0x67)
#define REG_DISP_MOP_ROT_34_L     (REG_DISP_MOP_ROT_BASE + 0x68)
#define REG_DISP_MOP_ROT_34_H     (REG_DISP_MOP_ROT_BASE + 0x69)
#define REG_DISP_MOP_ROT_35_L     (REG_DISP_MOP_ROT_BASE + 0x6A)
#define REG_DISP_MOP_ROT_35_H     (REG_DISP_MOP_ROT_BASE + 0x6B)
#define REG_DISP_MOP_ROT_36_L     (REG_DISP_MOP_ROT_BASE + 0x6C)
#define REG_DISP_MOP_ROT_36_H     (REG_DISP_MOP_ROT_BASE + 0x6D)
#define REG_DISP_MOP_ROT_37_L     (REG_DISP_MOP_ROT_BASE + 0x6E)
#define REG_DISP_MOP_ROT_37_H     (REG_DISP_MOP_ROT_BASE + 0x6F)
#define REG_DISP_MOP_ROT_38_L     (REG_DISP_MOP_ROT_BASE + 0x70)
#define REG_DISP_MOP_ROT_38_H     (REG_DISP_MOP_ROT_BASE + 0x71)
#define REG_DISP_MOP_ROT_39_L     (REG_DISP_MOP_ROT_BASE + 0x72)
#define REG_DISP_MOP_ROT_39_H     (REG_DISP_MOP_ROT_BASE + 0x73)
#define REG_DISP_MOP_ROT_3A_L     (REG_DISP_MOP_ROT_BASE + 0x74)
#define REG_DISP_MOP_ROT_3A_H     (REG_DISP_MOP_ROT_BASE + 0x75)
#define REG_DISP_MOP_ROT_3B_L     (REG_DISP_MOP_ROT_BASE + 0x76)
#define REG_DISP_MOP_ROT_3B_H     (REG_DISP_MOP_ROT_BASE + 0x77)
#define REG_DISP_MOP_ROT_3C_L     (REG_DISP_MOP_ROT_BASE + 0x78)
#define REG_DISP_MOP_ROT_3C_H     (REG_DISP_MOP_ROT_BASE + 0x79)
#define REG_DISP_MOP_ROT_3D_L     (REG_DISP_MOP_ROT_BASE + 0x7A)
#define REG_DISP_MOP_ROT_3D_H     (REG_DISP_MOP_ROT_BASE + 0x7B)
#define REG_DISP_MOP_ROT_3E_L     (REG_DISP_MOP_ROT_BASE + 0x7C)
#define REG_DISP_MOP_ROT_3E_H     (REG_DISP_MOP_ROT_BASE + 0x7D)
#define REG_DISP_MOP_ROT_3F_L     (REG_DISP_MOP_ROT_BASE + 0x7E)
#define REG_DISP_MOP_ROT_3F_H     (REG_DISP_MOP_ROT_BASE + 0x7F)
#define REG_DISP_MOP_ROT_40_L     (REG_DISP_MOP_ROT_BASE + 0x80)
#define REG_DISP_MOP_ROT_40_H     (REG_DISP_MOP_ROT_BASE + 0x81)
#define REG_DISP_MOP_ROT_41_L     (REG_DISP_MOP_ROT_BASE + 0x82)
#define REG_DISP_MOP_ROT_41_H     (REG_DISP_MOP_ROT_BASE + 0x83)
#define REG_DISP_MOP_ROT_42_L     (REG_DISP_MOP_ROT_BASE + 0x84)
#define REG_DISP_MOP_ROT_42_H     (REG_DISP_MOP_ROT_BASE + 0x85)
#define REG_DISP_MOP_ROT_43_L     (REG_DISP_MOP_ROT_BASE + 0x86)
#define REG_DISP_MOP_ROT_43_H     (REG_DISP_MOP_ROT_BASE + 0x87)
#define REG_DISP_MOP_ROT_44_L     (REG_DISP_MOP_ROT_BASE + 0x88)
#define REG_DISP_MOP_ROT_44_H     (REG_DISP_MOP_ROT_BASE + 0x89)
#define REG_DISP_MOP_ROT_45_L     (REG_DISP_MOP_ROT_BASE + 0x8A)
#define REG_DISP_MOP_ROT_45_H     (REG_DISP_MOP_ROT_BASE + 0x8B)
#define REG_DISP_MOP_ROT_46_L     (REG_DISP_MOP_ROT_BASE + 0x8C)
#define REG_DISP_MOP_ROT_46_H     (REG_DISP_MOP_ROT_BASE + 0x8D)
#define REG_DISP_MOP_ROT_47_L     (REG_DISP_MOP_ROT_BASE + 0x8E)
#define REG_DISP_MOP_ROT_47_H     (REG_DISP_MOP_ROT_BASE + 0x8F)
#define REG_DISP_MOP_ROT_48_L     (REG_DISP_MOP_ROT_BASE + 0x90)
#define REG_DISP_MOP_ROT_48_H     (REG_DISP_MOP_ROT_BASE + 0x91)
#define REG_DISP_MOP_ROT_49_L     (REG_DISP_MOP_ROT_BASE + 0x92)
#define REG_DISP_MOP_ROT_49_H     (REG_DISP_MOP_ROT_BASE + 0x93)
#define REG_DISP_MOP_ROT_4A_L     (REG_DISP_MOP_ROT_BASE + 0x94)
#define REG_DISP_MOP_ROT_4A_H     (REG_DISP_MOP_ROT_BASE + 0x95)
#define REG_DISP_MOP_ROT_4B_L     (REG_DISP_MOP_ROT_BASE + 0x96)
#define REG_DISP_MOP_ROT_4B_H     (REG_DISP_MOP_ROT_BASE + 0x97)
#define REG_DISP_MOP_ROT_4C_L     (REG_DISP_MOP_ROT_BASE + 0x98)
#define REG_DISP_MOP_ROT_4C_H     (REG_DISP_MOP_ROT_BASE + 0x99)
#define REG_DISP_MOP_ROT_4D_L     (REG_DISP_MOP_ROT_BASE + 0x9A)
#define REG_DISP_MOP_ROT_4D_H     (REG_DISP_MOP_ROT_BASE + 0x9B)
#define REG_DISP_MOP_ROT_4E_L     (REG_DISP_MOP_ROT_BASE + 0x9C)
#define REG_DISP_MOP_ROT_4E_H     (REG_DISP_MOP_ROT_BASE + 0x9D)
#define REG_DISP_MOP_ROT_4F_L     (REG_DISP_MOP_ROT_BASE + 0x9E)
#define REG_DISP_MOP_ROT_4F_H     (REG_DISP_MOP_ROT_BASE + 0x9F)
#define REG_DISP_MOP_ROT_50_L     (REG_DISP_MOP_ROT_BASE + 0xA0)
#define REG_DISP_MOP_ROT_50_H     (REG_DISP_MOP_ROT_BASE + 0xA1)
#define REG_DISP_MOP_ROT_51_L     (REG_DISP_MOP_ROT_BASE + 0xA2)
#define REG_DISP_MOP_ROT_51_H     (REG_DISP_MOP_ROT_BASE + 0xA3)
#define REG_DISP_MOP_ROT_52_L     (REG_DISP_MOP_ROT_BASE + 0xA4)
#define REG_DISP_MOP_ROT_52_H     (REG_DISP_MOP_ROT_BASE + 0xA5)
#define REG_DISP_MOP_ROT_53_L     (REG_DISP_MOP_ROT_BASE + 0xA6)
#define REG_DISP_MOP_ROT_53_H     (REG_DISP_MOP_ROT_BASE + 0xA7)
#define REG_DISP_MOP_ROT_54_L     (REG_DISP_MOP_ROT_BASE + 0xA8)
#define REG_DISP_MOP_ROT_54_H     (REG_DISP_MOP_ROT_BASE + 0xA9)
#define REG_DISP_MOP_ROT_55_L     (REG_DISP_MOP_ROT_BASE + 0xAA)
#define REG_DISP_MOP_ROT_55_H     (REG_DISP_MOP_ROT_BASE + 0xAB)
#define REG_DISP_MOP_ROT_56_L     (REG_DISP_MOP_ROT_BASE + 0xAC)
#define REG_DISP_MOP_ROT_56_H     (REG_DISP_MOP_ROT_BASE + 0xAD)
#define REG_DISP_MOP_ROT_57_L     (REG_DISP_MOP_ROT_BASE + 0xAE)
#define REG_DISP_MOP_ROT_57_H     (REG_DISP_MOP_ROT_BASE + 0xAF)
#define REG_DISP_MOP_ROT_58_L     (REG_DISP_MOP_ROT_BASE + 0xB0)
#define REG_DISP_MOP_ROT_58_H     (REG_DISP_MOP_ROT_BASE + 0xB1)
#define REG_DISP_MOP_ROT_59_L     (REG_DISP_MOP_ROT_BASE + 0xB2)
#define REG_DISP_MOP_ROT_59_H     (REG_DISP_MOP_ROT_BASE + 0xB3)
#define REG_DISP_MOP_ROT_5A_L     (REG_DISP_MOP_ROT_BASE + 0xB4)
#define REG_DISP_MOP_ROT_5A_H     (REG_DISP_MOP_ROT_BASE + 0xB5)
#define REG_DISP_MOP_ROT_5B_L     (REG_DISP_MOP_ROT_BASE + 0xB6)
#define REG_DISP_MOP_ROT_5B_H     (REG_DISP_MOP_ROT_BASE + 0xB7)
#define REG_DISP_MOP_ROT_5C_L     (REG_DISP_MOP_ROT_BASE + 0xB8)
#define REG_DISP_MOP_ROT_5C_H     (REG_DISP_MOP_ROT_BASE + 0xB9)
#define REG_DISP_MOP_ROT_5D_L     (REG_DISP_MOP_ROT_BASE + 0xBA)
#define REG_DISP_MOP_ROT_5D_H     (REG_DISP_MOP_ROT_BASE + 0xBB)
#define REG_DISP_MOP_ROT_5E_L     (REG_DISP_MOP_ROT_BASE + 0xBC)
#define REG_DISP_MOP_ROT_5E_H     (REG_DISP_MOP_ROT_BASE + 0xBD)
#define REG_DISP_MOP_ROT_5F_L     (REG_DISP_MOP_ROT_BASE + 0xBE)
#define REG_DISP_MOP_ROT_5F_H     (REG_DISP_MOP_ROT_BASE + 0xBF)
#define REG_DISP_MOP_ROT_60_L     (REG_DISP_MOP_ROT_BASE + 0xC0)
#define REG_DISP_MOP_ROT_60_H     (REG_DISP_MOP_ROT_BASE + 0xC1)
#define REG_DISP_MOP_ROT_61_L     (REG_DISP_MOP_ROT_BASE + 0xC2)
#define REG_DISP_MOP_ROT_61_H     (REG_DISP_MOP_ROT_BASE + 0xC3)
#define REG_DISP_MOP_ROT_62_L     (REG_DISP_MOP_ROT_BASE + 0xC4)
#define REG_DISP_MOP_ROT_62_H     (REG_DISP_MOP_ROT_BASE + 0xC5)
#define REG_DISP_MOP_ROT_63_L     (REG_DISP_MOP_ROT_BASE + 0xC6)
#define REG_DISP_MOP_ROT_63_H     (REG_DISP_MOP_ROT_BASE + 0xC7)
#define REG_DISP_MOP_ROT_64_L     (REG_DISP_MOP_ROT_BASE + 0xC8)
#define REG_DISP_MOP_ROT_64_H     (REG_DISP_MOP_ROT_BASE + 0xC9)
#define REG_DISP_MOP_ROT_65_L     (REG_DISP_MOP_ROT_BASE + 0xCA)
#define REG_DISP_MOP_ROT_65_H     (REG_DISP_MOP_ROT_BASE + 0xCB)
#define REG_DISP_MOP_ROT_66_L     (REG_DISP_MOP_ROT_BASE + 0xCC)
#define REG_DISP_MOP_ROT_66_H     (REG_DISP_MOP_ROT_BASE + 0xCD)
#define REG_DISP_MOP_ROT_67_L     (REG_DISP_MOP_ROT_BASE + 0xCE)
#define REG_DISP_MOP_ROT_67_H     (REG_DISP_MOP_ROT_BASE + 0xCF)
#define REG_DISP_MOP_ROT_68_L     (REG_DISP_MOP_ROT_BASE + 0xD0)
#define REG_DISP_MOP_ROT_68_H     (REG_DISP_MOP_ROT_BASE + 0xD1)
#define REG_DISP_MOP_ROT_69_L     (REG_DISP_MOP_ROT_BASE + 0xD2)
#define REG_DISP_MOP_ROT_69_H     (REG_DISP_MOP_ROT_BASE + 0xD3)
#define REG_DISP_MOP_ROT_6A_L     (REG_DISP_MOP_ROT_BASE + 0xD4)
#define REG_DISP_MOP_ROT_6A_H     (REG_DISP_MOP_ROT_BASE + 0xD5)
#define REG_DISP_MOP_ROT_6B_L     (REG_DISP_MOP_ROT_BASE + 0xD6)
#define REG_DISP_MOP_ROT_6B_H     (REG_DISP_MOP_ROT_BASE + 0xD7)
#define REG_DISP_MOP_ROT_6C_L     (REG_DISP_MOP_ROT_BASE + 0xD8)
#define REG_DISP_MOP_ROT_6C_H     (REG_DISP_MOP_ROT_BASE + 0xD9)
#define REG_DISP_MOP_ROT_6D_L     (REG_DISP_MOP_ROT_BASE + 0xDA)
#define REG_DISP_MOP_ROT_6D_H     (REG_DISP_MOP_ROT_BASE + 0xDB)
#define REG_DISP_MOP_ROT_6E_L     (REG_DISP_MOP_ROT_BASE + 0xDC)
#define REG_DISP_MOP_ROT_6E_H     (REG_DISP_MOP_ROT_BASE + 0xDD)
#define REG_DISP_MOP_ROT_6F_L     (REG_DISP_MOP_ROT_BASE + 0xDE)
#define REG_DISP_MOP_ROT_6F_H     (REG_DISP_MOP_ROT_BASE + 0xDF)
#define REG_DISP_MOP_ROT_70_L     (REG_DISP_MOP_ROT_BASE + 0xE0)
#define REG_DISP_MOP_ROT_70_H     (REG_DISP_MOP_ROT_BASE + 0xE1)
#define REG_DISP_MOP_ROT_71_L     (REG_DISP_MOP_ROT_BASE + 0xE2)
#define REG_DISP_MOP_ROT_71_H     (REG_DISP_MOP_ROT_BASE + 0xE3)
#define REG_DISP_MOP_ROT_72_L     (REG_DISP_MOP_ROT_BASE + 0xE4)
#define REG_DISP_MOP_ROT_72_H     (REG_DISP_MOP_ROT_BASE + 0xE5)
#define REG_DISP_MOP_ROT_73_L     (REG_DISP_MOP_ROT_BASE + 0xE6)
#define REG_DISP_MOP_ROT_73_H     (REG_DISP_MOP_ROT_BASE + 0xE7)
#define REG_DISP_MOP_ROT_74_L     (REG_DISP_MOP_ROT_BASE + 0xE8)
#define REG_DISP_MOP_ROT_74_H     (REG_DISP_MOP_ROT_BASE + 0xE9)
#define REG_DISP_MOP_ROT_75_L     (REG_DISP_MOP_ROT_BASE + 0xEA)
#define REG_DISP_MOP_ROT_75_H     (REG_DISP_MOP_ROT_BASE + 0xEB)
#define REG_DISP_MOP_ROT_76_L     (REG_DISP_MOP_ROT_BASE + 0xEC)
#define REG_DISP_MOP_ROT_76_H     (REG_DISP_MOP_ROT_BASE + 0xED)
#define REG_DISP_MOP_ROT_77_L     (REG_DISP_MOP_ROT_BASE + 0xEE)
#define REG_DISP_MOP_ROT_77_H     (REG_DISP_MOP_ROT_BASE + 0xEF)
#define REG_DISP_MOP_ROT_78_L     (REG_DISP_MOP_ROT_BASE + 0xF0)
#define REG_DISP_MOP_ROT_78_H     (REG_DISP_MOP_ROT_BASE + 0xF1)
#define REG_DISP_MOP_ROT_79_L     (REG_DISP_MOP_ROT_BASE + 0xF2)
#define REG_DISP_MOP_ROT_79_H     (REG_DISP_MOP_ROT_BASE + 0xF3)
#define REG_DISP_MOP_ROT_7A_L     (REG_DISP_MOP_ROT_BASE + 0xF4)
#define REG_DISP_MOP_ROT_7A_H     (REG_DISP_MOP_ROT_BASE + 0xF5)
#define REG_DISP_MOP_ROT_7B_L     (REG_DISP_MOP_ROT_BASE + 0xF6)
#define REG_DISP_MOP_ROT_7B_H     (REG_DISP_MOP_ROT_BASE + 0xF7)
#define REG_DISP_MOP_ROT_7C_L     (REG_DISP_MOP_ROT_BASE + 0xF8)
#define REG_DISP_MOP_ROT_7C_H     (REG_DISP_MOP_ROT_BASE + 0xF9)
#define REG_DISP_MOP_ROT_7D_L     (REG_DISP_MOP_ROT_BASE + 0xFA)
#define REG_DISP_MOP_ROT_7D_H     (REG_DISP_MOP_ROT_BASE + 0xFB)
#define REG_DISP_MOP_ROT_7E_L     (REG_DISP_MOP_ROT_BASE + 0xFC)
#define REG_DISP_MOP_ROT_7E_H     (REG_DISP_MOP_ROT_BASE + 0xFD)
#define REG_DISP_MOP_ROT_7F_L     (REG_DISP_MOP_ROT_BASE + 0xFE)
#define REG_DISP_MOP_ROT_7F_H     (REG_DISP_MOP_ROT_BASE + 0xFF)


#define REG_DISP_DAC_00_L         (REG_DISP_DAC_BASE + 0x00)
#define REG_DISP_DAC_00_H         (REG_DISP_DAC_BASE + 0x01)
#define REG_DISP_DAC_01_L         (REG_DISP_DAC_BASE + 0x02)
#define REG_DISP_DAC_01_H         (REG_DISP_DAC_BASE + 0x03)
#define REG_DISP_DAC_02_L         (REG_DISP_DAC_BASE + 0x04)
#define REG_DISP_DAC_02_H         (REG_DISP_DAC_BASE + 0x05)
#define REG_DISP_DAC_03_L         (REG_DISP_DAC_BASE + 0x06)
#define REG_DISP_DAC_03_H         (REG_DISP_DAC_BASE + 0x07)
#define REG_DISP_DAC_04_L         (REG_DISP_DAC_BASE + 0x08)
#define REG_DISP_DAC_04_H         (REG_DISP_DAC_BASE + 0x09)
#define REG_DISP_DAC_05_L         (REG_DISP_DAC_BASE + 0x0A)
#define REG_DISP_DAC_05_H         (REG_DISP_DAC_BASE + 0x0B)
#define REG_DISP_DAC_06_L         (REG_DISP_DAC_BASE + 0x0C)
#define REG_DISP_DAC_06_H         (REG_DISP_DAC_BASE + 0x0D)
#define REG_DISP_DAC_07_L         (REG_DISP_DAC_BASE + 0x0E)
#define REG_DISP_DAC_07_H         (REG_DISP_DAC_BASE + 0x0F)
#define REG_DISP_DAC_08_L         (REG_DISP_DAC_BASE + 0x10)
#define REG_DISP_DAC_08_H         (REG_DISP_DAC_BASE + 0x11)
#define REG_DISP_DAC_09_L         (REG_DISP_DAC_BASE + 0x12)
#define REG_DISP_DAC_09_H         (REG_DISP_DAC_BASE + 0x13)
#define REG_DISP_DAC_0A_L         (REG_DISP_DAC_BASE + 0x14)
#define REG_DISP_DAC_0A_H         (REG_DISP_DAC_BASE + 0x15)
#define REG_DISP_DAC_0B_L         (REG_DISP_DAC_BASE + 0x16)
#define REG_DISP_DAC_0B_H         (REG_DISP_DAC_BASE + 0x17)
#define REG_DISP_DAC_0C_L         (REG_DISP_DAC_BASE + 0x18)
#define REG_DISP_DAC_0C_H         (REG_DISP_DAC_BASE + 0x19)
#define REG_DISP_DAC_0D_L         (REG_DISP_DAC_BASE + 0x1A)
#define REG_DISP_DAC_0D_H         (REG_DISP_DAC_BASE + 0x1B)
#define REG_DISP_DAC_0E_L         (REG_DISP_DAC_BASE + 0x1C)
#define REG_DISP_DAC_0E_H         (REG_DISP_DAC_BASE + 0x1D)
#define REG_DISP_DAC_0F_L         (REG_DISP_DAC_BASE + 0x1E)
#define REG_DISP_DAC_0F_H         (REG_DISP_DAC_BASE + 0x1F)
#define REG_DISP_DAC_10_L         (REG_DISP_DAC_BASE + 0x20)
#define REG_DISP_DAC_10_H         (REG_DISP_DAC_BASE + 0x21)
#define REG_DISP_DAC_11_L         (REG_DISP_DAC_BASE + 0x22)
#define REG_DISP_DAC_11_H         (REG_DISP_DAC_BASE + 0x23)
#define REG_DISP_DAC_12_L         (REG_DISP_DAC_BASE + 0x24)
#define REG_DISP_DAC_12_H         (REG_DISP_DAC_BASE + 0x25)
#define REG_DISP_DAC_13_L         (REG_DISP_DAC_BASE + 0x26)
#define REG_DISP_DAC_13_H         (REG_DISP_DAC_BASE + 0x27)
#define REG_DISP_DAC_14_L         (REG_DISP_DAC_BASE + 0x28)
#define REG_DISP_DAC_14_H         (REG_DISP_DAC_BASE + 0x29)
#define REG_DISP_DAC_15_L         (REG_DISP_DAC_BASE + 0x2A)
#define REG_DISP_DAC_15_H         (REG_DISP_DAC_BASE + 0x2B)
#define REG_DISP_DAC_16_L         (REG_DISP_DAC_BASE + 0x2C)
#define REG_DISP_DAC_16_H         (REG_DISP_DAC_BASE + 0x2D)
#define REG_DISP_DAC_17_L         (REG_DISP_DAC_BASE + 0x2E)
#define REG_DISP_DAC_17_H         (REG_DISP_DAC_BASE + 0x2F)
#define REG_DISP_DAC_18_L         (REG_DISP_DAC_BASE + 0x30)
#define REG_DISP_DAC_18_H         (REG_DISP_DAC_BASE + 0x31)
#define REG_DISP_DAC_19_L         (REG_DISP_DAC_BASE + 0x32)
#define REG_DISP_DAC_19_H         (REG_DISP_DAC_BASE + 0x33)
#define REG_DISP_DAC_1A_L         (REG_DISP_DAC_BASE + 0x34)
#define REG_DISP_DAC_1A_H         (REG_DISP_DAC_BASE + 0x35)
#define REG_DISP_DAC_1B_L         (REG_DISP_DAC_BASE + 0x36)
#define REG_DISP_DAC_1B_H         (REG_DISP_DAC_BASE + 0x37)
#define REG_DISP_DAC_1C_L         (REG_DISP_DAC_BASE + 0x38)
#define REG_DISP_DAC_1C_H         (REG_DISP_DAC_BASE + 0x39)
#define REG_DISP_DAC_1D_L         (REG_DISP_DAC_BASE + 0x3A)
#define REG_DISP_DAC_1D_H         (REG_DISP_DAC_BASE + 0x3B)
#define REG_DISP_DAC_1E_L         (REG_DISP_DAC_BASE + 0x3C)
#define REG_DISP_DAC_1E_H         (REG_DISP_DAC_BASE + 0x3D)
#define REG_DISP_DAC_1F_L         (REG_DISP_DAC_BASE + 0x3E)
#define REG_DISP_DAC_1F_H         (REG_DISP_DAC_BASE + 0x3F)
#define REG_DISP_DAC_20_L         (REG_DISP_DAC_BASE + 0x40)
#define REG_DISP_DAC_20_H         (REG_DISP_DAC_BASE + 0x41)
#define REG_DISP_DAC_21_L         (REG_DISP_DAC_BASE + 0x42)
#define REG_DISP_DAC_21_H         (REG_DISP_DAC_BASE + 0x43)
#define REG_DISP_DAC_22_L         (REG_DISP_DAC_BASE + 0x44)
#define REG_DISP_DAC_22_H         (REG_DISP_DAC_BASE + 0x45)
#define REG_DISP_DAC_23_L         (REG_DISP_DAC_BASE + 0x46)
#define REG_DISP_DAC_23_H         (REG_DISP_DAC_BASE + 0x47)
#define REG_DISP_DAC_24_L         (REG_DISP_DAC_BASE + 0x48)
#define REG_DISP_DAC_24_H         (REG_DISP_DAC_BASE + 0x49)
#define REG_DISP_DAC_25_L         (REG_DISP_DAC_BASE + 0x4A)
#define REG_DISP_DAC_25_H         (REG_DISP_DAC_BASE + 0x4B)
#define REG_DISP_DAC_26_L         (REG_DISP_DAC_BASE + 0x4C)
#define REG_DISP_DAC_26_H         (REG_DISP_DAC_BASE + 0x4D)
#define REG_DISP_DAC_27_L         (REG_DISP_DAC_BASE + 0x4E)
#define REG_DISP_DAC_27_H         (REG_DISP_DAC_BASE + 0x4F)
#define REG_DISP_DAC_28_L         (REG_DISP_DAC_BASE + 0x50)
#define REG_DISP_DAC_28_H         (REG_DISP_DAC_BASE + 0x51)
#define REG_DISP_DAC_29_L         (REG_DISP_DAC_BASE + 0x52)
#define REG_DISP_DAC_29_H         (REG_DISP_DAC_BASE + 0x53)
#define REG_DISP_DAC_2A_L         (REG_DISP_DAC_BASE + 0x54)
#define REG_DISP_DAC_2A_H         (REG_DISP_DAC_BASE + 0x55)
#define REG_DISP_DAC_2B_L         (REG_DISP_DAC_BASE + 0x56)
#define REG_DISP_DAC_2B_H         (REG_DISP_DAC_BASE + 0x57)
#define REG_DISP_DAC_2C_L         (REG_DISP_DAC_BASE + 0x58)
#define REG_DISP_DAC_2C_H         (REG_DISP_DAC_BASE + 0x59)
#define REG_DISP_DAC_2D_L         (REG_DISP_DAC_BASE + 0x5A)
#define REG_DISP_DAC_2D_H         (REG_DISP_DAC_BASE + 0x5B)
#define REG_DISP_DAC_2E_L         (REG_DISP_DAC_BASE + 0x5C)
#define REG_DISP_DAC_2E_H         (REG_DISP_DAC_BASE + 0x5D)
#define REG_DISP_DAC_2F_L         (REG_DISP_DAC_BASE + 0x5E)
#define REG_DISP_DAC_2F_H         (REG_DISP_DAC_BASE + 0x5F)
#define REG_DISP_DAC_30_L         (REG_DISP_DAC_BASE + 0x60)
#define REG_DISP_DAC_30_H         (REG_DISP_DAC_BASE + 0x61)
#define REG_DISP_DAC_31_L         (REG_DISP_DAC_BASE + 0x62)
#define REG_DISP_DAC_31_H         (REG_DISP_DAC_BASE + 0x63)
#define REG_DISP_DAC_32_L         (REG_DISP_DAC_BASE + 0x64)
#define REG_DISP_DAC_32_H         (REG_DISP_DAC_BASE + 0x65)
#define REG_DISP_DAC_33_L         (REG_DISP_DAC_BASE + 0x66)
#define REG_DISP_DAC_33_H         (REG_DISP_DAC_BASE + 0x67)
#define REG_DISP_DAC_34_L         (REG_DISP_DAC_BASE + 0x68)
#define REG_DISP_DAC_34_H         (REG_DISP_DAC_BASE + 0x69)
#define REG_DISP_DAC_35_L         (REG_DISP_DAC_BASE + 0x6A)
#define REG_DISP_DAC_35_H         (REG_DISP_DAC_BASE + 0x6B)
#define REG_DISP_DAC_36_L         (REG_DISP_DAC_BASE + 0x6C)
#define REG_DISP_DAC_36_H         (REG_DISP_DAC_BASE + 0x6D)
#define REG_DISP_DAC_37_L         (REG_DISP_DAC_BASE + 0x6E)
#define REG_DISP_DAC_37_H         (REG_DISP_DAC_BASE + 0x6F)
#define REG_DISP_DAC_38_L         (REG_DISP_DAC_BASE + 0x70)
#define REG_DISP_DAC_38_H         (REG_DISP_DAC_BASE + 0x71)
#define REG_DISP_DAC_39_L         (REG_DISP_DAC_BASE + 0x72)
#define REG_DISP_DAC_39_H         (REG_DISP_DAC_BASE + 0x73)
#define REG_DISP_DAC_3A_L         (REG_DISP_DAC_BASE + 0x74)
#define REG_DISP_DAC_3A_H         (REG_DISP_DAC_BASE + 0x75)
#define REG_DISP_DAC_3B_L         (REG_DISP_DAC_BASE + 0x76)
#define REG_DISP_DAC_3B_H         (REG_DISP_DAC_BASE + 0x77)
#define REG_DISP_DAC_3C_L         (REG_DISP_DAC_BASE + 0x78)
#define REG_DISP_DAC_3C_H         (REG_DISP_DAC_BASE + 0x79)
#define REG_DISP_DAC_3D_L         (REG_DISP_DAC_BASE + 0x7A)
#define REG_DISP_DAC_3D_H         (REG_DISP_DAC_BASE + 0x7B)
#define REG_DISP_DAC_3E_L         (REG_DISP_DAC_BASE + 0x7C)
#define REG_DISP_DAC_3E_H         (REG_DISP_DAC_BASE + 0x7D)
#define REG_DISP_DAC_3F_L         (REG_DISP_DAC_BASE + 0x7E)
#define REG_DISP_DAC_3F_H         (REG_DISP_DAC_BASE + 0x7F)
#define REG_DISP_DAC_40_L         (REG_DISP_DAC_BASE + 0x80)
#define REG_DISP_DAC_40_H         (REG_DISP_DAC_BASE + 0x81)
#define REG_DISP_DAC_41_L         (REG_DISP_DAC_BASE + 0x82)
#define REG_DISP_DAC_41_H         (REG_DISP_DAC_BASE + 0x83)
#define REG_DISP_DAC_42_L         (REG_DISP_DAC_BASE + 0x84)
#define REG_DISP_DAC_42_H         (REG_DISP_DAC_BASE + 0x85)
#define REG_DISP_DAC_43_L         (REG_DISP_DAC_BASE + 0x86)
#define REG_DISP_DAC_43_H         (REG_DISP_DAC_BASE + 0x87)
#define REG_DISP_DAC_44_L         (REG_DISP_DAC_BASE + 0x88)
#define REG_DISP_DAC_44_H         (REG_DISP_DAC_BASE + 0x89)
#define REG_DISP_DAC_45_L         (REG_DISP_DAC_BASE + 0x8A)
#define REG_DISP_DAC_45_H         (REG_DISP_DAC_BASE + 0x8B)
#define REG_DISP_DAC_46_L         (REG_DISP_DAC_BASE + 0x8C)
#define REG_DISP_DAC_46_H         (REG_DISP_DAC_BASE + 0x8D)
#define REG_DISP_DAC_47_L         (REG_DISP_DAC_BASE + 0x8E)
#define REG_DISP_DAC_47_H         (REG_DISP_DAC_BASE + 0x8F)
#define REG_DISP_DAC_48_L         (REG_DISP_DAC_BASE + 0x90)
#define REG_DISP_DAC_48_H         (REG_DISP_DAC_BASE + 0x91)
#define REG_DISP_DAC_49_L         (REG_DISP_DAC_BASE + 0x92)
#define REG_DISP_DAC_49_H         (REG_DISP_DAC_BASE + 0x93)
#define REG_DISP_DAC_4A_L         (REG_DISP_DAC_BASE + 0x94)
#define REG_DISP_DAC_4A_H         (REG_DISP_DAC_BASE + 0x95)
#define REG_DISP_DAC_4B_L         (REG_DISP_DAC_BASE + 0x96)
#define REG_DISP_DAC_4B_H         (REG_DISP_DAC_BASE + 0x97)
#define REG_DISP_DAC_4C_L         (REG_DISP_DAC_BASE + 0x98)
#define REG_DISP_DAC_4C_H         (REG_DISP_DAC_BASE + 0x99)
#define REG_DISP_DAC_4D_L         (REG_DISP_DAC_BASE + 0x9A)
#define REG_DISP_DAC_4D_H         (REG_DISP_DAC_BASE + 0x9B)
#define REG_DISP_DAC_4E_L         (REG_DISP_DAC_BASE + 0x9C)
#define REG_DISP_DAC_4E_H         (REG_DISP_DAC_BASE + 0x9D)
#define REG_DISP_DAC_4F_L         (REG_DISP_DAC_BASE + 0x9E)
#define REG_DISP_DAC_4F_H         (REG_DISP_DAC_BASE + 0x9F)
#define REG_DISP_DAC_50_L         (REG_DISP_DAC_BASE + 0xA0)
#define REG_DISP_DAC_50_H         (REG_DISP_DAC_BASE + 0xA1)
#define REG_DISP_DAC_51_L         (REG_DISP_DAC_BASE + 0xA2)
#define REG_DISP_DAC_51_H         (REG_DISP_DAC_BASE + 0xA3)
#define REG_DISP_DAC_52_L         (REG_DISP_DAC_BASE + 0xA4)
#define REG_DISP_DAC_52_H         (REG_DISP_DAC_BASE + 0xA5)
#define REG_DISP_DAC_53_L         (REG_DISP_DAC_BASE + 0xA6)
#define REG_DISP_DAC_53_H         (REG_DISP_DAC_BASE + 0xA7)
#define REG_DISP_DAC_54_L         (REG_DISP_DAC_BASE + 0xA8)
#define REG_DISP_DAC_54_H         (REG_DISP_DAC_BASE + 0xA9)
#define REG_DISP_DAC_55_L         (REG_DISP_DAC_BASE + 0xAA)
#define REG_DISP_DAC_55_H         (REG_DISP_DAC_BASE + 0xAB)
#define REG_DISP_DAC_56_L         (REG_DISP_DAC_BASE + 0xAC)
#define REG_DISP_DAC_56_H         (REG_DISP_DAC_BASE + 0xAD)
#define REG_DISP_DAC_57_L         (REG_DISP_DAC_BASE + 0xAE)
#define REG_DISP_DAC_57_H         (REG_DISP_DAC_BASE + 0xAF)
#define REG_DISP_DAC_58_L         (REG_DISP_DAC_BASE + 0xB0)
#define REG_DISP_DAC_58_H         (REG_DISP_DAC_BASE + 0xB1)
#define REG_DISP_DAC_59_L         (REG_DISP_DAC_BASE + 0xB2)
#define REG_DISP_DAC_59_H         (REG_DISP_DAC_BASE + 0xB3)
#define REG_DISP_DAC_5A_L         (REG_DISP_DAC_BASE + 0xB4)
#define REG_DISP_DAC_5A_H         (REG_DISP_DAC_BASE + 0xB5)
#define REG_DISP_DAC_5B_L         (REG_DISP_DAC_BASE + 0xB6)
#define REG_DISP_DAC_5B_H         (REG_DISP_DAC_BASE + 0xB7)
#define REG_DISP_DAC_5C_L         (REG_DISP_DAC_BASE + 0xB8)
#define REG_DISP_DAC_5C_H         (REG_DISP_DAC_BASE + 0xB9)
#define REG_DISP_DAC_5D_L         (REG_DISP_DAC_BASE + 0xBA)
#define REG_DISP_DAC_5D_H         (REG_DISP_DAC_BASE + 0xBB)
#define REG_DISP_DAC_5E_L         (REG_DISP_DAC_BASE + 0xBC)
#define REG_DISP_DAC_5E_H         (REG_DISP_DAC_BASE + 0xBD)
#define REG_DISP_DAC_5F_L         (REG_DISP_DAC_BASE + 0xBE)
#define REG_DISP_DAC_5F_H         (REG_DISP_DAC_BASE + 0xBF)
#define REG_DISP_DAC_60_L         (REG_DISP_DAC_BASE + 0xC0)
#define REG_DISP_DAC_60_H         (REG_DISP_DAC_BASE + 0xC1)
#define REG_DISP_DAC_61_L         (REG_DISP_DAC_BASE + 0xC2)
#define REG_DISP_DAC_61_H         (REG_DISP_DAC_BASE + 0xC3)
#define REG_DISP_DAC_62_L         (REG_DISP_DAC_BASE + 0xC4)
#define REG_DISP_DAC_62_H         (REG_DISP_DAC_BASE + 0xC5)
#define REG_DISP_DAC_63_L         (REG_DISP_DAC_BASE + 0xC6)
#define REG_DISP_DAC_63_H         (REG_DISP_DAC_BASE + 0xC7)
#define REG_DISP_DAC_64_L         (REG_DISP_DAC_BASE + 0xC8)
#define REG_DISP_DAC_64_H         (REG_DISP_DAC_BASE + 0xC9)
#define REG_DISP_DAC_65_L         (REG_DISP_DAC_BASE + 0xCA)
#define REG_DISP_DAC_65_H         (REG_DISP_DAC_BASE + 0xCB)
#define REG_DISP_DAC_66_L         (REG_DISP_DAC_BASE + 0xCC)
#define REG_DISP_DAC_66_H         (REG_DISP_DAC_BASE + 0xCD)
#define REG_DISP_DAC_67_L         (REG_DISP_DAC_BASE + 0xCE)
#define REG_DISP_DAC_67_H         (REG_DISP_DAC_BASE + 0xCF)
#define REG_DISP_DAC_68_L         (REG_DISP_DAC_BASE + 0xD0)
#define REG_DISP_DAC_68_H         (REG_DISP_DAC_BASE + 0xD1)
#define REG_DISP_DAC_69_L         (REG_DISP_DAC_BASE + 0xD2)
#define REG_DISP_DAC_69_H         (REG_DISP_DAC_BASE + 0xD3)
#define REG_DISP_DAC_6A_L         (REG_DISP_DAC_BASE + 0xD4)
#define REG_DISP_DAC_6A_H         (REG_DISP_DAC_BASE + 0xD5)
#define REG_DISP_DAC_6B_L         (REG_DISP_DAC_BASE + 0xD6)
#define REG_DISP_DAC_6B_H         (REG_DISP_DAC_BASE + 0xD7)
#define REG_DISP_DAC_6C_L         (REG_DISP_DAC_BASE + 0xD8)
#define REG_DISP_DAC_6C_H         (REG_DISP_DAC_BASE + 0xD9)
#define REG_DISP_DAC_6D_L         (REG_DISP_DAC_BASE + 0xDA)
#define REG_DISP_DAC_6D_H         (REG_DISP_DAC_BASE + 0xDB)
#define REG_DISP_DAC_6E_L         (REG_DISP_DAC_BASE + 0xDC)
#define REG_DISP_DAC_6E_H         (REG_DISP_DAC_BASE + 0xDD)
#define REG_DISP_DAC_6F_L         (REG_DISP_DAC_BASE + 0xDE)
#define REG_DISP_DAC_6F_H         (REG_DISP_DAC_BASE + 0xDF)
#define REG_DISP_DAC_70_L         (REG_DISP_DAC_BASE + 0xE0)
#define REG_DISP_DAC_70_H         (REG_DISP_DAC_BASE + 0xE1)
#define REG_DISP_DAC_71_L         (REG_DISP_DAC_BASE + 0xE2)
#define REG_DISP_DAC_71_H         (REG_DISP_DAC_BASE + 0xE3)
#define REG_DISP_DAC_72_L         (REG_DISP_DAC_BASE + 0xE4)
#define REG_DISP_DAC_72_H         (REG_DISP_DAC_BASE + 0xE5)
#define REG_DISP_DAC_73_L         (REG_DISP_DAC_BASE + 0xE6)
#define REG_DISP_DAC_73_H         (REG_DISP_DAC_BASE + 0xE7)
#define REG_DISP_DAC_74_L         (REG_DISP_DAC_BASE + 0xE8)
#define REG_DISP_DAC_74_H         (REG_DISP_DAC_BASE + 0xE9)
#define REG_DISP_DAC_75_L         (REG_DISP_DAC_BASE + 0xEA)
#define REG_DISP_DAC_75_H         (REG_DISP_DAC_BASE + 0xEB)
#define REG_DISP_DAC_76_L         (REG_DISP_DAC_BASE + 0xEC)
#define REG_DISP_DAC_76_H         (REG_DISP_DAC_BASE + 0xED)
#define REG_DISP_DAC_77_L         (REG_DISP_DAC_BASE + 0xEE)
#define REG_DISP_DAC_77_H         (REG_DISP_DAC_BASE + 0xEF)
#define REG_DISP_DAC_78_L         (REG_DISP_DAC_BASE + 0xF0)
#define REG_DISP_DAC_78_H         (REG_DISP_DAC_BASE + 0xF1)
#define REG_DISP_DAC_79_L         (REG_DISP_DAC_BASE + 0xF2)
#define REG_DISP_DAC_79_H         (REG_DISP_DAC_BASE + 0xF3)
#define REG_DISP_DAC_7A_L         (REG_DISP_DAC_BASE + 0xF4)
#define REG_DISP_DAC_7A_H         (REG_DISP_DAC_BASE + 0xF5)
#define REG_DISP_DAC_7B_L         (REG_DISP_DAC_BASE + 0xF6)
#define REG_DISP_DAC_7B_H         (REG_DISP_DAC_BASE + 0xF7)
#define REG_DISP_DAC_7C_L         (REG_DISP_DAC_BASE + 0xF8)
#define REG_DISP_DAC_7C_H         (REG_DISP_DAC_BASE + 0xF9)
#define REG_DISP_DAC_7D_L         (REG_DISP_DAC_BASE + 0xFA)
#define REG_DISP_DAC_7D_H         (REG_DISP_DAC_BASE + 0xFB)
#define REG_DISP_DAC_7E_L         (REG_DISP_DAC_BASE + 0xFC)
#define REG_DISP_DAC_7E_H         (REG_DISP_DAC_BASE + 0xFD)
#define REG_DISP_DAC_7F_L         (REG_DISP_DAC_BASE + 0xFE)
#define REG_DISP_DAC_7F_H         (REG_DISP_DAC_BASE + 0xFF)

#define REG_HDMITX_DTOP_00_L         (REG_HDMITX_DTOP_BASE + 0x00)
#define REG_HDMITX_DTOP_00_H         (REG_HDMITX_DTOP_BASE + 0x01)
#define REG_HDMITX_DTOP_01_L         (REG_HDMITX_DTOP_BASE + 0x02)
#define REG_HDMITX_DTOP_01_H         (REG_HDMITX_DTOP_BASE + 0x03)
#define REG_HDMITX_DTOP_02_L         (REG_HDMITX_DTOP_BASE + 0x04)
#define REG_HDMITX_DTOP_02_H         (REG_HDMITX_DTOP_BASE + 0x05)
#define REG_HDMITX_DTOP_03_L         (REG_HDMITX_DTOP_BASE + 0x06)
#define REG_HDMITX_DTOP_03_H         (REG_HDMITX_DTOP_BASE + 0x07)
#define REG_HDMITX_DTOP_04_L         (REG_HDMITX_DTOP_BASE + 0x08)
#define REG_HDMITX_DTOP_04_H         (REG_HDMITX_DTOP_BASE + 0x09)
#define REG_HDMITX_DTOP_05_L         (REG_HDMITX_DTOP_BASE + 0x0A)
#define REG_HDMITX_DTOP_05_H         (REG_HDMITX_DTOP_BASE + 0x0B)
#define REG_HDMITX_DTOP_06_L         (REG_HDMITX_DTOP_BASE + 0x0C)
#define REG_HDMITX_DTOP_06_H         (REG_HDMITX_DTOP_BASE + 0x0D)
#define REG_HDMITX_DTOP_07_L         (REG_HDMITX_DTOP_BASE + 0x0E)
#define REG_HDMITX_DTOP_07_H         (REG_HDMITX_DTOP_BASE + 0x0F)
#define REG_HDMITX_DTOP_08_L         (REG_HDMITX_DTOP_BASE + 0x10)
#define REG_HDMITX_DTOP_08_H         (REG_HDMITX_DTOP_BASE + 0x11)
#define REG_HDMITX_DTOP_09_L         (REG_HDMITX_DTOP_BASE + 0x12)
#define REG_HDMITX_DTOP_09_H         (REG_HDMITX_DTOP_BASE + 0x13)
#define REG_HDMITX_DTOP_0A_L         (REG_HDMITX_DTOP_BASE + 0x14)
#define REG_HDMITX_DTOP_0A_H         (REG_HDMITX_DTOP_BASE + 0x15)
#define REG_HDMITX_DTOP_0B_L         (REG_HDMITX_DTOP_BASE + 0x16)
#define REG_HDMITX_DTOP_0B_H         (REG_HDMITX_DTOP_BASE + 0x17)
#define REG_HDMITX_DTOP_0C_L         (REG_HDMITX_DTOP_BASE + 0x18)
#define REG_HDMITX_DTOP_0C_H         (REG_HDMITX_DTOP_BASE + 0x19)
#define REG_HDMITX_DTOP_0D_L         (REG_HDMITX_DTOP_BASE + 0x1A)
#define REG_HDMITX_DTOP_0D_H         (REG_HDMITX_DTOP_BASE + 0x1B)
#define REG_HDMITX_DTOP_0E_L         (REG_HDMITX_DTOP_BASE + 0x1C)
#define REG_HDMITX_DTOP_0E_H         (REG_HDMITX_DTOP_BASE + 0x1D)
#define REG_HDMITX_DTOP_0F_L         (REG_HDMITX_DTOP_BASE + 0x1E)
#define REG_HDMITX_DTOP_0F_H         (REG_HDMITX_DTOP_BASE + 0x1F)
#define REG_HDMITX_DTOP_10_L         (REG_HDMITX_DTOP_BASE + 0x20)
#define REG_HDMITX_DTOP_10_H         (REG_HDMITX_DTOP_BASE + 0x21)
#define REG_HDMITX_DTOP_11_L         (REG_HDMITX_DTOP_BASE + 0x22)
#define REG_HDMITX_DTOP_11_H         (REG_HDMITX_DTOP_BASE + 0x23)
#define REG_HDMITX_DTOP_12_L         (REG_HDMITX_DTOP_BASE + 0x24)
#define REG_HDMITX_DTOP_12_H         (REG_HDMITX_DTOP_BASE + 0x25)
#define REG_HDMITX_DTOP_13_L         (REG_HDMITX_DTOP_BASE + 0x26)
#define REG_HDMITX_DTOP_13_H         (REG_HDMITX_DTOP_BASE + 0x27)
#define REG_HDMITX_DTOP_14_L         (REG_HDMITX_DTOP_BASE + 0x28)
#define REG_HDMITX_DTOP_14_H         (REG_HDMITX_DTOP_BASE + 0x29)
#define REG_HDMITX_DTOP_15_L         (REG_HDMITX_DTOP_BASE + 0x2A)
#define REG_HDMITX_DTOP_15_H         (REG_HDMITX_DTOP_BASE + 0x2B)
#define REG_HDMITX_DTOP_16_L         (REG_HDMITX_DTOP_BASE + 0x2C)
#define REG_HDMITX_DTOP_16_H         (REG_HDMITX_DTOP_BASE + 0x2D)
#define REG_HDMITX_DTOP_17_L         (REG_HDMITX_DTOP_BASE + 0x2E)
#define REG_HDMITX_DTOP_17_H         (REG_HDMITX_DTOP_BASE + 0x2F)
#define REG_HDMITX_DTOP_18_L         (REG_HDMITX_DTOP_BASE + 0x30)
#define REG_HDMITX_DTOP_18_H         (REG_HDMITX_DTOP_BASE + 0x31)
#define REG_HDMITX_DTOP_19_L         (REG_HDMITX_DTOP_BASE + 0x32)
#define REG_HDMITX_DTOP_19_H         (REG_HDMITX_DTOP_BASE + 0x33)
#define REG_HDMITX_DTOP_1A_L         (REG_HDMITX_DTOP_BASE + 0x34)
#define REG_HDMITX_DTOP_1A_H         (REG_HDMITX_DTOP_BASE + 0x35)
#define REG_HDMITX_DTOP_1B_L         (REG_HDMITX_DTOP_BASE + 0x36)
#define REG_HDMITX_DTOP_1B_H         (REG_HDMITX_DTOP_BASE + 0x37)
#define REG_HDMITX_DTOP_1C_L         (REG_HDMITX_DTOP_BASE + 0x38)
#define REG_HDMITX_DTOP_1C_H         (REG_HDMITX_DTOP_BASE + 0x39)
#define REG_HDMITX_DTOP_1D_L         (REG_HDMITX_DTOP_BASE + 0x3A)
#define REG_HDMITX_DTOP_1D_H         (REG_HDMITX_DTOP_BASE + 0x3B)
#define REG_HDMITX_DTOP_1E_L         (REG_HDMITX_DTOP_BASE + 0x3C)
#define REG_HDMITX_DTOP_1E_H         (REG_HDMITX_DTOP_BASE + 0x3D)
#define REG_HDMITX_DTOP_1F_L         (REG_HDMITX_DTOP_BASE + 0x3E)
#define REG_HDMITX_DTOP_1F_H         (REG_HDMITX_DTOP_BASE + 0x3F)
#define REG_HDMITX_DTOP_20_L         (REG_HDMITX_DTOP_BASE + 0x40)
#define REG_HDMITX_DTOP_20_H         (REG_HDMITX_DTOP_BASE + 0x41)
#define REG_HDMITX_DTOP_21_L         (REG_HDMITX_DTOP_BASE + 0x42)
#define REG_HDMITX_DTOP_21_H         (REG_HDMITX_DTOP_BASE + 0x43)
#define REG_HDMITX_DTOP_22_L         (REG_HDMITX_DTOP_BASE + 0x44)
#define REG_HDMITX_DTOP_22_H         (REG_HDMITX_DTOP_BASE + 0x45)
#define REG_HDMITX_DTOP_23_L         (REG_HDMITX_DTOP_BASE + 0x46)
#define REG_HDMITX_DTOP_23_H         (REG_HDMITX_DTOP_BASE + 0x47)
#define REG_HDMITX_DTOP_24_L         (REG_HDMITX_DTOP_BASE + 0x48)
#define REG_HDMITX_DTOP_24_H         (REG_HDMITX_DTOP_BASE + 0x49)
#define REG_HDMITX_DTOP_25_L         (REG_HDMITX_DTOP_BASE + 0x4A)
#define REG_HDMITX_DTOP_25_H         (REG_HDMITX_DTOP_BASE + 0x4B)
#define REG_HDMITX_DTOP_26_L         (REG_HDMITX_DTOP_BASE + 0x4C)
#define REG_HDMITX_DTOP_26_H         (REG_HDMITX_DTOP_BASE + 0x4D)
#define REG_HDMITX_DTOP_27_L         (REG_HDMITX_DTOP_BASE + 0x4E)
#define REG_HDMITX_DTOP_27_H         (REG_HDMITX_DTOP_BASE + 0x4F)
#define REG_HDMITX_DTOP_28_L         (REG_HDMITX_DTOP_BASE + 0x50)
#define REG_HDMITX_DTOP_28_H         (REG_HDMITX_DTOP_BASE + 0x51)
#define REG_HDMITX_DTOP_29_L         (REG_HDMITX_DTOP_BASE + 0x52)
#define REG_HDMITX_DTOP_29_H         (REG_HDMITX_DTOP_BASE + 0x53)
#define REG_HDMITX_DTOP_2A_L         (REG_HDMITX_DTOP_BASE + 0x54)
#define REG_HDMITX_DTOP_2A_H         (REG_HDMITX_DTOP_BASE + 0x55)
#define REG_HDMITX_DTOP_2B_L         (REG_HDMITX_DTOP_BASE + 0x56)
#define REG_HDMITX_DTOP_2B_H         (REG_HDMITX_DTOP_BASE + 0x57)
#define REG_HDMITX_DTOP_2C_L         (REG_HDMITX_DTOP_BASE + 0x58)
#define REG_HDMITX_DTOP_2C_H         (REG_HDMITX_DTOP_BASE + 0x59)
#define REG_HDMITX_DTOP_2D_L         (REG_HDMITX_DTOP_BASE + 0x5A)
#define REG_HDMITX_DTOP_2D_H         (REG_HDMITX_DTOP_BASE + 0x5B)
#define REG_HDMITX_DTOP_2E_L         (REG_HDMITX_DTOP_BASE + 0x5C)
#define REG_HDMITX_DTOP_2E_H         (REG_HDMITX_DTOP_BASE + 0x5D)
#define REG_HDMITX_DTOP_2F_L         (REG_HDMITX_DTOP_BASE + 0x5E)
#define REG_HDMITX_DTOP_2F_H         (REG_HDMITX_DTOP_BASE + 0x5F)
#define REG_HDMITX_DTOP_30_L         (REG_HDMITX_DTOP_BASE + 0x60)
#define REG_HDMITX_DTOP_30_H         (REG_HDMITX_DTOP_BASE + 0x61)
#define REG_HDMITX_DTOP_31_L         (REG_HDMITX_DTOP_BASE + 0x62)
#define REG_HDMITX_DTOP_31_H         (REG_HDMITX_DTOP_BASE + 0x63)
#define REG_HDMITX_DTOP_32_L         (REG_HDMITX_DTOP_BASE + 0x64)
#define REG_HDMITX_DTOP_32_H         (REG_HDMITX_DTOP_BASE + 0x65)
#define REG_HDMITX_DTOP_33_L         (REG_HDMITX_DTOP_BASE + 0x66)
#define REG_HDMITX_DTOP_33_H         (REG_HDMITX_DTOP_BASE + 0x67)
#define REG_HDMITX_DTOP_34_L         (REG_HDMITX_DTOP_BASE + 0x68)
#define REG_HDMITX_DTOP_34_H         (REG_HDMITX_DTOP_BASE + 0x69)
#define REG_HDMITX_DTOP_35_L         (REG_HDMITX_DTOP_BASE + 0x6A)
#define REG_HDMITX_DTOP_35_H         (REG_HDMITX_DTOP_BASE + 0x6B)
#define REG_HDMITX_DTOP_36_L         (REG_HDMITX_DTOP_BASE + 0x6C)
#define REG_HDMITX_DTOP_36_H         (REG_HDMITX_DTOP_BASE + 0x6D)
#define REG_HDMITX_DTOP_37_L         (REG_HDMITX_DTOP_BASE + 0x6E)
#define REG_HDMITX_DTOP_37_H         (REG_HDMITX_DTOP_BASE + 0x6F)
#define REG_HDMITX_DTOP_38_L         (REG_HDMITX_DTOP_BASE + 0x70)
#define REG_HDMITX_DTOP_38_H         (REG_HDMITX_DTOP_BASE + 0x71)
#define REG_HDMITX_DTOP_39_L         (REG_HDMITX_DTOP_BASE + 0x72)
#define REG_HDMITX_DTOP_39_H         (REG_HDMITX_DTOP_BASE + 0x73)
#define REG_HDMITX_DTOP_3A_L         (REG_HDMITX_DTOP_BASE + 0x74)
#define REG_HDMITX_DTOP_3A_H         (REG_HDMITX_DTOP_BASE + 0x75)
#define REG_HDMITX_DTOP_3B_L         (REG_HDMITX_DTOP_BASE + 0x76)
#define REG_HDMITX_DTOP_3B_H         (REG_HDMITX_DTOP_BASE + 0x77)
#define REG_HDMITX_DTOP_3C_L         (REG_HDMITX_DTOP_BASE + 0x78)
#define REG_HDMITX_DTOP_3C_H         (REG_HDMITX_DTOP_BASE + 0x79)
#define REG_HDMITX_DTOP_3D_L         (REG_HDMITX_DTOP_BASE + 0x7A)
#define REG_HDMITX_DTOP_3D_H         (REG_HDMITX_DTOP_BASE + 0x7B)
#define REG_HDMITX_DTOP_3E_L         (REG_HDMITX_DTOP_BASE + 0x7C)
#define REG_HDMITX_DTOP_3E_H         (REG_HDMITX_DTOP_BASE + 0x7D)
#define REG_HDMITX_DTOP_3F_L         (REG_HDMITX_DTOP_BASE + 0x7E)
#define REG_HDMITX_DTOP_3F_H         (REG_HDMITX_DTOP_BASE + 0x7F)
#define REG_HDMITX_DTOP_40_L         (REG_HDMITX_DTOP_BASE + 0x80)
#define REG_HDMITX_DTOP_40_H         (REG_HDMITX_DTOP_BASE + 0x81)
#define REG_HDMITX_DTOP_41_L         (REG_HDMITX_DTOP_BASE + 0x82)
#define REG_HDMITX_DTOP_41_H         (REG_HDMITX_DTOP_BASE + 0x83)
#define REG_HDMITX_DTOP_42_L         (REG_HDMITX_DTOP_BASE + 0x84)
#define REG_HDMITX_DTOP_42_H         (REG_HDMITX_DTOP_BASE + 0x85)
#define REG_HDMITX_DTOP_43_L         (REG_HDMITX_DTOP_BASE + 0x86)
#define REG_HDMITX_DTOP_43_H         (REG_HDMITX_DTOP_BASE + 0x87)
#define REG_HDMITX_DTOP_44_L         (REG_HDMITX_DTOP_BASE + 0x88)
#define REG_HDMITX_DTOP_44_H         (REG_HDMITX_DTOP_BASE + 0x89)
#define REG_HDMITX_DTOP_45_L         (REG_HDMITX_DTOP_BASE + 0x8A)
#define REG_HDMITX_DTOP_45_H         (REG_HDMITX_DTOP_BASE + 0x8B)
#define REG_HDMITX_DTOP_46_L         (REG_HDMITX_DTOP_BASE + 0x8C)
#define REG_HDMITX_DTOP_46_H         (REG_HDMITX_DTOP_BASE + 0x8D)
#define REG_HDMITX_DTOP_47_L         (REG_HDMITX_DTOP_BASE + 0x8E)
#define REG_HDMITX_DTOP_47_H         (REG_HDMITX_DTOP_BASE + 0x8F)
#define REG_HDMITX_DTOP_48_L         (REG_HDMITX_DTOP_BASE + 0x90)
#define REG_HDMITX_DTOP_48_H         (REG_HDMITX_DTOP_BASE + 0x91)
#define REG_HDMITX_DTOP_49_L         (REG_HDMITX_DTOP_BASE + 0x92)
#define REG_HDMITX_DTOP_49_H         (REG_HDMITX_DTOP_BASE + 0x93)
#define REG_HDMITX_DTOP_4A_L         (REG_HDMITX_DTOP_BASE + 0x94)
#define REG_HDMITX_DTOP_4A_H         (REG_HDMITX_DTOP_BASE + 0x95)
#define REG_HDMITX_DTOP_4B_L         (REG_HDMITX_DTOP_BASE + 0x96)
#define REG_HDMITX_DTOP_4B_H         (REG_HDMITX_DTOP_BASE + 0x97)
#define REG_HDMITX_DTOP_4C_L         (REG_HDMITX_DTOP_BASE + 0x98)
#define REG_HDMITX_DTOP_4C_H         (REG_HDMITX_DTOP_BASE + 0x99)
#define REG_HDMITX_DTOP_4D_L         (REG_HDMITX_DTOP_BASE + 0x9A)
#define REG_HDMITX_DTOP_4D_H         (REG_HDMITX_DTOP_BASE + 0x9B)
#define REG_HDMITX_DTOP_4E_L         (REG_HDMITX_DTOP_BASE + 0x9C)
#define REG_HDMITX_DTOP_4E_H         (REG_HDMITX_DTOP_BASE + 0x9D)
#define REG_HDMITX_DTOP_4F_L         (REG_HDMITX_DTOP_BASE + 0x9E)
#define REG_HDMITX_DTOP_4F_H         (REG_HDMITX_DTOP_BASE + 0x9F)
#define REG_HDMITX_DTOP_50_L         (REG_HDMITX_DTOP_BASE + 0xA0)
#define REG_HDMITX_DTOP_50_H         (REG_HDMITX_DTOP_BASE + 0xA1)
#define REG_HDMITX_DTOP_51_L         (REG_HDMITX_DTOP_BASE + 0xA2)
#define REG_HDMITX_DTOP_51_H         (REG_HDMITX_DTOP_BASE + 0xA3)
#define REG_HDMITX_DTOP_52_L         (REG_HDMITX_DTOP_BASE + 0xA4)
#define REG_HDMITX_DTOP_52_H         (REG_HDMITX_DTOP_BASE + 0xA5)
#define REG_HDMITX_DTOP_53_L         (REG_HDMITX_DTOP_BASE + 0xA6)
#define REG_HDMITX_DTOP_53_H         (REG_HDMITX_DTOP_BASE + 0xA7)
#define REG_HDMITX_DTOP_54_L         (REG_HDMITX_DTOP_BASE + 0xA8)
#define REG_HDMITX_DTOP_54_H         (REG_HDMITX_DTOP_BASE + 0xA9)
#define REG_HDMITX_DTOP_55_L         (REG_HDMITX_DTOP_BASE + 0xAA)
#define REG_HDMITX_DTOP_55_H         (REG_HDMITX_DTOP_BASE + 0xAB)
#define REG_HDMITX_DTOP_56_L         (REG_HDMITX_DTOP_BASE + 0xAC)
#define REG_HDMITX_DTOP_56_H         (REG_HDMITX_DTOP_BASE + 0xAD)
#define REG_HDMITX_DTOP_57_L         (REG_HDMITX_DTOP_BASE + 0xAE)
#define REG_HDMITX_DTOP_57_H         (REG_HDMITX_DTOP_BASE + 0xAF)
#define REG_HDMITX_DTOP_58_L         (REG_HDMITX_DTOP_BASE + 0xB0)
#define REG_HDMITX_DTOP_58_H         (REG_HDMITX_DTOP_BASE + 0xB1)
#define REG_HDMITX_DTOP_59_L         (REG_HDMITX_DTOP_BASE + 0xB2)
#define REG_HDMITX_DTOP_59_H         (REG_HDMITX_DTOP_BASE + 0xB3)
#define REG_HDMITX_DTOP_5A_L         (REG_HDMITX_DTOP_BASE + 0xB4)
#define REG_HDMITX_DTOP_5A_H         (REG_HDMITX_DTOP_BASE + 0xB5)
#define REG_HDMITX_DTOP_5B_L         (REG_HDMITX_DTOP_BASE + 0xB6)
#define REG_HDMITX_DTOP_5B_H         (REG_HDMITX_DTOP_BASE + 0xB7)
#define REG_HDMITX_DTOP_5C_L         (REG_HDMITX_DTOP_BASE + 0xB8)
#define REG_HDMITX_DTOP_5C_H         (REG_HDMITX_DTOP_BASE + 0xB9)
#define REG_HDMITX_DTOP_5D_L         (REG_HDMITX_DTOP_BASE + 0xBA)
#define REG_HDMITX_DTOP_5D_H         (REG_HDMITX_DTOP_BASE + 0xBB)
#define REG_HDMITX_DTOP_5E_L         (REG_HDMITX_DTOP_BASE + 0xBC)
#define REG_HDMITX_DTOP_5E_H         (REG_HDMITX_DTOP_BASE + 0xBD)
#define REG_HDMITX_DTOP_5F_L         (REG_HDMITX_DTOP_BASE + 0xBE)
#define REG_HDMITX_DTOP_5F_H         (REG_HDMITX_DTOP_BASE + 0xBF)
#define REG_HDMITX_DTOP_60_L         (REG_HDMITX_DTOP_BASE + 0xC0)
#define REG_HDMITX_DTOP_60_H         (REG_HDMITX_DTOP_BASE + 0xC1)
#define REG_HDMITX_DTOP_61_L         (REG_HDMITX_DTOP_BASE + 0xC2)
#define REG_HDMITX_DTOP_61_H         (REG_HDMITX_DTOP_BASE + 0xC3)
#define REG_HDMITX_DTOP_62_L         (REG_HDMITX_DTOP_BASE + 0xC4)
#define REG_HDMITX_DTOP_62_H         (REG_HDMITX_DTOP_BASE + 0xC5)
#define REG_HDMITX_DTOP_63_L         (REG_HDMITX_DTOP_BASE + 0xC6)
#define REG_HDMITX_DTOP_63_H         (REG_HDMITX_DTOP_BASE + 0xC7)
#define REG_HDMITX_DTOP_64_L         (REG_HDMITX_DTOP_BASE + 0xC8)
#define REG_HDMITX_DTOP_64_H         (REG_HDMITX_DTOP_BASE + 0xC9)
#define REG_HDMITX_DTOP_65_L         (REG_HDMITX_DTOP_BASE + 0xCA)
#define REG_HDMITX_DTOP_65_H         (REG_HDMITX_DTOP_BASE + 0xCB)
#define REG_HDMITX_DTOP_66_L         (REG_HDMITX_DTOP_BASE + 0xCC)
#define REG_HDMITX_DTOP_66_H         (REG_HDMITX_DTOP_BASE + 0xCD)
#define REG_HDMITX_DTOP_67_L         (REG_HDMITX_DTOP_BASE + 0xCE)
#define REG_HDMITX_DTOP_67_H         (REG_HDMITX_DTOP_BASE + 0xCF)
#define REG_HDMITX_DTOP_68_L         (REG_HDMITX_DTOP_BASE + 0xD0)
#define REG_HDMITX_DTOP_68_H         (REG_HDMITX_DTOP_BASE + 0xD1)
#define REG_HDMITX_DTOP_69_L         (REG_HDMITX_DTOP_BASE + 0xD2)
#define REG_HDMITX_DTOP_69_H         (REG_HDMITX_DTOP_BASE + 0xD3)
#define REG_HDMITX_DTOP_6A_L         (REG_HDMITX_DTOP_BASE + 0xD4)
#define REG_HDMITX_DTOP_6A_H         (REG_HDMITX_DTOP_BASE + 0xD5)
#define REG_HDMITX_DTOP_6B_L         (REG_HDMITX_DTOP_BASE + 0xD6)
#define REG_HDMITX_DTOP_6B_H         (REG_HDMITX_DTOP_BASE + 0xD7)
#define REG_HDMITX_DTOP_6C_L         (REG_HDMITX_DTOP_BASE + 0xD8)
#define REG_HDMITX_DTOP_6C_H         (REG_HDMITX_DTOP_BASE + 0xD9)
#define REG_HDMITX_DTOP_6D_L         (REG_HDMITX_DTOP_BASE + 0xDA)
#define REG_HDMITX_DTOP_6D_H         (REG_HDMITX_DTOP_BASE + 0xDB)
#define REG_HDMITX_DTOP_6E_L         (REG_HDMITX_DTOP_BASE + 0xDC)
#define REG_HDMITX_DTOP_6E_H         (REG_HDMITX_DTOP_BASE + 0xDD)
#define REG_HDMITX_DTOP_6F_L         (REG_HDMITX_DTOP_BASE + 0xDE)
#define REG_HDMITX_DTOP_6F_H         (REG_HDMITX_DTOP_BASE + 0xDF)
#define REG_HDMITX_DTOP_70_L         (REG_HDMITX_DTOP_BASE + 0xE0)
#define REG_HDMITX_DTOP_70_H         (REG_HDMITX_DTOP_BASE + 0xE1)
#define REG_HDMITX_DTOP_71_L         (REG_HDMITX_DTOP_BASE + 0xE2)
#define REG_HDMITX_DTOP_71_H         (REG_HDMITX_DTOP_BASE + 0xE3)
#define REG_HDMITX_DTOP_72_L         (REG_HDMITX_DTOP_BASE + 0xE4)
#define REG_HDMITX_DTOP_72_H         (REG_HDMITX_DTOP_BASE + 0xE5)
#define REG_HDMITX_DTOP_73_L         (REG_HDMITX_DTOP_BASE + 0xE6)
#define REG_HDMITX_DTOP_73_H         (REG_HDMITX_DTOP_BASE + 0xE7)
#define REG_HDMITX_DTOP_74_L         (REG_HDMITX_DTOP_BASE + 0xE8)
#define REG_HDMITX_DTOP_74_H         (REG_HDMITX_DTOP_BASE + 0xE9)
#define REG_HDMITX_DTOP_75_L         (REG_HDMITX_DTOP_BASE + 0xEA)
#define REG_HDMITX_DTOP_75_H         (REG_HDMITX_DTOP_BASE + 0xEB)
#define REG_HDMITX_DTOP_76_L         (REG_HDMITX_DTOP_BASE + 0xEC)
#define REG_HDMITX_DTOP_76_H         (REG_HDMITX_DTOP_BASE + 0xED)
#define REG_HDMITX_DTOP_77_L         (REG_HDMITX_DTOP_BASE + 0xEE)
#define REG_HDMITX_DTOP_77_H         (REG_HDMITX_DTOP_BASE + 0xEF)
#define REG_HDMITX_DTOP_78_L         (REG_HDMITX_DTOP_BASE + 0xF0)
#define REG_HDMITX_DTOP_78_H         (REG_HDMITX_DTOP_BASE + 0xF1)
#define REG_HDMITX_DTOP_79_L         (REG_HDMITX_DTOP_BASE + 0xF2)
#define REG_HDMITX_DTOP_79_H         (REG_HDMITX_DTOP_BASE + 0xF3)
#define REG_HDMITX_DTOP_7A_L         (REG_HDMITX_DTOP_BASE + 0xF4)
#define REG_HDMITX_DTOP_7A_H         (REG_HDMITX_DTOP_BASE + 0xF5)
#define REG_HDMITX_DTOP_7B_L         (REG_HDMITX_DTOP_BASE + 0xF6)
#define REG_HDMITX_DTOP_7B_H         (REG_HDMITX_DTOP_BASE + 0xF7)
#define REG_HDMITX_DTOP_7C_L         (REG_HDMITX_DTOP_BASE + 0xF8)
#define REG_HDMITX_DTOP_7C_H         (REG_HDMITX_DTOP_BASE + 0xF9)
#define REG_HDMITX_DTOP_7D_L         (REG_HDMITX_DTOP_BASE + 0xFA)
#define REG_HDMITX_DTOP_7D_H         (REG_HDMITX_DTOP_BASE + 0xFB)
#define REG_HDMITX_DTOP_7E_L         (REG_HDMITX_DTOP_BASE + 0xFC)
#define REG_HDMITX_DTOP_7E_H         (REG_HDMITX_DTOP_BASE + 0xFD)
#define REG_HDMITX_DTOP_7F_L         (REG_HDMITX_DTOP_BASE + 0xFE)
#define REG_HDMITX_DTOP_7F_H         (REG_HDMITX_DTOP_BASE + 0xFF)

#define REG_HDMITX_ATOP_00_L         (REG_HDMITX_ATOP_BASE + 0x00)
#define REG_HDMITX_ATOP_00_H         (REG_HDMITX_ATOP_BASE + 0x01)
#define REG_HDMITX_ATOP_01_L         (REG_HDMITX_ATOP_BASE + 0x02)
#define REG_HDMITX_ATOP_01_H         (REG_HDMITX_ATOP_BASE + 0x03)
#define REG_HDMITX_ATOP_02_L         (REG_HDMITX_ATOP_BASE + 0x04)
#define REG_HDMITX_ATOP_02_H         (REG_HDMITX_ATOP_BASE + 0x05)
#define REG_HDMITX_ATOP_03_L         (REG_HDMITX_ATOP_BASE + 0x06)
#define REG_HDMITX_ATOP_03_H         (REG_HDMITX_ATOP_BASE + 0x07)
#define REG_HDMITX_ATOP_04_L         (REG_HDMITX_ATOP_BASE + 0x08)
#define REG_HDMITX_ATOP_04_H         (REG_HDMITX_ATOP_BASE + 0x09)
#define REG_HDMITX_ATOP_05_L         (REG_HDMITX_ATOP_BASE + 0x0A)
#define REG_HDMITX_ATOP_05_H         (REG_HDMITX_ATOP_BASE + 0x0B)
#define REG_HDMITX_ATOP_06_L         (REG_HDMITX_ATOP_BASE + 0x0C)
#define REG_HDMITX_ATOP_06_H         (REG_HDMITX_ATOP_BASE + 0x0D)
#define REG_HDMITX_ATOP_07_L         (REG_HDMITX_ATOP_BASE + 0x0E)
#define REG_HDMITX_ATOP_07_H         (REG_HDMITX_ATOP_BASE + 0x0F)
#define REG_HDMITX_ATOP_08_L         (REG_HDMITX_ATOP_BASE + 0x10)
#define REG_HDMITX_ATOP_08_H         (REG_HDMITX_ATOP_BASE + 0x11)
#define REG_HDMITX_ATOP_09_L         (REG_HDMITX_ATOP_BASE + 0x12)
#define REG_HDMITX_ATOP_09_H         (REG_HDMITX_ATOP_BASE + 0x13)
#define REG_HDMITX_ATOP_0A_L         (REG_HDMITX_ATOP_BASE + 0x14)
#define REG_HDMITX_ATOP_0A_H         (REG_HDMITX_ATOP_BASE + 0x15)
#define REG_HDMITX_ATOP_0B_L         (REG_HDMITX_ATOP_BASE + 0x16)
#define REG_HDMITX_ATOP_0B_H         (REG_HDMITX_ATOP_BASE + 0x17)
#define REG_HDMITX_ATOP_0C_L         (REG_HDMITX_ATOP_BASE + 0x18)
#define REG_HDMITX_ATOP_0C_H         (REG_HDMITX_ATOP_BASE + 0x19)
#define REG_HDMITX_ATOP_0D_L         (REG_HDMITX_ATOP_BASE + 0x1A)
#define REG_HDMITX_ATOP_0D_H         (REG_HDMITX_ATOP_BASE + 0x1B)
#define REG_HDMITX_ATOP_0E_L         (REG_HDMITX_ATOP_BASE + 0x1C)
#define REG_HDMITX_ATOP_0E_H         (REG_HDMITX_ATOP_BASE + 0x1D)
#define REG_HDMITX_ATOP_0F_L         (REG_HDMITX_ATOP_BASE + 0x1E)
#define REG_HDMITX_ATOP_0F_H         (REG_HDMITX_ATOP_BASE + 0x1F)
#define REG_HDMITX_ATOP_10_L         (REG_HDMITX_ATOP_BASE + 0x20)
#define REG_HDMITX_ATOP_10_H         (REG_HDMITX_ATOP_BASE + 0x21)
#define REG_HDMITX_ATOP_11_L         (REG_HDMITX_ATOP_BASE + 0x22)
#define REG_HDMITX_ATOP_11_H         (REG_HDMITX_ATOP_BASE + 0x23)
#define REG_HDMITX_ATOP_12_L         (REG_HDMITX_ATOP_BASE + 0x24)
#define REG_HDMITX_ATOP_12_H         (REG_HDMITX_ATOP_BASE + 0x25)
#define REG_HDMITX_ATOP_13_L         (REG_HDMITX_ATOP_BASE + 0x26)
#define REG_HDMITX_ATOP_13_H         (REG_HDMITX_ATOP_BASE + 0x27)
#define REG_HDMITX_ATOP_14_L         (REG_HDMITX_ATOP_BASE + 0x28)
#define REG_HDMITX_ATOP_14_H         (REG_HDMITX_ATOP_BASE + 0x29)
#define REG_HDMITX_ATOP_15_L         (REG_HDMITX_ATOP_BASE + 0x2A)
#define REG_HDMITX_ATOP_15_H         (REG_HDMITX_ATOP_BASE + 0x2B)
#define REG_HDMITX_ATOP_16_L         (REG_HDMITX_ATOP_BASE + 0x2C)
#define REG_HDMITX_ATOP_16_H         (REG_HDMITX_ATOP_BASE + 0x2D)
#define REG_HDMITX_ATOP_17_L         (REG_HDMITX_ATOP_BASE + 0x2E)
#define REG_HDMITX_ATOP_17_H         (REG_HDMITX_ATOP_BASE + 0x2F)
#define REG_HDMITX_ATOP_18_L         (REG_HDMITX_ATOP_BASE + 0x30)
#define REG_HDMITX_ATOP_18_H         (REG_HDMITX_ATOP_BASE + 0x31)
#define REG_HDMITX_ATOP_19_L         (REG_HDMITX_ATOP_BASE + 0x32)
#define REG_HDMITX_ATOP_19_H         (REG_HDMITX_ATOP_BASE + 0x33)
#define REG_HDMITX_ATOP_1A_L         (REG_HDMITX_ATOP_BASE + 0x34)
#define REG_HDMITX_ATOP_1A_H         (REG_HDMITX_ATOP_BASE + 0x35)
#define REG_HDMITX_ATOP_1B_L         (REG_HDMITX_ATOP_BASE + 0x36)
#define REG_HDMITX_ATOP_1B_H         (REG_HDMITX_ATOP_BASE + 0x37)
#define REG_HDMITX_ATOP_1C_L         (REG_HDMITX_ATOP_BASE + 0x38)
#define REG_HDMITX_ATOP_1C_H         (REG_HDMITX_ATOP_BASE + 0x39)
#define REG_HDMITX_ATOP_1D_L         (REG_HDMITX_ATOP_BASE + 0x3A)
#define REG_HDMITX_ATOP_1D_H         (REG_HDMITX_ATOP_BASE + 0x3B)
#define REG_HDMITX_ATOP_1E_L         (REG_HDMITX_ATOP_BASE + 0x3C)
#define REG_HDMITX_ATOP_1E_H         (REG_HDMITX_ATOP_BASE + 0x3D)
#define REG_HDMITX_ATOP_1F_L         (REG_HDMITX_ATOP_BASE + 0x3E)
#define REG_HDMITX_ATOP_1F_H         (REG_HDMITX_ATOP_BASE + 0x3F)
#define REG_HDMITX_ATOP_20_L         (REG_HDMITX_ATOP_BASE + 0x40)
#define REG_HDMITX_ATOP_20_H         (REG_HDMITX_ATOP_BASE + 0x41)
#define REG_HDMITX_ATOP_21_L         (REG_HDMITX_ATOP_BASE + 0x42)
#define REG_HDMITX_ATOP_21_H         (REG_HDMITX_ATOP_BASE + 0x43)
#define REG_HDMITX_ATOP_22_L         (REG_HDMITX_ATOP_BASE + 0x44)
#define REG_HDMITX_ATOP_22_H         (REG_HDMITX_ATOP_BASE + 0x45)
#define REG_HDMITX_ATOP_23_L         (REG_HDMITX_ATOP_BASE + 0x46)
#define REG_HDMITX_ATOP_23_H         (REG_HDMITX_ATOP_BASE + 0x47)
#define REG_HDMITX_ATOP_24_L         (REG_HDMITX_ATOP_BASE + 0x48)
#define REG_HDMITX_ATOP_24_H         (REG_HDMITX_ATOP_BASE + 0x49)
#define REG_HDMITX_ATOP_25_L         (REG_HDMITX_ATOP_BASE + 0x4A)
#define REG_HDMITX_ATOP_25_H         (REG_HDMITX_ATOP_BASE + 0x4B)
#define REG_HDMITX_ATOP_26_L         (REG_HDMITX_ATOP_BASE + 0x4C)
#define REG_HDMITX_ATOP_26_H         (REG_HDMITX_ATOP_BASE + 0x4D)
#define REG_HDMITX_ATOP_27_L         (REG_HDMITX_ATOP_BASE + 0x4E)
#define REG_HDMITX_ATOP_27_H         (REG_HDMITX_ATOP_BASE + 0x4F)
#define REG_HDMITX_ATOP_28_L         (REG_HDMITX_ATOP_BASE + 0x50)
#define REG_HDMITX_ATOP_28_H         (REG_HDMITX_ATOP_BASE + 0x51)
#define REG_HDMITX_ATOP_29_L         (REG_HDMITX_ATOP_BASE + 0x52)
#define REG_HDMITX_ATOP_29_H         (REG_HDMITX_ATOP_BASE + 0x53)
#define REG_HDMITX_ATOP_2A_L         (REG_HDMITX_ATOP_BASE + 0x54)
#define REG_HDMITX_ATOP_2A_H         (REG_HDMITX_ATOP_BASE + 0x55)
#define REG_HDMITX_ATOP_2B_L         (REG_HDMITX_ATOP_BASE + 0x56)
#define REG_HDMITX_ATOP_2B_H         (REG_HDMITX_ATOP_BASE + 0x57)
#define REG_HDMITX_ATOP_2C_L         (REG_HDMITX_ATOP_BASE + 0x58)
#define REG_HDMITX_ATOP_2C_H         (REG_HDMITX_ATOP_BASE + 0x59)
#define REG_HDMITX_ATOP_2D_L         (REG_HDMITX_ATOP_BASE + 0x5A)
#define REG_HDMITX_ATOP_2D_H         (REG_HDMITX_ATOP_BASE + 0x5B)
#define REG_HDMITX_ATOP_2E_L         (REG_HDMITX_ATOP_BASE + 0x5C)
#define REG_HDMITX_ATOP_2E_H         (REG_HDMITX_ATOP_BASE + 0x5D)
#define REG_HDMITX_ATOP_2F_L         (REG_HDMITX_ATOP_BASE + 0x5E)
#define REG_HDMITX_ATOP_2F_H         (REG_HDMITX_ATOP_BASE + 0x5F)
#define REG_HDMITX_ATOP_30_L         (REG_HDMITX_ATOP_BASE + 0x60)
#define REG_HDMITX_ATOP_30_H         (REG_HDMITX_ATOP_BASE + 0x61)
#define REG_HDMITX_ATOP_31_L         (REG_HDMITX_ATOP_BASE + 0x62)
#define REG_HDMITX_ATOP_31_H         (REG_HDMITX_ATOP_BASE + 0x63)
#define REG_HDMITX_ATOP_32_L         (REG_HDMITX_ATOP_BASE + 0x64)
#define REG_HDMITX_ATOP_32_H         (REG_HDMITX_ATOP_BASE + 0x65)
#define REG_HDMITX_ATOP_33_L         (REG_HDMITX_ATOP_BASE + 0x66)
#define REG_HDMITX_ATOP_33_H         (REG_HDMITX_ATOP_BASE + 0x67)
#define REG_HDMITX_ATOP_34_L         (REG_HDMITX_ATOP_BASE + 0x68)
#define REG_HDMITX_ATOP_34_H         (REG_HDMITX_ATOP_BASE + 0x69)
#define REG_HDMITX_ATOP_35_L         (REG_HDMITX_ATOP_BASE + 0x6A)
#define REG_HDMITX_ATOP_35_H         (REG_HDMITX_ATOP_BASE + 0x6B)
#define REG_HDMITX_ATOP_36_L         (REG_HDMITX_ATOP_BASE + 0x6C)
#define REG_HDMITX_ATOP_36_H         (REG_HDMITX_ATOP_BASE + 0x6D)
#define REG_HDMITX_ATOP_37_L         (REG_HDMITX_ATOP_BASE + 0x6E)
#define REG_HDMITX_ATOP_37_H         (REG_HDMITX_ATOP_BASE + 0x6F)
#define REG_HDMITX_ATOP_38_L         (REG_HDMITX_ATOP_BASE + 0x70)
#define REG_HDMITX_ATOP_38_H         (REG_HDMITX_ATOP_BASE + 0x71)
#define REG_HDMITX_ATOP_39_L         (REG_HDMITX_ATOP_BASE + 0x72)
#define REG_HDMITX_ATOP_39_H         (REG_HDMITX_ATOP_BASE + 0x73)
#define REG_HDMITX_ATOP_3A_L         (REG_HDMITX_ATOP_BASE + 0x74)
#define REG_HDMITX_ATOP_3A_H         (REG_HDMITX_ATOP_BASE + 0x75)
#define REG_HDMITX_ATOP_3B_L         (REG_HDMITX_ATOP_BASE + 0x76)
#define REG_HDMITX_ATOP_3B_H         (REG_HDMITX_ATOP_BASE + 0x77)
#define REG_HDMITX_ATOP_3C_L         (REG_HDMITX_ATOP_BASE + 0x78)
#define REG_HDMITX_ATOP_3C_H         (REG_HDMITX_ATOP_BASE + 0x79)
#define REG_HDMITX_ATOP_3D_L         (REG_HDMITX_ATOP_BASE + 0x7A)
#define REG_HDMITX_ATOP_3D_H         (REG_HDMITX_ATOP_BASE + 0x7B)
#define REG_HDMITX_ATOP_3E_L         (REG_HDMITX_ATOP_BASE + 0x7C)
#define REG_HDMITX_ATOP_3E_H         (REG_HDMITX_ATOP_BASE + 0x7D)
#define REG_HDMITX_ATOP_3F_L         (REG_HDMITX_ATOP_BASE + 0x7E)
#define REG_HDMITX_ATOP_3F_H         (REG_HDMITX_ATOP_BASE + 0x7F)
#define REG_HDMITX_ATOP_40_L         (REG_HDMITX_ATOP_BASE + 0x80)
#define REG_HDMITX_ATOP_40_H         (REG_HDMITX_ATOP_BASE + 0x81)
#define REG_HDMITX_ATOP_41_L         (REG_HDMITX_ATOP_BASE + 0x82)
#define REG_HDMITX_ATOP_41_H         (REG_HDMITX_ATOP_BASE + 0x83)
#define REG_HDMITX_ATOP_42_L         (REG_HDMITX_ATOP_BASE + 0x84)
#define REG_HDMITX_ATOP_42_H         (REG_HDMITX_ATOP_BASE + 0x85)
#define REG_HDMITX_ATOP_43_L         (REG_HDMITX_ATOP_BASE + 0x86)
#define REG_HDMITX_ATOP_43_H         (REG_HDMITX_ATOP_BASE + 0x87)
#define REG_HDMITX_ATOP_44_L         (REG_HDMITX_ATOP_BASE + 0x88)
#define REG_HDMITX_ATOP_44_H         (REG_HDMITX_ATOP_BASE + 0x89)
#define REG_HDMITX_ATOP_45_L         (REG_HDMITX_ATOP_BASE + 0x8A)
#define REG_HDMITX_ATOP_45_H         (REG_HDMITX_ATOP_BASE + 0x8B)
#define REG_HDMITX_ATOP_46_L         (REG_HDMITX_ATOP_BASE + 0x8C)
#define REG_HDMITX_ATOP_46_H         (REG_HDMITX_ATOP_BASE + 0x8D)
#define REG_HDMITX_ATOP_47_L         (REG_HDMITX_ATOP_BASE + 0x8E)
#define REG_HDMITX_ATOP_47_H         (REG_HDMITX_ATOP_BASE + 0x8F)
#define REG_HDMITX_ATOP_48_L         (REG_HDMITX_ATOP_BASE + 0x90)
#define REG_HDMITX_ATOP_48_H         (REG_HDMITX_ATOP_BASE + 0x91)
#define REG_HDMITX_ATOP_49_L         (REG_HDMITX_ATOP_BASE + 0x92)
#define REG_HDMITX_ATOP_49_H         (REG_HDMITX_ATOP_BASE + 0x93)
#define REG_HDMITX_ATOP_4A_L         (REG_HDMITX_ATOP_BASE + 0x94)
#define REG_HDMITX_ATOP_4A_H         (REG_HDMITX_ATOP_BASE + 0x95)
#define REG_HDMITX_ATOP_4B_L         (REG_HDMITX_ATOP_BASE + 0x96)
#define REG_HDMITX_ATOP_4B_H         (REG_HDMITX_ATOP_BASE + 0x97)
#define REG_HDMITX_ATOP_4C_L         (REG_HDMITX_ATOP_BASE + 0x98)
#define REG_HDMITX_ATOP_4C_H         (REG_HDMITX_ATOP_BASE + 0x99)
#define REG_HDMITX_ATOP_4D_L         (REG_HDMITX_ATOP_BASE + 0x9A)
#define REG_HDMITX_ATOP_4D_H         (REG_HDMITX_ATOP_BASE + 0x9B)
#define REG_HDMITX_ATOP_4E_L         (REG_HDMITX_ATOP_BASE + 0x9C)
#define REG_HDMITX_ATOP_4E_H         (REG_HDMITX_ATOP_BASE + 0x9D)
#define REG_HDMITX_ATOP_4F_L         (REG_HDMITX_ATOP_BASE + 0x9E)
#define REG_HDMITX_ATOP_4F_H         (REG_HDMITX_ATOP_BASE + 0x9F)
#define REG_HDMITX_ATOP_50_L         (REG_HDMITX_ATOP_BASE + 0xA0)
#define REG_HDMITX_ATOP_50_H         (REG_HDMITX_ATOP_BASE + 0xA1)
#define REG_HDMITX_ATOP_51_L         (REG_HDMITX_ATOP_BASE + 0xA2)
#define REG_HDMITX_ATOP_51_H         (REG_HDMITX_ATOP_BASE + 0xA3)
#define REG_HDMITX_ATOP_52_L         (REG_HDMITX_ATOP_BASE + 0xA4)
#define REG_HDMITX_ATOP_52_H         (REG_HDMITX_ATOP_BASE + 0xA5)
#define REG_HDMITX_ATOP_53_L         (REG_HDMITX_ATOP_BASE + 0xA6)
#define REG_HDMITX_ATOP_53_H         (REG_HDMITX_ATOP_BASE + 0xA7)
#define REG_HDMITX_ATOP_54_L         (REG_HDMITX_ATOP_BASE + 0xA8)
#define REG_HDMITX_ATOP_54_H         (REG_HDMITX_ATOP_BASE + 0xA9)
#define REG_HDMITX_ATOP_55_L         (REG_HDMITX_ATOP_BASE + 0xAA)
#define REG_HDMITX_ATOP_55_H         (REG_HDMITX_ATOP_BASE + 0xAB)
#define REG_HDMITX_ATOP_56_L         (REG_HDMITX_ATOP_BASE + 0xAC)
#define REG_HDMITX_ATOP_56_H         (REG_HDMITX_ATOP_BASE + 0xAD)
#define REG_HDMITX_ATOP_57_L         (REG_HDMITX_ATOP_BASE + 0xAE)
#define REG_HDMITX_ATOP_57_H         (REG_HDMITX_ATOP_BASE + 0xAF)
#define REG_HDMITX_ATOP_58_L         (REG_HDMITX_ATOP_BASE + 0xB0)
#define REG_HDMITX_ATOP_58_H         (REG_HDMITX_ATOP_BASE + 0xB1)
#define REG_HDMITX_ATOP_59_L         (REG_HDMITX_ATOP_BASE + 0xB2)
#define REG_HDMITX_ATOP_59_H         (REG_HDMITX_ATOP_BASE + 0xB3)
#define REG_HDMITX_ATOP_5A_L         (REG_HDMITX_ATOP_BASE + 0xB4)
#define REG_HDMITX_ATOP_5A_H         (REG_HDMITX_ATOP_BASE + 0xB5)
#define REG_HDMITX_ATOP_5B_L         (REG_HDMITX_ATOP_BASE + 0xB6)
#define REG_HDMITX_ATOP_5B_H         (REG_HDMITX_ATOP_BASE + 0xB7)
#define REG_HDMITX_ATOP_5C_L         (REG_HDMITX_ATOP_BASE + 0xB8)
#define REG_HDMITX_ATOP_5C_H         (REG_HDMITX_ATOP_BASE + 0xB9)
#define REG_HDMITX_ATOP_5D_L         (REG_HDMITX_ATOP_BASE + 0xBA)
#define REG_HDMITX_ATOP_5D_H         (REG_HDMITX_ATOP_BASE + 0xBB)
#define REG_HDMITX_ATOP_5E_L         (REG_HDMITX_ATOP_BASE + 0xBC)
#define REG_HDMITX_ATOP_5E_H         (REG_HDMITX_ATOP_BASE + 0xBD)
#define REG_HDMITX_ATOP_5F_L         (REG_HDMITX_ATOP_BASE + 0xBE)
#define REG_HDMITX_ATOP_5F_H         (REG_HDMITX_ATOP_BASE + 0xBF)
#define REG_HDMITX_ATOP_60_L         (REG_HDMITX_ATOP_BASE + 0xC0)
#define REG_HDMITX_ATOP_60_H         (REG_HDMITX_ATOP_BASE + 0xC1)
#define REG_HDMITX_ATOP_61_L         (REG_HDMITX_ATOP_BASE + 0xC2)
#define REG_HDMITX_ATOP_61_H         (REG_HDMITX_ATOP_BASE + 0xC3)
#define REG_HDMITX_ATOP_62_L         (REG_HDMITX_ATOP_BASE + 0xC4)
#define REG_HDMITX_ATOP_62_H         (REG_HDMITX_ATOP_BASE + 0xC5)
#define REG_HDMITX_ATOP_63_L         (REG_HDMITX_ATOP_BASE + 0xC6)
#define REG_HDMITX_ATOP_63_H         (REG_HDMITX_ATOP_BASE + 0xC7)
#define REG_HDMITX_ATOP_64_L         (REG_HDMITX_ATOP_BASE + 0xC8)
#define REG_HDMITX_ATOP_64_H         (REG_HDMITX_ATOP_BASE + 0xC9)
#define REG_HDMITX_ATOP_65_L         (REG_HDMITX_ATOP_BASE + 0xCA)
#define REG_HDMITX_ATOP_65_H         (REG_HDMITX_ATOP_BASE + 0xCB)
#define REG_HDMITX_ATOP_66_L         (REG_HDMITX_ATOP_BASE + 0xCC)
#define REG_HDMITX_ATOP_66_H         (REG_HDMITX_ATOP_BASE + 0xCD)
#define REG_HDMITX_ATOP_67_L         (REG_HDMITX_ATOP_BASE + 0xCE)
#define REG_HDMITX_ATOP_67_H         (REG_HDMITX_ATOP_BASE + 0xCF)
#define REG_HDMITX_ATOP_68_L         (REG_HDMITX_ATOP_BASE + 0xD0)
#define REG_HDMITX_ATOP_68_H         (REG_HDMITX_ATOP_BASE + 0xD1)
#define REG_HDMITX_ATOP_69_L         (REG_HDMITX_ATOP_BASE + 0xD2)
#define REG_HDMITX_ATOP_69_H         (REG_HDMITX_ATOP_BASE + 0xD3)
#define REG_HDMITX_ATOP_6A_L         (REG_HDMITX_ATOP_BASE + 0xD4)
#define REG_HDMITX_ATOP_6A_H         (REG_HDMITX_ATOP_BASE + 0xD5)
#define REG_HDMITX_ATOP_6B_L         (REG_HDMITX_ATOP_BASE + 0xD6)
#define REG_HDMITX_ATOP_6B_H         (REG_HDMITX_ATOP_BASE + 0xD7)
#define REG_HDMITX_ATOP_6C_L         (REG_HDMITX_ATOP_BASE + 0xD8)
#define REG_HDMITX_ATOP_6C_H         (REG_HDMITX_ATOP_BASE + 0xD9)
#define REG_HDMITX_ATOP_6D_L         (REG_HDMITX_ATOP_BASE + 0xDA)
#define REG_HDMITX_ATOP_6D_H         (REG_HDMITX_ATOP_BASE + 0xDB)
#define REG_HDMITX_ATOP_6E_L         (REG_HDMITX_ATOP_BASE + 0xDC)
#define REG_HDMITX_ATOP_6E_H         (REG_HDMITX_ATOP_BASE + 0xDD)
#define REG_HDMITX_ATOP_6F_L         (REG_HDMITX_ATOP_BASE + 0xDE)
#define REG_HDMITX_ATOP_6F_H         (REG_HDMITX_ATOP_BASE + 0xDF)
#define REG_HDMITX_ATOP_70_L         (REG_HDMITX_ATOP_BASE + 0xE0)
#define REG_HDMITX_ATOP_70_H         (REG_HDMITX_ATOP_BASE + 0xE1)
#define REG_HDMITX_ATOP_71_L         (REG_HDMITX_ATOP_BASE + 0xE2)
#define REG_HDMITX_ATOP_71_H         (REG_HDMITX_ATOP_BASE + 0xE3)
#define REG_HDMITX_ATOP_72_L         (REG_HDMITX_ATOP_BASE + 0xE4)
#define REG_HDMITX_ATOP_72_H         (REG_HDMITX_ATOP_BASE + 0xE5)
#define REG_HDMITX_ATOP_73_L         (REG_HDMITX_ATOP_BASE + 0xE6)
#define REG_HDMITX_ATOP_73_H         (REG_HDMITX_ATOP_BASE + 0xE7)
#define REG_HDMITX_ATOP_74_L         (REG_HDMITX_ATOP_BASE + 0xE8)
#define REG_HDMITX_ATOP_74_H         (REG_HDMITX_ATOP_BASE + 0xE9)
#define REG_HDMITX_ATOP_75_L         (REG_HDMITX_ATOP_BASE + 0xEA)
#define REG_HDMITX_ATOP_75_H         (REG_HDMITX_ATOP_BASE + 0xEB)
#define REG_HDMITX_ATOP_76_L         (REG_HDMITX_ATOP_BASE + 0xEC)
#define REG_HDMITX_ATOP_76_H         (REG_HDMITX_ATOP_BASE + 0xED)
#define REG_HDMITX_ATOP_77_L         (REG_HDMITX_ATOP_BASE + 0xEE)
#define REG_HDMITX_ATOP_77_H         (REG_HDMITX_ATOP_BASE + 0xEF)
#define REG_HDMITX_ATOP_78_L         (REG_HDMITX_ATOP_BASE + 0xF0)
#define REG_HDMITX_ATOP_78_H         (REG_HDMITX_ATOP_BASE + 0xF1)
#define REG_HDMITX_ATOP_79_L         (REG_HDMITX_ATOP_BASE + 0xF2)
#define REG_HDMITX_ATOP_79_H         (REG_HDMITX_ATOP_BASE + 0xF3)
#define REG_HDMITX_ATOP_7A_L         (REG_HDMITX_ATOP_BASE + 0xF4)
#define REG_HDMITX_ATOP_7A_H         (REG_HDMITX_ATOP_BASE + 0xF5)
#define REG_HDMITX_ATOP_7B_L         (REG_HDMITX_ATOP_BASE + 0xF6)
#define REG_HDMITX_ATOP_7B_H         (REG_HDMITX_ATOP_BASE + 0xF7)
#define REG_HDMITX_ATOP_7C_L         (REG_HDMITX_ATOP_BASE + 0xF8)
#define REG_HDMITX_ATOP_7C_H         (REG_HDMITX_ATOP_BASE + 0xF9)
#define REG_HDMITX_ATOP_7D_L         (REG_HDMITX_ATOP_BASE + 0xFA)
#define REG_HDMITX_ATOP_7D_H         (REG_HDMITX_ATOP_BASE + 0xFB)
#define REG_HDMITX_ATOP_7E_L         (REG_HDMITX_ATOP_BASE + 0xFC)
#define REG_HDMITX_ATOP_7E_H         (REG_HDMITX_ATOP_BASE + 0xFD)
#define REG_HDMITX_ATOP_7F_L         (REG_HDMITX_ATOP_BASE + 0xFE)
#define REG_HDMITX_ATOP_7F_H         (REG_HDMITX_ATOP_BASE + 0xFF)

#define REG_CLKGEN_00_L              (REG_CLKGEN_BASE + 0x00)
#define REG_CLKGEN_00_H              (REG_CLKGEN_BASE + 0x01)
#define REG_CLKGEN_01_L              (REG_CLKGEN_BASE + 0x02)
#define REG_CLKGEN_01_H              (REG_CLKGEN_BASE + 0x03)
#define REG_CLKGEN_02_L              (REG_CLKGEN_BASE + 0x04)
#define REG_CLKGEN_02_H              (REG_CLKGEN_BASE + 0x05)
#define REG_CLKGEN_03_L              (REG_CLKGEN_BASE + 0x06)
#define REG_CLKGEN_03_H              (REG_CLKGEN_BASE + 0x07)
#define REG_CLKGEN_04_L              (REG_CLKGEN_BASE + 0x08)
#define REG_CLKGEN_04_H              (REG_CLKGEN_BASE + 0x09)
#define REG_CLKGEN_05_L              (REG_CLKGEN_BASE + 0x0A)
#define REG_CLKGEN_05_H              (REG_CLKGEN_BASE + 0x0B)
#define REG_CLKGEN_06_L              (REG_CLKGEN_BASE + 0x0C)
#define REG_CLKGEN_06_H              (REG_CLKGEN_BASE + 0x0D)
#define REG_CLKGEN_07_L              (REG_CLKGEN_BASE + 0x0E)
#define REG_CLKGEN_07_H              (REG_CLKGEN_BASE + 0x0F)
#define REG_CLKGEN_08_L              (REG_CLKGEN_BASE + 0x10)
#define REG_CLKGEN_08_H              (REG_CLKGEN_BASE + 0x11)
#define REG_CLKGEN_09_L              (REG_CLKGEN_BASE + 0x12)
#define REG_CLKGEN_09_H              (REG_CLKGEN_BASE + 0x13)
#define REG_CLKGEN_0A_L              (REG_CLKGEN_BASE + 0x14)
#define REG_CLKGEN_0A_H              (REG_CLKGEN_BASE + 0x15)
#define REG_CLKGEN_0B_L              (REG_CLKGEN_BASE + 0x16)
#define REG_CLKGEN_0B_H              (REG_CLKGEN_BASE + 0x17)
#define REG_CLKGEN_0C_L              (REG_CLKGEN_BASE + 0x18)
#define REG_CLKGEN_0C_H              (REG_CLKGEN_BASE + 0x19)
#define REG_CLKGEN_0D_L              (REG_CLKGEN_BASE + 0x1A)
#define REG_CLKGEN_0D_H              (REG_CLKGEN_BASE + 0x1B)
#define REG_CLKGEN_0E_L              (REG_CLKGEN_BASE + 0x1C)
#define REG_CLKGEN_0E_H              (REG_CLKGEN_BASE + 0x1D)
#define REG_CLKGEN_0F_L              (REG_CLKGEN_BASE + 0x1E)
#define REG_CLKGEN_0F_H              (REG_CLKGEN_BASE + 0x1F)
#define REG_CLKGEN_10_L              (REG_CLKGEN_BASE + 0x20)
#define REG_CLKGEN_10_H              (REG_CLKGEN_BASE + 0x21)
#define REG_CLKGEN_11_L              (REG_CLKGEN_BASE + 0x22)
#define REG_CLKGEN_11_H              (REG_CLKGEN_BASE + 0x23)
#define REG_CLKGEN_12_L              (REG_CLKGEN_BASE + 0x24)
#define REG_CLKGEN_12_H              (REG_CLKGEN_BASE + 0x25)
#define REG_CLKGEN_13_L              (REG_CLKGEN_BASE + 0x26)
#define REG_CLKGEN_13_H              (REG_CLKGEN_BASE + 0x27)
#define REG_CLKGEN_14_L              (REG_CLKGEN_BASE + 0x28)
#define REG_CLKGEN_14_H              (REG_CLKGEN_BASE + 0x29)
#define REG_CLKGEN_15_L              (REG_CLKGEN_BASE + 0x2A)
#define REG_CLKGEN_15_H              (REG_CLKGEN_BASE + 0x2B)
#define REG_CLKGEN_16_L              (REG_CLKGEN_BASE + 0x2C)
#define REG_CLKGEN_16_H              (REG_CLKGEN_BASE + 0x2D)
#define REG_CLKGEN_17_L              (REG_CLKGEN_BASE + 0x2E)
#define REG_CLKGEN_17_H              (REG_CLKGEN_BASE + 0x2F)
#define REG_CLKGEN_18_L              (REG_CLKGEN_BASE + 0x30)
#define REG_CLKGEN_18_H              (REG_CLKGEN_BASE + 0x31)
#define REG_CLKGEN_19_L              (REG_CLKGEN_BASE + 0x32)
#define REG_CLKGEN_19_H              (REG_CLKGEN_BASE + 0x33)
#define REG_CLKGEN_1A_L              (REG_CLKGEN_BASE + 0x34)
#define REG_CLKGEN_1A_H              (REG_CLKGEN_BASE + 0x35)
#define REG_CLKGEN_1B_L              (REG_CLKGEN_BASE + 0x36)
#define REG_CLKGEN_1B_H              (REG_CLKGEN_BASE + 0x37)
#define REG_CLKGEN_1C_L              (REG_CLKGEN_BASE + 0x38)
#define REG_CLKGEN_1C_H              (REG_CLKGEN_BASE + 0x39)
#define REG_CLKGEN_1D_L              (REG_CLKGEN_BASE + 0x3A)
#define REG_CLKGEN_1D_H              (REG_CLKGEN_BASE + 0x3B)
#define REG_CLKGEN_1E_L              (REG_CLKGEN_BASE + 0x3C)
#define REG_CLKGEN_1E_H              (REG_CLKGEN_BASE + 0x3D)
#define REG_CLKGEN_1F_L              (REG_CLKGEN_BASE + 0x3E)
#define REG_CLKGEN_1F_H              (REG_CLKGEN_BASE + 0x3F)
#define REG_CLKGEN_20_L              (REG_CLKGEN_BASE + 0x40)
#define REG_CLKGEN_20_H              (REG_CLKGEN_BASE + 0x41)
#define REG_CLKGEN_21_L              (REG_CLKGEN_BASE + 0x42)
#define REG_CLKGEN_21_H              (REG_CLKGEN_BASE + 0x43)
#define REG_CLKGEN_22_L              (REG_CLKGEN_BASE + 0x44)
#define REG_CLKGEN_22_H              (REG_CLKGEN_BASE + 0x45)
#define REG_CLKGEN_23_L              (REG_CLKGEN_BASE + 0x46)
#define REG_CLKGEN_23_H              (REG_CLKGEN_BASE + 0x47)
#define REG_CLKGEN_24_L              (REG_CLKGEN_BASE + 0x48)
#define REG_CLKGEN_24_H              (REG_CLKGEN_BASE + 0x49)
#define REG_CLKGEN_25_L              (REG_CLKGEN_BASE + 0x4A)
#define REG_CLKGEN_25_H              (REG_CLKGEN_BASE + 0x4B)
#define REG_CLKGEN_26_L              (REG_CLKGEN_BASE + 0x4C)
#define REG_CLKGEN_26_H              (REG_CLKGEN_BASE + 0x4D)
#define REG_CLKGEN_27_L              (REG_CLKGEN_BASE + 0x4E)
#define REG_CLKGEN_27_H              (REG_CLKGEN_BASE + 0x4F)
#define REG_CLKGEN_28_L              (REG_CLKGEN_BASE + 0x50)
#define REG_CLKGEN_28_H              (REG_CLKGEN_BASE + 0x51)
#define REG_CLKGEN_29_L              (REG_CLKGEN_BASE + 0x52)
#define REG_CLKGEN_29_H              (REG_CLKGEN_BASE + 0x53)
#define REG_CLKGEN_2A_L              (REG_CLKGEN_BASE + 0x54)
#define REG_CLKGEN_2A_H              (REG_CLKGEN_BASE + 0x55)
#define REG_CLKGEN_2B_L              (REG_CLKGEN_BASE + 0x56)
#define REG_CLKGEN_2B_H              (REG_CLKGEN_BASE + 0x57)
#define REG_CLKGEN_2C_L              (REG_CLKGEN_BASE + 0x58)
#define REG_CLKGEN_2C_H              (REG_CLKGEN_BASE + 0x59)
#define REG_CLKGEN_2D_L              (REG_CLKGEN_BASE + 0x5A)
#define REG_CLKGEN_2D_H              (REG_CLKGEN_BASE + 0x5B)
#define REG_CLKGEN_2E_L              (REG_CLKGEN_BASE + 0x5C)
#define REG_CLKGEN_2E_H              (REG_CLKGEN_BASE + 0x5D)
#define REG_CLKGEN_2F_L              (REG_CLKGEN_BASE + 0x5E)
#define REG_CLKGEN_2F_H              (REG_CLKGEN_BASE + 0x5F)
#define REG_CLKGEN_30_L              (REG_CLKGEN_BASE + 0x60)
#define REG_CLKGEN_30_H              (REG_CLKGEN_BASE + 0x61)
#define REG_CLKGEN_31_L              (REG_CLKGEN_BASE + 0x62)
#define REG_CLKGEN_31_H              (REG_CLKGEN_BASE + 0x63)
#define REG_CLKGEN_32_L              (REG_CLKGEN_BASE + 0x64)
#define REG_CLKGEN_32_H              (REG_CLKGEN_BASE + 0x65)
#define REG_CLKGEN_33_L              (REG_CLKGEN_BASE + 0x66)
#define REG_CLKGEN_33_H              (REG_CLKGEN_BASE + 0x67)
#define REG_CLKGEN_34_L              (REG_CLKGEN_BASE + 0x68)
#define REG_CLKGEN_34_H              (REG_CLKGEN_BASE + 0x69)
#define REG_CLKGEN_35_L              (REG_CLKGEN_BASE + 0x6A)
#define REG_CLKGEN_35_H              (REG_CLKGEN_BASE + 0x6B)
#define REG_CLKGEN_36_L              (REG_CLKGEN_BASE + 0x6C)
#define REG_CLKGEN_36_H              (REG_CLKGEN_BASE + 0x6D)
#define REG_CLKGEN_37_L              (REG_CLKGEN_BASE + 0x6E)
#define REG_CLKGEN_37_H              (REG_CLKGEN_BASE + 0x6F)
#define REG_CLKGEN_38_L              (REG_CLKGEN_BASE + 0x70)
#define REG_CLKGEN_38_H              (REG_CLKGEN_BASE + 0x71)
#define REG_CLKGEN_39_L              (REG_CLKGEN_BASE + 0x72)
#define REG_CLKGEN_39_H              (REG_CLKGEN_BASE + 0x73)
#define REG_CLKGEN_3A_L              (REG_CLKGEN_BASE + 0x74)
#define REG_CLKGEN_3A_H              (REG_CLKGEN_BASE + 0x75)
#define REG_CLKGEN_3B_L              (REG_CLKGEN_BASE + 0x76)
#define REG_CLKGEN_3B_H              (REG_CLKGEN_BASE + 0x77)
#define REG_CLKGEN_3C_L              (REG_CLKGEN_BASE + 0x78)
#define REG_CLKGEN_3C_H              (REG_CLKGEN_BASE + 0x79)
#define REG_CLKGEN_3D_L              (REG_CLKGEN_BASE + 0x7A)
#define REG_CLKGEN_3D_H              (REG_CLKGEN_BASE + 0x7B)
#define REG_CLKGEN_3E_L              (REG_CLKGEN_BASE + 0x7C)
#define REG_CLKGEN_3E_H              (REG_CLKGEN_BASE + 0x7D)
#define REG_CLKGEN_3F_L              (REG_CLKGEN_BASE + 0x7E)
#define REG_CLKGEN_3F_H              (REG_CLKGEN_BASE + 0x7F)
#define REG_CLKGEN_40_L              (REG_CLKGEN_BASE + 0x80)
#define REG_CLKGEN_40_H              (REG_CLKGEN_BASE + 0x81)
#define REG_CLKGEN_41_L              (REG_CLKGEN_BASE + 0x82)
#define REG_CLKGEN_41_H              (REG_CLKGEN_BASE + 0x83)
#define REG_CLKGEN_42_L              (REG_CLKGEN_BASE + 0x84)
#define REG_CLKGEN_42_H              (REG_CLKGEN_BASE + 0x85)
#define REG_CLKGEN_43_L              (REG_CLKGEN_BASE + 0x86)
#define REG_CLKGEN_43_H              (REG_CLKGEN_BASE + 0x87)
#define REG_CLKGEN_44_L              (REG_CLKGEN_BASE + 0x88)
#define REG_CLKGEN_44_H              (REG_CLKGEN_BASE + 0x89)
#define REG_CLKGEN_45_L              (REG_CLKGEN_BASE + 0x8A)
#define REG_CLKGEN_45_H              (REG_CLKGEN_BASE + 0x8B)
#define REG_CLKGEN_46_L              (REG_CLKGEN_BASE + 0x8C)
#define REG_CLKGEN_46_H              (REG_CLKGEN_BASE + 0x8D)
#define REG_CLKGEN_47_L              (REG_CLKGEN_BASE + 0x8E)
#define REG_CLKGEN_47_H              (REG_CLKGEN_BASE + 0x8F)
#define REG_CLKGEN_48_L              (REG_CLKGEN_BASE + 0x90)
#define REG_CLKGEN_48_H              (REG_CLKGEN_BASE + 0x91)
#define REG_CLKGEN_49_L              (REG_CLKGEN_BASE + 0x92)
#define REG_CLKGEN_49_H              (REG_CLKGEN_BASE + 0x93)
#define REG_CLKGEN_4A_L              (REG_CLKGEN_BASE + 0x94)
#define REG_CLKGEN_4A_H              (REG_CLKGEN_BASE + 0x95)
#define REG_CLKGEN_4B_L              (REG_CLKGEN_BASE + 0x96)
#define REG_CLKGEN_4B_H              (REG_CLKGEN_BASE + 0x97)
#define REG_CLKGEN_4C_L              (REG_CLKGEN_BASE + 0x98)
#define REG_CLKGEN_4C_H              (REG_CLKGEN_BASE + 0x99)
#define REG_CLKGEN_4D_L              (REG_CLKGEN_BASE + 0x9A)
#define REG_CLKGEN_4D_H              (REG_CLKGEN_BASE + 0x9B)
#define REG_CLKGEN_4E_L              (REG_CLKGEN_BASE + 0x9C)
#define REG_CLKGEN_4E_H              (REG_CLKGEN_BASE + 0x9D)
#define REG_CLKGEN_4F_L              (REG_CLKGEN_BASE + 0x9E)
#define REG_CLKGEN_4F_H              (REG_CLKGEN_BASE + 0x9F)
#define REG_CLKGEN_50_L              (REG_CLKGEN_BASE + 0xA0)
#define REG_CLKGEN_50_H              (REG_CLKGEN_BASE + 0xA1)
#define REG_CLKGEN_51_L              (REG_CLKGEN_BASE + 0xA2)
#define REG_CLKGEN_51_H              (REG_CLKGEN_BASE + 0xA3)
#define REG_CLKGEN_52_L              (REG_CLKGEN_BASE + 0xA4)
#define REG_CLKGEN_52_H              (REG_CLKGEN_BASE + 0xA5)
#define REG_CLKGEN_53_L              (REG_CLKGEN_BASE + 0xA6)
#define REG_CLKGEN_53_H              (REG_CLKGEN_BASE + 0xA7)
#define REG_CLKGEN_54_L              (REG_CLKGEN_BASE + 0xA8)
#define REG_CLKGEN_54_H              (REG_CLKGEN_BASE + 0xA9)
#define REG_CLKGEN_55_L              (REG_CLKGEN_BASE + 0xAA)
#define REG_CLKGEN_55_H              (REG_CLKGEN_BASE + 0xAB)
#define REG_CLKGEN_56_L              (REG_CLKGEN_BASE + 0xAC)
#define REG_CLKGEN_56_H              (REG_CLKGEN_BASE + 0xAD)
#define REG_CLKGEN_57_L              (REG_CLKGEN_BASE + 0xAE)
#define REG_CLKGEN_57_H              (REG_CLKGEN_BASE + 0xAF)
#define REG_CLKGEN_58_L              (REG_CLKGEN_BASE + 0xB0)
#define REG_CLKGEN_58_H              (REG_CLKGEN_BASE + 0xB1)
#define REG_CLKGEN_59_L              (REG_CLKGEN_BASE + 0xB2)
#define REG_CLKGEN_59_H              (REG_CLKGEN_BASE + 0xB3)
#define REG_CLKGEN_5A_L              (REG_CLKGEN_BASE + 0xB4)
#define REG_CLKGEN_5A_H              (REG_CLKGEN_BASE + 0xB5)
#define REG_CLKGEN_5B_L              (REG_CLKGEN_BASE + 0xB6)
#define REG_CLKGEN_5B_H              (REG_CLKGEN_BASE + 0xB7)
#define REG_CLKGEN_5C_L              (REG_CLKGEN_BASE + 0xB8)
#define REG_CLKGEN_5C_H              (REG_CLKGEN_BASE + 0xB9)
#define REG_CLKGEN_5D_L              (REG_CLKGEN_BASE + 0xBA)
#define REG_CLKGEN_5D_H              (REG_CLKGEN_BASE + 0xBB)
#define REG_CLKGEN_5E_L              (REG_CLKGEN_BASE + 0xBC)
#define REG_CLKGEN_5E_H              (REG_CLKGEN_BASE + 0xBD)
#define REG_CLKGEN_5F_L              (REG_CLKGEN_BASE + 0xBE)
#define REG_CLKGEN_5F_H              (REG_CLKGEN_BASE + 0xBF)
#define REG_CLKGEN_60_L              (REG_CLKGEN_BASE + 0xC0)
#define REG_CLKGEN_60_H              (REG_CLKGEN_BASE + 0xC1)
#define REG_CLKGEN_61_L              (REG_CLKGEN_BASE + 0xC2)
#define REG_CLKGEN_61_H              (REG_CLKGEN_BASE + 0xC3)
#define REG_CLKGEN_62_L              (REG_CLKGEN_BASE + 0xC4)
#define REG_CLKGEN_62_H              (REG_CLKGEN_BASE + 0xC5)
#define REG_CLKGEN_63_L              (REG_CLKGEN_BASE + 0xC6)
#define REG_CLKGEN_63_H              (REG_CLKGEN_BASE + 0xC7)
#define REG_CLKGEN_64_L              (REG_CLKGEN_BASE + 0xC8)
#define REG_CLKGEN_64_H              (REG_CLKGEN_BASE + 0xC9)
#define REG_CLKGEN_65_L              (REG_CLKGEN_BASE + 0xCA)
#define REG_CLKGEN_65_H              (REG_CLKGEN_BASE + 0xCB)
#define REG_CLKGEN_66_L              (REG_CLKGEN_BASE + 0xCC)
#define REG_CLKGEN_66_H              (REG_CLKGEN_BASE + 0xCD)
#define REG_CLKGEN_67_L              (REG_CLKGEN_BASE + 0xCE)
#define REG_CLKGEN_67_H              (REG_CLKGEN_BASE + 0xCF)
#define REG_CLKGEN_68_L              (REG_CLKGEN_BASE + 0xD0)
#define REG_CLKGEN_68_H              (REG_CLKGEN_BASE + 0xD1)
#define REG_CLKGEN_69_L              (REG_CLKGEN_BASE + 0xD2)
#define REG_CLKGEN_69_H              (REG_CLKGEN_BASE + 0xD3)
#define REG_CLKGEN_6A_L              (REG_CLKGEN_BASE + 0xD4)
#define REG_CLKGEN_6A_H              (REG_CLKGEN_BASE + 0xD5)
#define REG_CLKGEN_6B_L              (REG_CLKGEN_BASE + 0xD6)
#define REG_CLKGEN_6B_H              (REG_CLKGEN_BASE + 0xD7)
#define REG_CLKGEN_6C_L              (REG_CLKGEN_BASE + 0xD8)
#define REG_CLKGEN_6C_H              (REG_CLKGEN_BASE + 0xD9)
#define REG_CLKGEN_6D_L              (REG_CLKGEN_BASE + 0xDA)
#define REG_CLKGEN_6D_H              (REG_CLKGEN_BASE + 0xDB)
#define REG_CLKGEN_6E_L              (REG_CLKGEN_BASE + 0xDC)
#define REG_CLKGEN_6E_H              (REG_CLKGEN_BASE + 0xDD)
#define REG_CLKGEN_6F_L              (REG_CLKGEN_BASE + 0xDE)
#define REG_CLKGEN_6F_H              (REG_CLKGEN_BASE + 0xDF)
#define REG_CLKGEN_70_L              (REG_CLKGEN_BASE + 0xE0)
#define REG_CLKGEN_70_H              (REG_CLKGEN_BASE + 0xE1)
#define REG_CLKGEN_71_L              (REG_CLKGEN_BASE + 0xE2)
#define REG_CLKGEN_71_H              (REG_CLKGEN_BASE + 0xE3)
#define REG_CLKGEN_72_L              (REG_CLKGEN_BASE + 0xE4)
#define REG_CLKGEN_72_H              (REG_CLKGEN_BASE + 0xE5)
#define REG_CLKGEN_73_L              (REG_CLKGEN_BASE + 0xE6)
#define REG_CLKGEN_73_H              (REG_CLKGEN_BASE + 0xE7)
#define REG_CLKGEN_74_L              (REG_CLKGEN_BASE + 0xE8)
#define REG_CLKGEN_74_H              (REG_CLKGEN_BASE + 0xE9)
#define REG_CLKGEN_75_L              (REG_CLKGEN_BASE + 0xEA)
#define REG_CLKGEN_75_H              (REG_CLKGEN_BASE + 0xEB)
#define REG_CLKGEN_76_L              (REG_CLKGEN_BASE + 0xEC)
#define REG_CLKGEN_76_H              (REG_CLKGEN_BASE + 0xED)
#define REG_CLKGEN_77_L              (REG_CLKGEN_BASE + 0xEE)
#define REG_CLKGEN_77_H              (REG_CLKGEN_BASE + 0xEF)
#define REG_CLKGEN_78_L              (REG_CLKGEN_BASE + 0xF0)
#define REG_CLKGEN_78_H              (REG_CLKGEN_BASE + 0xF1)
#define REG_CLKGEN_79_L              (REG_CLKGEN_BASE + 0xF2)
#define REG_CLKGEN_79_H              (REG_CLKGEN_BASE + 0xF3)
#define REG_CLKGEN_7A_L              (REG_CLKGEN_BASE + 0xF4)
#define REG_CLKGEN_7A_H              (REG_CLKGEN_BASE + 0xF5)
#define REG_CLKGEN_7B_L              (REG_CLKGEN_BASE + 0xF6)
#define REG_CLKGEN_7B_H              (REG_CLKGEN_BASE + 0xF7)
#define REG_CLKGEN_7C_L              (REG_CLKGEN_BASE + 0xF8)
#define REG_CLKGEN_7C_H              (REG_CLKGEN_BASE + 0xF9)
#define REG_CLKGEN_7D_L              (REG_CLKGEN_BASE + 0xFA)
#define REG_CLKGEN_7D_H              (REG_CLKGEN_BASE + 0xFB)
#define REG_CLKGEN_7E_L              (REG_CLKGEN_BASE + 0xFC)
#define REG_CLKGEN_7E_H              (REG_CLKGEN_BASE + 0xFD)
#define REG_CLKGEN_7F_L              (REG_CLKGEN_BASE + 0xFE)
#define REG_CLKGEN_7F_H              (REG_CLKGEN_BASE + 0xFF)

#define REG_SC_CTRL_00_L             (REG_SC_CTRL_BASE + 0x00)
#define REG_SC_CTRL_00_H             (REG_SC_CTRL_BASE + 0x01)
#define REG_SC_CTRL_01_L             (REG_SC_CTRL_BASE + 0x02)
#define REG_SC_CTRL_01_H             (REG_SC_CTRL_BASE + 0x03)
#define REG_SC_CTRL_02_L             (REG_SC_CTRL_BASE + 0x04)
#define REG_SC_CTRL_02_H             (REG_SC_CTRL_BASE + 0x05)
#define REG_SC_CTRL_03_L             (REG_SC_CTRL_BASE + 0x06)
#define REG_SC_CTRL_03_H             (REG_SC_CTRL_BASE + 0x07)
#define REG_SC_CTRL_04_L             (REG_SC_CTRL_BASE + 0x08)
#define REG_SC_CTRL_04_H             (REG_SC_CTRL_BASE + 0x09)
#define REG_SC_CTRL_05_L             (REG_SC_CTRL_BASE + 0x0A)
#define REG_SC_CTRL_05_H             (REG_SC_CTRL_BASE + 0x0B)
#define REG_SC_CTRL_06_L             (REG_SC_CTRL_BASE + 0x0C)
#define REG_SC_CTRL_06_H             (REG_SC_CTRL_BASE + 0x0D)
#define REG_SC_CTRL_07_L             (REG_SC_CTRL_BASE + 0x0E)
#define REG_SC_CTRL_07_H             (REG_SC_CTRL_BASE + 0x0F)
#define REG_SC_CTRL_08_L             (REG_SC_CTRL_BASE + 0x10)
#define REG_SC_CTRL_08_H             (REG_SC_CTRL_BASE + 0x11)
#define REG_SC_CTRL_09_L             (REG_SC_CTRL_BASE + 0x12)
#define REG_SC_CTRL_09_H             (REG_SC_CTRL_BASE + 0x13)
#define REG_SC_CTRL_0A_L             (REG_SC_CTRL_BASE + 0x14)
#define REG_SC_CTRL_0A_H             (REG_SC_CTRL_BASE + 0x15)
#define REG_SC_CTRL_0B_L             (REG_SC_CTRL_BASE + 0x16)
#define REG_SC_CTRL_0B_H             (REG_SC_CTRL_BASE + 0x17)
#define REG_SC_CTRL_0C_L             (REG_SC_CTRL_BASE + 0x18)
#define REG_SC_CTRL_0C_H             (REG_SC_CTRL_BASE + 0x19)
#define REG_SC_CTRL_0D_L             (REG_SC_CTRL_BASE + 0x1A)
#define REG_SC_CTRL_0D_H             (REG_SC_CTRL_BASE + 0x1B)
#define REG_SC_CTRL_0E_L             (REG_SC_CTRL_BASE + 0x1C)
#define REG_SC_CTRL_0E_H             (REG_SC_CTRL_BASE + 0x1D)
#define REG_SC_CTRL_0F_L             (REG_SC_CTRL_BASE + 0x1E)
#define REG_SC_CTRL_0F_H             (REG_SC_CTRL_BASE + 0x1F)
#define REG_SC_CTRL_10_L             (REG_SC_CTRL_BASE + 0x20)
#define REG_SC_CTRL_10_H             (REG_SC_CTRL_BASE + 0x21)
#define REG_SC_CTRL_11_L             (REG_SC_CTRL_BASE + 0x22)
#define REG_SC_CTRL_11_H             (REG_SC_CTRL_BASE + 0x23)
#define REG_SC_CTRL_12_L             (REG_SC_CTRL_BASE + 0x24)
#define REG_SC_CTRL_12_H             (REG_SC_CTRL_BASE + 0x25)
#define REG_SC_CTRL_13_L             (REG_SC_CTRL_BASE + 0x26)
#define REG_SC_CTRL_13_H             (REG_SC_CTRL_BASE + 0x27)
#define REG_SC_CTRL_14_L             (REG_SC_CTRL_BASE + 0x28)
#define REG_SC_CTRL_14_H             (REG_SC_CTRL_BASE + 0x29)
#define REG_SC_CTRL_15_L             (REG_SC_CTRL_BASE + 0x2A)
#define REG_SC_CTRL_15_H             (REG_SC_CTRL_BASE + 0x2B)
#define REG_SC_CTRL_16_L             (REG_SC_CTRL_BASE + 0x2C)
#define REG_SC_CTRL_16_H             (REG_SC_CTRL_BASE + 0x2D)
#define REG_SC_CTRL_17_L             (REG_SC_CTRL_BASE + 0x2E)
#define REG_SC_CTRL_17_H             (REG_SC_CTRL_BASE + 0x2F)
#define REG_SC_CTRL_18_L             (REG_SC_CTRL_BASE + 0x30)
#define REG_SC_CTRL_18_H             (REG_SC_CTRL_BASE + 0x31)
#define REG_SC_CTRL_19_L             (REG_SC_CTRL_BASE + 0x32)
#define REG_SC_CTRL_19_H             (REG_SC_CTRL_BASE + 0x33)
#define REG_SC_CTRL_1A_L             (REG_SC_CTRL_BASE + 0x34)
#define REG_SC_CTRL_1A_H             (REG_SC_CTRL_BASE + 0x35)
#define REG_SC_CTRL_1B_L             (REG_SC_CTRL_BASE + 0x36)
#define REG_SC_CTRL_1B_H             (REG_SC_CTRL_BASE + 0x37)
#define REG_SC_CTRL_1C_L             (REG_SC_CTRL_BASE + 0x38)
#define REG_SC_CTRL_1C_H             (REG_SC_CTRL_BASE + 0x39)
#define REG_SC_CTRL_1D_L             (REG_SC_CTRL_BASE + 0x3A)
#define REG_SC_CTRL_1D_H             (REG_SC_CTRL_BASE + 0x3B)
#define REG_SC_CTRL_1E_L             (REG_SC_CTRL_BASE + 0x3C)
#define REG_SC_CTRL_1E_H             (REG_SC_CTRL_BASE + 0x3D)
#define REG_SC_CTRL_1F_L             (REG_SC_CTRL_BASE + 0x3E)
#define REG_SC_CTRL_1F_H             (REG_SC_CTRL_BASE + 0x3F)
#define REG_SC_CTRL_20_L             (REG_SC_CTRL_BASE + 0x40)
#define REG_SC_CTRL_20_H             (REG_SC_CTRL_BASE + 0x41)
#define REG_SC_CTRL_21_L             (REG_SC_CTRL_BASE + 0x42)
#define REG_SC_CTRL_21_H             (REG_SC_CTRL_BASE + 0x43)
#define REG_SC_CTRL_22_L             (REG_SC_CTRL_BASE + 0x44)
#define REG_SC_CTRL_22_H             (REG_SC_CTRL_BASE + 0x45)
#define REG_SC_CTRL_23_L             (REG_SC_CTRL_BASE + 0x46)
#define REG_SC_CTRL_23_H             (REG_SC_CTRL_BASE + 0x47)
#define REG_SC_CTRL_24_L             (REG_SC_CTRL_BASE + 0x48)
#define REG_SC_CTRL_24_H             (REG_SC_CTRL_BASE + 0x49)
#define REG_SC_CTRL_25_L             (REG_SC_CTRL_BASE + 0x4A)
#define REG_SC_CTRL_25_H             (REG_SC_CTRL_BASE + 0x4B)
#define REG_SC_CTRL_26_L             (REG_SC_CTRL_BASE + 0x4C)
#define REG_SC_CTRL_26_H             (REG_SC_CTRL_BASE + 0x4D)
#define REG_SC_CTRL_27_L             (REG_SC_CTRL_BASE + 0x4E)
#define REG_SC_CTRL_27_H             (REG_SC_CTRL_BASE + 0x4F)
#define REG_SC_CTRL_28_L             (REG_SC_CTRL_BASE + 0x50)
#define REG_SC_CTRL_28_H             (REG_SC_CTRL_BASE + 0x51)
#define REG_SC_CTRL_29_L             (REG_SC_CTRL_BASE + 0x52)
#define REG_SC_CTRL_29_H             (REG_SC_CTRL_BASE + 0x53)
#define REG_SC_CTRL_2A_L             (REG_SC_CTRL_BASE + 0x54)
#define REG_SC_CTRL_2A_H             (REG_SC_CTRL_BASE + 0x55)
#define REG_SC_CTRL_2B_L             (REG_SC_CTRL_BASE + 0x56)
#define REG_SC_CTRL_2B_H             (REG_SC_CTRL_BASE + 0x57)
#define REG_SC_CTRL_2C_L             (REG_SC_CTRL_BASE + 0x58)
#define REG_SC_CTRL_2C_H             (REG_SC_CTRL_BASE + 0x59)
#define REG_SC_CTRL_2D_L             (REG_SC_CTRL_BASE + 0x5A)
#define REG_SC_CTRL_2D_H             (REG_SC_CTRL_BASE + 0x5B)
#define REG_SC_CTRL_2E_L             (REG_SC_CTRL_BASE + 0x5C)
#define REG_SC_CTRL_2E_H             (REG_SC_CTRL_BASE + 0x5D)
#define REG_SC_CTRL_2F_L             (REG_SC_CTRL_BASE + 0x5E)
#define REG_SC_CTRL_2F_H             (REG_SC_CTRL_BASE + 0x5F)
#define REG_SC_CTRL_30_L             (REG_SC_CTRL_BASE + 0x60)
#define REG_SC_CTRL_30_H             (REG_SC_CTRL_BASE + 0x61)
#define REG_SC_CTRL_31_L             (REG_SC_CTRL_BASE + 0x62)
#define REG_SC_CTRL_31_H             (REG_SC_CTRL_BASE + 0x63)
#define REG_SC_CTRL_32_L             (REG_SC_CTRL_BASE + 0x64)
#define REG_SC_CTRL_32_H             (REG_SC_CTRL_BASE + 0x65)
#define REG_SC_CTRL_33_L             (REG_SC_CTRL_BASE + 0x66)
#define REG_SC_CTRL_33_H             (REG_SC_CTRL_BASE + 0x67)
#define REG_SC_CTRL_34_L             (REG_SC_CTRL_BASE + 0x68)
#define REG_SC_CTRL_34_H             (REG_SC_CTRL_BASE + 0x69)
#define REG_SC_CTRL_35_L             (REG_SC_CTRL_BASE + 0x6A)
#define REG_SC_CTRL_35_H             (REG_SC_CTRL_BASE + 0x6B)
#define REG_SC_CTRL_36_L             (REG_SC_CTRL_BASE + 0x6C)
#define REG_SC_CTRL_36_H             (REG_SC_CTRL_BASE + 0x6D)
#define REG_SC_CTRL_37_L             (REG_SC_CTRL_BASE + 0x6E)
#define REG_SC_CTRL_37_H             (REG_SC_CTRL_BASE + 0x6F)
#define REG_SC_CTRL_38_L             (REG_SC_CTRL_BASE + 0x70)
#define REG_SC_CTRL_38_H             (REG_SC_CTRL_BASE + 0x71)
#define REG_SC_CTRL_39_L             (REG_SC_CTRL_BASE + 0x72)
#define REG_SC_CTRL_39_H             (REG_SC_CTRL_BASE + 0x73)
#define REG_SC_CTRL_3A_L             (REG_SC_CTRL_BASE + 0x74)
#define REG_SC_CTRL_3A_H             (REG_SC_CTRL_BASE + 0x75)
#define REG_SC_CTRL_3B_L             (REG_SC_CTRL_BASE + 0x76)
#define REG_SC_CTRL_3B_H             (REG_SC_CTRL_BASE + 0x77)
#define REG_SC_CTRL_3C_L             (REG_SC_CTRL_BASE + 0x78)
#define REG_SC_CTRL_3C_H             (REG_SC_CTRL_BASE + 0x79)
#define REG_SC_CTRL_3D_L             (REG_SC_CTRL_BASE + 0x7A)
#define REG_SC_CTRL_3D_H             (REG_SC_CTRL_BASE + 0x7B)
#define REG_SC_CTRL_3E_L             (REG_SC_CTRL_BASE + 0x7C)
#define REG_SC_CTRL_3E_H             (REG_SC_CTRL_BASE + 0x7D)
#define REG_SC_CTRL_3F_L             (REG_SC_CTRL_BASE + 0x7E)
#define REG_SC_CTRL_3F_H             (REG_SC_CTRL_BASE + 0x7F)
#define REG_SC_CTRL_40_L             (REG_SC_CTRL_BASE + 0x80)
#define REG_SC_CTRL_40_H             (REG_SC_CTRL_BASE + 0x81)
#define REG_SC_CTRL_41_L             (REG_SC_CTRL_BASE + 0x82)
#define REG_SC_CTRL_41_H             (REG_SC_CTRL_BASE + 0x83)
#define REG_SC_CTRL_42_L             (REG_SC_CTRL_BASE + 0x84)
#define REG_SC_CTRL_42_H             (REG_SC_CTRL_BASE + 0x85)
#define REG_SC_CTRL_43_L             (REG_SC_CTRL_BASE + 0x86)
#define REG_SC_CTRL_43_H             (REG_SC_CTRL_BASE + 0x87)
#define REG_SC_CTRL_44_L             (REG_SC_CTRL_BASE + 0x88)
#define REG_SC_CTRL_44_H             (REG_SC_CTRL_BASE + 0x89)
#define REG_SC_CTRL_45_L             (REG_SC_CTRL_BASE + 0x8A)
#define REG_SC_CTRL_45_H             (REG_SC_CTRL_BASE + 0x8B)
#define REG_SC_CTRL_46_L             (REG_SC_CTRL_BASE + 0x8C)
#define REG_SC_CTRL_46_H             (REG_SC_CTRL_BASE + 0x8D)
#define REG_SC_CTRL_47_L             (REG_SC_CTRL_BASE + 0x8E)
#define REG_SC_CTRL_47_H             (REG_SC_CTRL_BASE + 0x8F)
#define REG_SC_CTRL_48_L             (REG_SC_CTRL_BASE + 0x90)
#define REG_SC_CTRL_48_H             (REG_SC_CTRL_BASE + 0x91)
#define REG_SC_CTRL_49_L             (REG_SC_CTRL_BASE + 0x92)
#define REG_SC_CTRL_49_H             (REG_SC_CTRL_BASE + 0x93)
#define REG_SC_CTRL_4A_L             (REG_SC_CTRL_BASE + 0x94)
#define REG_SC_CTRL_4A_H             (REG_SC_CTRL_BASE + 0x95)
#define REG_SC_CTRL_4B_L             (REG_SC_CTRL_BASE + 0x96)
#define REG_SC_CTRL_4B_H             (REG_SC_CTRL_BASE + 0x97)
#define REG_SC_CTRL_4C_L             (REG_SC_CTRL_BASE + 0x98)
#define REG_SC_CTRL_4C_H             (REG_SC_CTRL_BASE + 0x99)
#define REG_SC_CTRL_4D_L             (REG_SC_CTRL_BASE + 0x9A)
#define REG_SC_CTRL_4D_H             (REG_SC_CTRL_BASE + 0x9B)
#define REG_SC_CTRL_4E_L             (REG_SC_CTRL_BASE + 0x9C)
#define REG_SC_CTRL_4E_H             (REG_SC_CTRL_BASE + 0x9D)
#define REG_SC_CTRL_4F_L             (REG_SC_CTRL_BASE + 0x9E)
#define REG_SC_CTRL_4F_H             (REG_SC_CTRL_BASE + 0x9F)
#define REG_SC_CTRL_50_L             (REG_SC_CTRL_BASE + 0xA0)
#define REG_SC_CTRL_50_H             (REG_SC_CTRL_BASE + 0xA1)
#define REG_SC_CTRL_51_L             (REG_SC_CTRL_BASE + 0xA2)
#define REG_SC_CTRL_51_H             (REG_SC_CTRL_BASE + 0xA3)
#define REG_SC_CTRL_52_L             (REG_SC_CTRL_BASE + 0xA4)
#define REG_SC_CTRL_52_H             (REG_SC_CTRL_BASE + 0xA5)
#define REG_SC_CTRL_53_L             (REG_SC_CTRL_BASE + 0xA6)
#define REG_SC_CTRL_53_H             (REG_SC_CTRL_BASE + 0xA7)
#define REG_SC_CTRL_54_L             (REG_SC_CTRL_BASE + 0xA8)
#define REG_SC_CTRL_54_H             (REG_SC_CTRL_BASE + 0xA9)
#define REG_SC_CTRL_55_L             (REG_SC_CTRL_BASE + 0xAA)
#define REG_SC_CTRL_55_H             (REG_SC_CTRL_BASE + 0xAB)
#define REG_SC_CTRL_56_L             (REG_SC_CTRL_BASE + 0xAC)
#define REG_SC_CTRL_56_H             (REG_SC_CTRL_BASE + 0xAD)
#define REG_SC_CTRL_57_L             (REG_SC_CTRL_BASE + 0xAE)
#define REG_SC_CTRL_57_H             (REG_SC_CTRL_BASE + 0xAF)
#define REG_SC_CTRL_58_L             (REG_SC_CTRL_BASE + 0xB0)
#define REG_SC_CTRL_58_H             (REG_SC_CTRL_BASE + 0xB1)
#define REG_SC_CTRL_59_L             (REG_SC_CTRL_BASE + 0xB2)
#define REG_SC_CTRL_59_H             (REG_SC_CTRL_BASE + 0xB3)
#define REG_SC_CTRL_5A_L             (REG_SC_CTRL_BASE + 0xB4)
#define REG_SC_CTRL_5A_H             (REG_SC_CTRL_BASE + 0xB5)
#define REG_SC_CTRL_5B_L             (REG_SC_CTRL_BASE + 0xB6)
#define REG_SC_CTRL_5B_H             (REG_SC_CTRL_BASE + 0xB7)
#define REG_SC_CTRL_5C_L             (REG_SC_CTRL_BASE + 0xB8)
#define REG_SC_CTRL_5C_H             (REG_SC_CTRL_BASE + 0xB9)
#define REG_SC_CTRL_5D_L             (REG_SC_CTRL_BASE + 0xBA)
#define REG_SC_CTRL_5D_H             (REG_SC_CTRL_BASE + 0xBB)
#define REG_SC_CTRL_5E_L             (REG_SC_CTRL_BASE + 0xBC)
#define REG_SC_CTRL_5E_H             (REG_SC_CTRL_BASE + 0xBD)
#define REG_SC_CTRL_5F_L             (REG_SC_CTRL_BASE + 0xBE)
#define REG_SC_CTRL_5F_H             (REG_SC_CTRL_BASE + 0xBF)
#define REG_SC_CTRL_60_L             (REG_SC_CTRL_BASE + 0xC0)
#define REG_SC_CTRL_60_H             (REG_SC_CTRL_BASE + 0xC1)
#define REG_SC_CTRL_61_L             (REG_SC_CTRL_BASE + 0xC2)
#define REG_SC_CTRL_61_H             (REG_SC_CTRL_BASE + 0xC3)
#define REG_SC_CTRL_62_L             (REG_SC_CTRL_BASE + 0xC4)
#define REG_SC_CTRL_62_H             (REG_SC_CTRL_BASE + 0xC5)
#define REG_SC_CTRL_63_L             (REG_SC_CTRL_BASE + 0xC6)
#define REG_SC_CTRL_63_H             (REG_SC_CTRL_BASE + 0xC7)
#define REG_SC_CTRL_64_L             (REG_SC_CTRL_BASE + 0xC8)
#define REG_SC_CTRL_64_H             (REG_SC_CTRL_BASE + 0xC9)
#define REG_SC_CTRL_65_L             (REG_SC_CTRL_BASE + 0xCA)
#define REG_SC_CTRL_65_H             (REG_SC_CTRL_BASE + 0xCB)
#define REG_SC_CTRL_66_L             (REG_SC_CTRL_BASE + 0xCC)
#define REG_SC_CTRL_66_H             (REG_SC_CTRL_BASE + 0xCD)
#define REG_SC_CTRL_67_L             (REG_SC_CTRL_BASE + 0xCE)
#define REG_SC_CTRL_67_H             (REG_SC_CTRL_BASE + 0xCF)
#define REG_SC_CTRL_68_L             (REG_SC_CTRL_BASE + 0xD0)
#define REG_SC_CTRL_68_H             (REG_SC_CTRL_BASE + 0xD1)
#define REG_SC_CTRL_69_L             (REG_SC_CTRL_BASE + 0xD2)
#define REG_SC_CTRL_69_H             (REG_SC_CTRL_BASE + 0xD3)
#define REG_SC_CTRL_6A_L             (REG_SC_CTRL_BASE + 0xD4)
#define REG_SC_CTRL_6A_H             (REG_SC_CTRL_BASE + 0xD5)
#define REG_SC_CTRL_6B_L             (REG_SC_CTRL_BASE + 0xD6)
#define REG_SC_CTRL_6B_H             (REG_SC_CTRL_BASE + 0xD7)
#define REG_SC_CTRL_6C_L             (REG_SC_CTRL_BASE + 0xD8)
#define REG_SC_CTRL_6C_H             (REG_SC_CTRL_BASE + 0xD9)
#define REG_SC_CTRL_6D_L             (REG_SC_CTRL_BASE + 0xDA)
#define REG_SC_CTRL_6D_H             (REG_SC_CTRL_BASE + 0xDB)
#define REG_SC_CTRL_6E_L             (REG_SC_CTRL_BASE + 0xDC)
#define REG_SC_CTRL_6E_H             (REG_SC_CTRL_BASE + 0xDD)
#define REG_SC_CTRL_6F_L             (REG_SC_CTRL_BASE + 0xDE)
#define REG_SC_CTRL_6F_H             (REG_SC_CTRL_BASE + 0xDF)
#define REG_SC_CTRL_70_L             (REG_SC_CTRL_BASE + 0xE0)
#define REG_SC_CTRL_70_H             (REG_SC_CTRL_BASE + 0xE1)
#define REG_SC_CTRL_71_L             (REG_SC_CTRL_BASE + 0xE2)
#define REG_SC_CTRL_71_H             (REG_SC_CTRL_BASE + 0xE3)
#define REG_SC_CTRL_72_L             (REG_SC_CTRL_BASE + 0xE4)
#define REG_SC_CTRL_72_H             (REG_SC_CTRL_BASE + 0xE5)
#define REG_SC_CTRL_73_L             (REG_SC_CTRL_BASE + 0xE6)
#define REG_SC_CTRL_73_H             (REG_SC_CTRL_BASE + 0xE7)
#define REG_SC_CTRL_74_L             (REG_SC_CTRL_BASE + 0xE8)
#define REG_SC_CTRL_74_H             (REG_SC_CTRL_BASE + 0xE9)
#define REG_SC_CTRL_75_L             (REG_SC_CTRL_BASE + 0xEA)
#define REG_SC_CTRL_75_H             (REG_SC_CTRL_BASE + 0xEB)
#define REG_SC_CTRL_76_L             (REG_SC_CTRL_BASE + 0xEC)
#define REG_SC_CTRL_76_H             (REG_SC_CTRL_BASE + 0xED)
#define REG_SC_CTRL_77_L             (REG_SC_CTRL_BASE + 0xEE)
#define REG_SC_CTRL_77_H             (REG_SC_CTRL_BASE + 0xEF)
#define REG_SC_CTRL_78_L             (REG_SC_CTRL_BASE + 0xF0)
#define REG_SC_CTRL_78_H             (REG_SC_CTRL_BASE + 0xF1)
#define REG_SC_CTRL_79_L             (REG_SC_CTRL_BASE + 0xF2)
#define REG_SC_CTRL_79_H             (REG_SC_CTRL_BASE + 0xF3)
#define REG_SC_CTRL_7A_L             (REG_SC_CTRL_BASE + 0xF4)
#define REG_SC_CTRL_7A_H             (REG_SC_CTRL_BASE + 0xF5)
#define REG_SC_CTRL_7B_L             (REG_SC_CTRL_BASE + 0xF6)
#define REG_SC_CTRL_7B_H             (REG_SC_CTRL_BASE + 0xF7)
#define REG_SC_CTRL_7C_L             (REG_SC_CTRL_BASE + 0xF8)
#define REG_SC_CTRL_7C_H             (REG_SC_CTRL_BASE + 0xF9)
#define REG_SC_CTRL_7D_L             (REG_SC_CTRL_BASE + 0xFA)
#define REG_SC_CTRL_7D_H             (REG_SC_CTRL_BASE + 0xFB)
#define REG_SC_CTRL_7E_L             (REG_SC_CTRL_BASE + 0xFC)
#define REG_SC_CTRL_7E_H             (REG_SC_CTRL_BASE + 0xFD)
#define REG_SC_CTRL_7F_L             (REG_SC_CTRL_BASE + 0xFE)
#define REG_SC_CTRL_7F_H             (REG_SC_CTRL_BASE + 0xFF)


#endif /* __HAL_DISP_REG_H__ */
